/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.report.action;

import gov.va.med.esr.common.model.lookup.ReportType;
import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.common.model.report.ReportSetupLite;
import gov.va.med.esr.common.model.report.SimpleCompletedReport;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.report.action.ReportAction;
import gov.va.med.esr.ui.report.action.ReportFilterForm;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.mlw.vlh.ValueList;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public abstract class ReportFilterAction
extends ReportAction {
    public abstract String getTableId();

    public abstract String getValueListAdapter();

    public ActionForward displayReportData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportFilterForm filterForm = (ReportFilterForm)form;
        filterForm.setDisplayFilter(false);
        filterForm.setFilterApplied(filterForm.getContainsFilterCriteria());
        ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)this.getTableId(), (String)this.getValueListAdapter());
        ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
        if (!filterForm.getContainsFilterCriteria()) {
            this.cacheReportFilters(ValueListActionUtils.getCachedResults((HttpSession)request.getSession(), (String)this.getTableId()), request);
        }
        this.processMessagesInSession(request);
        return mapping.findForward("displayData");
    }

    public ActionForward applyFilter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportFilterForm filterForm = (ReportFilterForm)form;
        if (!this.validateFilter(request, filterForm)) {
            if (ValueListActionUtils.isCachedResults((HttpSession)request.getSession(), (String)this.getTableId())) {
                ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)this.getTableId(), (String)this.getValueListAdapter());
                ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
            }
            filterForm.setDisplayFilter(true);
            return mapping.findForward("displayData");
        }
        return this.refreshData(mapping, form, request, response);
    }

    public ActionForward resetFilter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportFilterForm filterForm = (ReportFilterForm)form;
        filterForm.resetFilter();
        return this.refreshData(mapping, form, request, response);
    }

    public ActionForward refreshData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ValueListActionUtils.clearCachedResults((HttpSession)request.getSession(), (String)this.getTableId());
        this.placeMessagesInSession(request);
        return mapping.findForward("displayUpdatedData");
    }

    protected void placeMessagesInSession(HttpServletRequest request) {
        String value = this.getValueFromParamOrAtttributeKey(request, "infoMessage");
        if (value != null) {
            this.setMessageInSession(request.getSession(), value, false);
        }
        if ((value = this.getValueFromParamOrAtttributeKey(request, "errorMessage")) != null) {
            this.setMessageInSession(request.getSession(), value, true);
        }
    }

    protected void processMessagesInSession(HttpServletRequest request) {
        String value = this.getMessageFromSession(request.getSession(), false);
        this.setMessageInSession(request.getSession(), null, false);
        this.processMessage(request, "infoMessage", value);
        value = this.getMessageFromSession(request.getSession(), true);
        this.processMessage(request, "errorMessage", value);
        this.setMessageInSession(request.getSession(), null, true);
    }

    protected void cacheReportFilters(List reportList, HttpServletRequest request) {
        HashMap<String, ReportType> reportTypeMap = new HashMap<String, ReportType>();
        HashMap<String, StandardReport> reportIdMap = new HashMap<String, StandardReport>();
        HashMap<String, StandardReport> reportTitleMap = new HashMap<String, StandardReport>();
        HashMap<String, ReportExportedType> fileTypeMap = new HashMap<String, ReportExportedType>();
        for (Object report : reportList) {
            ReportExportedType fileType;
            ReportType reportType;
            StandardReport standardReport = this.getStandardReport(report);
            if (standardReport == null) continue;
            if (StringUtils.isNotEmpty((String)standardReport.getDescription()) && StringUtils.isNotEmpty((String)standardReport.getCode())) {
                reportTitleMap.put(standardReport.getDescription(), standardReport);
            }
            if (StringUtils.isNotEmpty((String)standardReport.getCode())) {
                reportIdMap.put(standardReport.getCode(), standardReport);
            }
            if ((reportType = standardReport.getType()) != null && StringUtils.isNotEmpty((String)reportType.getDescription()) && StringUtils.isNotEmpty((String)reportType.getCode())) {
                reportTypeMap.put(reportType.getCode(), reportType);
            }
            if ((fileType = this.getReportExportedType(report)) == null || !StringUtils.isNotEmpty((String)fileType.getDescription()) || !StringUtils.isNotEmpty((String)fileType.getCode())) continue;
            fileTypeMap.put(fileType.getCode(), fileType);
        }
        ArrayList reportTypeList = new ArrayList(reportTypeMap.values());
        ArrayList reportIdList = new ArrayList(reportIdMap.values());
        ArrayList reportTitleList = new ArrayList(reportTitleMap.values());
        ArrayList fileTypeList = new ArrayList(fileTypeMap.values());
        Collections.sort(reportTitleList, StandardReport.getNameComparator());
        request.getSession().setAttribute("reportTitleList", reportTitleList);
        Collections.sort(reportIdList, StandardReport.getCodeComparator());
        request.getSession().setAttribute("reportIdList", reportIdList);
        Collections.sort(reportTypeList, ReportType.getReportTypeNameComparator());
        request.getSession().setAttribute("reportTypeList", reportTypeList);
        Collections.sort(fileTypeList, ReportExportedType.getNameComparator());
        request.getSession().setAttribute("fileTypeList", fileTypeList);
    }

    private StandardReport getStandardReport(Object report) {
        StandardReport standardReport = null;
        if (report instanceof SimpleCompletedReport) {
            standardReport = ((SimpleCompletedReport)report).getStandardReport();
        } else if (report instanceof ReportSetupLite) {
            standardReport = ((ReportSetupLite)report).getReport();
        } else {
            throw new IllegalArgumentException("Unable to get a standard report from object of type: " + report.getClass().getName());
        }
        return standardReport;
    }

    private ReportExportedType getReportExportedType(Object report) {
        ReportExportedType reportExportedType = null;
        if (report instanceof SimpleCompletedReport) {
            reportExportedType = ((SimpleCompletedReport)report).getFileType();
        } else if (report instanceof ReportSetupLite) {
            reportExportedType = ((ReportSetupLite)report).getFileType();
        } else {
            throw new IllegalArgumentException("Unable to get a report exported type from object of type: " + report.getClass().getName());
        }
        return reportExportedType;
    }

    protected boolean validateFilter(HttpServletRequest request, ReportFilterForm form) throws UnknownLookupCodeException, UnknownLookupTypeException {
        boolean valid = true;
        Date fromDate = null;
        Date toDate = null;
        if (StringUtils.isNotEmpty((String)form.getDateFrom())) {
            try {
                fromDate = DateUtils.getDate((String)form.getDateFrom());
            }
            catch (Exception e) {
                this.addActionMessageForField(request, new ActionMessage("errors.date", (Object)form.getDateFrom()), "dateFilter");
                valid = false;
            }
        }
        if (StringUtils.isNotEmpty((String)form.getDateTo())) {
            try {
                toDate = DateUtils.getDate((String)form.getDateTo());
            }
            catch (Exception e) {
                this.addActionMessageForField(request, new ActionMessage("errors.date", (Object)form.getDateTo()), "dateFilter");
                valid = false;
            }
        }
        if (fromDate != null && toDate != null && toDate.getTime() < fromDate.getTime()) {
            this.addActionMessageForField(request, new ActionMessage("errors.invalidStartEndDates", (Object)form.getDateTo(), (Object)form.getDateFrom()), "dateFilter");
            valid = false;
        }
        if (StringUtils.isNotEmpty((String)form.getReportId()) && StringUtils.isNotEmpty((String)form.getReportTitle()) && !form.getReportId().equals(form.getReportTitle())) {
            this.addActionMessageForField(request, "errors.report.reportIdAndTitleMustMatch", "reportId");
            this.addActionMessageForField(request, "errors.report.reportIdAndTitleMustMatch", "reportTitle");
            valid = false;
        } else if ((StringUtils.isNotEmpty((String)form.getReportId()) || StringUtils.isNotEmpty((String)form.getReportTitle())) && StringUtils.isNotEmpty((String)form.getReportType())) {
            StandardReport standardReport;
            ReportType reportType;
            boolean reportIdSpecified = false;
            boolean reportTitleSpecified = false;
            String reportId = form.getReportId();
            if (StringUtils.isNotEmpty((String)form.getReportId())) {
                reportIdSpecified = true;
                reportId = form.getReportId();
            }
            if (StringUtils.isNotEmpty((String)form.getReportTitle())) {
                reportTitleSpecified = true;
                reportId = form.getReportTitle();
            }
            if (!(reportType = (standardReport = this.getLookupService().getStandardReportByCode(reportId)).getType()).getCode().equals(form.getReportType())) {
                if (reportIdSpecified) {
                    this.addActionMessageForField(request, "errors.report.reportIdAndTypeMustMatch", "reportId");
                }
                if (reportTitleSpecified) {
                    this.addActionMessageForField(request, "errors.report.reportIdAndTypeMustMatch", "reportTitle");
                }
                this.addActionMessageForField(request, "errors.report.reportIdAndTypeMustMatch", "reportType");
                valid = false;
            }
        }
        return valid;
    }

    protected void setMessageInSession(HttpSession session, String messageBundleKey, boolean errorMessage) {
        session.setAttribute(errorMessage ? "reportingErrorMessageSessionKey" : "reportingInfoMessageSessionKey", (Object)messageBundleKey);
    }

    protected String getMessageFromSession(HttpSession session, boolean errorMessage) {
        return (String)session.getAttribute(errorMessage ? "reportingErrorMessageSessionKey" : "reportingInfoMessageSessionKey");
    }
}

