/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.report.action;

import gov.va.med.esr.common.model.lookup.BadAddressReason;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.lookup.RejectionRemark;
import gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy;
import gov.va.med.esr.common.model.lookup.ReportLetterFile;
import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.VISN;
import gov.va.med.esr.common.model.registry.RegistryLoadStatistics;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.security.ESRUserPrincipal;
import gov.va.med.esr.common.report.data.ParameterConfig;
import gov.va.med.esr.ui.report.action.ReportAction;
import gov.va.med.esr.ui.report.action.ReportParamInfoForm;
import gov.va.med.esr.ui.report.action.ReportScheduleInfoForm;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.StringUtils;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ReportEditAction
extends ReportAction {
    public static final String INVALID_VISNS_FACILITIES = "errors.report.invalidStationNumbers";
    public static final String INVALID_VISNS = "errors.report.invalidVISNs";
    public static final String INVALID_FACILITIES = "errors.report.invalidFacilities";

    public ActionForward displayReportParameters(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportParamInfoForm form = (ReportParamInfoForm)actionForm;
        String reportId = request.getParameter("reportId");
        if (StringUtils.isNotEmpty((String)reportId)) {
            StandardReport stdReport = this.getStandardReport(request, reportId);
            form.setReportId(reportId);
            form.setReportName(stdReport.getCodeDescription());
        }
        this.setDefaults(form, request);
        return mapping.findForward("displayReportParameters");
    }

    public ActionForward displayReportSelection(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("standardReportList", (Object)this.getStandardReports(request));
        return mapping.findForward("displayReportSelection");
    }

    public ActionForward displayAddReportSchedule(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportScheduleInfoForm form = (ReportScheduleInfoForm)actionForm;
        ActionForward forward = mapping.findForward("displayAddReportSchedule");
        String reportId = form.getReportId();
        if (StringUtils.isEmpty((String)reportId)) {
            forward = mapping.findForward("displayReportSelection");
        } else {
            StandardReport stdReport = this.getStandardReport(request, reportId);
            form.setReportId(reportId);
            form.setReportName(stdReport.getCodeDescription());
        }
        return forward;
    }

    public ActionForward addReportSchedule(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        StandardReport stdReport;
        ReportScheduleInfoForm form = (ReportScheduleInfoForm)actionForm;
        String reportId = form.getReportId();
        StandardReport standardReport = stdReport = StringUtils.isNotEmpty((String)reportId) ? this.getStandardReport(request, reportId) : null;
        if (stdReport != null) {
            UserPrincipal user = this.getLoggedInUser();
            ReportSetup reportSetup = new ReportSetup();
            reportSetup.setSetupUser((ESRUserPrincipal)user);
            reportSetup.setReport(this.getStandardReport(request, reportId));
            this.getConversionService().convert((Object)form, (Object)reportSetup);
            this.getStandardReportService().scheduleReport(user, reportSetup);
        }
        return mapping.findForward("displayScheduledReportsWithMessage");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("cancel");
    }

    public ActionForward generateReport(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        StandardReport stdReport;
        ReportParamInfoForm form = (ReportParamInfoForm)actionForm;
        String reportId = request.getParameter("reportId");
        StandardReport standardReport = stdReport = StringUtils.isNotEmpty((String)reportId) ? this.getStandardReport(request, reportId) : null;
        if (stdReport != null) {
            UserPrincipal user = this.getLoggedInUser();
            ReportSetup reportSetup = new ReportSetup();
            reportSetup.setReport(stdReport);
            reportSetup.setSetupUser((ESRUserPrincipal)user);
            if (!this.isSitesListValid(form, request)) {
                return mapping.getInputForward();
            }
            this.getConversionService().convert((Object)form, (Object)reportSetup);
            this.getStandardReportService().generateReport(user, reportSetup);
        }
        return mapping.findForward("displayAvailableReportsWithMessage");
    }

    private boolean isSitesListValid(ReportParamInfoForm form, HttpServletRequest request) {
        String[] stationNumbers = form.getStationNumbersAsArray();
        boolean valid = true;
        boolean visns = false;
        boolean sites = false;
        StringBuffer invalidCodes = new StringBuffer();
        if (stationNumbers != null && stationNumbers.length > 0) {
            for (int i = 0; i < stationNumbers.length; ++i) {
                String code = stationNumbers[i];
                Lookup lookupObj = null;
                try {
                    if (code.startsWith("VISN")) {
                        visns = true;
                        lookupObj = this.getLookupCacheService().getByCodeFromCache(VISN.class, code);
                    } else {
                        sites = true;
                        lookupObj = this.getLookupCacheService().getByCodeFromCache(VAFacility.class, code);
                    }
                }
                catch (Exception e) {
                    valid = false;
                }
                if (lookupObj != null) continue;
                valid = false;
                invalidCodes.append(i == 0 ? code : "," + code);
            }
        }
        if (!valid) {
            this.addActionMessageForField(request, INVALID_VISNS_FACILITIES, invalidCodes.toString(), "stattionNumbers");
        }
        if (valid) {
            String facilityDisplayBy = form.getFacilityDisplayByNoDefault();
            if (sites && StringUtils.equals((String)facilityDisplayBy, (String)ReportFacilityDisplayBy.CODE_VISN.getCode())) {
                this.addActionMessageForField(request, INVALID_VISNS, form.getStationNumbers(), "stattionNumbers");
                valid = false;
            } else if (visns && (StringUtils.equals((String)facilityDisplayBy, (String)ReportFacilityDisplayBy.CODE_SITE.getCode()) || StringUtils.equals((String)facilityDisplayBy, (String)ReportFacilityDisplayBy.CODE_VAMC.getCode()) || StringUtils.equals((String)facilityDisplayBy, (String)ReportFacilityDisplayBy.CODE_VAMC_SITE.getCode()))) {
                this.addActionMessageForField(request, INVALID_FACILITIES, form.getStationNumbers(), "stattionNumbers");
                valid = false;
            }
        }
        return valid;
    }

    private void setDefaults(ReportParamInfoForm form, HttpServletRequest request) throws Exception {
        RegistryLoadStatistics stats;
        ServletContext context = request.getSession().getServletContext();
        Map parameterMap = (Map)context.getAttribute("reportParamConfigMap");
        if (parameterMap == null) {
            return;
        }
        String reportId = form.getReportIdNoSpace();
        Map reportParamMap = (Map)parameterMap.get(reportId);
        if (reportParamMap == null) {
            return;
        }
        PropertyUtilsBean propertyUtils = new PropertyUtilsBean();
        for (String fieldName : reportParamMap.keySet()) {
            String defaultValue;
            ParameterConfig paramConfig = (ParameterConfig)reportParamMap.get(fieldName);
            if (paramConfig == null || (defaultValue = paramConfig.getDefaultValue()) == null) continue;
            if ("all".equals(defaultValue)) {
                String[] list = this.getAllLookupDefaults(fieldName);
                if (list == null) {
                    list = new String[]{"all"};
                }
                propertyUtils.setNestedProperty((Object)form, fieldName, (Object)list);
                continue;
            }
            propertyUtils.setNestedProperty((Object)form, fieldName, (Object)defaultValue);
        }
        if (reportId.equals("IV1")) {
            String curYear = String.valueOf(gov.va.med.esr.ui.common.util.DateUtils.getCurrentYear());
            form.setBeginIncomeYear(curYear);
            form.setEndIncomeYear(curYear);
            form.setFacilityDisplayBy(ReportFacilityDisplayBy.CODE_VISN.getCode());
            String[] allvisns = new String[]{"all"};
            form.setVisn(allvisns);
        } else if (reportId.equals("IV5")) {
            form.setFacilityDisplayBy(ReportFacilityDisplayBy.CODE_SITE.getCode());
            String[] allSites = new String[]{"all"};
            form.setFacility(allSites);
        } else if (reportId.equals("EED10")) {
            form.setFacilityDisplayBy(ReportFacilityDisplayBy.CODE_VISN.getCode());
            String[] allvisns = new String[]{"all"};
            form.setVisn(allvisns);
        } else if (reportId.equals("QM10")) {
            String fiscalYear = String.valueOf(DateUtils.getFiscalYear((Calendar)Calendar.getInstance()));
            form.setReportPeriodYear(fiscalYear);
            form.setReportPeriodQuarterYear(fiscalYear);
        } else if (reportId.equals("QM27") && (stats = this.getRegistryService().getMostRecentRegistrySummaryByType(null)) != null) {
            form.setBatchNumber(stats.getEntityKey().getKeyValueAsString());
        }
    }

    private String[] getAllLookupDefaults(String fieldName) throws Exception {
        Collection set = null;
        if ("registryType".equals(fieldName)) {
            set = this.getLookupCacheService().getFromCache(RegistryType.class.getName());
        } else if ("letterFile".equals(fieldName)) {
            set = this.getLookupCacheService().getFromCache(ReportLetterFile.class.getName());
        } else {
            if ("cancelDeclineReason".equals(fieldName)) {
                return null;
            }
            if ("badAddressReason".equals(fieldName)) {
                set = this.getLookupCacheService().getFromCache(BadAddressReason.class.getName());
            } else if ("phRejectReason".equals(fieldName)) {
                set = this.getLookupCacheService().getFromCache(RejectionRemark.class.getName());
            }
        }
        if (set != null && set.size() > 0) {
            String[] selectedValues = new String[set.size() + 1];
            int index = 0;
            selectedValues[index++] = "all";
            for (Lookup lookup : set) {
                selectedValues[index++] = lookup.getCode();
            }
            return selectedValues;
        }
        return null;
    }
}

