/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.report.action;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.AACIndicator;
import gov.va.med.esr.common.model.lookup.AckType;
import gov.va.med.esr.common.model.lookup.BadAddressReason;
import gov.va.med.esr.common.model.lookup.CancelDeclineReason;
import gov.va.med.esr.common.model.lookup.ComAACErrorType;
import gov.va.med.esr.common.model.lookup.ComAACRejectReasonType;
import gov.va.med.esr.common.model.lookup.DayOfMonth;
import gov.va.med.esr.common.model.lookup.DayOfQuarter;
import gov.va.med.esr.common.model.lookup.DayOfWeek;
import gov.va.med.esr.common.model.lookup.EnrollmentOverrideReason;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentProcessStatus;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.EnrollmentStatusComponent;
import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.lookup.Month;
import gov.va.med.esr.common.model.lookup.PersonMergeStatus;
import gov.va.med.esr.common.model.lookup.Quarter;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.lookup.RejectionRemark;
import gov.va.med.esr.common.model.lookup.ReportDetailBy;
import gov.va.med.esr.common.model.lookup.ReportDetailFor;
import gov.va.med.esr.common.model.lookup.ReportDivision;
import gov.va.med.esr.common.model.lookup.ReportEEDWeeklyType;
import gov.va.med.esr.common.model.lookup.ReportEligibilityFactorLU;
import gov.va.med.esr.common.model.lookup.ReportExceptionType;
import gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy;
import gov.va.med.esr.common.model.lookup.ReportFormat;
import gov.va.med.esr.common.model.lookup.ReportLetterFile;
import gov.va.med.esr.common.model.lookup.ReportPeriodType;
import gov.va.med.esr.common.model.lookup.ReportRunFrequency;
import gov.va.med.esr.common.model.lookup.ReportScheduleType;
import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.VISN;
import gov.va.med.esr.common.model.lookup.VOAFormType;
import gov.va.med.esr.common.model.lookup.WeekOfMonth;
import gov.va.med.esr.common.model.lookup.WkfCaseStatusType;
import gov.va.med.esr.common.model.lookup.WkfCaseType;
import gov.va.med.esr.common.model.report.BaseReportLookupParameter;
import gov.va.med.esr.common.model.report.ReportBadAddressReason;
import gov.va.med.esr.common.model.report.ReportCancelDeclineReason;
import gov.va.med.esr.common.model.report.ReportDayOfWeek;
import gov.va.med.esr.common.model.report.ReportEEDWeeklyReportType;
import gov.va.med.esr.common.model.report.ReportEligibilityFactor;
import gov.va.med.esr.common.model.report.ReportEnrollmentOverrideReason;
import gov.va.med.esr.common.model.report.ReportEnrollmentPriorityGroup;
import gov.va.med.esr.common.model.report.ReportEnrollmentStatus;
import gov.va.med.esr.common.model.report.ReportEnrollmentStatusComponent;
import gov.va.med.esr.common.model.report.ReportFacility;
import gov.va.med.esr.common.model.report.ReportFormType;
import gov.va.med.esr.common.model.report.ReportFunctionalGroup;
import gov.va.med.esr.common.model.report.ReportLetterErrorType;
import gov.va.med.esr.common.model.report.ReportLetterRejectReason;
import gov.va.med.esr.common.model.report.ReportLinkLetterFile;
import gov.va.med.esr.common.model.report.ReportMessageError;
import gov.va.med.esr.common.model.report.ReportMessageType;
import gov.va.med.esr.common.model.report.ReportPHRejectionRemark;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportPeriod;
import gov.va.med.esr.common.model.report.ReportPersonMergeStatus;
import gov.va.med.esr.common.model.report.ReportQueryToSite;
import gov.va.med.esr.common.model.report.ReportRegistryType;
import gov.va.med.esr.common.model.report.ReportSchedule;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.report.ReportUser;
import gov.va.med.esr.common.model.report.ReportVBAQueryStatus;
import gov.va.med.esr.common.model.report.ReportWkfCaseStatusType;
import gov.va.med.esr.common.model.report.ReportWkfCaseType;
import gov.va.med.esr.common.model.security.ESRUserPrincipal;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.esr.ui.common.beans.PendingEnrollmentStatus;
import gov.va.med.esr.ui.common.beans.VAFacilityExceptVBA;
import gov.va.med.esr.ui.common.beans.VAMC;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.esr.ui.report.action.ReportConstants;
import gov.va.med.esr.ui.report.action.ReportParamInfoForm;
import gov.va.med.esr.ui.report.action.ReportScheduleInfoForm;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReportConversionService
extends UIConversionServiceImpl
implements ReportConstants {
    private static final String[] SUMMARY_ONLY_REPORTS = new String[]{"EED6", "QM4", "QM15"};

    public Object convert(Object source, Class targetClass) throws ConversionServiceException {
        return null;
    }

    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        if (source instanceof ReportParamInfoForm && target instanceof ReportSetup) {
            this.convertFormToReportSetup((ReportScheduleInfoForm)((Object)source), (ReportSetup)target);
        } else if (target instanceof ReportSetup && source instanceof ReportParamInfoForm) {
            this.convertReportSetupToForm((ReportSetup)source, (ReportParamInfoForm)((Object)target));
        }
    }

    private void convertFormToReportSetup(ReportScheduleInfoForm form, ReportSetup reportSetup) throws ConversionServiceException {
        ReportParameterSet paramSet = reportSetup.getParameterSet();
        if (paramSet == null) {
            paramSet = new ReportParameterSet();
            reportSetup.setParameterSet(paramSet);
        }
        if (StringUtils.contains((String[])SUMMARY_ONLY_REPORTS, (String)form.getReportIdNoSpace())) {
            form.setReportFormat(ReportFormat.SUMMARY.getCode());
        }
        reportSetup.setSetupUser((ESRUserPrincipal)this.getLoggedInUser());
        this.convertFormToReportParameterSet(form, paramSet);
        if (StringUtils.equals((String)form.getTabName(), (String)"scheduledReports")) {
            this.populateReportSchedule(form, reportSetup);
            String[] emails = StringUtils.split((String)form.getEmailReportTo(), (String)" ,;");
            if (emails != null && emails.length > 0) {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < emails.length; ++i) {
                    if (!StringUtils.isNotEmpty((String)emails[i])) continue;
                    if (buffer.length() > 0) {
                        buffer.append(",");
                    }
                    buffer.append(emails[i]);
                }
                reportSetup.setEmail(buffer.toString());
            }
        }
    }

    private void convertFormToReportParameterSet(ReportScheduleInfoForm form, ReportParameterSet paramSet) throws ConversionServiceException {
        try {
            String[] pendingEnrollmentStatus;
            Set voaFormTypes;
            if (StringUtils.equals((String)form.getReportIdNoSpace(), (String)"EED2")) {
                Calendar calendar;
                int year;
                ImpreciseDate fromYear = gov.va.med.esr.ui.common.util.DateUtils.getImpreciseDate((String)form.getFromYear());
                ImpreciseDate toYear = gov.va.med.esr.ui.common.util.DateUtils.getImpreciseDate((String)form.getToYear());
                if (fromYear != null) {
                    year = fromYear.getCalendar().get(1);
                    calendar = Calendar.getInstance();
                    calendar.clear();
                    calendar.set(year, 0, 1);
                    paramSet.setFromDate(calendar.getTime());
                }
                if (toYear != null) {
                    year = toYear.getCalendar().get(1);
                    calendar = Calendar.getInstance();
                    calendar.clear();
                    calendar.set(year, 11, 31);
                    paramSet.setToDate(calendar.getTime());
                }
            } else if (StringUtils.equals((String)form.getReportIdNoSpace(), (String)"EED10")) {
                ImpreciseDate asOfDate;
                Calendar calendar;
                ImpreciseDate toDate;
                int month;
                int year;
                ImpreciseDate fromDate;
                paramSet.setFromDate(null);
                if (StringUtils.isNotEmpty((String)form.getFromDate()) && (fromDate = gov.va.med.esr.ui.common.util.DateUtils.getImpreciseDate((String)form.getFromDate())) != null) {
                    year = fromDate.getCalendar().get(1);
                    month = fromDate.getCalendar().get(2);
                    Calendar calendar2 = Calendar.getInstance();
                    calendar2.clear();
                    calendar2.set(year, month, 1);
                    paramSet.setFromDate(calendar2.getTime());
                }
                paramSet.setToDate(null);
                if (StringUtils.isNotEmpty((String)form.getToDate()) && (toDate = gov.va.med.esr.ui.common.util.DateUtils.getImpreciseDate((String)form.getToDate())) != null) {
                    year = toDate.getCalendar().get(1);
                    month = toDate.getCalendar().get(2);
                    int day = toDate.getCalendar().getActualMaximum(5);
                    calendar = Calendar.getInstance();
                    calendar.clear();
                    calendar.set(year, month, day);
                    paramSet.setToDate(calendar.getTime());
                }
                paramSet.setAsOfDate(null);
                if (StringUtils.isNotEmpty((String)form.getAsOfDate()) && (asOfDate = gov.va.med.esr.ui.common.util.DateUtils.getImpreciseDate((String)form.getAsOfDate())) != null) {
                    year = asOfDate.getCalendar().get(1);
                    month = asOfDate.getCalendar().get(2);
                    int day = asOfDate.getCalendar().getActualMaximum(5);
                    calendar = Calendar.getInstance();
                    calendar.clear();
                    calendar.set(year, month, day);
                    paramSet.setAsOfDate(calendar.getTime());
                }
            } else {
                paramSet.setFromDate(gov.va.med.esr.ui.common.util.DateUtils.getDate((String)form.getFromDate()));
                paramSet.setToDate(gov.va.med.esr.ui.common.util.DateUtils.getDate((String)form.getToDate()));
                paramSet.setAsOfDate(gov.va.med.esr.ui.common.util.DateUtils.getDate((String)form.getAsOfDate()));
            }
            paramSet.setPhUnconfirmedDays(this.getInteger(form.getPhUnconfirmedForMoreThan()));
            paramSet.setBeginIncomeYear(this.getInteger(form.getBeginIncomeYear()));
            paramSet.setEndIncomeYear(this.getInteger(form.getEndIncomeYear()));
            paramSet.setDivision((ReportDivision)this.getLookup(ReportDivision.class, form.getDivision()));
            paramSet.setRunReportByUser(this.getTrueFalse(form.getRunReportByUser()));
            paramSet.setBatchNumber(this.getInteger(form.getBatchNumber()));
            if (StringUtils.equals((String)form.getExceptionType(), (String)ReportExceptionType.SYSTEM_ERROR.getCode())) {
                paramSet.setExceptionType(null);
            } else {
                paramSet.setExceptionType((ReportExceptionType)this.getLookup(ReportExceptionType.class, form.getExceptionType()));
            }
            paramSet.setIncludeUsers(this.getTrueFalse(form.getIncludeUsers()));
            paramSet.setEnrollmentEffectiveDateOfChange(gov.va.med.esr.ui.common.util.DateUtils.getDate((String)form.getEnrollmentEffectiveDateChange()));
            paramSet.setDaysBetweenUpdates(this.getInteger(form.getDaysBetweenUpdates()));
            paramSet.setNumberOfRecordsPerEnrollmentStatus(this.getInteger(form.getRecordsPerEnrollmentStatus()));
            paramSet.setOutlierDays(this.getInteger(form.getOutlierDays()));
            paramSet.setRandomNumberOfRecords(this.getInteger(form.getRandomNumberOfRecords()));
            paramSet.removeAllEnrollmentStatusComponents();
            Set enrollmentStatusComponents = this.getReportLookupParameter(form.getEnrollmentStatusComponent(), EnrollmentStatusComponent.class, ReportEnrollmentStatusComponent.class);
            if (enrollmentStatusComponents != null && !enrollmentStatusComponents.isEmpty()) {
                paramSet.addAllEnrollmentStatusComponents(enrollmentStatusComponents);
            }
            if ((StringUtils.equals((String)form.getReportIdNoSpace(), (String)StandardReport.CODE_QM_11.getCode()) || StringUtils.equals((String)form.getReportIdNoSpace(), (String)StandardReport.CODE_QM_15.getCode()) || StringUtils.equals((String)form.getReportIdNoSpace(), (String)StandardReport.CODE_QM_3.getCode())) && !StringUtils.equals((String)form.getReportFormat(), (String)ReportFormat.DETAIL.getCode())) {
                paramSet.setOutlierDays(null);
                paramSet.setRandomNumberOfRecords(null);
                paramSet.removeAllEnrollmentStatusComponents();
            }
            paramSet.removeAllEligibilityFactors();
            Set eligibilityFactors = this.getReportLookupParameter(form.getEligibilityFactors(), ReportEligibilityFactorLU.class, ReportEligibilityFactor.class);
            if (eligibilityFactors != null && !eligibilityFactors.isEmpty()) {
                paramSet.addAllEligibilityFactors(eligibilityFactors);
            }
            paramSet.removeAllPersonMergeStatuses();
            Set personMergeStatuses = this.getReportLookupParameter(form.getPersonMergeStatus(), PersonMergeStatus.class, ReportPersonMergeStatus.class);
            if (personMergeStatuses != null && !personMergeStatuses.isEmpty()) {
                paramSet.addAllPersonMergeStatuses(personMergeStatuses);
            }
            if (!StringUtils.equals((String)form.getReportFormat(), (String)ReportFormat.DETAIL.getCode())) {
                paramSet.removeAllPersonMergeStatuses();
            }
            paramSet.setEnrollmentProcessStatus((EnrollmentProcessStatus)this.getLookup(EnrollmentProcessStatus.class, form.getEnrollmentProcessStatus()));
            this.populateReportPeriod(form, paramSet);
            paramSet.setAddressUpdateDays(this.getInteger(form.getAddressUpdatedMultipleTimesWithin()));
            paramSet.setPhUnconfirmedDays(this.getInteger(form.getPhUnconfirmedForMoreThan()));
            this.populateFacilities(form, paramSet);
            this.populateQueryTo(form, paramSet);
            String reportFormat = form.getReportFormat();
            paramSet.setReportFormat((ReportFormat)this.getLookup(ReportFormat.class, reportFormat));
            paramSet.setDetailFor(null);
            paramSet.setDetailBy(null);
            if (StringUtils.equals((String)reportFormat, (String)ReportFormat.DETAIL.getCode())) {
                if (StringUtils.equals((String)form.getReportIdNoSpace(), (String)"QM8")) {
                    paramSet.setDetailFor((ReportDetailFor)this.getLookup(ReportDetailFor.class, form.getUpdateStatus()));
                }
                if (StringUtils.equals((String)form.getReportIdNoSpace(), (String)"QM17") || StringUtils.equals((String)form.getReportIdNoSpace(), (String)"EED9")) {
                    paramSet.setDetailBy((ReportDetailBy)this.getLookup(ReportDetailBy.class, form.getReportDetailBy()));
                }
            }
            paramSet.setFileType((ReportExportedType)this.getLookup(ReportExportedType.class, form.getFileType()));
            paramSet.removeAllFormTypes();
            String[] formTypeArr = form.getVoaFormTypes();
            if (formTypeArr != null && formTypeArr.length > 0) {
                for (int i = 0; i < formTypeArr.length; ++i) {
                    if (!formTypeArr[i].equalsIgnoreCase("all")) continue;
                    formTypeArr = null;
                    break;
                }
            }
            if ((voaFormTypes = this.getReportLookupParameter(formTypeArr, VOAFormType.class, ReportFormType.class)) != null && !voaFormTypes.isEmpty()) {
                paramSet.addAllFormTypes(voaFormTypes);
            }
            paramSet.removeAllMessageTypes();
            Set messageTypes = this.getReportLookupParameter(form.getMessageType(), MessageType.class, ReportMessageType.class);
            if (messageTypes != null && !messageTypes.isEmpty()) {
                paramSet.addAllMessageTypes(messageTypes);
            }
            paramSet.removeAllMessageErrors();
            Set messageErrors = this.getMessageErrorReportLookupParameter(form.getMessageError(), AckType.class, ReportMessageError.class);
            if (messageErrors != null && !messageErrors.isEmpty()) {
                paramSet.addAllMessageErrors(messageErrors);
            }
            paramSet.removeAllBadAddressReasons();
            Set badAddressReasons = this.getReportLookupParameter(form.getBadAddressReason(), BadAddressReason.class, ReportBadAddressReason.class);
            if (badAddressReasons != null && !badAddressReasons.isEmpty()) {
                paramSet.addAllBadAddressReasons(badAddressReasons);
            }
            paramSet.removeAllCancelDeclineReasons();
            Set cancelDeclineReasons = this.getReportLookupParameter(form.getCancelDeclineReason(), CancelDeclineReason.class, ReportCancelDeclineReason.class);
            if (cancelDeclineReasons != null && !cancelDeclineReasons.isEmpty()) {
                paramSet.addAllCancelDeclineReasons(cancelDeclineReasons);
            }
            paramSet.removeAllEnrollmentOverrideReasons();
            Set enrollmentOverrideReasons = this.getReportLookupParameter(form.getEnrollmentOverrideReason(), EnrollmentOverrideReason.class, ReportEnrollmentOverrideReason.class);
            if (enrollmentOverrideReasons != null && !enrollmentOverrideReasons.isEmpty()) {
                paramSet.addAllEnrollmentOverrideReasons(enrollmentOverrideReasons);
            }
            paramSet.removeAllPHRejectionRemarks();
            Set rejectionRemarks = this.getReportLookupParameter(form.getPhRejectReason(), RejectionRemark.class, ReportPHRejectionRemark.class);
            if (rejectionRemarks != null && !rejectionRemarks.isEmpty()) {
                paramSet.addAllPHRejectionRemarks(rejectionRemarks);
            }
            this.populateLetterFilesAndRejectErrors(form, paramSet);
            paramSet.removeAllFunctionalGroups();
            Set functionalGroups = this.getReportLookupParameter(form.getFunctionalGroup(), FunctionalGroup.class, ReportFunctionalGroup.class);
            if (functionalGroups != null && !functionalGroups.isEmpty()) {
                paramSet.addAllFunctionalGroups(functionalGroups);
            }
            paramSet.removeAllWkfCaseStatusTypes();
            Set caseStatusTypes = this.getReportLookupParameter(form.getWorkItemStatus(), WkfCaseStatusType.class, ReportWkfCaseStatusType.class);
            if (caseStatusTypes != null && !caseStatusTypes.isEmpty()) {
                paramSet.addAllWkfCaseStatusTypes(caseStatusTypes);
            }
            paramSet.removeAllWkfCaseTypes();
            Set caseTypes = this.getReportLookupParameter(form.getWorkItemType(), WkfCaseType.class, ReportWkfCaseType.class);
            if (caseTypes != null && !caseTypes.isEmpty()) {
                paramSet.addAllWkfCaseTypes(caseTypes);
            }
            paramSet.removeAllUsers();
            Set users = this.getReportUserParameter(form.getReportUser());
            if (users != null && !users.isEmpty()) {
                paramSet.addAllUsers(users);
            }
            paramSet.removeAllEnrollmentStatuses();
            Set enrollmentStatuses = this.getReportLookupParameter(form.getEnrollmentStatus(), EnrollmentStatus.class, ReportEnrollmentStatus.class);
            if (enrollmentStatuses != null && !enrollmentStatuses.isEmpty()) {
                paramSet.addAllEnrollmentStatuses(enrollmentStatuses);
            }
            if ((pendingEnrollmentStatus = form.getPendingEnrollmentStatus()) != null && pendingEnrollmentStatus.length > 0) {
                paramSet.removeAllEnrollmentStatuses();
                Set pendingEnrollmentStatuses = this.getReportLookupParameter(pendingEnrollmentStatus, PendingEnrollmentStatus.class, ReportEnrollmentStatus.class);
                if (pendingEnrollmentStatuses != null && !pendingEnrollmentStatuses.isEmpty()) {
                    paramSet.addAllEnrollmentStatuses(pendingEnrollmentStatuses);
                }
            }
            paramSet.removeAllRegistryTypes();
            Set registryTypes = this.getReportLookupParameter(form.getRegistryType(), RegistryType.class, ReportRegistryType.class);
            if (registryTypes != null && !registryTypes.isEmpty()) {
                paramSet.addAllRegistryTypes(registryTypes);
            }
            paramSet.removeAllReportEEDWeeklyReportTypes();
            Set reportEEDWeeklyReportTypes = this.getReportLookupParameter(form.getEedWeeklyReport(), ReportEEDWeeklyType.class, ReportEEDWeeklyReportType.class);
            if (reportEEDWeeklyReportTypes != null && !reportEEDWeeklyReportTypes.isEmpty()) {
                paramSet.addAllReportEEDWeeklyReportTypes(reportEEDWeeklyReportTypes);
            }
            paramSet.removeAllReportEnrollmentPriorityGroups();
            Set enrollmentPriorityGroups = this.getReportEnrollmentPriorityGroups(form.getPriorityGroup());
            if (enrollmentPriorityGroups != null && !enrollmentPriorityGroups.isEmpty()) {
                paramSet.addAllReportEnrollmentPriorityGroups(enrollmentPriorityGroups);
            }
            paramSet.removeAllVBAQueryStatuses();
            Set vbaQueryStatuses = this.getReportLookupParameter(form.getVbaQueryStatus(), AACIndicator.class, ReportVBAQueryStatus.class);
            if (vbaQueryStatuses != null && !vbaQueryStatuses.isEmpty()) {
                paramSet.addAllVBAQueryStatuses(vbaQueryStatuses);
            }
        }
        catch (ConversionServiceException cEx) {
            throw cEx;
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Error while converting form to bom", ex);
        }
    }

    private void convertReportSetupToForm(ReportSetup reportSetup, ReportParamInfoForm form) throws ConversionServiceException {
    }

    private void populateLetterFilesAndRejectErrors(ReportParamInfoForm form, ReportParameterSet paramSet) throws ConversionServiceException {
        paramSet.removeAllReportLinkLetterFiles();
        Set letterFiles = this.getReportLookupParameter(form.getLetterFile(), ReportLetterFile.class, ReportLinkLetterFile.class);
        if (letterFiles != null && !letterFiles.isEmpty()) {
            paramSet.addAllReportLinkLetterFiles(letterFiles);
        }
        paramSet.removeAllLetterRejectReasons();
        paramSet.removeAllLetterErrorTypes();
        paramSet.setAllLetterRejectReasons(false);
        paramSet.setAllLetterErrorTypes(false);
        String[] letterRejectErrors = new String[]{};
        String[] letterRejects = new String[]{};
        String[] letterErrors = new String[]{};
        Set reportLetterFileCodes = paramSet.getReportLetterFileCodes();
        if (reportLetterFileCodes.contains(ReportLetterFile.ERROR.getCode()) && reportLetterFileCodes.contains(ReportLetterFile.CODE_1_REJECT.getCode())) {
            letterRejectErrors = form.getLetterRejectErrorReason();
        } else if (reportLetterFileCodes.contains(ReportLetterFile.ERROR.getCode())) {
            letterErrors = form.getLetterErrorType();
        } else if (reportLetterFileCodes.contains(ReportLetterFile.CODE_1_REJECT.getCode())) {
            letterRejects = form.getLetterRejectReason();
        }
        if (reportLetterFileCodes.isEmpty()) {
            paramSet.setAllLetterRejectReasons(true);
            paramSet.setAllLetterErrorTypes(true);
        } else if (form.getAllLetterRejectErrorReasonSelected()) {
            paramSet.setAllLetterRejectReasons(true);
            paramSet.setAllLetterErrorTypes(true);
        } else {
            if (letterRejectErrors.length > 0) {
                ArrayList<String> letterRejectsList = new ArrayList<String>();
                ArrayList<String> letterErrorsList = new ArrayList<String>();
                for (int i = 0; i < letterRejectErrors.length; ++i) {
                    String code;
                    String prefixedCode = letterRejectErrors[i];
                    if (prefixedCode.startsWith("E.")) {
                        code = prefixedCode.substring("E.".length());
                        letterErrorsList.add(code);
                        continue;
                    }
                    if (!prefixedCode.startsWith("R.")) continue;
                    code = prefixedCode.substring("R.".length());
                    letterRejectsList.add(code);
                }
                letterRejects = letterRejectsList.toArray(new String[0]);
                letterErrors = letterErrorsList.toArray(new String[0]);
            }
            if (letterRejects.length > 0 || letterErrors.length > 0) {
                Set x;
                if (letterRejects.length > 0) {
                    if (form.getAllLetterRejectReasonSelected()) {
                        paramSet.setAllLetterRejectReasons(true);
                    } else {
                        x = this.getReportLookupParameter(letterRejects, ComAACRejectReasonType.class, ReportLetterRejectReason.class);
                        if (x != null && !x.isEmpty()) {
                            paramSet.addAllLetterRejectReasons(x);
                        }
                    }
                }
                if (letterErrors.length > 0) {
                    if (form.getAllLetterErrorTypeSelected()) {
                        paramSet.setAllLetterErrorTypes(true);
                    } else {
                        x = this.getReportLookupParameter(letterRejects, ComAACErrorType.class, ReportLetterErrorType.class);
                        if (x != null && !x.isEmpty()) {
                            paramSet.addAllLetterErrorTypes(x);
                        }
                    }
                }
            } else {
                if (reportLetterFileCodes.contains(ReportLetterFile.CODE_1_REJECT.getCode())) {
                    paramSet.setAllLetterRejectReasons(true);
                }
                if (reportLetterFileCodes.contains(ReportLetterFile.ERROR.getCode())) {
                    paramSet.setAllLetterErrorTypes(true);
                }
            }
        }
    }

    private void populateReportPeriod(ReportParamInfoForm form, ReportParameterSet parameSet) throws ConversionServiceException {
        parameSet.setReportPeriod(null);
        String reportPeriodType = form.getReportPeriodType();
        if (StringUtils.isNotEmpty((String)reportPeriodType)) {
            ReportPeriod reportPeriod = new ReportPeriod();
            if (StringUtils.equals((String)form.getTabName(), (String)"scheduledReports")) {
                String generateReport = ((ReportScheduleInfoForm)form).getGenerateReportNoDefault();
                if (StringUtils.equals((String)generateReport, (String)ReportRunFrequency.OTHER.getCode()) && StringUtils.equals((String)reportPeriodType, (String)ReportPeriodType.CODE_DATE_RANGE.getName())) {
                    parameSet.setReportPeriod(reportPeriod);
                    reportPeriod.setFromDate(gov.va.med.esr.ui.common.util.DateUtils.getDate((String)form.getReportPeriodStartDate()));
                    reportPeriod.setToDate(gov.va.med.esr.ui.common.util.DateUtils.getDate((String)form.getReportPeriodEndDate()));
                }
            } else {
                parameSet.setReportPeriod(reportPeriod);
                reportPeriod.setType((ReportPeriodType)this.getLookup(ReportPeriodType.class, form.getReportPeriodType()));
                if (StringUtils.equals((String)reportPeriodType, (String)ReportPeriodType.CODE_ALL_FISCAL_YEARS.getName())) {
                    reportPeriod.setYear(new Integer(DateUtils.getFiscalYear((Date)gov.va.med.esr.ui.common.util.DateUtils.getDate((String)form.getAsOfDate()))));
                } else if (StringUtils.equals((String)reportPeriodType, (String)ReportPeriodType.CODE_FISCAL_YEAR.getName())) {
                    reportPeriod.setYear(this.getInteger(form.getReportPeriodYear()));
                } else if (StringUtils.equals((String)reportPeriodType, (String)ReportPeriodType.CODE_QUARTERLY.getName())) {
                    reportPeriod.setYear(this.getInteger(form.getReportPeriodQuarterYear()));
                    reportPeriod.setQuarter((Quarter)this.getLookup(Quarter.class, form.getReportPeriodQuarter()));
                } else if (StringUtils.equals((String)reportPeriodType, (String)ReportPeriodType.CODE_DATE_RANGE.getName())) {
                    reportPeriod.setFromDate(gov.va.med.esr.ui.common.util.DateUtils.getDate((String)form.getReportPeriodStartDate()));
                    reportPeriod.setToDate(gov.va.med.esr.ui.common.util.DateUtils.getDate((String)form.getReportPeriodEndDate()));
                }
            }
        }
    }

    private void populateReportSchedule(ReportScheduleInfoForm form, ReportSetup reportSetup) throws ConversionServiceException {
        String generateReport = form.getGenerateReportNoDefault();
        if (StringUtils.isNotEmpty((String)generateReport)) {
            ReportSchedule schedule = new ReportSchedule();
            reportSetup.setSchedule(schedule);
            schedule.setRunFrequency((ReportRunFrequency)this.getLookup(ReportRunFrequency.class, generateReport));
            String scheduleType = form.getScheduleType();
            if (StringUtils.equals((String)generateReport, (String)ReportRunFrequency.DAILY_WEEKLY.getCode())) {
                scheduleType = ReportScheduleType.DAY_OF_WEEK.getCode();
                Set dayOfWeeks = this.getReportLookupParameter(form.getDailyWeeklyDay(), DayOfWeek.class, ReportDayOfWeek.class);
                if (dayOfWeeks != null && !dayOfWeeks.isEmpty()) {
                    schedule.addAllDaysOfWeek(dayOfWeeks);
                }
            } else if (StringUtils.equals((String)generateReport, (String)ReportRunFrequency.MONTHLY.getCode())) {
                if (StringUtils.equals((String)scheduleType, (String)ReportScheduleType.DAY_OF_MONTH.getCode())) {
                    schedule.setDayOfMonth((DayOfMonth)this.getLookup(DayOfMonth.class, form.getMonthlyDayOfEveryMonthNoDefault()));
                } else if (StringUtils.equals((String)scheduleType, (String)ReportScheduleType.WEEK_DAY.getCode())) {
                    schedule.setWeekOfMonth((WeekOfMonth)this.getLookup(WeekOfMonth.class, form.getMonthlyWeekOfEveryMonthNoDefault()));
                    schedule.setDayOfWeek((DayOfWeek)this.getLookup(DayOfWeek.class, form.getMonthlyDayOfEveryWeekNoDefault()));
                }
            } else if (StringUtils.equals((String)generateReport, (String)ReportRunFrequency.QUARTERLY.getCode())) {
                scheduleType = ReportScheduleType.DAY_OF_QUARTER.getCode();
                schedule.setDayOfQuarter((DayOfQuarter)this.getLookup(DayOfQuarter.class, form.getQuarterlyDayOfQuarterNoDefault()));
            } else if (StringUtils.equals((String)generateReport, (String)ReportRunFrequency.YEARLY.getCode())) {
                if (StringUtils.equals((String)scheduleType, (String)ReportScheduleType.MONTH_DAY.getCode())) {
                    schedule.setMonth((Month)this.getLookup(Month.class, form.getYearlyMonthOfYearNoDefault()));
                    schedule.setNumericDayOfMonth(this.getInteger(form.getYearlyDayOfMonthNoDefault()));
                } else if (StringUtils.equals((String)scheduleType, (String)ReportScheduleType.WEEK_DAY_MONTH.getCode())) {
                    schedule.setWeekOfMonth((WeekOfMonth)this.getLookup(WeekOfMonth.class, form.getYearlyWeekOfMonthNoDefault()));
                    schedule.setDayOfWeek((DayOfWeek)this.getLookup(DayOfWeek.class, form.getYearlyDayOfWeekNoDefault()));
                    schedule.setMonth((Month)this.getLookup(Month.class, form.getYearlyMonthNoDefault()));
                }
            } else if (StringUtils.equals((String)generateReport, (String)ReportRunFrequency.OTHER.getCode())) {
                scheduleType = ReportScheduleType.DATE.getCode();
                schedule.setDateToGenerate(gov.va.med.esr.ui.common.util.DateUtils.getDate((String)form.getOtherDateToGenerateReport()));
            }
            if (StringUtils.isNotEmpty((String)scheduleType)) {
                schedule.setScheduleType((ReportScheduleType)this.getLookup(ReportScheduleType.class, scheduleType));
            }
            schedule.setHour(this.getInteger(form.getTimeToGenerateReportHourNoDefault()));
            schedule.setMinute(this.getInteger(form.getTimeToGenerateReportMinuteNoDefault()));
        }
    }

    private Set getReportEnrollmentPriorityGroups(String[] code) throws ConversionServiceException {
        if (code == null || code.length == 0) {
            return null;
        }
        HashSet<ReportEnrollmentPriorityGroup> ePriorityGroup = new HashSet<ReportEnrollmentPriorityGroup>();
        try {
            if (StringUtils.contains((String[])code, (String)"all")) {
                Collection ePriorityGroups = this.getLookupCacheService().getFromCache(EnrollmentPriorityGroup.class.getName());
                Collection ePrioritySubGroups = this.getLookupCacheService().getFromCache(EnrollmentPrioritySubGroup.class.getName());
                ReportEnrollmentPriorityGroup reportLookupParam = null;
                for (EnrollmentPriorityGroup priorityGroupLookup : ePriorityGroups) {
                    if (StringUtils.equals((String)priorityGroupLookup.getCode(), (String)EnrollmentPriorityGroup.GROUP_7.getName()) || StringUtils.equals((String)priorityGroupLookup.getCode(), (String)EnrollmentPriorityGroup.GROUP_8.getName())) {
                        Iterator subIter = ePrioritySubGroups.iterator();
                        while (subIter.hasNext()) {
                            reportLookupParam = (ReportEnrollmentPriorityGroup)ReportEnrollmentPriorityGroup.class.newInstance();
                            reportLookupParam.setEnrollmentPriorityGroup(priorityGroupLookup);
                            EnrollmentPrioritySubGroup prioritySubGroupLookup = (EnrollmentPrioritySubGroup)subIter.next();
                            reportLookupParam.setEnrollmentPrioritySubGroup(prioritySubGroupLookup);
                            if (reportLookupParam == null) continue;
                            ePriorityGroup.add(reportLookupParam);
                        }
                    } else {
                        reportLookupParam = (ReportEnrollmentPriorityGroup)ReportEnrollmentPriorityGroup.class.newInstance();
                        reportLookupParam.setEnrollmentPriorityGroup(priorityGroupLookup);
                        if (reportLookupParam != null) {
                            ePriorityGroup.add(reportLookupParam);
                        }
                    }
                    if (reportLookupParam == null) continue;
                    ePriorityGroup.add(reportLookupParam);
                }
            } else {
                for (int i = 0; i < code.length; ++i) {
                    if (StringUtils.isEmpty((String)code[i])) continue;
                    String[] codes = StringUtils.split((String)code[i], (String)",");
                    String priorityCode = codes[0];
                    String prioritySubCode = codes.length > 1 ? codes[1] : null;
                    EnrollmentPriorityGroup priorityGroupLookup = (EnrollmentPriorityGroup)this.getLookup(EnrollmentPriorityGroup.class, priorityCode);
                    ReportEnrollmentPriorityGroup reportLookupParam = null;
                    if (priorityGroupLookup == null) continue;
                    reportLookupParam = (ReportEnrollmentPriorityGroup)ReportEnrollmentPriorityGroup.class.newInstance();
                    reportLookupParam.setEnrollmentPriorityGroup(priorityGroupLookup);
                    EnrollmentPrioritySubGroup prioritySubGroupLookup = (EnrollmentPrioritySubGroup)this.getLookup(EnrollmentPrioritySubGroup.class, prioritySubCode);
                    if (prioritySubGroupLookup != null) {
                        reportLookupParam.setEnrollmentPrioritySubGroup(prioritySubGroupLookup);
                    }
                    if (reportLookupParam == null) continue;
                    ePriorityGroup.add(reportLookupParam);
                }
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Error while creating EnrollmentPriorityGroups", ex);
        }
        return ePriorityGroup;
    }

    private void populateFacilities(ReportScheduleInfoForm form, ReportParameterSet paramSet) throws ConversionServiceException {
        String facilityDisplayBy = form.getFacilityDisplayByNoDefault();
        paramSet.setFacilityDisplayBy((ReportFacilityDisplayBy)this.getLookup(ReportFacilityDisplayBy.class, facilityDisplayBy));
        Set facilities = null;
        if (StringUtils.equals((String)facilityDisplayBy, (String)ReportFacilityDisplayBy.CODE_VISN.getCode())) {
            facilities = this.getVISNFacilities(this.merge(form.getVisn(), form.getStationNumbersAsArray()));
        } else if (StringUtils.equals((String)facilityDisplayBy, (String)ReportFacilityDisplayBy.CODE_VISN_SITE.getCode())) {
            facilities = this.getFacilitiesForVisnSite(this.merge(form.getVisnFacility(), form.getStationNumbersAsArray()));
        } else if (StringUtils.equals((String)facilityDisplayBy, (String)ReportFacilityDisplayBy.CODE_SITE.getCode())) {
            facilities = this.getFacilitiesForSite(this.merge(form.getFacility(), form.getStationNumbersAsArray()));
        } else if (StringUtils.equals((String)facilityDisplayBy, (String)ReportFacilityDisplayBy.CODE_VAMC.getCode())) {
            facilities = this.getFacilitiesForVISNVAMCSite(this.merge(form.getVamcs(), form.getStationNumbersAsArray()));
        } else if (StringUtils.equals((String)facilityDisplayBy, (String)ReportFacilityDisplayBy.CODE_VAMC_SITE.getCode())) {
            facilities = this.getFacilitiesForVISNVAMCSite(this.merge(form.getVamcFacility(), form.getStationNumbersAsArray()));
        } else if (StringUtils.equals((String)facilityDisplayBy, (String)ReportFacilityDisplayBy.CODE_VISN_VAMC_SITE.getCode())) {
            facilities = this.getFacilitiesForVISNVAMCSite(this.merge(form.getVisnVamcFacility(), form.getStationNumbersAsArray()));
        } else if (StringUtils.equals((String)facilityDisplayBy, (String)ReportFacilityDisplayBy.CODE_VISN_VAMC.getCode())) {
            facilities = this.getFacilitiesForVISNVAMCSite(this.merge(form.getVisnVamc(), form.getStationNumbersAsArray()));
        }
        paramSet.removeAllFacilities();
        if (facilities != null) {
            for (VAFacility facility : facilities) {
                if (facility == null) continue;
                ReportFacility reportFacility = new ReportFacility();
                reportFacility.setFacility(facility);
                paramSet.addFacility(reportFacility);
            }
        }
    }

    private Set getFacilitiesForVISNVAMCSite(String[] code) throws ConversionServiceException {
        HashSet<VAFacility> facilities = new HashSet<VAFacility>();
        try {
            if (code != null && code.length > 0) {
                if (StringUtils.contains((String[])code, (String)"all")) {
                    facilities = new HashSet();
                } else if (StringUtils.contains((String[])code, (String)"allVAMCs")) {
                    Collection vamcs = this.getLookupCacheService().getFromCache(VAMC.class.getName());
                    if (vamcs != null) {
                        facilities.addAll(vamcs);
                    }
                } else {
                    Collection vamcs = this.getLookupCacheService().getFromCache(VAMC.class.getName());
                    Map parentSiteMap = this.getLookupCacheService().getParentSiteMap();
                    VAFacility vamc = null;
                    VAFacility facility = null;
                    HashSet<String> visnCode = new HashSet<String>();
                    for (int i = 0; i < code.length; ++i) {
                        if (!StringUtils.isNotEmpty((String)code[i])) continue;
                        if (code[i].startsWith("VISN")) {
                            visnCode.add(code[i]);
                            continue;
                        }
                        vamc = this.getVAMC(vamcs, code[i]);
                        if (vamc != null) {
                            facilities.add(vamc);
                            List vamcSites = (List)parentSiteMap.get(vamc.getIdentifier());
                            if (vamcSites == null) continue;
                            facilities.addAll(vamcSites);
                            continue;
                        }
                        facility = (VAFacility)this.getLookup(VAFacility.class, code[i]);
                        if (facility == null) continue;
                        facilities.add(facility);
                    }
                    Set lookups = this.getFacilitiesForVisnVamc(this.getStringArrayFromSet(visnCode), parentSiteMap);
                    if (lookups != null) {
                        facilities.addAll(lookups);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Error while getting VISN/VAMC/Site map", ex);
        }
        return facilities;
    }

    private Set getFacilitiesForVisnVamc(String[] code, Map parentSiteMap) throws ConversionServiceException {
        HashSet<VAFacility> facilities = new HashSet<VAFacility>();
        Set lookups = this.getLookups(VISN.class, code);
        if (lookups != null && !lookups.isEmpty()) {
            try {
                Map visnVamcMap = this.getLookupCacheService().getVISNVAMCMap();
                Iterator iter = lookups.iterator();
                while (iter.hasNext()) {
                    List list = (List)visnVamcMap.get(iter.next());
                    if (list == null || list.isEmpty()) continue;
                    for (VAFacility vamc : list) {
                        facilities.add(vamc);
                        List sites = (List)parentSiteMap.get(vamc.getIdentifier());
                        if (sites == null) continue;
                        facilities.addAll(sites);
                    }
                }
            }
            catch (Exception ex) {
                throw new ConversionServiceException("Error while getting VISN/VAMC map", ex);
            }
        }
        return facilities;
    }

    private VAFacility getVAMC(Collection vamcs, String code) {
        if (vamcs != null) {
            VAFacility site2 = null;
            for (VAFacility site2 : vamcs) {
                if (!site2.getCode().equals(code)) continue;
                return site2;
            }
        }
        return null;
    }

    private Set getVISNFacilities(String[] code) throws ConversionServiceException {
        HashSet<VAFacility> lookups = null;
        try {
            if (code != null && code.length > 0) {
                if (StringUtils.contains((String[])code, (String)"all")) {
                    Collection visns = this.getLookupCacheService().getFromCache(VISN.class.getName());
                    lookups = new HashSet();
                    if (visns != null) {
                        VAFacility facility = null;
                        VISN visn2 = null;
                        for (VISN visn2 : visns) {
                            facility = visn2 != null ? (VAFacility)this.getLookupByName(VAFacility.class, visn2.getCode()) : null;
                            if (facility == null) continue;
                            lookups.add(facility);
                        }
                        VAFacility noVISNFacility = new VAFacility();
                        noVISNFacility.setVisnId(VISN.CODE_NO_VISN_IDENTIFIER);
                        lookups.add(noVISNFacility);
                    }
                } else {
                    lookups = new HashSet<VAFacility>();
                    VAFacility facility = null;
                    for (int i = 0; i < code.length; ++i) {
                        if (StringUtils.equals((String)VISN.CODE_NO_VISN.getCode(), (String)code[i])) {
                            facility = new VAFacility();
                            facility.setVisnId(VISN.CODE_NO_VISN_IDENTIFIER);
                        } else {
                            facility = (VAFacility)this.getLookupByName(VAFacility.class, code[i]);
                        }
                        if (facility == null) continue;
                        lookups.add(facility);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Error while getting VISN lookup object VAFacility and name = " + code, ex);
        }
        return lookups;
    }

    private Set getFacilitiesForVisn(String[] code) throws ConversionServiceException {
        HashSet facilities = new HashSet();
        if (code == null || code.length == 0) {
            return facilities;
        }
        ArrayList<String> validCodes = new ArrayList<String>();
        Map visnSiteMap = null;
        try {
            visnSiteMap = this.getLookupCacheService().getVISNSiteMap();
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Error while getting VISN/Site map", ex);
        }
        for (int i = 0; i < code.length; ++i) {
            String currentCode = code[i];
            if (VISN.CODE_NO_VISN.getCode().equals(currentCode)) {
                List list = (List)visnSiteMap.get(VISN.getNoVISN());
                if (list == null || list.isEmpty()) continue;
                facilities.addAll(list);
                continue;
            }
            validCodes.add(currentCode);
        }
        Set lookups = null;
        if (!validCodes.isEmpty()) {
            String[] validCodesArr = new String[validCodes.size()];
            for (int i = 0; i < validCodes.size(); ++i) {
                validCodesArr[i] = (String)validCodes.get(i);
            }
            lookups = this.getLookups(VISN.class, validCodesArr);
        }
        if (lookups != null && !lookups.isEmpty()) {
            Iterator iter = lookups.iterator();
            while (iter.hasNext()) {
                List list = (List)visnSiteMap.get(iter.next());
                if (list == null || list.isEmpty()) continue;
                facilities.addAll(list);
            }
        }
        return facilities;
    }

    private Set getFacilitiesForVisnSite(String[] code) throws ConversionServiceException {
        HashSet facilities = new HashSet();
        if (code != null && code.length > 0) {
            if (StringUtils.contains((String[])code, (String)"all")) {
                facilities = new HashSet();
            } else {
                HashSet<String> visnCode = new HashSet<String>();
                HashSet<String> facilityCode = new HashSet<String>();
                for (int i = 0; i < code.length; ++i) {
                    if (!StringUtils.isNotEmpty((String)code[i])) continue;
                    if (code[i].startsWith(VISN.CODE_NO_VISN.getCode()) || code[i].startsWith("VISN") || code[i].equals("all")) {
                        visnCode.add(code[i]);
                        continue;
                    }
                    facilityCode.add(code[i]);
                }
                Set lookups = this.getFacilitiesForVisn(this.getStringArrayFromSet(visnCode));
                if (lookups != null) {
                    facilities.addAll(lookups);
                }
                if ((lookups = this.getLookups(VAFacility.class, this.getStringArrayFromSet(facilityCode))) != null) {
                    facilities.addAll(lookups);
                }
            }
        }
        return facilities;
    }

    private Set getFacilitiesForSite(String[] code) throws ConversionServiceException {
        Set facilities = null;
        if (code != null && code.length > 0) {
            facilities = StringUtils.contains((String[])code, (String)"all") ? new HashSet() : this.getLookups(VAFacility.class, code);
        }
        return facilities;
    }

    private void populateQueryTo(ReportScheduleInfoForm form, ReportParameterSet paramSet) throws ConversionServiceException {
        String[] queryTo = form.getQueryTo();
        Collection facilities = null;
        if (StringUtils.contains((String[])queryTo, (String)"allSites")) {
            facilities = this.getLookups(VAFacilityExceptVBA.class);
        } else if (StringUtils.contains((String[])queryTo, (String)"allSitesAndVBA")) {
            facilities = this.getLookups(VAFacility.class);
        } else if (StringUtils.contains((String[])queryTo, (String)VBA)) {
            facilities = this.getLookups(VAFacility.class, queryTo);
        }
        paramSet.removeAllQueryToSites();
        if (facilities != null) {
            for (VAFacility facility : facilities) {
                if (facility == null) continue;
                ReportQueryToSite reportQueryToSite = new ReportQueryToSite();
                reportQueryToSite.setQueryToSite(facility);
                paramSet.addQueryToSite(reportQueryToSite);
            }
        }
    }

    private Set getReportUserParameter(String[] code) throws ConversionServiceException {
        if (code == null || code.length == 0) {
            return null;
        }
        HashSet<ReportUser> reportParam = null;
        try {
            reportParam = new HashSet<ReportUser>();
            for (int i = 0; i < code.length; ++i) {
                String code1 = code[i];
                if ("all".equals(code1)) continue;
                ESRUserPrincipalImpl user = this.getUserAdminService().findUserByName(code1);
                ReportUser reportUser = new ReportUser();
                reportUser.setUser((ESRUserPrincipal)user);
                reportParam.add(reportUser);
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Error while converting " + ESRUserPrincipal.class.getName(), ex);
        }
        return reportParam;
    }

    private Set getMessageErrorReportLookupParameter(String code, Class lookupType, Class reportParamType) throws ConversionServiceException {
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        Set reportParam = null;
        if (StringUtils.equals((String)code, (String)"all")) {
            String[] codes = new String[]{AckType.CODE_AE.getCode(), AckType.CODE_AR.getCode()};
            reportParam = this.getReportLookupParameter(codes, lookupType, reportParamType);
        } else {
            reportParam = this.getReportLookupParameter(code, lookupType, reportParamType);
        }
        return reportParam;
    }

    private Set getReportLookupParameter(String code, Class lookupType, Class reportParamType) throws ConversionServiceException {
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        String[] codes = new String[]{code};
        return this.getReportLookupParameter(codes, lookupType, reportParamType);
    }

    private Set getReportLookupParameter(String[] code, Class lookupType, Class reportParamType) throws ConversionServiceException {
        if (code == null || code.length == 0) {
            return null;
        }
        Set lookups = this.getLookups(lookupType, code);
        HashSet<BaseReportLookupParameter> reportParam = null;
        if (lookups != null && !lookups.isEmpty()) {
            try {
                reportParam = new HashSet<BaseReportLookupParameter>();
                Iterator iter = lookups.iterator();
                while (iter.hasNext()) {
                    BaseReportLookupParameter lookupParameter = this.createReportLookupParameter((Lookup)iter.next(), reportParamType);
                    reportParam.add(lookupParameter);
                }
            }
            catch (ConversionServiceException cEx) {
                throw cEx;
            }
            catch (Exception ex) {
                throw new ConversionServiceException("Error while converting " + reportParamType.getName(), ex);
            }
        }
        return reportParam;
    }

    private BaseReportLookupParameter createReportLookupParameter(Lookup lookup, Class reportParamType) throws ConversionServiceException {
        try {
            BaseReportLookupParameter lookupParameter = (BaseReportLookupParameter)reportParamType.newInstance();
            lookupParameter.setLookup(lookup);
            return lookupParameter;
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Error while creating report lookup parameter " + reportParamType.getName(), ex);
        }
    }

    private Set getLookups(Class clazz, String[] code) throws ConversionServiceException {
        HashSet<Lookup> lookups = null;
        try {
            if (code != null && code.length > 0) {
                if (StringUtils.contains((String[])code, (String)"all")) {
                    lookups = new HashSet(this.getLookupCacheService().getFromCache(clazz.getName()));
                } else {
                    lookups = new HashSet<Lookup>();
                    Lookup lookup = null;
                    for (int i = 0; i < code.length; ++i) {
                        lookup = this.getLookup(clazz, code[i]);
                        if (lookup == null) continue;
                        lookups.add(this.getLookup(clazz, code[i]));
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Error while getting lookup object for type = " + clazz.getName() + " code = " + code, ex);
        }
        return lookups;
    }

    private Collection getLookups(Class clazz) throws ConversionServiceException {
        try {
            return this.getLookupCacheService().getFromCache(clazz.getName());
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Error while getting lookup object for type = " + clazz.getName(), ex);
        }
    }

    private Lookup getLookupByName(Class clazz, String name) throws ConversionServiceException {
        AbstractLookup lookup = null;
        try {
            if (StringUtils.isNotEmpty((String)name)) {
                lookup = this.getLookupCacheService().getLookupService().getByName(clazz, name);
            }
        }
        catch (Exception ex) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Error while getting lookup object for ");
            buffer.append(" type = " + clazz.getName());
            buffer.append(" name = " + name);
            throw new ConversionServiceException(buffer.toString(), ex);
        }
        return lookup;
    }

    private Integer getInteger(String value) {
        return StringUtils.isNotEmpty((String)value) ? new Integer(value) : null;
    }

    private boolean getTrueFalse(String flag) {
        return StringUtils.equals((String)flag, (String)"y");
    }

    protected static void setPrivateFieldData(Object obj, Class clazz, String methodName, Object data) {
        try {
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(methodName)) continue;
                Object[] params = new Object[]{data};
                methods[i].setAccessible(true);
                methods[i].invoke(obj, params);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String[] merge(String[] setOne, String[] SetTwo) {
        int i;
        HashSet<String> newSet = new HashSet<String>();
        if (setOne != null && setOne.length > 0) {
            for (i = 0; i < setOne.length; ++i) {
                newSet.add(setOne[i]);
            }
        }
        if (SetTwo != null && SetTwo.length > 0) {
            for (i = 0; i < SetTwo.length; ++i) {
                newSet.add(SetTwo[i]);
            }
        }
        return this.getStringArrayFromSet(newSet);
    }

    private String[] getStringArrayFromSet(Set set) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        String[] code = new String[set.size()];
        int i = 0;
        for (String string : set) {
            if (!StringUtils.isNotEmpty((String)string)) continue;
            code[i] = string;
            ++i;
        }
        return code;
    }
}

