/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.report.action;

import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.common.model.report.CompletedReport;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.report.action.ReportActionHelper;
import gov.va.med.fw.report.ReportExportedType;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.Validate;

public class ReportBean
implements Serializable {
    private static final long serialVersionUID = -1370346746640850300L;
    private ReportSetup reportSetup;
    private ReportParameterSet paramSet;
    private StandardReport stdReport;
    private CompletedReport completedReport;

    public ReportBean(ReportSetup reportSetup) {
        Validate.notNull((Object)reportSetup, (String)"ReportSetup report cannot be null");
        this.reportSetup = reportSetup;
        this.stdReport = this.reportSetup.getReport();
        this.paramSet = this.reportSetup.getParameterSet();
    }

    public ReportBean(CompletedReport completedReport) {
        Validate.notNull((Object)completedReport, (String)"CompletedReport report cannot be null");
        this.stdReport = completedReport.getStandardReport();
    }

    public String getId() {
        return null;
    }

    public String getReportId() {
        return this.stdReport != null ? this.stdReport.getCode() : "";
    }

    public String getReportIdNoSpace() {
        return ReportActionHelper.getRemoveSpaceAndDash(this.getReportId());
    }

    public String getType() {
        return this.stdReport != null && this.stdReport.getType() != null ? this.stdReport.getType().getDescription() : "";
    }

    public String getName() {
        return this.stdReport != null ? this.stdReport.getDescription() : "";
    }

    public String getScheduledRunDate() {
        return DateUtils.format((Date)DateUtils.getCurrentDate(), (String)"MM/dd/yyyy");
    }

    public String getCompletedDate() {
        return DateUtils.format((Date)(this.completedReport != null ? this.completedReport.getCompletedDate() : null), (String)"MM/dd/yyyy");
    }

    public ReportExportedType getFileType() {
        ReportExportedType fileType;
        ReportExportedType reportExportedType = fileType = this.paramSet != null ? this.paramSet.getFileType() : null;
        if (fileType == null) {
            fileType = this.completedReport != null ? this.completedReport.getFileType() : null;
        }
        return fileType;
    }
}

