/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.report.action;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.common.model.report.CompletedReport;
import gov.va.med.esr.common.report.data.ReportParameterConfig;
import gov.va.med.esr.service.StandardReportService;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.esr.ui.report.action.ReportActionHelper;
import gov.va.med.esr.ui.report.action.ReportConstants;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import gov.va.med.fw.util.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mlw.vlh.ValueList;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.web.context.ServletContextAware;

public class ReportAction
extends AbstractAction
implements ReportConstants,
ServletContextAware {
    private ServletContext servletContext;
    private ReportParameterConfig reportParameterConfig;
    private StandardReportService standardReportService;

    public ActionForward displayAvailableReports(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List reports = this.getStandardReports(request);
        if (reports != null && reports.size() > 0) {
            ValueList valueList = ValueListActionUtils.getValueList((ActionForm)actionForm, (HttpServletRequest)request, (String)"stdReportTableId", (String)"stdReportsValueListAdapter", (List)reports);
            ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
        }
        return mapping.findForward("displayAvailableReports");
    }

    public ActionForward displayReport(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String reportId = request.getParameter("reportId");
        CompletedReport compltReport = this.getCompletedReport(request, reportId);
        if (compltReport != null) {
            String fileType;
            byte[] buffer = compltReport.getReportFileContent();
            String string = fileType = compltReport.getFileType() != null ? compltReport.getFileType().getCode() : null;
            if (StringUtils.equals((String)fileType, (String)ReportExportedType.PDF.getCode())) {
                response.setHeader("Content-Disposition", "inline; filename=report.pdf");
                this.writeReportToReponse(buffer, "application/pdf", response);
            } else if (StringUtils.equals((String)fileType, (String)ReportExportedType.CSV.getCode())) {
                response.setHeader("Content-Disposition", "inline; filename=report.csv");
                this.writeReportToReponse(buffer, "application/csv", response);
            }
        } else {
            this.writeMessageToReponse("Report/report id is empty", response);
        }
        return null;
    }

    protected List getStandardReports(HttpServletRequest request) throws ServiceException {
        List standardReports = (List)request.getSession().getAttribute("standardReportList");
        if (standardReports == null) {
            List reportIds = this.getReportParameterConfig().getReportIds();
            List stdReports = this.getStandardReportService().getStandardReports(this.getLoggedInUser());
            standardReports = this.getFilteredStandardReports(stdReports, reportIds);
            Comparator comparator = new Comparator(){

                public int compare(Object pObject1, Object pObject2) {
                    String name1 = pObject1 != null && pObject1 instanceof StandardReport ? ((StandardReport)pObject1).getDescription() : null;
                    String name2 = pObject2 != null && pObject2 instanceof StandardReport ? ((StandardReport)pObject2).getDescription() : null;
                    return name1 != null && name2 != null ? name1.compareTo(name2) : 0;
                }
            };
            Collections.sort(standardReports, comparator);
            request.getSession().setAttribute("standardReportList", (Object)standardReports);
        }
        return standardReports;
    }

    private List getFilteredStandardReports(List stdReports, List reportIds) {
        ArrayList<StandardReport> standardReports = new ArrayList<StandardReport>();
        if (reportIds != null && !reportIds.isEmpty()) {
            for (StandardReport stdReport : stdReports) {
                if (!stdReport.isActive() || !reportIds.contains(ReportActionHelper.getRemoveSpaceAndDash(stdReport.getCode()))) continue;
                if (stdReport.getCode().equals(StandardReport.CODE_QM_26.getCode())) continue;
                if (stdReport.getCode().equals(StandardReport.CODE_QM_27.getCode())) continue;
                standardReports.add(stdReport);
            }
        }
        return standardReports;
    }

    protected StandardReport getStandardReport(HttpServletRequest request, String reportId) throws ServiceException {
        Map standardReportsMap = this.getStandardReportsMap(request);
        return standardReportsMap != null ? (StandardReport)standardReportsMap.get(reportId) : null;
    }

    protected CompletedReport getCompletedReport(HttpServletRequest request, String reportId) throws ServiceException {
        EntityKey key = StringUtils.isNotEmpty((String)reportId) ? CommonEntityKeyFactory.createCompletedReportEntityKey((String)reportId) : null;
        return key != null ? this.getStandardReportService().getCompletedReport(key) : null;
    }

    private Map getStandardReportsMap(HttpServletRequest request) throws ServiceException {
        HashMap<String, StandardReport> standardReportsMap = (HashMap<String, StandardReport>)request.getSession().getAttribute("standardReportMap");
        if (standardReportsMap == null) {
            List standardReports = this.getStandardReports(request);
            if (standardReports != null) {
                standardReportsMap = new HashMap<String, StandardReport>();
                StandardReport stdReport2 = null;
                for (StandardReport stdReport2 : standardReports) {
                    standardReportsMap.put(stdReport2.getCode(), stdReport2);
                }
            }
            request.setAttribute("standardReportMap", standardReportsMap);
        }
        return standardReportsMap;
    }

    protected Map getKeyMethodMap() {
        if (this.keyMethodMap == null) {
            this.keyMethodMap = new HashMap();
            this.keyMethodMap.put("button.displayAvailableReports", "displayAvailableReports");
            this.keyMethodMap.put("button.displayScheduledReports", "resetFilter");
            this.keyMethodMap.put("button.displayCompletedReports", "resetFilter");
            this.keyMethodMap.put("button.displayArchivedReports", "resetFilter");
            this.keyMethodMap.put("button.displayReport", "displayReport");
            this.keyMethodMap.put("button.displayReportParameters", "displayReportParameters");
            this.keyMethodMap.put("button.runReport", "generateReport");
            this.keyMethodMap.put("button.displayReportSelection", "displayReportSelection");
            this.keyMethodMap.put("button.displayAddReportSchedule", "displayAddReportSchedule");
            this.keyMethodMap.put("button.add", "addReportSchedule");
            this.keyMethodMap.put("button.displayUpdateReportSchedule", "displayUpdateReportSchedule");
            this.keyMethodMap.put("button.update", "updateReportSchedule");
            this.keyMethodMap.put("button.cancel", "cancel");
            this.keyMethodMap.put("button.applyFilter", "applyFilter");
            this.keyMethodMap.put("button.goFilter", "applyFilter");
            this.keyMethodMap.put("button.resetFilter", "resetFilter");
            this.keyMethodMap.put("button.display", "displayReportData");
            this.keyMethodMap.put("button.cancelScheduledReport", "cancelScheduledReport");
            this.keyMethodMap.put("button.deleteCompletedReport", "deleteCompletedReport");
            this.keyMethodMap.put("button.inactivateCompletedReport", "inactivateCompletedReport");
            this.keyMethodMap.put("button.refresh", "refreshData");
        }
        return this.keyMethodMap;
    }

    private void writeReportToReponse(byte[] buffer, String contentType, HttpServletResponse response) throws IOException {
        response.setContentType(contentType);
        ServletOutputStream outStream = response.getOutputStream();
        outStream.write(buffer);
        outStream.close();
    }

    private void writeMessageToReponse(String msg, HttpServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.write(msg);
        writer.close();
    }

    public ReportParameterConfig getReportParameterConfig() {
        return this.reportParameterConfig;
    }

    public void setReportParameterConfig(ReportParameterConfig reportParameterConfig) {
        this.reportParameterConfig = reportParameterConfig;
    }

    @Override
    public StandardReportService getStandardReportService() {
        return this.standardReportService;
    }

    @Override
    public void setStandardReportService(StandardReportService standardReportService) {
        this.standardReportService = standardReportService;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void afterPropertiesSet() {
        Validate.notNull((Object)this.reportParameterConfig, (String)"Report Parameter configuration cannot be null");
        Validate.notNull((Object)this.standardReportService, (String)"standardReportService cannot be null");
        if (this.servletContext != null && this.reportParameterConfig != null) {
            this.servletContext.setAttribute("reportParamConfigMap", (Object)this.reportParameterConfig.getParameterMap());
        }
    }
}

