/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.report.action;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.ReportType;
import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.service.ReportFilter;
import gov.va.med.esr.service.ReportStatus;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.report.action.CompletedReportsForm;
import gov.va.med.esr.ui.report.action.ReportFilterAction;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.persistent.NoRecordFoundException;
import gov.va.med.fw.report.ReportException;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.mlw.vlh.ValueList;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class CompletedReportsAction
extends ReportFilterAction {
    @Override
    public String getTableId() {
        return "cmpReportTableId";
    }

    @Override
    public String getValueListAdapter() {
        return "cmpReportsValueListAdapter";
    }

    @Override
    public ActionForward displayReportData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CompletedReportsForm filterForm = (CompletedReportsForm)form;
        filterForm.setDisplayFilter(false);
        filterForm.setFilterApplied(filterForm.getContainsFilterCriteria());
        ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)this.getTableId(), (String)this.getValueListAdapter());
        ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
        if (!filterForm.isFilterCached()) {
            this.cacheReportFilters(request, filterForm);
        }
        this.processMessagesInSession(request);
        return mapping.findForward("displayData");
    }

    @Override
    public ActionForward applyFilter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CompletedReportsForm filterForm = (CompletedReportsForm)form;
        if (!this.validateFilter(request, filterForm)) {
            if (ValueListActionUtils.isCachedResults((HttpSession)request.getSession(), (String)this.getTableId())) {
                ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)this.getTableId(), (String)this.getValueListAdapter());
                ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
            }
            filterForm.setDisplayFilter(true);
            return mapping.findForward("displayData");
        }
        return this.refreshData(mapping, form, request, response);
    }

    @Override
    public ActionForward refreshData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CompletedReportsForm filterForm = (CompletedReportsForm)form;
        filterForm.setFilterCached(false);
        return super.refreshData(mapping, form, request, response);
    }

    public ActionForward deleteCompletedReport(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String reportId = request.getParameter("deleteReportId");
        String isInactiveReport = request.getParameter("isInactiveReport");
        EntityKey key = CommonEntityKeyFactory.createSimpleCompletedReportEntityKey((String)reportId);
        try {
            this.getStandardReportService().deleteCompletedReport(key, this.getLoggedInUser());
        }
        catch (NoRecordFoundException ex) {
            return mapping.findForward("displayCompletedReportsDeleteInvalidId");
        }
        if (isInactiveReport != null && isInactiveReport.trim().equals("true")) {
            return mapping.findForward("displayCompletedInactiveReportsDeleteMsg");
        }
        return mapping.findForward("displayCompletedReportsDeleteMsg");
    }

    public ActionForward inactivateCompletedReport(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String reportId = request.getParameter("inactivateReportId");
        EntityKey key = CommonEntityKeyFactory.createSimpleCompletedReportEntityKey((String)reportId);
        try {
            this.getStandardReportService().inactivateCompletedReport(key, this.getLoggedInUser());
        }
        catch (NoRecordFoundException ex) {
            return mapping.findForward("displayCompletedReportsInactivateInvalidId");
        }
        catch (ReportException rx) {
            return mapping.findForward("displayCompletedReportsInactivationInvalid");
        }
        return mapping.findForward("displayCompletedReportsInactivatedMsg");
    }

    protected boolean validateFilter(HttpServletRequest request, CompletedReportsForm form) throws UnknownLookupCodeException, UnknownLookupTypeException {
        boolean valid = super.validateFilter(request, form);
        if (StringUtils.isNotEmpty((String)form.getInactivatedDate())) {
            try {
                Date archivedDate = DateUtils.getDate((String)form.getInactivatedDate());
            }
            catch (Exception e) {
                this.addActionMessageForField(request, new ActionMessage("errors.date", (Object)form.getInactivatedDate()), "reportArchivedDate");
                valid = false;
            }
        }
        return valid;
    }

    protected void cacheReportFilters(HttpServletRequest request, CompletedReportsForm form) throws Exception {
        ReportFilter reportFilter = this.getStandardReportService().getCompletedReportFilter();
        ArrayList<Lookup> statusList = new ArrayList<Lookup>();
        if (reportFilter.getActiveReportsCount() > 0) {
            statusList.add(this.getLookupCacheService().getByCodeFromCache(ReportStatus.class, ReportStatus.ACTIVE.getCode()));
        }
        if (reportFilter.getInactiveReportsCount() > 0) {
            statusList.add(this.getLookupCacheService().getByCodeFromCache(ReportStatus.class, ReportStatus.INACTIVE.getCode()));
        }
        request.getSession().setAttribute("reportStatusList", statusList);
        HashMap<String, ReportType> reportTypeMap = new HashMap<String, ReportType>();
        if (reportFilter.getStandardReports() != null) {
            for (StandardReport standardReport : reportFilter.getStandardReports()) {
                ReportType reportType;
                if (standardReport == null || (reportType = standardReport.getType()) == null || !StringUtils.isNotEmpty((String)reportType.getDescription()) || !StringUtils.isNotEmpty((String)reportType.getCode())) continue;
                reportTypeMap.put(reportType.getCode(), reportType);
            }
            ArrayList reportTypeList = new ArrayList(reportTypeMap.values());
            ArrayList reportIdList = new ArrayList(reportFilter.getStandardReports());
            ArrayList reportTitleList = new ArrayList(reportFilter.getStandardReports());
            List fileTypeList = reportFilter.getReportFileTypes();
            Collections.sort(reportTitleList, StandardReport.getNameComparator());
            request.getSession().setAttribute("reportTitleList", reportTitleList);
            Collections.sort(reportIdList, StandardReport.getCodeComparator());
            request.getSession().setAttribute("reportIdList", reportIdList);
            Collections.sort(reportTypeList, ReportType.getReportTypeNameComparator());
            request.getSession().setAttribute("reportTypeList", reportTypeList);
            Collections.sort(fileTypeList, ReportExportedType.getNameComparator());
            request.getSession().setAttribute("fileTypeList", (Object)fileTypeList);
        }
        form.setFilterCached(true);
    }

    @Override
    public ActionForward resetFilter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CompletedReportsForm filterForm = (CompletedReportsForm)form;
        filterForm.resetFilter();
        filterForm.setFilterCached(false);
        return this.refreshData(mapping, form, request, response);
    }
}

