/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.registry.action;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.registry.action.RegistryConstants;
import gov.va.med.esr.ui.registry.action.RegistryInfoForm;
import gov.va.med.esr.ui.registry.action.RegistryPHInfoForm;
import gov.va.med.esr.ui.registry.action.RegistryPOWInfoForm;
import gov.va.med.esr.ui.registry.action.RegistrySHADInfoForm;
import gov.va.med.fw.util.StringUtils;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;

public class RegistryValidator
implements RegistryConstants {
    protected static ActionErrors validate(RegistryInfoForm form, HttpServletRequest request, ActionErrors errors) {
        if (errors == null) {
            errors = new ActionErrors();
        }
        if (form instanceof RegistryPHInfoForm) {
            errors = RegistryValidator.validatePHInfo((RegistryPHInfoForm)form, request, errors);
        }
        if (form instanceof RegistryPOWInfoForm) {
            errors = RegistryValidator.validatePOWInfo((RegistryPOWInfoForm)form, request, errors);
        }
        if (form instanceof RegistrySHADInfoForm) {
            errors = RegistryValidator.validateSHADInfo((RegistrySHADInfoForm)form, request, errors);
        }
        return errors;
    }

    private static ActionErrors validatePHInfo(RegistryPHInfoForm form, HttpServletRequest request, ActionErrors valErrors) {
        ActionErrors errors = new ActionErrors();
        MessageResources messageResources = form.getResources(request);
        errors.add((ActionMessages)valErrors);
        for (int i = 0; i < form.getDocumentCount(); ++i) {
            RegistryValidator.validatePHDocument(form, i, errors, messageResources);
        }
        return errors;
    }

    private static ActionErrors validatePOWInfo(RegistryPOWInfoForm form, HttpServletRequest request, ActionErrors valErrors) {
        ActionErrors errors = new ActionErrors();
        MessageResources messageResources = form.getResources(request);
        errors.add((ActionMessages)valErrors);
        for (int i = 0; i < form.getEpisodeCount(); ++i) {
            RegistryValidator.validatePOWEpisode(form, i, errors, messageResources);
        }
        return errors;
    }

    private static ActionErrors validateSHADInfo(RegistrySHADInfoForm form, HttpServletRequest request, ActionErrors valErrors) {
        ActionErrors errors = new ActionErrors();
        MessageResources messageResources = form.getResources(request);
        errors.add((ActionMessages)valErrors);
        for (int i = 0; i < form.getDocumentCount(); ++i) {
            RegistryValidator.validateSHADDocument(form, i, errors, messageResources);
        }
        return errors;
    }

    private static ActionErrors validatePHDocument(RegistryPHInfoForm form, int documentIndex, ActionErrors errors, MessageResources messageResources) {
        if (!form.isPHDocumentEmpty(documentIndex)) {
            String unacceptableRemark;
            String documentAcceptable;
            String documentReceivedDate;
            String dataSource;
            String index = "[" + documentIndex + "]";
            String label = null;
            String fieldName = null;
            String documentType = form.getDocumentType(documentIndex);
            if (StringUtils.isEmpty((String)documentType)) {
                label = messageResources.getMessage("label.registry.documentType");
                errors.add("documentType" + index, new ActionMessage("errors.required", (Object)label));
            }
            if (StringUtils.isEmpty((String)(dataSource = form.getDataSource(documentIndex)))) {
                label = messageResources.getMessage("label.registry.dataSource");
                fieldName = "dataSource" + index;
                errors.add(fieldName, new ActionMessage("errors.required", (Object)label));
            }
            if (StringUtils.isNotEmpty((String)(documentReceivedDate = form.getDocumentReceivedDate(documentIndex)))) {
                label = messageResources.getMessage("label.registry.documentReceivedDate");
                fieldName = "documentReceivedDate" + index;
                RegistryValidator.validateDate(documentReceivedDate, fieldName, label, errors);
            }
            if (StringUtils.isEmpty((String)(documentAcceptable = form.getDocumentAcceptable(documentIndex)))) {
                label = messageResources.getMessage("label.registry.documentAcceptable");
                fieldName = "documentAcceptable" + index;
                errors.add(fieldName, new ActionMessage("errors.required", (Object)label));
            }
            if (StringUtils.isNotEmpty((String)(unacceptableRemark = form.getUnacceptableRemark(documentIndex))) && unacceptableRemark.length() > 200) {
                label = messageResources.getMessage("label.registry.unacceptableRemark");
                fieldName = "unacceptableRemark" + index;
                errors.add(fieldName, new ActionMessage("errors.invalidUnacceptableRemarkLength", (Object)label));
            }
        }
        return errors;
    }

    private static ActionErrors validatePOWEpisode(RegistryPOWInfoForm form, int documentIndex, ActionErrors errors, MessageResources messageResources) {
        if (!form.isPOWEpisodeEmpty(documentIndex)) {
            String confinementLocation;
            Date releaseDatePrecise;
            Date captureDatePrecise;
            String index = "[" + documentIndex + "]";
            String label = null;
            String fieldName = null;
            String dataSource = form.getDataSource(documentIndex);
            if (StringUtils.isEmpty((String)dataSource)) {
                label = messageResources.getMessage("label.pow.Source");
                fieldName = "dataSource" + index;
                errors.add(fieldName, new ActionMessage("errors.required", (Object)label));
            }
            boolean captureDateValid = false;
            String captureDate = form.getPowCaptureDate(documentIndex);
            String captureDateLabel = messageResources.getMessage("label.pow.captureDate");
            String captureDateFieldName = "powCaptureDate" + index;
            if (StringUtils.isEmpty((String)captureDate)) {
                errors.add(captureDateFieldName, new ActionMessage("errors.required", (Object)captureDateLabel));
            } else {
                captureDateValid = RegistryValidator.validateImpreciseDate(captureDate, captureDateFieldName, captureDateLabel, errors);
            }
            boolean releaseDateValid = false;
            String releaseDate = form.getPowReleaseDate(documentIndex);
            String releaseDateLabel = messageResources.getMessage("label.pow.releaseDate");
            String releaseDateFieldName = "powReleaseDate" + index;
            if (StringUtils.isEmpty((String)releaseDate)) {
                errors.add(releaseDateFieldName, new ActionMessage("errors.required", (Object)releaseDateLabel));
            } else {
                releaseDateValid = RegistryValidator.validateImpreciseDate(releaseDate, releaseDateFieldName, releaseDateLabel, errors);
            }
            if (captureDateValid && releaseDateValid && (captureDatePrecise = ImpreciseDateUtils.getDateWithDefault((ImpreciseDate)DateUtils.getImpreciseDate((String)captureDate))).after(releaseDatePrecise = ImpreciseDateUtils.getDateWithDefault((ImpreciseDate)DateUtils.getImpreciseDate((String)releaseDate)))) {
                ActionMessage message = new ActionMessage("errors.dates.invalid", (Object)captureDateLabel, (Object)releaseDateLabel);
                errors.add(captureDateFieldName, message);
                errors.add(releaseDateFieldName, message);
            }
            if (StringUtils.isEmpty((String)(confinementLocation = form.getConfinementLocation(documentIndex)))) {
                label = messageResources.getMessage("label.pow.confinementLocation");
                fieldName = "confinementLocation" + index;
                errors.add(fieldName, new ActionMessage("errors.required", (Object)label));
            }
        }
        return errors;
    }

    private static ActionErrors validateSHADDocument(RegistrySHADInfoForm form, int documentIndex, ActionErrors errors, MessageResources messageResources) {
        if (!form.isSHADDocumentEmpty(documentIndex)) {
            String documentReceivedDate;
            String index = "[" + documentIndex + "]";
            String label = null;
            String fieldName = null;
            String documentType = form.getDocumentType(documentIndex);
            if (StringUtils.isEmpty((String)documentType)) {
                label = messageResources.getMessage("label.registry.documentType");
                errors.add("documentType" + index, new ActionMessage("errors.required", (Object)label));
            }
            if (StringUtils.isNotEmpty((String)(documentReceivedDate = form.getDocumentReceivedDate(documentIndex)))) {
                label = messageResources.getMessage("label.registry.documentReceivedDate");
                fieldName = "documentReceivedDate" + index;
                RegistryValidator.validateDate(documentReceivedDate, fieldName, label, errors);
            }
        }
        return errors;
    }

    private static boolean validateDate(String fieldValue, String fieldName, String fieldLabel, ActionErrors errors) {
        if (StringUtils.isNotEmpty((String)fieldValue)) {
            try {
                Date date = DateUtils.getDate((String)fieldValue);
                Date currentDate = new Date();
                if (date.after(currentDate)) {
                    errors.add(fieldName, new ActionMessage("errors.validateDateFuture", (Object)fieldLabel));
                    return false;
                }
            }
            catch (Exception ex) {
                errors.add(fieldName, new ActionMessage("errors.invalid", (Object)fieldLabel));
                return false;
            }
        }
        return true;
    }

    private static boolean validateImpreciseDate(String fieldValue, String fieldName, String fieldLabel, ActionErrors errors) {
        if (StringUtils.isNotEmpty((String)fieldValue)) {
            try {
                ImpreciseDate impDate = DateUtils.getImpreciseDate((String)fieldValue);
                Date date = ImpreciseDateUtils.getDateWithDefault((ImpreciseDate)impDate);
                if (date.after(new Date())) {
                    errors.add(fieldName, new ActionMessage("errors.validateDateFuture", (Object)fieldLabel));
                    return false;
                }
            }
            catch (Exception ex) {
                errors.add(fieldName, new ActionMessage("errors.imprecisedate", (Object)fieldLabel));
                return false;
            }
        }
        return true;
    }
}

