/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.registry.action;

import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.service.RegistrySearchCriteria;
import gov.va.med.esr.service.RegistrySearchResultBean;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.esr.ui.registry.action.RegistrySearchForm;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.ui.valuelist.SearchValueListAdapter;
import gov.va.med.fw.ui.valuelist.ValueListException;
import gov.va.med.fw.util.StringUtils;
import java.util.List;
import net.mlw.vlh.ValueListInfo;
import org.apache.struts.action.ActionForm;

public class RegistrySearchValueListAdapter
extends SearchValueListAdapter {
    private static final long serialVersionUID = 5706057699566470164L;
    private LookupCacheService lookupCacheService;

    protected void populateFormAttributes(ActionForm actionForm, SearchQueryInfo searchQueryInfo) throws ValueListException {
        try {
            RegistrySearchForm form = (RegistrySearchForm)actionForm;
            RegistrySearchCriteria criteria = (RegistrySearchCriteria)searchQueryInfo;
            criteria.setSsn(SSN.formatSSN((String)form.getSsn()));
            if (StringUtils.isNotEmpty((String)form.getLastName())) {
                criteria.setLastName(form.getLastName().trim());
            }
            if (StringUtils.isNotEmpty((String)form.getFirstName())) {
                criteria.setFirstName(form.getFirstName().trim());
            }
            if (StringUtils.isNotEmpty((String)form.getMilitaryServiceNumber())) {
                criteria.setMilitaryServiceNumber(form.getMilitaryServiceNumber().trim());
            }
            if (StringUtils.isNotEmpty((String)form.getRegistryType())) {
                criteria.setRegistryType((RegistryType)this.lookupCacheService.getByCodeFromCache(RegistryType.class, form.getRegistryType().trim()));
            }
        }
        catch (Exception ex) {
            throw new ValueListException("Unable to copy properties from FormBean to SearchQueryInfo.", (Throwable)ex);
        }
    }

    protected List performPostQueryProcessing(List results, SearchQueryInfo searchQueryInfo, ValueListInfo info) throws ValueListException {
        if (results != null && !results.isEmpty()) {
            for (RegistrySearchResultBean bean : results) {
                String ssn = StringUtils.isNotEmpty((String)StringUtils.trim((String)bean.getSsn())) ? JspUtils.displaySSN((String)bean.getSsn()) : "UNKNOWN";
                bean.setSsn(ssn);
            }
        }
        return results;
    }

    public LookupCacheService getLookupCacheService() {
        return this.lookupCacheService;
    }

    public void setLookupCacheService(LookupCacheService lookupCacheService) {
        this.lookupCacheService = lookupCacheService;
    }
}

