/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.registry.action;

import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.registry.action.RegistryConstants;
import gov.va.med.esr.ui.registry.action.RegistrySearchForm;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import gov.va.med.fw.ui.valuelist.MaxRecordsExceededValueListException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mlw.vlh.ValueList;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class RegistrySearchAction
extends AbstractAction
implements RegistryConstants {
    public ActionForward display(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RegistrySearchForm form = (RegistrySearchForm)actionForm;
        this.initialise(request);
        if (form.isRequiredFieldsFilled() && form.validateForm(request)) {
            return this.search(mapping, (ActionForm)form, request, response);
        }
        this.clear(actionForm);
        return mapping.findForward("display");
    }

    public void clear(ActionForm actionForm) throws Exception {
        ((RegistrySearchForm)actionForm).clear();
    }

    public ActionForward clear(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((RegistrySearchForm)actionForm).clear();
        return mapping.findForward("display");
    }

    public ActionForward search(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RegistrySearchForm form = (RegistrySearchForm)actionForm;
        form.setSearchedFlag("y");
        try {
            ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)"registrySearchTableId", (String)"registrySearchAdapter");
            ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
            if (valueList == null || !valueList.hasNext()) {
                this.addInformationMessage(request, "errors.search.noresult");
            }
        }
        catch (MaxRecordsExceededValueListException ex) {
            this.addActionMessage(request, new ActionMessage("errors.max.records.exceeded", (Object)new Integer(ex.getTotalRecords()), (Object)new Integer(ex.getRecordLimit())));
        }
        return mapping.findForward("display");
    }

    protected Map getKeyMethodMap() {
        if (this.keyMethodMap == null) {
            this.keyMethodMap = new HashMap();
            this.keyMethodMap.put("button.display", "display");
            this.keyMethodMap.put("button.search", "search");
            this.keyMethodMap.put("button.clear", "clear");
            this.keyMethodMap.put("button.cancel", "cancel");
        }
        return this.keyMethodMap;
    }

    public void afterPropertiesSet() {
    }

    protected void initialise(HttpServletRequest request) throws Exception {
        ArrayList<Lookup> list = (ArrayList<Lookup>)request.getSession().getAttribute("rgistryTypeList");
        if (list == null) {
            list = new ArrayList<Lookup>();
            LookupCacheService lookupCacheService = this.getLookupCacheService();
            list.add(lookupCacheService.getByCodeFromCache(RegistryType.class, RegistryType.CODE_PH_REGISTRY.getName()));
            list.add(lookupCacheService.getByCodeFromCache(RegistryType.class, RegistryType.CODE_POW_REGISTRY.getName()));
            list.add(lookupCacheService.getByCodeFromCache(RegistryType.class, RegistryType.CODE_SHAD_REGISTRY.getName()));
            request.getSession().setAttribute("rgistryTypeList", list);
        }
    }
}

