/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.registry.action;

import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.registry.RegistryLoadStatistics;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.esr.ui.registry.action.RegistryConstants;
import gov.va.med.esr.ui.registry.action.RegistrySearchForm;
import gov.va.med.fw.batchprocess.BatchProcessDetail;
import gov.va.med.fw.batchprocess.BatchProcessInvoker;
import gov.va.med.fw.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class RegistryLoadAction
extends AbstractAction
implements RegistryConstants {
    private static final Map registryLoadJob = new HashMap();
    BatchProcessInvoker invoker = null;

    public ActionForward display(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("display");
    }

    public ActionForward load(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("display");
        RegistrySearchForm form = (RegistrySearchForm)actionForm;
        BatchProcessDetail batchProcessDetail = this.getBatchProcessDetail(form.getRegistryType());
        if (batchProcessDetail != null) {
            this.invoker.invokeBatchProcessWithEvent(batchProcessDetail);
            this.addInformationMessage(request, "message.registry.batchProcess.invoked.success");
            forward = this.displayStatistics(mapping, actionForm, request, response);
        } else {
            this.addActionMessage(request, "message.registry.batchProcess.invoked.failure");
        }
        return forward;
    }

    public ActionForward displayStatisticsScreen(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("displayStatistics");
    }

    public ActionForward displayStatistics(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RegistrySearchForm form = (RegistrySearchForm)actionForm;
        String regType = form.getRegistryType();
        if (StringUtils.isNotEmpty((String)regType)) {
            RegistryType registryType = (RegistryType)this.getLookupCacheService().getByCodeFromCache(RegistryType.class.getName(), regType);
            RegistryLoadStatistics loadSummary = this.getRegistryService().getMostRecentRegistrySummaryByType(registryType);
            request.setAttribute("loadRegistrySummary", (Object)loadSummary);
        } else {
            this.addActionMessage(request, "errors.required", "registryType");
        }
        return mapping.findForward("displayStatistics");
    }

    private BatchProcessDetail getBatchProcessDetail(String registryType) throws Exception {
        String jobName = (String)registryLoadJob.get(registryType);
        return StringUtils.isNotEmpty((String)jobName) ? (BatchProcessDetail)this.getLookupCacheService().getByCodeFromCache(BatchProcessDetail.class.getName(), jobName) : null;
    }

    protected Map getKeyMethodMap() {
        if (this.keyMethodMap == null) {
            this.keyMethodMap = new HashMap();
            this.keyMethodMap.put("button.display", "display");
            this.keyMethodMap.put("button.registry.start", "load");
            this.keyMethodMap.put("button.registry.displayStatisticsScreen", "displayStatisticsScreen");
            this.keyMethodMap.put("button.refresh", "displayStatistics");
            this.keyMethodMap.put("button.cancel", "display");
        }
        return this.keyMethodMap;
    }

    public void afterPropertiesSet() {
    }

    public BatchProcessInvoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(BatchProcessInvoker invoker) {
        this.invoker = invoker;
    }

    static {
        registryLoadJob.put(RegistryType.CODE_POW_REGISTRY.getCode(), "scheduledJob.processPrisonerOfWarRegistryFile");
        registryLoadJob.put(RegistryType.CODE_PH_REGISTRY.getCode(), "scheduledJob.processPurpleHeartRegistryFile");
        registryLoadJob.put(RegistryType.CODE_SHAD_REGISTRY.getCode(), "scheduledJob.processSHADRegistryFile");
    }
}

