/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.registry.action;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.esr.ui.registry.action.RegistryConstants;
import gov.va.med.esr.ui.registry.action.RegistryInfoForm;
import gov.va.med.esr.ui.registry.action.RegistryPHInfoForm;
import gov.va.med.esr.ui.registry.action.RegistryPOWInfoForm;
import gov.va.med.esr.ui.registry.action.RegistrySHADInfoForm;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public abstract class RegistryEditAction
extends AbstractAction
implements RegistryConstants {
    public static final String FWD_REGISTRY_NO_DATA_CHANGED = "registryNoDataChanged";

    public ActionForward display(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("display");
    }

    public abstract ActionForward displayAdd(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    public abstract ActionForward displayUpdate(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    public ActionForward reset(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RegistryInfoForm form = (RegistryInfoForm)actionForm;
        String pageName = form.getPageName();
        return pageName != null && pageName.startsWith("update") ? this.displayUpdate(mapping, (ActionForm)form, request, response) : this.displayAdd(mapping, (ActionForm)form, request, response);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("displaySearch");
    }

    public ActionForward addMilitaryServiceNumber(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RegistryInfoForm form = (RegistryInfoForm)actionForm;
        form.addNewMilitaryServiceNumber();
        return StringUtils.isEmpty((String)request.getParameter("registryId")) ? mapping.findForward("displayAdd") : mapping.findForward("displayUpdate");
    }

    public ActionForward returnFromHistory(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RegistryInfoForm form = (RegistryInfoForm)actionForm;
        form.initialize();
        Registry registry = this.getRegistryFromCache(request);
        return this.prepareDisplayUpdate(mapping, actionForm, request, response, registry);
    }

    protected ActionForward prepareDisplayUpdate(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response, Registry registry) throws Exception {
        ActionForward forward = mapping.findForward("displayUpdate");
        RegistryInfoForm form = (RegistryInfoForm)actionForm;
        if (registry == null) {
            forward = mapping.findForward("displaySearchWithRegistryNotFoundMessage");
        } else {
            this.setRegistryInCache(request, registry);
            this.getConversionService().convert((Object)registry, (Object)form);
            if (form.getMilitaryServiceNumbersCount() == 0) {
                form.addNewMilitaryServiceNumber();
            }
            if (form instanceof RegistryPHInfoForm) {
                if (((RegistryPHInfoForm)form).getDocumentCount() == 0) {
                    ((RegistryPHInfoForm)form).addPHDocument();
                }
            } else if (form instanceof RegistrySHADInfoForm) {
                if (((RegistrySHADInfoForm)form).getDocumentCount() == 0) {
                    ((RegistrySHADInfoForm)form).addSHADDocument();
                }
            } else if (form instanceof RegistryPOWInfoForm && ((RegistryPOWInfoForm)form).getEpisodeCount() == 0) {
                ((RegistryPOWInfoForm)form).addPOWEpisode();
            }
        }
        return forward;
    }

    protected Registry getRegistry(HttpServletRequest request, String registryId, String registryType) throws ServiceException {
        Registry registry = null;
        if (StringUtils.isNotEmpty((String)registryId) && registryType != null) {
            try {
                RegistryType type = (RegistryType)this.getLookupCacheService().getByCodeFromCache(RegistryType.class, registryType);
                EntityKey entityKey = null;
                if (StringUtils.equals((String)RegistryType.CODE_PH_REGISTRY.getCode(), (String)registryType)) {
                    entityKey = CommonEntityKeyFactory.createPurpleHeartEntityKey((String)registryId);
                }
                if (StringUtils.equals((String)RegistryType.CODE_POW_REGISTRY.getCode(), (String)registryType)) {
                    entityKey = CommonEntityKeyFactory.createPrisonerOfWarEntityKey((String)registryId);
                } else if (StringUtils.equals((String)RegistryType.CODE_SHAD_REGISTRY.getCode(), (String)registryType)) {
                    entityKey = CommonEntityKeyFactory.createSHADEntityKey((String)registryId);
                }
                registry = this.getRegistryService().getRegistryById(entityKey, type);
            }
            catch (ServiceException srvEx) {
                throw srvEx;
            }
            catch (Exception ex) {
                throw new ServiceException((Throwable)ex);
            }
        }
        return registry;
    }

    protected synchronized void setRegistryInCache(HttpServletRequest request, Registry registry) throws ServiceException {
        HttpSession session = request.getSession();
        session.removeAttribute("rgistry");
        session.setAttribute("rgistry", (Object)registry);
    }

    protected synchronized void removeRegistryFromCache(HttpServletRequest request) throws ServiceException {
        HttpSession session = request.getSession();
        session.removeAttribute("rgistry");
    }

    protected Registry getRegistryFromCache(HttpServletRequest request, String registryId, String registryType) {
        Registry registry = this.getRegistryFromCache(request);
        if (registry != null) {
            RegistryType type;
            String id = registry.getEntityKey() != null ? registry.getEntityKey().getKeyValueAsString() : null;
            RegistryType registryType2 = type = registry.getRegistryTrait() != null ? registry.getRegistryTrait().getRegistryType() : null;
            if (type != null && StringUtils.equals((String)id, (String)registryId) && StringUtils.equals((String)type.getCode(), (String)registryType)) {
                return registry;
            }
        }
        return null;
    }

    protected Registry getRegistryFromCache(HttpServletRequest request) {
        return (Registry)request.getSession().getAttribute("rgistry");
    }

    @Override
    protected ActionForward handleOptimisticLockException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.addActionMessage(request, "error.optimisticLock");
        return this.displayUpdate(mapping, form, request, response);
    }

    @Override
    protected ActionForward handleEntityNotChangedException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward(FWD_REGISTRY_NO_DATA_CHANGED);
        if (forward == null) {
            forward = mapping.getInputForward();
        }
        return forward;
    }

    protected Map getKeyMethodMap() {
        if (this.keyMethodMap == null) {
            this.keyMethodMap = new HashMap();
            this.keyMethodMap.put("button.display", "display");
            this.keyMethodMap.put("button.registry.displayAdd", "displayAdd");
            this.keyMethodMap.put("button.registry.displayUpdate", "displayUpdate");
            this.keyMethodMap.put("button.registry.returnFromHistory", "returnFromHistory");
            this.keyMethodMap.put("button.addMilitaryServiceNumber", "addMilitaryServiceNumber");
            this.keyMethodMap.put("button.addDocument", "addDocument");
            this.keyMethodMap.put("button.addPOWEpisode", "addPOWEpisode");
            this.keyMethodMap.put("button.add", "add");
            this.keyMethodMap.put("button.update", "update");
            this.keyMethodMap.put("button.reset", "reset");
            this.keyMethodMap.put("button.clear", "reset");
            this.keyMethodMap.put("button.cancel", "cancel");
        }
        return this.keyMethodMap;
    }

    public void afterPropertiesSet() {
        Validate.notNull((Object)this.getConversionService(), (String)"RegistryConversionService cannot be null");
    }
}

