/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.registry.action;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.POWEpisode;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.PurpleHeartDocument;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.ee.SHADDocument;
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.PHDataSource;
import gov.va.med.esr.common.model.lookup.PHDocumentType;
import gov.va.med.esr.common.model.lookup.POWCampLocation;
import gov.va.med.esr.common.model.lookup.POWDataSource;
import gov.va.med.esr.common.model.lookup.POWDocumentType;
import gov.va.med.esr.common.model.lookup.PrisonerOfWarLocation;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.lookup.RejectionRemark;
import gov.va.med.esr.common.model.lookup.SHADDocumentType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.esr.common.model.registry.RegistryTrait;
import gov.va.med.esr.common.model.registry.RegistryTraitDetail;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.esr.ui.registry.action.RegistryInfoForm;
import gov.va.med.esr.ui.registry.action.RegistryPHInfoForm;
import gov.va.med.esr.ui.registry.action.RegistryPOWInfoForm;
import gov.va.med.esr.ui.registry.action.RegistrySHADInfoForm;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.security.Principal;
import gov.va.med.fw.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RegistryConversionService
extends UIConversionServiceImpl {
    public Object convert(Object source, Class targetClass) throws ConversionServiceException {
        return null;
    }

    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        if (source instanceof RegistryInfoForm && target instanceof Registry) {
            RegistryInfoForm form = (RegistryInfoForm)((Object)source);
            String registryType = form.getRegistryType();
            if (StringUtils.equals((String)RegistryType.CODE_PH_REGISTRY.getName(), (String)registryType)) {
                this.convertPHFormToPurpleHeart((RegistryPHInfoForm)form, (PurpleHeart)target);
            } else if (StringUtils.equals((String)RegistryType.CODE_POW_REGISTRY.getName(), (String)registryType)) {
                this.convertPOWFormToPrisonerOfWar((RegistryPOWInfoForm)form, (PrisonerOfWar)target);
            } else if (StringUtils.equals((String)RegistryType.CODE_SHAD_REGISTRY.getName(), (String)registryType)) {
                this.convertSHADFormToSHADRegistry((RegistrySHADInfoForm)form, (SHAD)target);
            }
        } else if (source instanceof Registry && target instanceof RegistryInfoForm) {
            String registryType;
            Registry registry = (Registry)source;
            String string = registryType = registry != null && registry.getRegistryTrait() != null && registry.getRegistryTrait().getRegistryType() != null ? registry.getRegistryTrait().getRegistryType().getCode() : null;
            if (StringUtils.equals((String)RegistryType.CODE_PH_REGISTRY.getName(), registryType)) {
                this.convertPurpleHeartToPHForm((PurpleHeart)source, (RegistryPHInfoForm)((Object)target));
            } else if (StringUtils.equals((String)RegistryType.CODE_POW_REGISTRY.getName(), (String)registryType)) {
                this.convertPrisonerOfWarToPOWForm((PrisonerOfWar)source, (RegistryPOWInfoForm)((Object)target));
            } else if (StringUtils.equals((String)RegistryType.CODE_SHAD_REGISTRY.getName(), (String)registryType)) {
                this.convertSHADRegistryToSHADForm((SHAD)source, (RegistrySHADInfoForm)((Object)target));
            }
        }
    }

    private void convertPHFormToPurpleHeart(RegistryPHInfoForm form, PurpleHeart registry) throws ConversionServiceException {
        if (registry.getEntityKey() != null) {
            registry.setPhIndicator(this.getTrueFalse(form.getPurpleHeartIndicator()));
        }
        this.populateCommon(form, (Registry)registry);
        DecorationStatus status = StringUtils.isNotEmpty((String)form.getPurpleHeartStatus()) ? (DecorationStatus)this.getLookup(DecorationStatus.class, form.getPurpleHeartStatus()) : null;
        RejectionRemark rejectionRemark = StringUtils.isNotEmpty((String)form.getRejectedRemarks()) ? (RejectionRemark)this.getLookup(RejectionRemark.class, form.getRejectedRemarks()) : null;
        VAFacility facility = StringUtils.isNotEmpty((String)form.getPurpleHeartSiteNumber()) ? (VAFacility)this.getLookup(VAFacility.class, form.getPurpleHeartSiteNumber()) : null;
        registry.setStatus(status);
        registry.setRejectionRemark(rejectionRemark);
        registry.setFacility(facility);
        registry.setAssignedContactUser(StringUtils.isBlank((String)form.getAssignedLAS()) ? null : form.getAssignedLAS());
        Map existingPHDocumentsMap = this.getMapFromCollection(registry.getDocuments());
        registry.removeAllDocuments();
        List documentIds = form.getDocumentIdList();
        if (documentIds != null && !documentIds.isEmpty()) {
            for (int i = 0; i < documentIds.size(); ++i) {
                String phDocumentId = (String)documentIds.get(i);
                if (StringUtils.isEmpty((String)phDocumentId)) {
                    if (form.isPHDocumentEmpty(i)) continue;
                    PurpleHeartDocument newPHDoc = this.ctrateNewPHDocument(form, i);
                    form.setDocumentHashCode(i, String.valueOf(newPHDoc.hashCode()));
                    registry.addDocument(newPHDoc);
                    continue;
                }
                if (form.isPHDocumentEmpty(i)) continue;
                PurpleHeartDocument phDoc = (PurpleHeartDocument)existingPHDocumentsMap.get(phDocumentId);
                phDoc = phDoc == null ? this.ctrateNewPHDocument(form, i) : this.updatePHDocument(form, i, phDoc);
                form.setDocumentHashCode(i, String.valueOf(phDoc.hashCode()));
                registry.addDocument(phDoc);
            }
        }
    }

    private void convertPurpleHeartToPHForm(PurpleHeart registry, RegistryPHInfoForm form) throws ConversionServiceException {
        form.setPurpleHeartIndicator(this.getYesNo(registry.getPhIndicator()));
        form.setPurpleHeartStatus(this.getLookupCode((Lookup)registry.getStatus()));
        form.setStatusUpdateDate(DateUtils.format((Date)registry.getStatusLastEditDate(), (String)"MM/dd/yyyy"));
        form.setRejectedRemarks(this.getLookupCode((Lookup)registry.getRejectionRemark()));
        form.setPurpleHeartSiteNumber(this.getLookupCode((Lookup)registry.getFacility()));
        this.populateCommon((Registry)registry, form);
        form.setAssignedLAS(registry.getAssignedContactUser());
        Set documents = registry.getDocuments();
        if (documents != null) {
            PurpleHeartDocument document2 = null;
            String hashCode = null;
            for (PurpleHeartDocument document2 : documents) {
                if (document2 == null) continue;
                String id = document2.getEntityKey().getKeyValueAsString();
                String documentType = this.getLookupCode((Lookup)document2.getDocumentType());
                String dataSource = this.getLookupCode((Lookup)document2.getDataSource());
                String documentReceivedDate = DateUtils.format((Date)document2.getReceivedDate(), (String)"MM/dd/yyyy");
                String documentLogInDate = DateUtils.format((Date)document2.getLoginDate(), (String)"MM/dd/yyyy");
                String documentLoggedInBy = document2.getLoggedInUser();
                String documentAcceptable = this.getYesNo(document2.getAcceptable());
                String unacceptableRemark = document2.getUnacceptableRemarks();
                hashCode = String.valueOf(document2.hashCode());
                form.addPHDocument(id, documentType, dataSource, documentReceivedDate, documentLogInDate, documentLoggedInBy, documentAcceptable, unacceptableRemark, hashCode);
            }
        }
    }

    private void convertPOWFormToPrisonerOfWar(RegistryPOWInfoForm form, PrisonerOfWar registry) throws ConversionServiceException {
        if (registry.getEntityKey() != null) {
            Indicator indicator = (Indicator)this.getLookup(Indicator.class, this.getIndicatorCode(form.getPowIndicator()));
            registry.setPowIndicator(indicator);
        }
        this.populateCommon(form, (Registry)registry);
        RegistryTrait trait = registry.getRegistryTrait();
        if (trait != null) {
            ImpreciseDate dateWithTime = DateUtils.getImpreciseDate((String)form.getDateDeath(), (boolean)true);
            if (dateWithTime != null) {
                String impreciseString = dateWithTime.toStandardFormat();
                if (impreciseString.length() > 8) {
                    if (!dateWithTime.equals((Object)trait.getDeathDate())) {
                        impreciseString = impreciseString.substring(0, 8);
                        ImpreciseDate dateWithoutTime = new ImpreciseDate(impreciseString);
                        trait.setDeathDate(dateWithoutTime);
                    }
                } else {
                    trait.setDeathDate(DateUtils.getImpreciseDate((String)form.getDateDeath(), (boolean)true));
                }
            } else {
                trait.setDeathDate(DateUtils.getImpreciseDate((String)form.getDateDeath(), (boolean)true));
            }
        }
        registry.setIcn(StringUtils.isBlank((String)form.getIcn()) ? null : form.getIcn());
        Map existingPOWEpisodesMap = this.getMapFromCollection(registry.getEpisodes());
        registry.removeAllEpisodes();
        List episodetIds = form.getEpisodeIdList();
        if (episodetIds != null && !episodetIds.isEmpty()) {
            for (int i = 0; i < episodetIds.size(); ++i) {
                String powEpisodeId = (String)episodetIds.get(i);
                if (StringUtils.isEmpty((String)powEpisodeId)) {
                    if (form.isPOWEpisodeEmpty(i)) continue;
                    POWEpisode newPOWEpisode = this.ctrateNewPOWEpisode(form, i);
                    form.setEpisodeHashCode(i, String.valueOf(newPOWEpisode.hashCode()));
                    registry.addEpisode(newPOWEpisode);
                    continue;
                }
                if (form.isPOWEpisodeEmpty(i)) continue;
                POWEpisode powEpisode = (POWEpisode)existingPOWEpisodesMap.get(powEpisodeId);
                powEpisode = powEpisode == null ? this.ctrateNewPOWEpisode(form, i) : this.updatePOWEpisode(form, i, powEpisode);
                form.setEpisodeHashCode(i, String.valueOf(powEpisode.hashCode()));
                registry.addEpisode(powEpisode);
            }
        }
    }

    private void convertPrisonerOfWarToPOWForm(PrisonerOfWar registry, RegistryPOWInfoForm form) throws ConversionServiceException {
        this.populateCommon((Registry)registry, form);
        String powIndicatorCode = registry != null && registry.getPowIndicator() != null ? registry.getPowIndicator().getCode() : null;
        form.setPowIndicator(powIndicatorCode != null && powIndicatorCode.equals(Indicator.NO.getCode()) ? "n" : "y");
        ImpreciseDate deathDate = registry.getRegistryTrait() != null ? registry.getRegistryTrait().getDeathDate() : null;
        form.setDateDeath(DateUtils.formatForEdit((ImpreciseDate)deathDate, null));
        form.setIcn(registry.getIcn());
        form.setDateEntered(DateUtils.format((Date)registry.getDateEntered(), (String)"MM/dd/yyyy"));
        Set episodes = registry.getEpisodes();
        if (episodes != null) {
            POWEpisode episode2 = null;
            String hashCode = null;
            for (POWEpisode episode2 : episodes) {
                String daysInCaptivity;
                if (episode2 == null) continue;
                String id = episode2.getEntityKey().getKeyValueAsString();
                String documentType = this.getLookupCode((Lookup)episode2.getDocumentType());
                String dataSource = this.getLookupCode((Lookup)episode2.getDataSource());
                ImpreciseDate powCaptureDate = episode2.getCaptureDate();
                ImpreciseDate powReleaseDate = episode2.getReleaseDate();
                String captureDate = DateUtils.format((ImpreciseDate)powCaptureDate, (String)"MM/dd/yyyy");
                String releaseDate = DateUtils.format((ImpreciseDate)powReleaseDate, (String)"MM/dd/yyyy");
                String string = daysInCaptivity = episode2.getNumberOfDaysInCaptivity() != null ? episode2.getNumberOfDaysInCaptivity().toString() : null;
                if (StringUtils.isEmpty((String)daysInCaptivity) && powCaptureDate != null && powReleaseDate != null) {
                    Long days = DateUtils.getDays((ImpreciseDate)powCaptureDate, (ImpreciseDate)powReleaseDate, (boolean)true);
                    daysInCaptivity = days != null ? days.toString() : "";
                }
                String confinementLocation = episode2.getConfinementLocation() != null ? episode2.getConfinementLocation().getCode() : null;
                String campLocation = episode2.getCampLocation() != null ? episode2.getCampLocation().getCode() : null;
                String enteredDate = DateUtils.format((Date)episode2.getDateEntered(), (String)"MM/dd/yyyy");
                String enteredBy = episode2.getCreatedBy() != null ? episode2.getCreatedBy().getName() : "";
                hashCode = String.valueOf(episode2.hashCode());
                form.addPOWEpisode(id, documentType, dataSource, captureDate, releaseDate, daysInCaptivity, confinementLocation, campLocation, enteredDate, enteredBy, hashCode);
            }
        }
    }

    private void convertSHADFormToSHADRegistry(RegistrySHADInfoForm form, SHAD registry) throws ConversionServiceException {
        if (registry.getEntityKey() != null) {
            Indicator indicator = (Indicator)this.getLookup(Indicator.class, this.getIndicatorCode(form.getShadIndicator()));
            registry.setShadIndicator(indicator);
        }
        this.populateCommon(form, (Registry)registry);
        registry.setClaimNumber(StringUtils.isBlank((String)form.getClaimNumber()) ? null : form.getClaimNumber());
        Map existingSHADDocumentsMap = this.getMapFromCollection(registry.getDocuments());
        registry.removeAllDocuments();
        List documentIds = form.getDocumentIdList();
        if (documentIds != null && !documentIds.isEmpty()) {
            for (int i = 0; i < documentIds.size(); ++i) {
                String documentId = (String)documentIds.get(i);
                if (StringUtils.isEmpty((String)documentId)) {
                    if (form.isSHADDocumentEmpty(i)) continue;
                    SHADDocument newSHADDoc = this.ctrateNewSHADDocument(form, i);
                    form.setDocumentHashCode(i, String.valueOf(newSHADDoc.hashCode()));
                    registry.addDocument(newSHADDoc);
                    continue;
                }
                if (form.isSHADDocumentEmpty(i)) continue;
                SHADDocument shadDoc = (SHADDocument)existingSHADDocumentsMap.get(documentId);
                shadDoc = shadDoc == null ? this.ctrateNewSHADDocument(form, i) : this.updateSHADDocument(form, i, shadDoc);
                form.setDocumentHashCode(i, String.valueOf(shadDoc.hashCode()));
                registry.addDocument(shadDoc);
            }
        }
    }

    private void convertSHADRegistryToSHADForm(SHAD registry, RegistrySHADInfoForm form) throws ConversionServiceException {
        form.setShadIndicator(this.getYesNo(registry.getShadIndicator()));
        this.populateCommon((Registry)registry, form);
        form.setClaimNumber(registry.getClaimNumber());
        Set documents = registry.getDocuments();
        if (documents != null) {
            SHADDocument document2 = null;
            String hashCode = null;
            for (SHADDocument document2 : documents) {
                if (document2 == null) continue;
                String id = document2.getEntityKey().getKeyValueAsString();
                String documentType = this.getLookupCode((Lookup)document2.getDocumentType());
                String documentReceivedDate = DateUtils.format((Date)document2.getReceivedDate(), (String)"MM/dd/yyyy");
                hashCode = String.valueOf(document2.hashCode());
                form.addSHADDocument(id, documentType, documentReceivedDate, hashCode);
            }
        }
    }

    private PurpleHeartDocument ctrateNewPHDocument(RegistryPHInfoForm form, int index) throws ConversionServiceException {
        PurpleHeartDocument newPHDoc = new PurpleHeartDocument();
        return this.updatePHDocument(form, index, newPHDoc);
    }

    private PurpleHeartDocument updatePHDocument(RegistryPHInfoForm form, int index, PurpleHeartDocument phDoc) throws ConversionServiceException {
        PHDocumentType documentType = (PHDocumentType)this.getLookup(PHDocumentType.class, form.getDocumentType(index));
        PHDataSource dataSource = (PHDataSource)this.getLookup(PHDataSource.class, form.getDataSource(index));
        phDoc.setDocumentType(documentType);
        phDoc.setDataSource(dataSource);
        phDoc.setReceivedDate(DateUtils.getDate((String)form.getDocumentReceivedDate(index)));
        phDoc.setAcceptable(this.getTrueFalse(form.getDocumentAcceptable(index)));
        phDoc.setUnacceptableRemarks(StringUtils.isBlank((String)form.getUnacceptableRemark(index)) ? null : form.getUnacceptableRemark(index));
        return phDoc;
    }

    private POWEpisode ctrateNewPOWEpisode(RegistryPOWInfoForm form, int index) throws ConversionServiceException {
        POWEpisode newPOWEpisode = new POWEpisode();
        return this.updatePOWEpisode(form, index, newPOWEpisode);
    }

    private POWEpisode updatePOWEpisode(RegistryPOWInfoForm form, int index, POWEpisode powEpisode) throws ConversionServiceException {
        POWDocumentType documentType = (POWDocumentType)this.getLookup(POWDocumentType.class, form.getDocumentType(index));
        powEpisode.setDocumentType(documentType);
        POWDataSource dataSource = (POWDataSource)this.getLookup(POWDataSource.class, form.getDataSource(index));
        powEpisode.setDataSource(dataSource);
        powEpisode.setCaptureDate(DateUtils.getImpreciseDate((String)form.getPowCaptureDate(index)));
        powEpisode.setReleaseDate(DateUtils.getImpreciseDate((String)form.getPowReleaseDate(index)));
        Long days = DateUtils.getDays((String)form.getPowCaptureDate(index), (String)form.getPowReleaseDate(index), (boolean)true);
        powEpisode.setNumberOfDaysInCaptivity(days != null ? new Integer(days.intValue()) : null);
        POWCampLocation campLocation = (POWCampLocation)this.getLookup(POWCampLocation.class, form.getCampLocation(index));
        powEpisode.setCampLocation(campLocation);
        PrisonerOfWarLocation powLocation = (PrisonerOfWarLocation)this.getLookup(PrisonerOfWarLocation.class, form.getConfinementLocation(index));
        powEpisode.setConfinementLocation(powLocation);
        return powEpisode;
    }

    private SHADDocument ctrateNewSHADDocument(RegistrySHADInfoForm form, int index) throws ConversionServiceException {
        SHADDocument newSHADDoc = new SHADDocument();
        return this.updateSHADDocument(form, index, newSHADDoc);
    }

    private SHADDocument updateSHADDocument(RegistrySHADInfoForm form, int index, SHADDocument shadDoc) throws ConversionServiceException {
        SHADDocumentType documentType = (SHADDocumentType)this.getLookup(SHADDocumentType.class, form.getDocumentType(index));
        shadDoc.setDocumentType(documentType);
        shadDoc.setReceivedDate(DateUtils.getDate((String)form.getDocumentReceivedDate(index)));
        return shadDoc;
    }

    private void populateCommon(RegistryInfoForm form, Registry registry) throws ConversionServiceException {
        if (registry != null) {
            RegistryTrait registryTrait = registry.getRegistryTrait();
            if (registryTrait == null) {
                registryTrait = new RegistryTrait();
                registry.setRegistryTrait(registryTrait);
            }
            RegistryType type = (RegistryType)this.getLookup(RegistryType.class, form.getRegistryType());
            registryTrait.setRegistryType(type);
            String ssn = SSN.formatSSN((String)form.getSsn());
            registryTrait.setSsn(StringUtils.isNotEmpty((String)ssn) ? ssn : null);
            String prefix = StringUtils.isNotEmpty((String)form.getPrefix()) ? form.getPrefix().toUpperCase().trim() : null;
            registryTrait.setPrefix(prefix);
            String firstName = StringUtils.isNotEmpty((String)form.getFirstName()) ? form.getFirstName().toUpperCase().trim() : null;
            registryTrait.setFirstName(firstName);
            String middleName = StringUtils.isNotEmpty((String)form.getMiddleName()) ? form.getMiddleName().toUpperCase().trim() : null;
            registryTrait.setMiddleName(middleName);
            String lastName = StringUtils.isNotEmpty((String)form.getLastName()) ? form.getLastName().toUpperCase().trim() : null;
            registryTrait.setLastName(lastName);
            String suffix = StringUtils.isNotEmpty((String)form.getSuffix()) ? form.getSuffix().toUpperCase().trim() : null;
            registryTrait.setSuffix(suffix);
            String degree = StringUtils.isNotEmpty((String)form.getDegree()) ? form.getDegree().toUpperCase().trim() : null;
            registryTrait.setEducationalDegree(degree);
            registryTrait.removeAllRegistryTraitDetails();
            List militaryServiveNumbers = form.getMilitaryServiceNumbersList();
            if (militaryServiveNumbers != null) {
                for (String militaryServiveNumber : militaryServiveNumbers) {
                    if (!StringUtils.isNotEmpty((String)militaryServiveNumber)) continue;
                    RegistryTraitDetail detail = new RegistryTraitDetail();
                    detail.setMilitaryServiceNumber(militaryServiveNumber.trim());
                    registryTrait.addRegistryTraitDetail(detail);
                }
            }
        }
    }

    private void populateCommon(Registry registry, RegistryInfoForm form) throws ConversionServiceException {
        form.setRegistryId(registry.getEntityKey().getKeyValueAsString());
        RegistryTrait trait = registry.getRegistryTrait();
        if (trait != null) {
            form.setSsn(JspUtils.displaySSN((String)trait.getSsn()));
            form.setPrefix(trait.getPrefix());
            form.setFirstName(trait.getFirstName());
            form.setMiddleName(trait.getMiddleName());
            form.setLastName(trait.getLastName());
            form.setSuffix(trait.getSuffix());
            form.setDegree(trait.getEducationalDegree());
            form.setRegistryType(this.getLookupCode((Lookup)trait.getRegistryType()));
            Set traitDetails = trait.getRegistryTraitDetails();
            if (traitDetails != null && !traitDetails.isEmpty()) {
                RegistryTraitDetail traitDetail2 = null;
                List militaryServiceNumbers = form.getMilitaryServiceNumbersList();
                for (RegistryTraitDetail traitDetail2 : traitDetails) {
                    if (traitDetail2 == null) continue;
                    militaryServiceNumbers.add(traitDetail2.getMilitaryServiceNumber());
                }
            }
        }
        Date updatedate = registry.getModifiedOn() != null ? registry.getModifiedOn() : registry.getCreatedOn();
        form.setUpdatedDate(DateUtils.format((Date)updatedate, (String)"MM/dd/yyyy h:mm:ssa"));
        Principal updatedBy = registry.getModifiedBy() != null ? registry.getModifiedBy() : registry.getCreatedBy();
        form.setUpdatedBy(updatedBy != null ? updatedBy.getName() : null);
    }

    private String getYesNo(Boolean flag) {
        if (flag == null) {
            return null;
        }
        return flag != false ? "y" : "n";
    }

    private String getYesNo(Indicator indicator) {
        if (indicator == null) {
            return null;
        }
        return this.getYesNo(indicator.toBoolean());
    }

    private String getIndicatorCode(String flag) {
        if (flag == null) {
            return Indicator.UNKNOWN.getCode();
        }
        return StringUtils.equals((String)flag, (String)"y") ? Indicator.YES.getCode() : Indicator.NO.getCode();
    }

    private Boolean getTrueFalse(String flag) {
        if (StringUtils.isEmpty((String)flag)) {
            return null;
        }
        return StringUtils.equals((String)flag, (String)"y") ? Boolean.TRUE : Boolean.FALSE;
    }

    private Map getMapFromCollection(Set set) {
        HashMap<String, AbstractKeyedEntity> map = new HashMap<String, AbstractKeyedEntity>();
        if (set != null) {
            AbstractKeyedEntity keyedEntity2 = null;
            for (AbstractKeyedEntity keyedEntity2 : set) {
                map.put(keyedEntity2.getEntityKey().getKeyValueAsString(), keyedEntity2);
            }
        }
        return map;
    }
}

