/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.person.action;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.CDCondition;
import gov.va.med.esr.common.model.ee.CDDiagnosis;
import gov.va.med.esr.common.model.ee.CDProcedure;
import gov.va.med.esr.common.model.ee.ConflictExperience;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.POWEpisode;
import gov.va.med.esr.common.model.ee.PurpleHeartDocument;
import gov.va.med.esr.common.model.ee.RatedDisability;
import gov.va.med.esr.common.model.ee.ReceivedEligibility;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.ee.SpecialFactor;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.insurance.Medicare;
import gov.va.med.esr.common.model.insurance.PrivateInsurance;
import gov.va.med.esr.common.model.lookup.Condition;
import gov.va.med.esr.common.model.lookup.Diagnosis;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.Procedure;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PersonMergeInfo;
import gov.va.med.esr.common.model.person.SignatureImage;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.service.PersonMergeService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.ui.admin.action.PersonMergeWorklistSearchActionForm;
import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.esr.ui.person.action.FacilityFeeBasis;
import gov.va.med.esr.ui.person.action.PersonMergeAction;
import gov.va.med.esr.ui.person.beans.PersonMergeRowInfo;
import gov.va.med.esr.ui.person.beans.PersonMergeRowInfoMeta;
import gov.va.med.esr.ui.person.beans.PersonMergeRowInfoMetaData;
import gov.va.med.fw.conversion.ConversionService;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import gov.va.med.fw.ui.valuelist.InvalidArgumentValueListException;
import gov.va.med.fw.ui.valuelist.MaxRecordsExceededValueListException;
import gov.va.med.fw.ui.valuelist.MissingCapabilityValueListException;
import gov.va.med.fw.ui.valuelist.TimeoutValueListException;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mlw.vlh.ValueList;
import net.mlw.vlh.ValueListInfo;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.util.MessageResources;

public class PersonMergeWorklistAction
extends PersonMergeAction {
    public static final String FORWARD_DISPLAY = "display";
    public static final String FORWARD_SUCCESS = "success";
    public static final String FORWARD_FAILURE = "failure";
    public static final String FORWARD_PERSON_DETAIL = "personMergeDetail";
    public static final String FORWARD_PERSON_FIND_DETAIL = "personMergeFindDetail";
    public static final String PERSON_MERGE_WORKLIST_TABLE_ID = "personMergeWorklistSearchTableId";
    public static final String PERSON_MERGE_WORKLIST_SEARCH_ADAPTER = "personMergeWorklistSearchAdapter";
    public static final String PERSON_MERGE_SEARCH_WORKLIST_SEARCH_ADAPTER = "personMergeSearchWorklistSearchAdapter";
    public static final String PERSON_MERGE_WORKLIST_VALUELIST_REQUEST_KEY = "vlhlist";
    public static final String SELECTED_PERSON_MERGE_INFO_ID_REQUEST_KEY = "selectedPersonMergeInfoId";
    public static final String PRIMARY_PERSON_KEY = "primaryPersonKey";
    public static final String DEPRECATED_PERSON_KEY = "deprecatedPersonKey";
    public static final String PRIMARY_PERSON_DEMOGRAPHIC_FORM_KEY = "primaryPersonDemographicFormKey";
    public static final String DEPRECATED_PERSON_DEMOGRAPHIC_FORM_KEY = "deprecatedPersonDemographicFormKey";
    private ConversionService mergeDemographicsConversionService = null;
    private ConversionService demographicPersonalConversionService = null;

    @Override
    public void afterPropertiesSet() {
    }

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)PERSON_MERGE_WORKLIST_TABLE_ID, (String)PERSON_MERGE_WORKLIST_SEARCH_ADAPTER);
        ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)PERSON_MERGE_WORKLIST_VALUELIST_REQUEST_KEY);
        return mapping.findForward(FORWARD_DISPLAY);
    }

    public ActionForward mergeSearch(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PersonMergeWorklistSearchActionForm personMergeWorklistSearchActionForm = (PersonMergeWorklistSearchActionForm)form;
        personMergeWorklistSearchActionForm.clear();
        return mapping.findForward(FORWARD_SUCCESS);
    }

    public ActionForward clear(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.mergeSearch(mapping, form, request, response);
    }

    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        PersonMergeWorklistSearchActionForm personMergeWorklistSearchActionForm = form instanceof PersonMergeWorklistSearchActionForm ? (PersonMergeWorklistSearchActionForm)form : null;
        Validate.notNull((Object)((Object)personMergeWorklistSearchActionForm), (String)"PersonMergeWorklistSearchActionForm bean is null");
        try {
            ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)PERSON_MERGE_WORKLIST_TABLE_ID, (String)PERSON_MERGE_SEARCH_WORKLIST_SEARCH_ADAPTER);
            ValueListInfo info = valueList.getValueListInfo();
            if (info.getTotalNumberOfEntries() == 0) {
                personMergeWorklistSearchActionForm.clear();
                this.addActionMessage(request, new ActionMessage("errors.search.noresult"));
                forward = mapping.findForward(FORWARD_FAILURE);
            } else {
                if (info.getTotalNumberOfEntries() == 1) {
                    List results = valueList.getList();
                    PersonMergeInfo personMergeInfo = (PersonMergeInfo)results.get(0);
                    this.putSandboxEntry(request, SELECTED_PERSON_MERGE_INFO_ID_REQUEST_KEY, personMergeInfo.getEntityKey().getKeyValueAsString());
                    forward = mapping.findForward(FORWARD_PERSON_FIND_DETAIL);
                }
                if (forward == null) {
                    ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)PERSON_MERGE_WORKLIST_VALUELIST_REQUEST_KEY);
                    forward = mapping.findForward(FORWARD_SUCCESS);
                }
            }
        }
        catch (MaxRecordsExceededValueListException ex) {
            if (ex.getTotalRecords() > 0 && ex.getRecordLimit() > 0) {
                this.addActionMessage(request, new ActionMessage("errors.max.records.exceeded", (Object)new Integer(ex.getTotalRecords()), (Object)new Integer(ex.getRecordLimit())));
            } else if (ex.getRecordLimit() > 0) {
                this.addActionMessage(request, new ActionMessage("errors.max.records.exceeded.recordLimit", (Object)new Integer(ex.getRecordLimit())));
            } else {
                this.addActionMessage(request, new ActionMessage("errors.max.records.exceeded.noParams"));
            }
            forward = mapping.findForward(FORWARD_FAILURE);
        }
        catch (MissingCapabilityValueListException ex) {
            this.addActionMessage(request, new ActionMessage("errors.invalid.search.permission"));
            forward = mapping.findForward(FORWARD_FAILURE);
        }
        catch (TimeoutValueListException ex) {
            this.addActionMessage(request, "error.timeout");
            forward = mapping.findForward(FORWARD_FAILURE);
        }
        catch (InvalidArgumentValueListException ex) {
            this.addActionMessage(request, "error.invalid.parameter.combination");
            forward = mapping.findForward(FORWARD_FAILURE);
        }
        return forward;
    }

    public ActionForward selectPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PersonMergeInfo personMergeInfo;
        String personMergeInfoId = request.getParameter(SELECTED_PERSON_MERGE_INFO_ID_REQUEST_KEY);
        if (personMergeInfoId == null) {
            personMergeInfoId = (String)this.getSandboxEntry(request, SELECTED_PERSON_MERGE_INFO_ID_REQUEST_KEY);
        }
        Validate.notNull((Object)personMergeInfoId, (String)"Person Merge Info ID is null.");
        HashMap<String, PersonMergeInfo> personMergeInfoMap = PersonMergeWorklistAction.getPersonMergeInfoMapFromSession(request);
        if (personMergeInfoMap != null && (personMergeInfo = (PersonMergeInfo)personMergeInfoMap.get("person_personMergeInfo")) != null && personMergeInfoId.equals(personMergeInfo.getEntityKey().getKeyValueAsString())) {
            return mapping.findForward(FORWARD_PERSON_DETAIL);
        }
        personMergeInfoMap = new HashMap<String, PersonMergeInfo>();
        PersonMergeService personMergeService = this.getPersonMergeService();
        PersonMergeInfo personMergeInfo2 = personMergeService.getPersonMergeInfo(CommonEntityKeyFactory.createPersonMergeInfoEntityKey((String)personMergeInfoId));
        PersonService personService = this.getPersonService();
        Person primaryPerson = personService.getPerson((PersonEntityKey)personMergeInfo2.getPrimaryPersonEntityKey());
        Person deprecatedPerson = personService.getPerson((PersonEntityKey)personMergeInfo2.getDeprecatedPersonEntityKey());
        this.populateUserSelections(personMergeInfoMap, personMergeInfo2);
        this.populateBeans(request, personMergeInfoMap, primaryPerson, deprecatedPerson);
        PersonMergeWorklistAction.setPersonMergeInfoMapInSession(request, personMergeInfoMap);
        personMergeInfo2.setRecordLocked(Boolean.TRUE);
        personMergeInfo2 = personMergeService.updatePersonMergeInfo(personMergeInfo2);
        personMergeInfoMap.put("person_personMergeInfo", personMergeInfo2);
        this.unlockPreviousPersonMerge(request);
        this.setLockedMergeInfoEntityKey(request, personMergeInfo2.getEntityKey());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Locking person merge record with ID " + personMergeInfo2.getEntityKey().getKeyValueAsString() + " on session " + request.getSession().getId() + " and lock key placed in session."));
        }
        return mapping.findForward(FORWARD_PERSON_DETAIL);
    }

    protected void unlockPreviousPersonMerge(HttpServletRequest request) throws ServiceException {
        Object key = this.getLockedMergeInfoEntityKey(request);
        if (key != null && key instanceof EntityKey) {
            PersonMergeService personMergeService = this.getPersonMergeService();
            PersonMergeInfo oldInfo = personMergeService.getPersonMergeInfo((EntityKey)key);
            oldInfo.setRecordLocked(Boolean.FALSE);
            personMergeService.updatePersonMergeInfo(oldInfo);
        }
    }

    protected void populateUserSelections(Map personMergeInfoMap, PersonMergeInfo personMergeInfo) {
        HashMap<String, String> userSelectionMap = new HashMap<String, String>();
        String mergeSelections = personMergeInfo.getMergeSelections();
        if (StringUtils.isNotEmpty((String)mergeSelections)) {
            String[] selectionArray = mergeSelections.split(";");
            for (int i = 0; i < selectionArray.length; ++i) {
                String selection = selectionArray[i];
                String[] keyValue = selection.split("=");
                if (keyValue.length > 2) {
                    throw new IllegalArgumentException("User selection '" + selection + "' contains " + keyValue.length + " " + "=" + " characters.  Only 1 is allowed.");
                }
                userSelectionMap.put(keyValue[0], keyValue.length == 2 ? keyValue[1] : null);
            }
        }
        personMergeInfoMap.put("person_userSelections", userSelectionMap);
    }

    protected void populateBeans(HttpServletRequest request, Map personMergeInfoMap, Object primaryObject, Person deprecatedObject) throws Exception {
        Set groupKeySet = this.personMergeRowGroupInfoMetaMap.keySet();
        for (String metaGroupKey : groupKeySet) {
            List groupMetaSectionList = (List)this.personMergeRowGroupInfoMetaMap.get(metaGroupKey);
            ArrayList groupSectionList = new ArrayList();
            personMergeInfoMap.put(metaGroupKey, groupSectionList);
            ArrayList<String> expColFieldnameList = new ArrayList<String>();
            personMergeInfoMap.put(metaGroupKey + "_expColFieldnames", expColFieldnameList);
            for (PersonMergeRowInfoMeta groupMetaSection : groupMetaSectionList) {
                if (groupMetaSection.isParentRow()) {
                    expColFieldnameList.add(groupMetaSection.getFieldName());
                }
                Object primaryValue = primaryObject;
                Object deprecatedValue = deprecatedObject;
                if (StringUtils.isNotEmpty((String)groupMetaSection.getFieldProperty()) || StringUtils.isNotEmpty((String)groupMetaSection.getFieldPropertyHelperMethod())) {
                    primaryValue = this.getBeanInfo(primaryObject, groupMetaSection, false);
                    deprecatedValue = this.getBeanInfo(deprecatedObject, groupMetaSection, false);
                }
                this.addSectionGroupInfoWithChildren(request, primaryValue, deprecatedValue, groupMetaSection, groupSectionList);
            }
        }
    }

    @Override
    public boolean match(Object object1, Object object2) {
        if (RatedDisability.class.isAssignableFrom(object1.getClass())) {
            RatedDisability object1Disability = (RatedDisability)object1;
            RatedDisability object2Disability = (RatedDisability)object2;
            String object1DisabilityCode = null;
            String object2DisabilityCode = null;
            if (object1Disability != null && object1Disability.getDisability() != null && object1Disability.getDisability().getCode() != null) {
                object1DisabilityCode = object1Disability.getDisability().getCode();
            }
            if (object2Disability != null && object2Disability.getDisability() != null && object2Disability.getDisability().getCode() != null) {
                object2DisabilityCode = object2Disability.getDisability().getCode();
            }
            return object1DisabilityCode != null && object2DisabilityCode != null ? object1DisabilityCode.equals(object2DisabilityCode) : false;
        }
        if (PurpleHeartDocument.class.isAssignableFrom(object1.getClass())) {
            return true;
        }
        if (POWEpisode.class.isAssignableFrom(object1.getClass())) {
            return true;
        }
        if (CDCondition.class.isAssignableFrom(object1.getClass())) {
            Condition condition1 = ((CDCondition)object1).getCondition();
            Condition condition2 = ((CDCondition)object2).getCondition();
            return condition1 != null && condition2 != null ? condition1.equals((Object)condition2) : false;
        }
        if (CDProcedure.class.isAssignableFrom(object1.getClass())) {
            Procedure procedure1 = ((CDProcedure)object1).getProcedure();
            Procedure procedure2 = ((CDProcedure)object2).getProcedure();
            return procedure1 != null && procedure2 != null ? procedure1.equals((Object)procedure2) : false;
        }
        if (CDDiagnosis.class.isAssignableFrom(object1.getClass())) {
            Diagnosis diagnosis1 = ((CDDiagnosis)object1).getDiagnosis();
            Diagnosis diagnosis2 = ((CDDiagnosis)object2).getDiagnosis();
            return diagnosis1 != null && diagnosis2 != null ? diagnosis1.equals((Object)diagnosis2) : false;
        }
        if (ReceivedEligibility.class.isAssignableFrom(object1.getClass())) {
            EligibilityType type1 = ((ReceivedEligibility)object1).getType();
            EligibilityType type2 = ((ReceivedEligibility)object2).getType();
            return type1 != null && type2 != null ? type1.equals((Object)type2) : false;
        }
        if (Association.class.isAssignableFrom(object1.getClass())) {
            return true;
        }
        if (Address.class.isAssignableFrom(object1.getClass())) {
            Address object1Address = (Address)object1;
            Address object2Address = (Address)object2;
            String object1AddressCode = null;
            String object2AddressCode = null;
            if (object1Address != null && object1Address.getType() != null && object1Address.getType().getCode() != null) {
                object1AddressCode = object1Address.getType().getCode();
            }
            if (object2Address != null && object2Address.getType() != null && object2Address.getType().getCode() != null) {
                object2AddressCode = object2Address.getType().getCode();
            }
            return object1AddressCode != null && object2AddressCode != null ? object1AddressCode.equals(object2AddressCode) : false;
        }
        if (Email.class.isAssignableFrom(object1.getClass())) {
            Email object1Email = (Email)object1;
            Email object2Email = (Email)object2;
            String object1EmailCode = null;
            String object2EmailCode = null;
            if (object1Email != null && object1Email.getType() != null && object1Email.getType().getCode() != null) {
                object1EmailCode = object1Email.getType().getCode();
            }
            if (object2Email != null && object2Email.getType() != null && object2Email.getType().getCode() != null) {
                object2EmailCode = object2Email.getType().getCode();
            }
            return object1EmailCode != null && object2EmailCode != null ? object1EmailCode.equals(object2EmailCode) : false;
        }
        if (Phone.class.isAssignableFrom(object1.getClass())) {
            Phone object1Phone = (Phone)object1;
            Phone object2Phone = (Phone)object2;
            String object1PhoneCode = null;
            String object2PhoneCode = null;
            if (object1Phone != null && object1Phone.getType() != null && object1Phone.getType().getCode() != null) {
                object1PhoneCode = object1Phone.getType().getCode();
            }
            if (object2Phone != null && object2Phone.getType() != null && object2Phone.getType().getCode() != null) {
                object2PhoneCode = object2Phone.getType().getCode();
            }
            return object1PhoneCode != null && object2PhoneCode != null ? object1PhoneCode.equals(object2PhoneCode) : false;
        }
        if (MilitaryServiceSiteRecord.class.isAssignableFrom(object1.getClass())) {
            MilitaryServiceSiteRecord object1SiteRec = (MilitaryServiceSiteRecord)object1;
            MilitaryServiceSiteRecord object2SiteRec = (MilitaryServiceSiteRecord)object2;
            String object1SiteRecCode = null;
            String object2SiteRecCode = null;
            if (object1SiteRec != null && object1SiteRec.getSite() != null && object1SiteRec.getSite().getCode() != null) {
                object1SiteRecCode = object1SiteRec.getSite().getCode();
            }
            if (object2SiteRec != null && object2SiteRec.getSite() != null && object2SiteRec.getSite().getCode() != null) {
                object2SiteRecCode = object2SiteRec.getSite().getCode();
            }
            return object1SiteRecCode != null && object2SiteRecCode != null ? object1SiteRecCode.equals(object2SiteRecCode) : false;
        }
        if (FacilityFeeBasis.class.isAssignableFrom(object1.getClass())) {
            FacilityFeeBasis object1ffb = (FacilityFeeBasis)((Object)object1);
            FacilityFeeBasis object2ffb = (FacilityFeeBasis)((Object)object2);
            String object1ffbCode = null;
            String object2ffbCode = null;
            if (object1ffb != null && object1ffb.getFacility() != null && object1ffb.getFacility().getCode() != null) {
                object1ffbCode = object1ffb.getFacility().getCode();
            }
            if (object2ffb != null && object2ffb.getFacility() != null && object2ffb.getFacility().getCode() != null) {
                object2ffbCode = object2ffb.getFacility().getCode();
            }
            return object1ffbCode != null && object2ffbCode != null ? object1ffbCode.equals(object2ffbCode) : false;
        }
        if (SignatureImage.class.isAssignableFrom(object1.getClass())) {
            SignatureImage object1SigImage = (SignatureImage)object1;
            SignatureImage object2SigImage = (SignatureImage)object2;
            String object1Code = null;
            String object2Code = null;
            if (object1SigImage != null && object1SigImage.getSiteSubmittingImage() != null && object1SigImage.getSiteSubmittingImage().getCode() != null) {
                object1Code = object1SigImage.getSiteSubmittingImage().getCode();
            }
            if (object2SigImage != null && object2SigImage.getSiteSubmittingImage() != null && object2SigImage.getSiteSubmittingImage().getCode() != null) {
                object2Code = object2SigImage.getSiteSubmittingImage().getCode();
            }
            return object1Code != null && object2Code != null ? object1Code.equals(object2Code) : false;
        }
        if (MilitaryServiceEpisode.class.isAssignableFrom(object1.getClass())) {
            return true;
        }
        if (ConflictExperience.class.isAssignableFrom(object1.getClass())) {
            return true;
        }
        if (Medicare.class.isAssignableFrom(object1.getClass())) {
            Medicare object1Medicare = (Medicare)object1;
            Medicare object2Medicare = (Medicare)object2;
            boolean object1PartA = object1Medicare.isEnrolledInPartA() != null && Boolean.TRUE.equals(object1Medicare.isEnrolledInPartA());
            boolean object2PartA = object2Medicare.isEnrolledInPartA() != null && Boolean.TRUE.equals(object2Medicare.isEnrolledInPartA());
            return object1Medicare.getReportSite().getStationNumber().equals(object2Medicare.getReportSite().getStationNumber()) && object1PartA == object2PartA;
        }
        if (PrivateInsurance.class.isAssignableFrom(object1.getClass())) {
            PrivateInsurance object1Insurance = (PrivateInsurance)object1;
            PrivateInsurance object2Insurance = (PrivateInsurance)object2;
            String object1InsuranceNum = null;
            String object2InsuranceNum = null;
            if (object1Insurance != null && object1Insurance.getReportSite() != null && object1Insurance.getReportSite().getStationNumber() != null) {
                object1InsuranceNum = object1Insurance.getReportSite().getStationNumber();
            }
            if (object2Insurance != null && object2Insurance.getReportSite() != null && object2Insurance.getReportSite().getStationNumber() != null) {
                object2InsuranceNum = object2Insurance.getReportSite().getStationNumber();
            }
            return object1InsuranceNum != null && object2InsuranceNum != null ? object1InsuranceNum.equals(object2InsuranceNum) : false;
        }
        if (VAFacility.class.isAssignableFrom(object1.getClass())) {
            VAFacility type1 = (VAFacility)object1;
            VAFacility type2 = (VAFacility)object2;
            return type1 != null && type2 != null ? type1.equals((Object)type2) : false;
        }
        if (PatientVisitSummary.class.isAssignableFrom(object1.getClass())) {
            return true;
        }
        if (SignatureImage.class.isAssignableFrom(object1.getClass())) {
            return true;
        }
        return super.match(object1, object2);
    }

    protected void addSectionGroupInfoWithChildren(HttpServletRequest request, Object primaryObject, Object deprecatedObject, PersonMergeRowInfoMeta groupMeta, List groupInfoList) throws Exception {
        PersonMergeRowInfo groupInfo = this.addSectionGroupInfo(request, groupMeta, groupInfoList);
        this.addGroupChildren(request, groupInfo, primaryObject, deprecatedObject);
        this.adjustParentGroupInfo(groupInfo);
    }

    protected void adjustParentGroupInfo(PersonMergeRowInfo parentInfo) {
        if (parentInfo.isSelectable()) {
            boolean unselectPrimary = true;
            boolean unselectDeprecated = true;
            boolean childSelectable = false;
            List children = parentInfo.getChildren();
            for (PersonMergeRowInfo childInfo : children) {
                if (!childInfo.isSelectable()) continue;
                childSelectable = true;
                if (StringUtils.isNotEmpty((String)childInfo.getPrimaryInputType())) {
                    unselectPrimary = false;
                }
                if (!StringUtils.isNotEmpty((String)childInfo.getDeprecatedInputType())) continue;
                unselectDeprecated = false;
            }
            if (!childSelectable && parentInfo.isParentRow() && children.size() == 0) {
                childSelectable = true;
            }
            if (!childSelectable && parentInfo.isParentRow() && parentInfo.getAllChildrenSame()) {
                childSelectable = true;
            }
            if (childSelectable) {
                if (unselectPrimary) {
                    parentInfo.setPrimaryInputType(null);
                    parentInfo.setPrimaryObject(null);
                }
                if (unselectDeprecated) {
                    parentInfo.setDeprecatedInputType(null);
                    parentInfo.setDeprecatedObject(null);
                }
            }
        }
    }

    protected void addGroupInfoWithChildren(HttpServletRequest request, PersonMergeRowInfo sectionGroupInfo, Object primaryObject, Object deprecatedObject, PersonMergeRowInfoMeta groupMeta, int count) throws Exception {
        MessageResources messageResources = (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
        PersonMergeRowInfo groupInfo = new PersonMergeRowInfo(groupMeta);
        groupInfo.setCount(count);
        if (primaryObject != null && AbstractKeyedEntity.class.isAssignableFrom(primaryObject.getClass())) {
            AbstractKeyedEntity primaryEntityKey = (AbstractKeyedEntity)primaryObject;
            groupInfo.setPrimaryEntityKey(primaryEntityKey.getEntityKey().getKeyValueAsString());
        }
        if (deprecatedObject != null && AbstractKeyedEntity.class.isAssignableFrom(deprecatedObject.getClass())) {
            AbstractKeyedEntity deprecatedEntityKey = (AbstractKeyedEntity)deprecatedObject;
            groupInfo.setDeprecatedEntityKey(deprecatedEntityKey.getEntityKey().getKeyValueAsString());
        }
        sectionGroupInfo.addChild(groupInfo);
        if (primaryObject != null || deprecatedObject != null) {
            this.addGroupChildren(request, groupInfo, primaryObject, deprecatedObject);
        }
        this.setDefaultFieldTypes(groupInfo);
        if (groupInfo.isSelectable()) {
            String fieldLabel = messageResources.getMessage(sectionGroupInfo.getGroupFieldMessageKey());
            groupInfo.setPrimaryObject("Select Surviving " + fieldLabel);
            groupInfo.setDeprecatedObject("Select Deprecated " + fieldLabel);
            if (groupInfo.getSelectableChildrenSame()) {
                if (groupInfo.isSingleSelect()) {
                    groupInfo.setPrimaryObject("");
                    groupInfo.setDeprecatedObject("");
                    groupInfo.setPrimaryInputType(null);
                    groupInfo.setDeprecatedInputType(null);
                }
            } else {
                if (primaryObject == null) {
                    groupInfo.setPrimaryInputType(null);
                    groupInfo.setPrimaryObject("");
                }
                if (deprecatedObject == null) {
                    groupInfo.setDeprecatedInputType(null);
                    groupInfo.setDeprecatedObject("");
                }
            }
        } else {
            groupInfo.setPrimaryObject("");
            groupInfo.setDeprecatedObject("");
        }
    }

    protected PersonMergeRowInfo addSectionGroupInfo(HttpServletRequest request, PersonMergeRowInfoMeta groupMeta, List groupInfoList) throws Exception {
        MessageResources messageResources = (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
        PersonMergeRowInfo groupInfo = new PersonMergeRowInfo(groupMeta);
        this.setDefaultFieldTypes(groupInfo);
        if (groupInfo.isSelectable()) {
            String fieldLabel = messageResources.getMessage(groupInfo.getFieldMessageKey());
            groupInfo.setPrimaryObject("Select All Surviving " + fieldLabel);
            groupInfo.setDeprecatedObject("Select All Deprecated " + fieldLabel);
        } else {
            groupInfo.setPrimaryObject("");
            groupInfo.setDeprecatedObject("");
        }
        groupInfoList.add(groupInfo);
        return groupInfo;
    }

    protected void addGroupChildren(HttpServletRequest request, PersonMergeRowInfo groupInfo, Object primaryObject, Object deprecatedObject) throws Exception {
        MessageResources messageResources = (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
        List childMetaList = (List)this.personMergeRowInfoMetaMap.get(groupInfo.getFieldName());
        if (childMetaList != null) {
            for (PersonMergeRowInfoMeta childMeta : childMetaList) {
                if (childMeta.isParentRow()) {
                    Object typeCheck;
                    Object primaryValue = this.getBeanInfo(primaryObject, childMeta, false);
                    Object deprecatedValue = this.getBeanInfo(deprecatedObject, childMeta, false);
                    Object object = typeCheck = primaryValue == null ? deprecatedValue : primaryValue;
                    if (typeCheck instanceof Collection) {
                        ArrayList deprecatedList;
                        PersonMergeRowInfo parentInfo = new PersonMergeRowInfo(childMeta);
                        this.setDefaultFieldTypes(parentInfo);
                        if (parentInfo.isSelectable()) {
                            String fieldLabel = messageResources.getMessage(parentInfo.getFieldMessageKey());
                            parentInfo.setPrimaryObject("Select All Surviving " + fieldLabel);
                            parentInfo.setDeprecatedObject("Select All Deprecated " + fieldLabel);
                        } else {
                            parentInfo.setPrimaryObject("");
                            parentInfo.setDeprecatedObject("");
                        }
                        groupInfo.addChild(parentInfo);
                        ArrayList primaryList = primaryValue == null ? new ArrayList() : new ArrayList((Collection)primaryValue);
                        ArrayList arrayList = deprecatedList = deprecatedValue == null ? new ArrayList() : new ArrayList((Collection)deprecatedValue);
                        if (StringUtils.isEmpty((String)parentInfo.getFieldPropertyHelperMethod())) {
                            Collections.sort(primaryList, new BeanComparator("entityKey.keyValueAsString", (Comparator)new NullComparator()));
                            Collections.sort(deprecatedList, new BeanComparator("entityKey.keyValueAsString", (Comparator)new NullComparator()));
                        }
                        int count = 0;
                        for (Object setDeprecatedObject : deprecatedList) {
                            Object setPrimaryObject = null;
                            Iterator matchIter = primaryList.iterator();
                            while (matchIter.hasNext() && setPrimaryObject == null) {
                                Object primaryMatchObject = matchIter.next();
                                if (!this.match(primaryMatchObject, setDeprecatedObject)) continue;
                                setPrimaryObject = primaryMatchObject;
                            }
                            this.addGroupInfoWithChildren(request, parentInfo, setPrimaryObject, setDeprecatedObject, childMeta, count);
                            ++count;
                            if (setPrimaryObject == null) continue;
                            primaryList.remove(setPrimaryObject);
                        }
                        for (Object setPrimaryObject : primaryList) {
                            this.addGroupInfoWithChildren(request, parentInfo, setPrimaryObject, null, childMeta, count);
                            ++count;
                        }
                        this.adjustParentGroupInfo(parentInfo);
                        continue;
                    }
                    this.addGroupInfoWithChildren(request, groupInfo, primaryValue, deprecatedValue, childMeta, -1);
                    continue;
                }
                this.addChildLeaf(groupInfo, new PersonMergeRowInfo(childMeta), primaryObject, deprecatedObject);
            }
        }
    }

    protected void addChildLeaf(PersonMergeRowInfo groupInfo, PersonMergeRowInfo childInfo, Object primaryObject, Object deprecatedObject) throws Exception {
        childInfo.setPrimaryObject(this.getBeanInfo(primaryObject, childInfo, true));
        childInfo.setDeprecatedObject(this.getBeanInfo(deprecatedObject, childInfo, true));
        this.setDefaultFieldTypes(childInfo);
        if (childInfo.isSelectable()) {
            if (childInfo.getObjectsSame()) {
                if (childInfo.isSingleSelect()) {
                    childInfo.setPrimaryInputType(null);
                    childInfo.setDeprecatedInputType(null);
                }
            } else {
                if (StringUtils.isEmpty((String)childInfo.getPrimaryObjectAsString())) {
                    childInfo.setPrimaryInputType(null);
                }
                if (StringUtils.isEmpty((String)childInfo.getDeprecatedObjectAsString())) {
                    childInfo.setDeprecatedInputType(null);
                }
            }
        }
        groupInfo.addChild(childInfo);
    }

    protected void setDefaultFieldTypes(PersonMergeRowInfo info) {
        if (info.isSelectable()) {
            info.setDeprecatedInputType("checkbox");
            info.setPrimaryInputType("checkbox");
        } else {
            info.setPrimaryInputType(null);
            info.setDeprecatedInputType(null);
        }
    }

    protected Object getBeanInfo(Object sourceObject, PersonMergeRowInfoMetaData mergeRowInfoMetaData, boolean formatResult) throws Exception {
        String fieldProperty = mergeRowInfoMetaData.getFieldProperty();
        String fieldPropertyHelperMethod = mergeRowInfoMetaData.getFieldPropertyHelperMethod();
        boolean displayField = mergeRowInfoMetaData.getDisplayField();
        if (!displayField) {
            return "";
        }
        Object objectValue = null;
        Object fieldPropertyHelperParam = sourceObject;
        if (StringUtils.isNotEmpty((String)fieldProperty) || StringUtils.isNotEmpty((String)fieldPropertyHelperMethod)) {
            if (sourceObject != null && StringUtils.isNotEmpty((String)fieldProperty)) {
                if (fieldProperty.equals("this")) {
                    objectValue = sourceObject;
                } else {
                    PropertyUtilsBean propertyUtils = new PropertyUtilsBean();
                    try {
                        objectValue = propertyUtils.getNestedProperty(sourceObject, fieldProperty);
                    }
                    catch (NestedNullException ex) {
                    }
                    catch (NullPointerException ex) {
                    }
                    catch (NoSuchMethodException noEx) {
                        throw new RuntimeException("Class name = " + sourceObject.getClass().getName() + ", fieldProperty = " + fieldProperty, noEx);
                    }
                }
                fieldPropertyHelperParam = objectValue;
            }
            if (StringUtils.isNotEmpty((String)fieldPropertyHelperMethod)) {
                int index = fieldPropertyHelperMethod.lastIndexOf(".");
                if (index == fieldPropertyHelperMethod.length() - 1) {
                    throw new IllegalArgumentException("The field property helper method '" + fieldPropertyHelperMethod + "' can't end with a '.'");
                }
                String className = index == -1 ? null : fieldPropertyHelperMethod.substring(0, index);
                String methodName = index == -1 ? fieldPropertyHelperMethod : fieldPropertyHelperMethod.substring(index + 1, fieldPropertyHelperMethod.length());
                Object targetObject = null;
                targetObject = StringUtils.isEmpty((String)className) ? this : Class.forName(className);
                objectValue = this.executeMethod(targetObject, methodName, fieldPropertyHelperParam, mergeRowInfoMetaData);
            }
        }
        if (formatResult) {
            if (objectValue instanceof Set) {
                return JspUtils.displayValues((Set)((Set)objectValue), (String)"", null);
            }
            return JspUtils.displayValue((Object)objectValue, (String)"", null);
        }
        return objectValue;
    }

    public ConversionService getMergeDemographicsConversionService() {
        return this.mergeDemographicsConversionService;
    }

    public void setMergeDemographicsConversionService(ConversionService mergeDemographicsConversionService) {
        this.mergeDemographicsConversionService = mergeDemographicsConversionService;
    }

    public ConversionService getDemographicPersonalConversionService() {
        return this.demographicPersonalConversionService;
    }

    public void setDemographicPersonalConversionService(ConversionService demographicPersonalConversionService) {
        this.demographicPersonalConversionService = demographicPersonalConversionService;
    }

    public List getMilitaryServiceSiteRecords(MilitaryService ms, PersonMergeRowInfoMetaData metaData) {
        ArrayList<MilitaryServiceSiteRecord> returnSiteRecords = new ArrayList<MilitaryServiceSiteRecord>();
        if (ms != null) {
            Set allMSSiteRecords = ms != null ? ms.getMilitaryServiceSiteRecords() : null;
            ArrayList siteRecordList = allMSSiteRecords == null ? new ArrayList() : new ArrayList(allMSSiteRecords);
            Collections.sort(siteRecordList, new BeanComparator("entityKey.keyValueAsString", (Comparator)new NullComparator()));
            MilitaryServiceSiteRecord hecRecord = ms.getHECMilitaryServiceSiteRecord();
            if (hecRecord != null) {
                returnSiteRecords.add(hecRecord);
            }
            for (MilitaryServiceSiteRecord siteRecord : siteRecordList) {
                if (siteRecord == null || siteRecord.getSite().getCode().equals(VAFacility.CODE_HEC.getName())) continue;
                returnSiteRecords.add(siteRecord);
            }
        }
        return returnSiteRecords;
    }

    public String getShadIndicatorName(SHAD shad, PersonMergeRowInfoMetaData metaData) {
        Indicator indicator;
        String returnValue = "";
        if (shad != null && (indicator = shad.getShadIndicator()) != null) {
            returnValue = indicator.getName();
        }
        return returnValue;
    }

    public String getSpecialFactorIndicatorName(SpecialFactor specialFactor, PersonMergeRowInfoMetaData metaData) {
        Indicator indicator;
        String returnValue = "";
        if (specialFactor != null && (indicator = specialFactor.getSpecialFactorIndicator()) != null) {
            returnValue = indicator.getName();
        }
        return returnValue;
    }

    public IncomeTest getCurrentIncomeTest(Person person, PersonMergeRowInfoMetaData metaData) {
        return this.getPersonHelperService().getCurrentIncomeTest(person);
    }

    public FinancialStatement getCurrentgetFinancialStatement(Person person, PersonMergeRowInfoMetaData metaData) {
        IncomeTest incomeTest = this.getCurrentIncomeTest(person, metaData);
        return incomeTest != null ? person.getFinancialStatement(incomeTest.getIncomeYear()) : null;
    }

    public Set getBeneficiaryTravels(Person person, PersonMergeRowInfoMetaData metaData) {
        IncomeTest incomeTest = this.getCurrentIncomeTest(person, metaData);
        return incomeTest != null ? person.getBeneficiaryTravels(incomeTest.getIncomeYear()) : new HashSet();
    }

    public SpouseFinancials getActiveSpouseFinancials(Person person, PersonMergeRowInfoMetaData metaData) {
        FinancialStatement stmt = this.getCurrentgetFinancialStatement(person, metaData);
        return stmt != null ? stmt.getActiveSpouseFinancials() : null;
    }

    public Set getSpouseFinancials(Person person, PersonMergeRowInfoMetaData metaData) {
        FinancialStatement stmt = this.getCurrentgetFinancialStatement(person, metaData);
        return stmt != null ? stmt.getSpouseFinancials() : null;
    }

    public Set getDependentFinancials(Person person, PersonMergeRowInfoMetaData metaData) {
        FinancialStatement stmt = this.getCurrentgetFinancialStatement(person, metaData);
        return stmt != null ? stmt.getDependentFinancials() : new HashSet();
    }

    public List getMedicareInsurances(Person person, PersonMergeRowInfoMetaData metaData) {
        HashMap<String, Medicare> partAMap = new HashMap<String, Medicare>();
        HashMap<String, Medicare> partBMap = new HashMap<String, Medicare>();
        ArrayList<String> stationSortList = new ArrayList<String>();
        ArrayList returnList = new ArrayList();
        Set medicareInsuranceSet = person.getMedicareInsurances();
        for (Medicare medicare : medicareInsuranceSet) {
            String stationNumber = medicare.getReportSite().getStationNumber();
            if (!stationSortList.contains(stationNumber) && !VAFacility.CODE_HEC.getName().equals(stationNumber)) {
                stationSortList.add(stationNumber);
            }
            if (medicare.isEnrolledInPartB() != null && Boolean.TRUE.equals(medicare.isEnrolledInPartB())) {
                partBMap.put(stationNumber, medicare);
                continue;
            }
            if (medicare.isEnrolledInPartA() != null && Boolean.TRUE.equals(medicare.isEnrolledInPartA())) {
                partAMap.put(stationNumber, medicare);
                continue;
            }
            throw new IllegalArgumentException("Medicare insurance with Id " + medicare.getEntityKey().getKeyValueAsString() + " doesn't contain " + "Part A or Part B.");
        }
        Collections.sort(stationSortList);
        if (partAMap.get(VAFacility.CODE_HEC.getName()) != null) {
            returnList.add(partAMap.get(VAFacility.CODE_HEC.getName()));
        }
        if (partBMap.get(VAFacility.CODE_HEC.getName()) != null) {
            returnList.add(partBMap.get(VAFacility.CODE_HEC.getName()));
        }
        for (String stationNumber : stationSortList) {
            if (partAMap.get(stationNumber) != null) {
                returnList.add(partAMap.get(stationNumber));
            }
            if (partBMap.get(stationNumber) == null) continue;
            returnList.add(partBMap.get(stationNumber));
        }
        return returnList;
    }

    public List getPrivateInsurances(Person person, PersonMergeRowInfoMetaData metaData) {
        HashMap<String, PrivateInsurance> insuranceMap = new HashMap<String, PrivateInsurance>();
        ArrayList<String> stationSortList = new ArrayList<String>();
        ArrayList returnList = new ArrayList();
        Set privateInsuranceSet = person.getPrivateInsurances();
        for (PrivateInsurance privateInsurance : privateInsuranceSet) {
            if (privateInsurance == null || privateInsurance.getReportSite() == null || privateInsurance.getReportSite().getStationNumber() == null) continue;
            String stationNumber = privateInsurance.getReportSite().getStationNumber();
            if (!stationSortList.contains(stationNumber) && !VAFacility.CODE_HEC.getName().equals(stationNumber)) {
                stationSortList.add(stationNumber);
            }
            insuranceMap.put(stationNumber, privateInsurance);
        }
        Collections.sort(stationSortList);
        if (insuranceMap.get(VAFacility.CODE_HEC.getName()) != null) {
            returnList.add(insuranceMap.get(VAFacility.CODE_HEC.getName()));
        }
        for (String stationNumber : stationSortList) {
            if (insuranceMap.get(stationNumber) == null) continue;
            returnList.add(insuranceMap.get(stationNumber));
        }
        return returnList;
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.display", FORWARD_DISPLAY);
        map.put("button.refresh", FORWARD_DISPLAY);
        map.put("button.selectPerson", "selectPerson");
        map.put("button.search", "search");
        map.put("button.research", "research");
        map.put("button.clear", "clear");
        map.put("button.cancel", "clear");
        map.put("button.mergeSearch", "mergeSearch");
        return map;
    }
}

