/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.person.action;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PersonMergeInfo;
import gov.va.med.esr.ui.person.action.MergeActionHelper;
import gov.va.med.esr.ui.person.action.MergeConstants;
import gov.va.med.esr.ui.person.action.PersonMergeAction;
import gov.va.med.esr.ui.person.beans.PersonMergeRowInfo;
import gov.va.med.fw.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class PersonMergeDetailAction
extends PersonMergeAction
implements MergeConstants {
    public static final int ERROR_FOUND = 0;
    public static final int CHILD_SELECTION_NEEDED = 1;
    public static final int CHILD_SELECTION_NOT_NEEDED = 2;

    public ActionForward discardAllSelections(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map personMergeInfoMap = PersonMergeDetailAction.getPersonMergeInfoMapFromSession(request);
        PersonMergeInfo personMergeInfo = (PersonMergeInfo)personMergeInfoMap.get("person_personMergeInfo");
        if (personMergeInfo == null) {
            throw new Exception("Unable to obtain PersonMergeInfo from Session");
        }
        PersonMergeInfo updatePersonMergeInfo = (PersonMergeInfo)personMergeInfo.clone();
        updatePersonMergeInfo.setMergeSelections(null);
        updatePersonMergeInfo.setMergeStartDate(null);
        updatePersonMergeInfo.setMergeEndDate(null);
        updatePersonMergeInfo.setRecordLocked(Boolean.FALSE);
        updatePersonMergeInfo = this.getPersonMergeService().updatePersonMergeInfo(updatePersonMergeInfo);
        this.setLockedMergeInfoEntityKey(request, null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Unlocking person merge (from discardSelections) record with ID " + personMergeInfo.getEntityKey().getKeyValueAsString() + " on session " + request.getSession().getId() + " and lock key removed from session."));
        }
        PersonMergeDetailAction.setPersonMergeInfoMapInSession(request, null);
        return mapping.findForward("personMergeWorklist");
    }

    public ActionForward saveAndMergeLater(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map personMergeInfoMap = PersonMergeDetailAction.getPersonMergeInfoMapFromSession(request);
        MergeActionHelper.saveUserSelections(request, personMergeInfoMap);
        PersonMergeInfo personMergeInfo = (PersonMergeInfo)personMergeInfoMap.get("person_personMergeInfo");
        if (personMergeInfo == null) {
            throw new Exception("Unable to obtain PersonMergeInfo from Session");
        }
        PersonMergeInfo updatePersonMergeInfo = (PersonMergeInfo)personMergeInfo.clone();
        Map userSelectionMap = (Map)personMergeInfoMap.get("person_userSelections");
        updatePersonMergeInfo.setMergeSelections(MergeActionHelper.getUserSelectionsAsString(userSelectionMap));
        updatePersonMergeInfo.setRecordLocked(Boolean.TRUE);
        updatePersonMergeInfo = this.getPersonMergeService().saveInProgress(updatePersonMergeInfo);
        this.setLockedMergeInfoEntityKey(request, null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Unlocking person merge (from saveAndMergeLater) record with ID " + personMergeInfo.getEntityKey().getKeyValueAsString() + " on session " + request.getSession().getId() + " and lock key removed from session."));
        }
        PersonMergeDetailAction.setPersonMergeInfoMapInSession(request, null);
        return mapping.findForward("personMergeWorklist");
    }

    public ActionForward mergeRecordsNow(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map personMergeInfoMap = PersonMergeDetailAction.getPersonMergeInfoMapFromSession(request);
        MergeActionHelper.saveUserSelections(request, personMergeInfoMap);
        String tabForward = this.validateUserSelections(request);
        if (StringUtils.isNotEmpty((String)tabForward)) {
            String forward = "display" + tabForward.substring(0, 1).toUpperCase() + tabForward.substring(1, tabForward.length());
            return mapping.findForward(forward);
        }
        this.populateDefaultSelections(request);
        Person mergedPerson = this.mergeRecords(mapping, form, request, response);
        this.getPersonMergeService().updatePerson(mergedPerson);
        this.setLockedMergeInfoEntityKey(request, null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Unlocking person merge (from mergeRecordsNow) record for person ID " + mergedPerson.getEntityKey().getKeyValueAsString() + " on session " + request.getSession().getId() + " and lock key removed from session."));
        }
        PersonMergeDetailAction.setPersonMergeInfoMapInSession(request, null);
        this.updateHeader(request);
        return mapping.findForward("personMergeWorklist");
    }

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("displayEligibility");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map personMergeInfoMap = PersonMergeDetailAction.getPersonMergeInfoMapFromSession(request);
        PersonMergeInfo personMergeInfo = (PersonMergeInfo)personMergeInfoMap.get("person_personMergeInfo");
        if (personMergeInfo == null) {
            throw new Exception("Unable to obtain PersonMergeInfo from Session");
        }
        PersonMergeInfo updatePersonMergeInfo = (PersonMergeInfo)personMergeInfo.clone();
        updatePersonMergeInfo.setRecordLocked(Boolean.FALSE);
        updatePersonMergeInfo = this.getPersonMergeService().updatePersonMergeInfo(updatePersonMergeInfo);
        this.setLockedMergeInfoEntityKey(request, null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Unlocking person merge (from cancel) record with ID " + personMergeInfo.getEntityKey().getKeyValueAsString() + " on session " + request.getSession().getId() + " and lock key removed from session."));
        }
        PersonMergeDetailAction.setPersonMergeInfoMapInSession(request, null);
        return mapping.findForward("personMergeWorklist");
    }

    public ActionForward selectEligibility(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map personMergeInfoMap = PersonMergeDetailAction.getPersonMergeInfoMapFromSession(request);
        MergeActionHelper.saveUserSelections(request, personMergeInfoMap);
        return mapping.findForward("displayEligibility");
    }

    public ActionForward selectDemographics(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map personMergeInfoMap = PersonMergeDetailAction.getPersonMergeInfoMapFromSession(request);
        MergeActionHelper.saveUserSelections(request, personMergeInfoMap);
        return mapping.findForward("displayDemographics");
    }

    public ActionForward selectMilitaryService(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map personMergeInfoMap = PersonMergeDetailAction.getPersonMergeInfoMapFromSession(request);
        MergeActionHelper.saveUserSelections(request, personMergeInfoMap);
        return mapping.findForward("displayMilitaryService");
    }

    public ActionForward selectFinancials(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map personMergeInfoMap = PersonMergeDetailAction.getPersonMergeInfoMapFromSession(request);
        MergeActionHelper.saveUserSelections(request, personMergeInfoMap);
        return mapping.findForward("displayFinancials");
    }

    public ActionForward selectFacility(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map personMergeInfoMap = PersonMergeDetailAction.getPersonMergeInfoMapFromSession(request);
        MergeActionHelper.saveUserSelections(request, personMergeInfoMap);
        return mapping.findForward("displayFacility");
    }

    protected String validateUserSelections(HttpServletRequest request) throws Exception {
        MessageResources messageResources = (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
        Map personMergeInfoMap = PersonMergeDetailAction.getPersonMergeInfoMapFromSession(request);
        Map userSelectionMap = (Map)personMergeInfoMap.get("person_userSelections");
        for (int i = 0; i < TABS.length; ++i) {
            String tabName = TABS[i];
            boolean errorFound = false;
            List sectionList = (List)personMergeInfoMap.get(tabName);
            for (PersonMergeRowInfo sectionInfo : sectionList) {
                int returnStatus = this.validateGroup(sectionInfo, messageResources, userSelectionMap, request);
                if (returnStatus != 0) continue;
                errorFound = true;
            }
            if (!errorFound) continue;
            return tabName;
        }
        return null;
    }

    protected int validateGroup(PersonMergeRowInfo groupInfo, MessageResources messageResources, Map userSelectionMap, HttpServletRequest request) {
        boolean errorFound = false;
        if (groupInfo.isSelectionNeeded() && (!groupInfo.areBothInputTypesPresent() || userSelectionMap.containsKey(groupInfo.getPrimaryFieldKey()) || userSelectionMap.containsKey(groupInfo.getDeprecatedFieldKey()))) {
            return 1;
        }
        boolean childSelectionNeeded = false;
        List children = groupInfo.getChildren();
        for (int j = 0; j < children.size(); ++j) {
            PersonMergeRowInfo childInfo = (PersonMergeRowInfo)children.get(j);
            if (childInfo.isParentRow()) {
                int status = this.validateGroup(childInfo, messageResources, userSelectionMap, request);
                if (status == 0 && !errorFound) {
                    errorFound = true;
                }
                if (status != 1 || childSelectionNeeded) continue;
                childSelectionNeeded = true;
                continue;
            }
            if (!childInfo.isSelectionNeeded()) continue;
            childSelectionNeeded = true;
            if (!childInfo.areBothInputTypesPresent() || userSelectionMap.containsKey(childInfo.getPrimaryFieldKey()) || userSelectionMap.containsKey(childInfo.getDeprecatedFieldKey())) continue;
            errorFound = true;
            String fieldLabel = messageResources.getMessage(childInfo.getFieldMessageKey());
            String fieldName = childInfo.getFieldName();
            this.addActionMessageForField(request, "errors.person.mergeSelectionRequired", fieldLabel, fieldName);
        }
        if (!errorFound && !childSelectionNeeded && groupInfo.isSelectionNeeded() && groupInfo.areBothInputTypesPresent()) {
            errorFound = true;
            String fieldLabel = messageResources.getMessage(groupInfo.getFieldMessageKey());
            String fieldName = groupInfo.getFieldName();
            if (groupInfo.isParentRow() && groupInfo.getCount() >= 0) {
                fieldLabel = messageResources.getMessage(groupInfo.getGroupFieldMessageKey()) + " " + (groupInfo.getCount() + 1);
                fieldName = fieldName + "_" + groupInfo.getCount();
            }
            this.addActionMessageForField(request, "errors.person.mergeSelectionRequired", fieldLabel, fieldName);
        }
        if (errorFound) {
            return 0;
        }
        if (childSelectionNeeded) {
            return 1;
        }
        return 2;
    }

    protected void populateDefaultSelections(HttpServletRequest request) throws Exception {
        Map personMergeInfoMap = PersonMergeDetailAction.getPersonMergeInfoMapFromSession(request);
        Map userSelectionMap = (Map)personMergeInfoMap.get("person_userSelections");
        for (int i = 0; i < TABS.length; ++i) {
            String tabName = TABS[i];
            List sectionList = (List)personMergeInfoMap.get(tabName);
            for (PersonMergeRowInfo sectionInfo : sectionList) {
                this.populateDefaultGroupSelections(sectionInfo, userSelectionMap);
            }
        }
    }

    protected void populateDefaultGroupSelections(PersonMergeRowInfo groupInfo, Map userSelectionMap) {
        if (groupInfo.isSelectionDefaulted()) {
            userSelectionMap.put(groupInfo.getPrimaryFieldKey(), "checked");
        }
        List children = groupInfo.getChildren();
        for (int j = 0; j < children.size(); ++j) {
            PersonMergeRowInfo childInfo = (PersonMergeRowInfo)children.get(j);
            if (childInfo.isParentRow()) {
                this.populateDefaultGroupSelections(childInfo, userSelectionMap);
                continue;
            }
            if (!childInfo.isSelectionDefaulted()) continue;
            userSelectionMap.put(childInfo.getPrimaryFieldKey(), "checked");
        }
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.display", "display");
        map.put("button.person.discardAllSelections", "discardAllSelections");
        map.put("button.person.saveAndMergeLater", "saveAndMergeLater");
        map.put("button.person.mergeRecordsNow", "mergeRecordsNow");
        map.put("button.person.eligibility", "selectEligibility");
        map.put("button.person.demographics", "selectDemographics");
        map.put("button.person.militaryService", "selectMilitaryService");
        map.put("button.person.financials", "selectFinancials");
        map.put("button.person.facility", "selectFacility");
        map.put("button.cancel", "cancel");
        return map;
    }
}

