/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.person.action;

import gov.va.med.esr.common.model.ee.CDCondition;
import gov.va.med.esr.common.model.ee.CDDescriptor;
import gov.va.med.esr.common.model.ee.CDDiagnosis;
import gov.va.med.esr.common.model.ee.CDProcedure;
import gov.va.med.esr.common.model.ee.FeeBasis;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.POWEpisode;
import gov.va.med.esr.common.model.ee.ReceivedEligibility;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.financials.BeneficiaryTravel;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.insurance.Medicare;
import gov.va.med.esr.common.model.insurance.PrivateInsurance;
import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PersonMergeInfo;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.ui.common.action.PersonAbstractAction;
import gov.va.med.esr.ui.person.action.MergeConstants;
import gov.va.med.esr.ui.person.beans.PersonMergeRowInfo;
import gov.va.med.fw.conversion.CopyServiceException;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.util.Reflector;
import gov.va.med.fw.util.StringUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public abstract class PersonMergeAction
extends PersonAbstractAction
implements MergeConstants {
    protected Map personMergeRowInfoMetaMap = null;
    protected Map personMergeRowGroupInfoMetaMap = null;

    @Override
    protected boolean requiresSelectedPerson() {
        return false;
    }

    public Person mergeRecords(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map personMergeInfoMap = PersonMergeAction.getPersonMergeInfoMapFromSession(request);
        Map userSelectionMap = (Map)personMergeInfoMap.get("person_userSelections");
        PersonMergeInfo personMergeInfo = (PersonMergeInfo)personMergeInfoMap.get("person_personMergeInfo");
        PersonIdEntityKey primaryPersonKey = personMergeInfo.getPrimaryPersonEntityKey();
        PersonIdEntityKey deprecatedPersonKey = personMergeInfo.getDeprecatedPersonEntityKey();
        Person primaryPerson = this.getPersonService().getPerson((PersonEntityKey)primaryPersonKey);
        Person deprecatedPerson = this.getPersonService().getPerson((PersonEntityKey)deprecatedPersonKey);
        this.mergePersonRecords(primaryPerson, deprecatedPerson, personMergeInfoMap, userSelectionMap);
        return primaryPerson;
    }

    private void mergePersonRecords(Person primaryPerson, Person deprecatedPerson, Map personMergeInfoMap, Map userSelectionMap) throws Exception {
        Set groupNames = this.getPersonMergeRowGroupInfoMetaMap().keySet();
        PropertyUtilsBean propUtils = new PropertyUtilsBean();
        for (String metaGroupKey : groupNames) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("MERGE - Processing Section: " + metaGroupKey));
            }
            List groupSectionList = (List)personMergeInfoMap.get(metaGroupKey);
            for (PersonMergeRowInfo sectionInfo : groupSectionList) {
                String fieldProperty;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("MERGE - Processing Section: " + sectionInfo.getFieldName()));
                }
                if (metaGroupKey.equalsIgnoreCase("demographics") && sectionInfo.getFieldName().equalsIgnoreCase("demographics_privateInsurances")) {
                    this.removeAddressFromPrivateInsurance(deprecatedPerson);
                }
                if (metaGroupKey.equalsIgnoreCase("demographics") && sectionInfo.getFieldName().equalsIgnoreCase("demographics_medicareInsurances")) {
                    this.removeAddressFromMedicareInsurance(deprecatedPerson);
                }
                String string = fieldProperty = sectionInfo.getMergeProperty() == null ? sectionInfo.getFieldProperty() : sectionInfo.getMergeProperty();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("MERGE fieldProperty:" + fieldProperty + " mergeMethod:" + sectionInfo.getMergeMethodName()));
                }
                if (sectionInfo.isSelectable()) {
                    if (userSelectionMap.containsKey(sectionInfo.getPrimaryFieldKey())) {
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug((Object)"MERGE - Primary is selected - skipping");
                        continue;
                    }
                    if (userSelectionMap.containsKey(sectionInfo.getDeprecatedFieldKey())) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)"MERGE - Deprecated is selected - copying");
                        }
                        this.copyProperty(propUtils, userSelectionMap, (AbstractEntity)primaryPerson, (AbstractEntity)deprecatedPerson, sectionInfo);
                        continue;
                    }
                }
                if (!sectionInfo.isParentRow()) continue;
                if (StringUtils.isNotEmpty((String)fieldProperty)) {
                    if (this.isNull(propUtils, (AbstractEntity)primaryPerson, (AbstractEntity)deprecatedPerson, fieldProperty)) continue;
                    AbstractEntity primaryValue = (AbstractEntity)PersonMergeAction.getNestedProperty(propUtils, primaryPerson, fieldProperty);
                    AbstractEntity deprecatedValue = (AbstractEntity)PersonMergeAction.getNestedProperty(propUtils, deprecatedPerson, fieldProperty);
                    if (deprecatedValue == null) continue;
                    this.processParentSection(propUtils, userSelectionMap, primaryValue, deprecatedValue, sectionInfo);
                    continue;
                }
                this.processParentSection(propUtils, userSelectionMap, (AbstractEntity)primaryPerson, (AbstractEntity)deprecatedPerson, sectionInfo);
            }
        }
    }

    private void removeAddressFromPrivateInsurance(Person deprecatedPerson) {
        if (deprecatedPerson != null && deprecatedPerson.getPrivateInsurances() != null) {
            Set privateInsurancesSet = deprecatedPerson.getPrivateInsurances();
            HashSet<PrivateInsurance> toAdd = new HashSet<PrivateInsurance>();
            HashSet toRemove = new HashSet(privateInsurancesSet);
            for (PrivateInsurance privateInsurance : toRemove) {
                if (privateInsurance.getAddress() != null) {
                    privateInsurance.setAddress(null);
                }
                toAdd.add(privateInsurance);
                deprecatedPerson.removeInsurance((InsurancePolicy)privateInsurance);
            }
            Iterator i = toAdd.iterator();
            while (i.hasNext()) {
                deprecatedPerson.addInsurance((InsurancePolicy)i.next());
            }
        }
    }

    private void removeAddressFromMedicareInsurance(Person deprecatedPerson) {
        if (deprecatedPerson != null && deprecatedPerson.getMedicareInsurances() != null) {
            Set medicareInsurancesSet = deprecatedPerson.getMedicareInsurances();
            HashSet<Medicare> toAdd = new HashSet<Medicare>();
            HashSet toRemove = new HashSet(medicareInsurancesSet);
            for (Medicare medicareInsurance : toRemove) {
                if (medicareInsurance.getAddress() != null) {
                    medicareInsurance.setAddress(null);
                }
                toAdd.add(medicareInsurance);
                deprecatedPerson.removeInsurance((InsurancePolicy)medicareInsurance);
            }
            Iterator i = toAdd.iterator();
            while (i.hasNext()) {
                deprecatedPerson.addInsurance((InsurancePolicy)i.next());
            }
        }
    }

    private void processParentSection(PropertyUtilsBean propUtils, Map userSelectionMap, AbstractEntity primary, AbstractEntity deprecated, PersonMergeRowInfo sectionInfo) throws Exception {
        List sectionItems = sectionInfo.getChildren();
        if (sectionItems == null || sectionItems.size() == 0) {
            return;
        }
        for (PersonMergeRowInfo sectionItem : sectionItems) {
            String fieldProperty;
            if (!sectionItem.isSelectable()) continue;
            String string = fieldProperty = sectionItem.getMergeProperty() == null ? sectionItem.getFieldProperty() : sectionItem.getMergeProperty();
            if (sectionItem.isParentRow()) {
                if (this.isNull(propUtils, primary, deprecated, fieldProperty)) continue;
                if (this.isSet(propUtils, primary, deprecated, fieldProperty)) {
                    this.mergeSets(propUtils, userSelectionMap, primary, deprecated, sectionItem);
                    continue;
                }
                throw new Exception("Individual children are not supported for section " + sectionItem.getFieldName());
            }
            this.copyProperty(propUtils, userSelectionMap, primary, deprecated, sectionItem);
        }
    }

    private void copyProperty(PropertyUtilsBean propUtils, Map userSelectionMap, AbstractEntity primary, AbstractEntity deprecated, PersonMergeRowInfo sectionItem) throws Exception {
        if (sectionItem.getMergeMethodName() != null) {
            this.mergeCustomPropertyFunction(propUtils, userSelectionMap, primary, deprecated, sectionItem);
        } else if (sectionItem.getMergeProperty() != null) {
            this.mergeCustomProperty(propUtils, userSelectionMap, primary, deprecated, sectionItem);
        } else if (StringUtils.isNotEmpty((String)sectionItem.getFieldProperty())) {
            if (PersonMergeAction.isSimpleProperty(sectionItem.getFieldProperty())) {
                this.mergeSimpleProperty(propUtils, userSelectionMap, primary, deprecated, sectionItem);
            } else {
                this.mergeNestedProperty(propUtils, userSelectionMap, primary, deprecated, sectionItem);
            }
        } else {
            String errMsg = "MERGE section Item " + sectionItem.getFieldName() + " is selectable but property is empty";
            log.error((Object)errMsg);
            throw new RuntimeException(errMsg);
        }
    }

    private void mergeSets(PropertyUtilsBean propUtils, Map userSelectionMap, AbstractEntity primary, AbstractEntity deprecated, PersonMergeRowInfo propertyInfo) throws Exception {
        block14: {
            String fieldProperty;
            if (!propertyInfo.isSelectable()) {
                return;
            }
            if (primary == null && deprecated == null) {
                return;
            }
            if (propertyInfo.getMergeMethodName() != null) {
                Object[] params = new Object[]{primary, deprecated, userSelectionMap, propertyInfo};
                this.executeMethod((Object)this, propertyInfo.getMergeMethodName(), params);
                return;
            }
            String simpleFieldProperty = fieldProperty = propertyInfo.getMergeProperty() == null ? propertyInfo.getFieldProperty() : propertyInfo.getMergeProperty();
            String parentFiledProperty = null;
            Object primaryObj = primary;
            Object deprecatedObj = deprecated;
            if (!PersonMergeAction.isSimpleProperty(fieldProperty)) {
                simpleFieldProperty = fieldProperty.substring(fieldProperty.lastIndexOf(46) + 1);
                parentFiledProperty = fieldProperty.substring(0, fieldProperty.lastIndexOf(46));
                primaryObj = PersonMergeAction.getNestedProperty(propUtils, primary, parentFiledProperty);
                deprecatedObj = PersonMergeAction.getNestedProperty(propUtils, deprecated, parentFiledProperty);
                if (primaryObj == null) {
                    throw new Exception("Parent property for a set is null on source object Class" + primary.getClass().getName() + " property " + parentFiledProperty);
                }
            }
            if (primaryObj == null && deprecatedObj == null) {
                return;
            }
            HashSet primarySet = (HashSet)PersonMergeAction.getSimpleProperty(propUtils, primaryObj, simpleFieldProperty);
            Set depSet = (Set)PersonMergeAction.getSimpleProperty(propUtils, deprecatedObj, simpleFieldProperty);
            Class<?> parentType = primaryObj == null ? deprecatedObj.getClass() : primaryObj.getClass();
            Class propertyType = PersonMergeAction.getType(primarySet);
            if (propertyType == null) {
                propertyType = PersonMergeAction.getType(depSet);
            }
            if (propertyType == null) {
                return;
            }
            String addMethod = PersonMergeAction.getAddMethod(parentType, propertyType, simpleFieldProperty);
            String removeMethod = PersonMergeAction.getRemoveMethod(parentType, propertyType, simpleFieldProperty);
            if (!(primarySet == null || primarySet.size() <= 0 || propertyInfo.isSelectable() && userSelectionMap.containsKey(propertyInfo.getPrimaryFieldKey()))) {
                primarySet = new HashSet(primarySet);
                for (Object objRemove : primarySet) {
                    String key = PersonMergeAction.getKey((AbstractEntity)objRemove);
                    if (userSelectionMap.containsKey(propertyInfo.getFieldName() + "_" + key)) continue;
                    this.executeMethod(primaryObj, removeMethod, objRemove);
                }
            }
            if (depSet == null || depSet.size() <= 0) break block14;
            if (propertyInfo.isSelectable() && userSelectionMap.containsKey(propertyInfo.getDeprecatedFieldKey())) {
                Set newSet = this.getCopy(depSet);
                for (Object objAdd : newSet) {
                    this.executeMethod(primaryObj, addMethod, objAdd);
                }
            } else {
                for (Object objDep : depSet) {
                    Object objAdd;
                    objAdd = this.getCopy(objDep);
                    String key = PersonMergeAction.getKey((AbstractEntity)objDep);
                    if (!userSelectionMap.containsKey(propertyInfo.getFieldName() + "_" + key)) continue;
                    this.executeMethod(primaryObj, addMethod, objAdd);
                }
            }
        }
    }

    private void mergeCustomProperty(PropertyUtilsBean propUtils, Map userSelectionMap, AbstractEntity primary, AbstractEntity deprecated, PersonMergeRowInfo propertyInfo) throws Exception {
        if (!propertyInfo.isSelectable()) {
            return;
        }
        String customPpropertyName = propertyInfo.getMergeProperty();
        if (userSelectionMap.containsKey(propertyInfo.getDeprecatedFieldKey())) {
            // empty if block
        }
    }

    private void mergeCustomPropertyFunction(PropertyUtilsBean propUtils, Map userSelectionMap, AbstractEntity primary, AbstractEntity deprecated, PersonMergeRowInfo propertyInfo) throws Exception {
        if (!propertyInfo.isSelectable()) {
            return;
        }
        String customMergeMethodName = propertyInfo.getMergeMethodName();
        if (userSelectionMap.containsKey(propertyInfo.getDeprecatedFieldKey())) {
            this.executeMethod(this, customMergeMethodName, deprecated, primary);
        }
    }

    private void mergeSimpleProperty(PropertyUtilsBean propUtils, Map userSelectionMap, AbstractEntity primary, AbstractEntity deprecated, PersonMergeRowInfo propertyInfo) throws Exception {
        if (!propertyInfo.isSelectable()) {
            return;
        }
        String fieldProperty = propertyInfo.getFieldProperty();
        if (PersonMergeAction.isSimpleProperty(fieldProperty)) {
            String srcKey = propertyInfo.getPrimaryFieldKey();
            String depKey = propertyInfo.getDeprecatedFieldKey();
            if (!userSelectionMap.containsKey(srcKey)) {
                if (userSelectionMap.containsKey(depKey)) {
                    Object depPropValue = PersonMergeAction.getNestedProperty(propUtils, deprecated, fieldProperty);
                    Object depPropCopy = this.getCopy(depPropValue);
                    propUtils.setSimpleProperty((Object)primary, fieldProperty, depPropCopy);
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Property is not slected skipping - " + fieldProperty));
                }
            }
        }
    }

    private void mergeNestedProperty(PropertyUtilsBean propUtils, Map userSelectionMap, AbstractEntity primary, AbstractEntity deprecated, PersonMergeRowInfo propertyInfo) throws Exception {
        Object propValue;
        if (!propertyInfo.isSelectable()) {
            return;
        }
        String depKey = propertyInfo.getDeprecatedFieldKey();
        String fieldProperty = propertyInfo.getFieldProperty();
        if (userSelectionMap.containsKey(depKey) && (propValue = propUtils.getNestedProperty((Object)deprecated, fieldProperty)) != null) {
            if (String.class.isAssignableFrom(propValue.getClass())) {
                int index = fieldProperty.lastIndexOf(46);
                String parentPropName = fieldProperty.substring(0, index);
                Object parentPropValue = propUtils.getNestedProperty((Object)deprecated, parentPropName);
                if (AbstractLookup.class.isAssignableFrom(parentPropValue.getClass())) {
                    propUtils.setNestedProperty((Object)primary, parentPropName, parentPropValue);
                } else {
                    this.setNestedPropertyCreate(propUtils, primary, fieldProperty, propValue);
                }
                return;
            }
            this.setNestedPropertyCreate(propUtils, primary, fieldProperty, propValue);
        }
    }

    private void setNestedPropertyCreate(PropertyUtilsBean propUtils, AbstractEntity primary, String fieldProperty, Object propValue) throws Exception {
        block3: {
            boolean isSet = false;
            try {
                propUtils.setNestedProperty((Object)primary, fieldProperty, propValue);
            }
            catch (IllegalArgumentException iae) {
                String msg = iae.getMessage();
                this.logger.warn((Object)("Ignoring IllegalArgumentException for " + fieldProperty + ", error is " + msg));
                if (primary != null && propValue != null && "Null property value for 'employment'".equals(msg)) {
                    ((Person)primary).setEmployment(new Employment());
                    propUtils.setNestedProperty((Object)primary, fieldProperty, propValue);
                    isSet = true;
                }
                if (isSet) break block3;
                throw iae;
            }
        }
    }

    public boolean isSet(PropertyUtilsBean propUtils, AbstractEntity primary, AbstractEntity deprecated, String propertyName) throws Exception {
        Object primaryValue = PersonMergeAction.getNestedProperty(propUtils, primary, propertyName);
        Object deprecatedValue = PersonMergeAction.getNestedProperty(propUtils, deprecated, propertyName);
        Object typeCheck = primaryValue == null ? deprecatedValue : primaryValue;
        return Set.class.isAssignableFrom(typeCheck.getClass());
    }

    public boolean isNull(PropertyUtilsBean propUtils, AbstractEntity primary, AbstractEntity deprecated, String propertyName) throws Exception {
        Object primaryValue = PersonMergeAction.getNestedProperty(propUtils, primary, propertyName);
        Object deprecatedValue = PersonMergeAction.getNestedProperty(propUtils, deprecated, propertyName);
        return primaryValue == null && deprecatedValue == null;
    }

    public static Object getSimpleProperty(PropertyUtilsBean propUtils, Object target, String propertyName) throws Exception {
        if (target == null) {
            return null;
        }
        if (propertyName == null) {
            throw new Exception("Null Property specified for Class: " + target.getClass().getName());
        }
        try {
            return propUtils.getSimpleProperty(target, propertyName);
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (Exception e) {
            throw new Exception("Reflection Exception on Class: " + target.getClass().getName() + " property: " + propertyName, e);
        }
    }

    public static Object getNestedProperty(PropertyUtilsBean propUtils, Object target, String propertyName) throws Exception {
        if (target == null) {
            return null;
        }
        if (propertyName == null) {
            throw new Exception("Null Property specified for Class: " + target.getClass().getName());
        }
        try {
            return propUtils.getNestedProperty(target, propertyName);
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (Exception e) {
            throw new Exception("Reflection Exception on Class: " + target.getClass().getName() + " property: " + propertyName, e);
        }
    }

    public static boolean isSimpleProperty(String propertyName) {
        return propertyName.indexOf(46) <= 0;
    }

    protected void mergeClaimFolderNumber(Person src, Person target) {
        target.setClaimFolderNumber(src.getClaimFolderNumber());
        target.setClaimFolderLocation(src.getClaimFolderLocation());
    }

    protected void mergeSSNsourceOfChange(Person src, Person target) throws Exception {
        SSN ssnSource = src.getOfficialSsn();
        if (ssnSource == null) {
            return;
        }
        SSN ssnTarget = target.getOfficialSsn();
        if (ssnTarget == null) {
            return;
        }
        ssnTarget.setSourceOfChange(ssnSource.getSourceOfChange());
    }

    protected void mergeSSAVerification(Person src, Person target) throws Exception {
        SSN ssnSource = src.getOfficialSsn();
        if (ssnSource == null) {
            return;
        }
        SSN ssnTarget = target.getOfficialSsn();
        if (ssnTarget == null) {
            return;
        }
        ssnTarget.setSsaVerificationDate(ssnSource.getSsaVerificationDate());
        ssnTarget.setSsaVerificationStatus(ssnSource.getSsaVerificationStatus());
        ssnTarget.setSsaMessage(ssnSource.getSsaMessage());
    }

    protected void mergeUserEnrollee(Person src, Person target) throws Exception {
        target.setUserEnrolleeSite(src.getUserEnrolleeSite());
        target.setUserEnrolleeValidThrough(src.getUserEnrolleeValidThrough());
    }

    protected void mergeAppointmentRequest(Person src, Person target) throws Exception {
        target.setAppointmentRequestDate(src.getAppointmentRequestDate());
        target.setAppointmentRequestResponse(src.getAppointmentRequestResponse());
    }

    protected void mergeFacilities(Person primary, Person deprecated, HashMap userSelectionMap, PersonMergeRowInfo propertyInfo) throws CopyServiceException {
        String key;
        Set primarySet = primary.getFacilities();
        Set depSet = deprecated.getFacilities();
        HashSet removeSet = new HashSet();
        HashSet addSet = new HashSet();
        if (!(primarySet == null || primarySet.size() <= 0 || propertyInfo.isSelectable() && userSelectionMap.containsKey(propertyInfo.getPrimaryFieldKey()))) {
            for (Object objRemove : primarySet) {
                key = PersonMergeAction.getKey((AbstractEntity)objRemove) + PersonMergeAction.getKey((AbstractEntity)primary);
                if (userSelectionMap.containsKey(propertyInfo.getFieldName() + "_" + key)) continue;
                removeSet.add(objRemove);
            }
        }
        if (depSet != null && depSet.size() > 0) {
            if (propertyInfo.isSelectable() && userSelectionMap.containsKey(propertyInfo.getDeprecatedFieldKey())) {
                addSet.addAll(depSet);
            } else {
                for (Object objAdd : primarySet) {
                    key = PersonMergeAction.getKey((AbstractEntity)objAdd) + PersonMergeAction.getKey((AbstractEntity)deprecated);
                    if (!userSelectionMap.containsKey(propertyInfo.getFieldName() + "_" + key)) continue;
                    addSet.add(objAdd);
                }
            }
        }
        for (VAFacility facility : removeSet) {
            primary.removePatientVisitSummary(facility);
            primary.removeFeeBasis(facility);
        }
        for (VAFacility facility : addSet) {
            Set summaries = deprecated.getPatientVisitSummaries(facility);
            for (AbstractEntity entity : summaries) {
                AbstractEntity entityCopy = this.getPersonMergeCopyService().getCopy(entity);
                primary.addPatientVisitSummary((PatientVisitSummary)entityCopy);
            }
            Set feeBasisInfo = deprecated.getFeeBasis(facility);
            for (AbstractEntity entity : feeBasisInfo) {
                FeeBasis feeBasisCopy = (FeeBasis)this.getPersonMergeCopyService().getCopy(entity);
                primary.addFeeBasis(feeBasisCopy);
            }
        }
    }

    protected void mergeFinancials(Person src, Person target) throws CopyServiceException {
        IncomeTest srcTest = this.getPersonHelperService().getCurrentIncomeTest(src);
        if (srcTest == null || srcTest.getIncomeYear() == null) {
            return;
        }
        Integer srcIncomeYear = srcTest.getIncomeYear();
        FinancialStatement srcStmt = src.getFinancialStatement(srcIncomeYear);
        if (srcStmt != null) {
            FinancialStatement srcStmtCopy = (FinancialStatement)this.getPersonMergeCopyService().getCopy((AbstractEntity)srcStmt);
            target.setFinancialStatement(srcStmtCopy.getIncomeYear(), srcStmtCopy);
        }
        IncomeTest srcTestCopy = (IncomeTest)this.getPersonMergeCopyService().getCopy((AbstractEntity)srcTest);
        target.setIncomeTest(srcTestCopy.getIncomeYear(), srcTestCopy);
        Set beneficiaryTravels = src.getBeneficiaryTravels(srcIncomeYear);
        if (beneficiaryTravels != null) {
            for (BeneficiaryTravel beneficiaryTravel : beneficiaryTravels) {
                if (beneficiaryTravel == null) continue;
                BeneficiaryTravel copyObj = (BeneficiaryTravel)this.getPersonMergeCopyService().getCopy((AbstractEntity)beneficiaryTravel);
                target.setBeneficiaryTravel(copyObj.getYear(), copyObj.getFacilityVisited(), copyObj);
            }
        }
    }

    protected void mergeMonetaryBenefitAward(Person src, Person target) throws CopyServiceException {
        MonetaryBenefitAward srcAward = src.getMonetaryBenefitAward();
        if (srcAward != null) {
            MonetaryBenefitAward srcCopy = (MonetaryBenefitAward)this.getCopy(srcAward);
            target.setMonetaryBenefitAward(srcCopy);
        } else {
            target.setMonetaryBenefitAward(null);
        }
        this.mergeUnemployable(src, target);
    }

    protected void mergeUnemployable(Person src, Person target) throws CopyServiceException {
        Boolean indicator = null;
        ServiceConnectionAward svcConnAward = src.getServiceConnectionAward();
        if (svcConnAward != null) {
            indicator = svcConnAward.getUnemployable();
        }
        if ((svcConnAward = target.getServiceConnectionAward()) == null) {
            svcConnAward = new ServiceConnectionAward();
            target.setServiceConnectionAward(svcConnAward);
        }
        svcConnAward.setUnemployable(indicator);
    }

    protected void mergeAidAndAttendance(Person src, Person target) throws CopyServiceException {
        this.mergeMonetaryBenefit(src, target, MonetaryBenefitType.CODE_AID_AND_ATTENDANCE);
    }

    protected void mergeHouseBound(Person src, Person target) throws CopyServiceException {
        this.mergeMonetaryBenefit(src, target, MonetaryBenefitType.CODE_HOUSEBOUND);
    }

    protected void mergeVAPension(Person src, Person target) throws CopyServiceException {
        this.mergeMonetaryBenefit(src, target, MonetaryBenefitType.CODE_VA_PENSION);
    }

    protected void mergeDisabilityCompensation(Person src, Person target) throws CopyServiceException {
        this.mergeMonetaryBenefit(src, target, MonetaryBenefitType.CODE_DISABILITY_COMPENSATION);
    }

    protected void mergeMonetaryBenefit(Person src, Person target, MonetaryBenefitType.Code mbtType) throws CopyServiceException {
        MonetaryBenefitAward mbAward = src.getMonetaryBenefitAward();
        MonetaryBenefit mb = null;
        if (mbAward != null) {
            mb = mbAward.getMonetaryBenefitByType(mbtType);
        }
        if ((mbAward = target.getMonetaryBenefitAward()) == null) {
            mbAward = new MonetaryBenefitAward();
            target.setMonetaryBenefitAward(mbAward);
        }
        MonetaryBenefit mbt = null;
        mbt = mbAward.getMonetaryBenefitByType(mbtType);
        if (mb == null) {
            mbAward.removeMonetaryBenefitByType(mbtType);
        } else if (mbt == null) {
            mbAward.addMonetaryBenefit((MonetaryBenefit)this.getCopy(mb));
        } else {
            this.getCopyService().copy((AbstractEntity)mb, (AbstractEntity)mbt);
        }
    }

    protected void mergeCheckAmount(Person src, Person target) throws CopyServiceException {
        MonetaryBenefitAward mbAward = src.getMonetaryBenefitAward();
        BigDecimal checkAmount = null;
        if (mbAward != null) {
            checkAmount = mbAward.getCheckAmount();
            mbAward = target.getMonetaryBenefitAward();
            if (mbAward == null) {
                mbAward = new MonetaryBenefitAward();
                target.setMonetaryBenefitAward(mbAward);
            }
            mbAward.setCheckAmount(checkAmount);
        }
    }

    protected Map getCopy(Map source) throws Exception {
        HashMap newMap = new HashMap();
        if (source != null && source.size() > 0) {
            Set keys = source.keySet();
            for (Object key : keys) {
                newMap.put(key, this.getCopy(source.get(key)));
            }
        }
        return newMap;
    }

    protected Set getCopy(Set source) throws Exception {
        HashSet<Object> newSet = new HashSet<Object>();
        if (source != null && source.size() > 0) {
            Iterator i = source.iterator();
            while (i.hasNext()) {
                newSet.add(this.getCopy(i.next()));
            }
        }
        return newSet;
    }

    protected Object getCopy(Object source) throws CopyServiceException {
        if (source == null) {
            return null;
        }
        if (source instanceof AbstractLookup) {
            return source;
        }
        if (source instanceof AbstractEntity) {
            AbstractEntity target = this.getPersonMergeCopyService().getCopy((AbstractEntity)source);
            return target;
        }
        return source;
    }

    public static String getAddMethod(Class parentType, Class propertyType, String property) {
        String methodName = null;
        if (propertyType != null) {
            if (InsurancePolicy.class.isAssignableFrom(propertyType)) {
                return "addInsurance";
            }
            if (CDDiagnosis.class.isAssignableFrom(propertyType)) {
                return "addDiagnosis";
            }
            if (CDProcedure.class.isAssignableFrom(propertyType)) {
                return "addProcedure";
            }
            if (CDCondition.class.isAssignableFrom(propertyType)) {
                return "addCondition";
            }
            if (CDDescriptor.class.isAssignableFrom(propertyType)) {
                return "addCDDescriptor";
            }
            if (POWEpisode.class.isAssignableFrom(propertyType)) {
                return "addEpisode";
            }
            if (ReceivedEligibility.class.isAssignableFrom(propertyType)) {
                return "addReceivedSecondaryEligibility";
            }
            String name = propertyType.getName();
            return "add" + name.substring(name.lastIndexOf(46) + 1);
        }
        return methodName;
    }

    public static String getRemoveMethod(Class parentType, Class propertyType, String property) {
        String methodName = null;
        if (propertyType != null) {
            if (InsurancePolicy.class.isAssignableFrom(propertyType)) {
                return "removeInsurance";
            }
            if (CDDiagnosis.class.isAssignableFrom(propertyType)) {
                return "removeDiagnosis";
            }
            if (CDProcedure.class.isAssignableFrom(propertyType)) {
                return "removeProcedure";
            }
            if (CDCondition.class.isAssignableFrom(propertyType)) {
                return "removeCondition";
            }
            if (CDDescriptor.class.isAssignableFrom(propertyType)) {
                return "removeCDDescriptor";
            }
            if (POWEpisode.class.isAssignableFrom(propertyType)) {
                return "removeEpisode";
            }
            if (ReceivedEligibility.class.isAssignableFrom(propertyType)) {
                return "removeReceivedSecondaryEligibility";
            }
            String name = propertyType.getName();
            return "remove" + name.substring(name.lastIndexOf(46) + 1);
        }
        return methodName;
    }

    protected Object executeMethod(Object targetObj, String methodName, Object arg1) throws Exception {
        Object[] params = new Object[]{arg1};
        return this.executeMethod(targetObj, methodName, params);
    }

    protected Object executeMethod(Object targetObj, String methodName, Object arg1, Object arg2) throws Exception {
        Object[] params = new Object[]{arg1, arg2};
        return this.executeMethod(targetObj, methodName, params);
    }

    protected Object executeMethod(Object targetObj, String methodName, Object[] params) throws Exception {
        if (targetObj != null && methodName != null && params != null) {
            Class currentClass = targetObj.getClass();
            if (Class.class.isAssignableFrom(targetObj.getClass())) {
                currentClass = (Class)targetObj;
            }
            while (currentClass != null) {
                try {
                    Method method = Reflector.findMethod((Class)currentClass, (String)methodName, (Class[])Reflector.typesOf((Object[])params));
                    return method.invoke(targetObj, params);
                }
                catch (NoSuchMethodException nsmf) {
                    currentClass = currentClass.getSuperclass();
                }
            }
            if (params[0] == null) {
                return null;
            }
            String className = targetObj.getClass().getName();
            if (Class.class.isAssignableFrom(targetObj.getClass())) {
                className = ((Class)targetObj).getName();
            }
            StringBuffer paramBuffer = new StringBuffer();
            for (int i = 0; i < params.length; ++i) {
                if (paramBuffer.length() > 0) {
                    paramBuffer.append(", ");
                }
                Object param = params[i];
                paramBuffer.append("param[" + i + "] class: " + param == null ? "null" : param.getClass().getName());
            }
            throw new NoSuchMethodException("Unable to find a matching '" + methodName + "' method in the '" + className + "' class hierarchy.  Params: " + paramBuffer.toString());
        }
        return null;
    }

    public static String getFieldProperty(PersonMergeRowInfo rowInfo) {
        return rowInfo.getMergeProperty() == null ? rowInfo.getFieldProperty() : rowInfo.getMergeProperty();
    }

    public static Class getType(Collection collection) {
        Class clazz = null;
        if (collection != null && collection.size() > 0) {
            return collection.iterator().next().getClass();
        }
        return clazz;
    }

    public static String getKey(AbstractEntity entity) {
        if (entity == null) {
            return null;
        }
        if (AbstractKeyedEntity.class.isAssignableFrom(entity.getClass())) {
            return ((AbstractKeyedEntity)entity).getEntityKey().getKeyValueAsString();
        }
        if (AbstractLookup.class.isAssignableFrom(entity.getClass())) {
            return String.valueOf(((AbstractLookup)entity).getIdentifier());
        }
        return null;
    }

    public void afterPropertiesSet() {
    }

    protected static void setPersonMergeInfoMapInSession(HttpServletRequest request, Map personMergeInfoMap) {
        HttpSession session = request.getSession();
        session.setAttribute("personMergeInfoMap", (Object)personMergeInfoMap);
    }

    protected static Map getPersonMergeInfoMapFromSession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        return (Map)session.getAttribute("personMergeInfoMap");
    }

    protected static void setPersonMergeInfoInSession(HttpServletRequest request, PersonMergeInfo personMergeInfo) {
        HttpSession session = request.getSession();
        session.setAttribute("personMergeInfo", (Object)personMergeInfo);
    }

    protected static PersonMergeInfo getPersonMergeInfoFromSession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        return (PersonMergeInfo)session.getAttribute("personMergeInfo");
    }

    protected static void setPrimaryMergePersonInSession(HttpServletRequest request, Person primaryMergePerson) {
        HttpSession session = request.getSession();
        session.setAttribute("primaryMergePerson", (Object)primaryMergePerson);
    }

    protected static Person getPrimaryMergePersonFromSession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        return (Person)session.getAttribute("primaryMergePerson");
    }

    protected static void setDeprecatedMergePersonInSession(HttpServletRequest request, Person DeprecatedMergePerson) {
        HttpSession session = request.getSession();
        session.setAttribute("deprecatedMergePerson", (Object)DeprecatedMergePerson);
    }

    protected Person getDeprecatedMergePersonFromSession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        return (Person)session.getAttribute("deprecatedMergePerson");
    }

    public Map getPersonMergeRowInfoMetaMap() {
        return this.personMergeRowInfoMetaMap;
    }

    public void setPersonMergeRowInfoMetaMap(Map personMergeRowInfoMetaMap) {
        this.personMergeRowInfoMetaMap = personMergeRowInfoMetaMap;
    }

    public Map getPersonMergeRowGroupInfoMetaMap() {
        return this.personMergeRowGroupInfoMetaMap;
    }

    public void setPersonMergeRowGroupInfoMetaMap(Map personMergeRowGroupInfoMetaMap) {
        this.personMergeRowGroupInfoMetaMap = personMergeRowGroupInfoMetaMap;
    }
}

