/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.person.action;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.esr.ui.person.action.FacilityFeeBasis;
import gov.va.med.esr.ui.person.action.MergeConstants;
import gov.va.med.esr.ui.person.beans.PersonMergeRowInfoMetaData;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;

public abstract class MergeActionHelper
implements MergeConstants {
    public static String getUserSelectionsAsString(Map userSelectionMap) {
        Set keySet = userSelectionMap.keySet();
        ArrayList<String> selectionList = new ArrayList<String>();
        for (String key : keySet) {
            String value = (String)userSelectionMap.get(key);
            StringBuffer singleSelectionBuffer = new StringBuffer(key);
            if (StringUtils.isNotEmpty((String)value)) {
                singleSelectionBuffer.append("=");
                singleSelectionBuffer.append(value);
            }
            selectionList.add(singleSelectionBuffer.toString());
        }
        Collections.sort(selectionList);
        StringBuffer userSelectionBuffer = new StringBuffer();
        Iterator iterator = selectionList.iterator();
        while (iterator.hasNext()) {
            if (userSelectionBuffer.length() > 0) {
                userSelectionBuffer.append(";");
            }
            userSelectionBuffer.append((String)iterator.next());
        }
        return userSelectionBuffer.toString();
    }

    public static void saveUserSelections(HttpServletRequest request, Map personMergeInfoMap) {
        Map userSelectionMap = (Map)personMergeInfoMap.get("person_userSelections");
        String tabName = request.getParameter("tabName");
        Validate.notEmpty((String)tabName, (String)"tabName request parameter must be part of the request.");
        Set keySet = userSelectionMap.keySet();
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!key.startsWith(tabName)) continue;
            iterator.remove();
        }
        Map requestParameterMap = request.getParameterMap();
        keySet = requestParameterMap.keySet();
        for (String key : keySet) {
            if (!key.startsWith(tabName)) continue;
            String[] paramValues = (String[])requestParameterMap.get(key);
            for (int i = 0; i < paramValues.length; ++i) {
                String paramValue = paramValues[i];
                if (key.endsWith("ExpColId")) {
                    userSelectionMap.put(key, paramValue);
                    continue;
                }
                String userSelectionKey = MergeActionHelper.getUserSelectionKey(key, paramValue);
                userSelectionMap.put(userSelectionKey, "checked");
            }
        }
    }

    public static String getUserSelectionKey(String requestKey, String requestValue) {
        Validate.notEmpty((String)requestKey, (String)"Request key can not be empty.");
        Validate.notEmpty((String)requestValue, (String)"Request value can not be empty.");
        if (MergeActionHelper.isParameterSingleValue(requestValue)) {
            return requestKey + "_" + requestValue;
        }
        if (MergeActionHelper.isParameterCollectionValue(requestValue)) {
            String[] collectionKeyParts = requestKey.split("_");
            StringBuffer collectionKeyBuffer = new StringBuffer(collectionKeyParts[0]);
            for (int i = 1; i < collectionKeyParts.length - 1; ++i) {
                collectionKeyBuffer.append("_");
                collectionKeyBuffer.append(collectionKeyParts[i]);
            }
            collectionKeyBuffer.append("_");
            collectionKeyBuffer.append(requestValue);
            return collectionKeyBuffer.toString();
        }
        throw new IllegalArgumentException("Request does not contain either a single value or collection value with requestKey: " + requestKey + " and requestValue: " + requestValue + ".");
    }

    public static boolean isParameterSingleValue(String parameterValue) {
        if (StringUtils.isEmpty((String)parameterValue)) {
            return false;
        }
        return !MergeActionHelper.isParameterCollectionValue(parameterValue);
    }

    public static boolean isParameterCollectionValue(String parameterValue) {
        if (StringUtils.isEmpty((String)parameterValue)) {
            return false;
        }
        return parameterValue.matches("([0-9]*)");
    }

    public static boolean getAidAndAttendance(Person person, PersonMergeRowInfoMetaData metaData) {
        MonetaryBenefitAward mBenefitAward = person.getMonetaryBenefitAward();
        MonetaryBenefit mBenefit = mBenefitAward != null ? mBenefitAward.getMonetaryBenefitByType(MonetaryBenefitType.CODE_AID_AND_ATTENDANCE) : null;
        return mBenefit != null;
    }

    public static boolean getHouseBound(Person person, PersonMergeRowInfoMetaData metaData) {
        MonetaryBenefitAward mBenefitAward = person.getMonetaryBenefitAward();
        MonetaryBenefit mBenefit = mBenefitAward != null ? mBenefitAward.getMonetaryBenefitByType(MonetaryBenefitType.CODE_HOUSEBOUND) : null;
        return mBenefit != null;
    }

    public static boolean getVAPension(Person person, PersonMergeRowInfoMetaData metaData) {
        MonetaryBenefitAward mBenefitAward = person.getMonetaryBenefitAward();
        MonetaryBenefit mBenefit = mBenefitAward != null ? mBenefitAward.getMonetaryBenefitByType(MonetaryBenefitType.CODE_VA_PENSION) : null;
        return mBenefit != null;
    }

    public static boolean getUnemployable(Person person, PersonMergeRowInfoMetaData metaData) {
        Boolean unemployable = person.getServiceConnectionAward() != null ? person.getServiceConnectionAward().getUnemployable() : null;
        return unemployable != null ? unemployable : false;
    }

    public static boolean getDisabilityCompensation(Person person, PersonMergeRowInfoMetaData metaData) {
        MonetaryBenefitAward mBenefitAward = person.getMonetaryBenefitAward();
        MonetaryBenefit mBenefit = mBenefitAward != null ? mBenefitAward.getMonetaryBenefitByType(MonetaryBenefitType.CODE_DISABILITY_COMPENSATION) : null;
        return mBenefit != null;
    }

    public static List getPatientVisitSummaries(Person person, PersonMergeRowInfoMetaData metaData) {
        ArrayList<FacilityFeeBasis> facilities = new ArrayList<FacilityFeeBasis>();
        LinkedHashMap<VAFacility, ArrayList<PatientVisitSummary>> facilityPatientVisitSummary = new LinkedHashMap<VAFacility, ArrayList<PatientVisitSummary>>();
        for (PatientVisitSummary pvs : person.getPatientVisitSummaries().values()) {
            VAFacility fac = pvs != null ? pvs.getFacilityVisited() : null;
            if (fac == null) continue;
            ArrayList<PatientVisitSummary> list = (ArrayList<PatientVisitSummary>)facilityPatientVisitSummary.get(fac);
            if (list == null) {
                list = new ArrayList<PatientVisitSummary>();
                facilityPatientVisitSummary.put(fac, list);
            }
            list.add(pvs);
        }
        for (VAFacility site : person.getFacilities()) {
            List pvsList = (List)facilityPatientVisitSummary.get(site);
            FacilityFeeBasis facFeeBasis = new FacilityFeeBasis(site, person.getEntityKey());
            facFeeBasis.setPatientVisitSummary(pvsList);
            facFeeBasis.setFeeBasis(new ArrayList(person.getFeeBasis(site)));
            facilities.add(facFeeBasis);
        }
        return facilities;
    }

    public static String formatTimestamp(Date date, PersonMergeRowInfoMetaData metaData) {
        return JspUtils.displayDate((Date)date, null, (boolean)true);
    }

    public static String formatTimestamp(ImpreciseDate date, PersonMergeRowInfoMetaData metaData) {
        return JspUtils.displayDate((ImpreciseDate)date, null, (boolean)true);
    }

    public static String formatTimestamp(String date, PersonMergeRowInfoMetaData metaData) {
        return date;
    }

    public static String formatCurrency(BigDecimal value, PersonMergeRowInfoMetaData metaData) {
        return "$" + value == null ? "" : NumberFormat.getCurrencyInstance().format(value.doubleValue());
    }

    public static String formatCurrency(Integer value, PersonMergeRowInfoMetaData metaData) {
        return "$" + value == null ? "" : NumberFormat.getCurrencyInstance().format(value.doubleValue());
    }

    public static boolean formatYesNo(Object obj, PersonMergeRowInfoMetaData metaData) {
        if (obj != null) {
            if (Boolean.class.isAssignableFrom(obj.getClass())) {
                return (Boolean)obj;
            }
            if (Indicator.class.isAssignableFrom(obj.getClass())) {
                return ((Indicator)obj).toBoolean();
            }
            return obj != null;
        }
        return false;
    }

    public static boolean isNotNull(Object obj, PersonMergeRowInfoMetaData metaData) {
        return obj != null;
    }
}

