/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.militaryservice.action;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.OEFOIFSource;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.CommonDateUtils;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.militaryservice.action.MilitaryServiceActionHelper;
import gov.va.med.esr.ui.militaryservice.action.MilitaryServiceConstants;
import gov.va.med.esr.ui.militaryservice.action.MilitaryServiceInfoForm;
import gov.va.med.esr.ui.util.SessionManager;
import gov.va.med.fw.util.StringUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;

public class MilitaryServiceValidator
implements MilitaryServiceConstants {
    protected static ActionMessages validateMilitaryService(MilitaryServiceInfoForm form, HttpServletRequest request, Person person) {
        int i;
        MessageResources messageResources = form.getResources(request);
        ActionMessages messages = form.getActionMessages(request);
        MilitaryServiceValidator.validateMedalOfHonor(form, messages, messageResources);
        MilitaryServiceValidator.validateCampLejeune(form, messages, messageResources);
        Map oefOifCombatEpisodeMap = new HashMap();
        if (person != null && person.getMilitaryService() != null) {
            oefOifCombatEpisodeMap = MilitaryServiceActionHelper.getMapFromCollection(person.getMilitaryService().getCombatEpisodes());
        }
        for (int i2 = 0; i2 < form.getOefOifCombatEpisodeIdList().size(); ++i2) {
            String id = form.getOefOifCombatEpisodeId(i2);
            CombatEpisode episode = StringUtils.isNotEmpty((String)id) ? (CombatEpisode)oefOifCombatEpisodeMap.get(id) : null;
            String oefOifSource = form.getOefOifCombatSource(i2);
            if (!StringUtils.equals((String)oefOifSource, (String)OEFOIFSource.CODE_CENTRALIZED_ELIGIBILITY_VERIFICATION.getCode()) && !form.isOefOifCombatEpisodeChanged(i2, episode)) continue;
            MilitaryServiceValidator.validateOefOifCombatEpisode(form, i2, messages, messageResources);
        }
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        form.setAddAPerson(isAddAPerson);
        for (i = 0; i < form.getServiceEpisodeIdList().size(); ++i) {
            MilitaryServiceValidator.validateServiceEpisode(form, i, messages, messageResources);
        }
        for (i = 0; i < form.getConflictEpisodeIdList().size(); ++i) {
            MilitaryServiceValidator.validateConflictEpisode(form, i, messages, messageResources);
        }
        return messages;
    }

    private static void validateMedalOfHonor(MilitaryServiceInfoForm form, ActionMessages errors, MessageResources messageResources) {
        if (StringUtils.isNotBlank((String)form.getMohInd()) && "y".equalsIgnoreCase(form.getMohInd())) {
            String label = null;
            String labelTxt = null;
            boolean isValid = true;
            String mohDocumentReceiptDate = form.getDocumentReceiptDate();
            label = "Medal of Honor " + messageResources.getMessage("label.documentReceiptDate");
            if (StringUtils.isNotEmpty((String)mohDocumentReceiptDate)) {
                try {
                    isValid = MilitaryServiceValidator.validateDate(mohDocumentReceiptDate, "documentReceiptDate", label, errors);
                    if (isValid) {
                        CommonDateUtils.getDate((String)mohDocumentReceiptDate, (boolean)true);
                        Date receiptdate = DateUtils.getDate((String)mohDocumentReceiptDate, (boolean)true);
                        Date current = DateUtils.getCurrentDateTime();
                        if (receiptdate != null && receiptdate.compareTo(current) > 0) {
                            errors.add("documentReceiptDate", new ActionMessage("errors.detail", (Object)(label + " cannot be a future date")));
                        }
                    }
                    if (StringUtils.isEmpty((String)form.getDocumentType())) {
                        labelTxt = messageResources.getMessage("label.documentType");
                        errors.add("documentType", new ActionMessage("errors.required", (Object)labelTxt));
                    }
                    labelTxt = null;
                    if (StringUtils.isEmpty((String)form.getDataSource())) {
                        labelTxt = messageResources.getMessage("label.dataSource");
                        errors.add("dataSource", new ActionMessage("errors.required", (Object)labelTxt));
                    }
                }
                catch (Exception e) {
                    errors.add("documentReceiptDate", new ActionMessage("errors.detail", (Object)(label + " must be a precise date.")));
                }
            }
        }
    }

    private static void validateCurrentMilitaryService(MilitaryServiceInfoForm form, ActionMessages errors, MessageResources messageResources) {
        String label = null;
        if (StringUtils.isEmpty((String)form.getDischargeDueToDisability())) {
            label = messageResources.getMessage("label.dischargeDueToDisablility");
            errors.add("dischargeDueToDisability", new ActionMessage("errors.required", (Object)label));
        }
        if (StringUtils.isEmpty((String)form.getRetirementDueToMilitaryDisability())) {
            label = messageResources.getMessage("label.militaryDisabilityRetirement");
            errors.add("retirementDueToMilitaryDisability", new ActionMessage("errors.required", (Object)label));
        }
        if (StringUtils.isEmpty((String)form.getExposedToContaminants())) {
            label = messageResources.getMessage("label.environmentalContaminants");
            errors.add("exposedToContaminants", new ActionMessage("errors.required", (Object)label));
        }
        if (StringUtils.isEmpty((String)form.getShad())) {
            label = messageResources.getMessage("label.SHAD");
            errors.add("shad", new ActionMessage("errors.required", (Object)label));
        }
        if (form.getCampLejeuneVerificationComments().length() > 200) {
            label = messageResources.getMessage("label.CampLejeune");
            errors.add("campLejeuneVerificationComments", new ActionMessage("Comments is limitted to 200 characters"));
        }
    }

    private static void validateServiceEpisode(MilitaryServiceInfoForm form, int serviceEpisodeIndex, ActionMessages errors, MessageResources messageResources) {
        if (form.isAddAPerson()) {
            if (form.isServiceEpisodeEmpty(serviceEpisodeIndex)) {
                MilitaryServiceValidator.validateMilitaryServiceNumber(form, serviceEpisodeIndex, errors, messageResources);
                MilitaryServiceValidator.validateMilitaryServiceComponent(form, serviceEpisodeIndex, errors, messageResources);
                MilitaryServiceValidator.validateMilitaryServiceElements(form, serviceEpisodeIndex, errors, messageResources);
            } else {
                MilitaryServiceValidator.validateMilitaryServiceComponent(form, serviceEpisodeIndex, errors, messageResources);
                MilitaryServiceValidator.validateMilitaryServiceElements(form, serviceEpisodeIndex, errors, messageResources);
            }
        } else if (!form.isServiceEpisodeEmpty(serviceEpisodeIndex)) {
            MilitaryServiceValidator.validateMilitaryServiceElements(form, serviceEpisodeIndex, errors, messageResources);
        }
    }

    private static void validateMilitaryServiceElements(MilitaryServiceInfoForm form, int serviceEpisodeIndex, ActionMessages errors, MessageResources messageResources) {
        String index = "[" + serviceEpisodeIndex + "]";
        String label = null;
        String branchOfService = (String)form.getServiceEpisodeBranchOfServiceList().get(serviceEpisodeIndex);
        if (StringUtils.isEmpty((String)branchOfService)) {
            label = messageResources.getMessage("label.branchOfService");
            errors.add("serviceEpisodeBranchOfService" + index, new ActionMessage("errors.required", (Object)label));
        }
        String entryDate = (String)form.getServiceEpisodeEntryDateList().get(serviceEpisodeIndex);
        label = messageResources.getMessage("label.serviceEntryDate");
        MilitaryServiceValidator.validateDate(entryDate, "serviceEpisodeEntryDate" + index, label, errors);
        String separationDate = (String)form.getServiceEpisodeSeparationDateList().get(serviceEpisodeIndex);
        label = messageResources.getMessage("label.serviceSeperationDate");
        MilitaryServiceValidator.validateDate(separationDate, "serviceEpisodeSeparationDate" + index, label, errors);
        String dischargeType = (String)form.getServiceEpisodeDischargeTypeList().get(serviceEpisodeIndex);
        if (StringUtils.isEmpty((String)dischargeType)) {
            label = messageResources.getMessage("label.dischargeType");
            errors.add("serviceEpisodeDischargeType" + index, new ActionMessage("errors.required", (Object)label));
        }
    }

    private static void validateMilitaryServiceComponent(MilitaryServiceInfoForm form, int serviceEpisodeIndex, ActionMessages errors, MessageResources messageResources) {
        String index = "[" + serviceEpisodeIndex + "]";
        String label = null;
        String msComponent = (String)form.getServiceEpisodeServiceComponentList().get(serviceEpisodeIndex);
        if (StringUtils.isEmpty((String)msComponent)) {
            label = messageResources.getMessage("label.serviceComponent");
            errors.add("serviceEpisodeServiceComponent" + index, new ActionMessage("errors.required", (Object)label));
        }
    }

    private static void validateMilitaryServiceNumber(MilitaryServiceInfoForm form, int serviceEpisodeIndex, ActionMessages errors, MessageResources messageResources) {
        String index = "[" + serviceEpisodeIndex + "]";
        String label = null;
        String msComponent = (String)form.getServiceEpisodeMilitaryServiceNumberList().get(serviceEpisodeIndex);
        if (StringUtils.isEmpty((String)msComponent)) {
            label = messageResources.getMessage("label.militaryServiceNumber");
            errors.add("serviceEpisodeMilitaryServiceNumber" + index, new ActionMessage("errors.required", (Object)label));
        }
    }

    private static void validateConflictEpisode(MilitaryServiceInfoForm form, int conflictEpisodeIndex, ActionMessages errors, MessageResources messageResources) {
        if (!form.isConflictEpisodeEmpty(conflictEpisodeIndex)) {
            String index = "[" + conflictEpisodeIndex + "]";
            String label = null;
            String startDate = (String)form.getConflictEpisodeStartDateList().get(conflictEpisodeIndex);
            label = messageResources.getMessage("label.conflictStartDate");
            MilitaryServiceValidator.validateDate(startDate, "conflictEpisodeStartDate" + index, label, errors);
            String endDate = (String)form.getConflictEpisodeEndDateList().get(conflictEpisodeIndex);
            label = messageResources.getMessage("label.conflictEndDate");
            MilitaryServiceValidator.validateDate(endDate, "conflictEpisodeEndDate" + index, label, errors);
            String location = (String)form.getConflictEpisodeLocationList().get(conflictEpisodeIndex);
            if (StringUtils.isEmpty((String)location)) {
                label = messageResources.getMessage("label.conflictservicelocation");
                errors.add("conflictEpisodeLocation" + index, new ActionMessage("errors.required", (Object)label));
            }
        }
    }

    private static void validateOefOifCombatEpisode(MilitaryServiceInfoForm form, int oefOifCombatEpisode, ActionMessages errors, MessageResources messageResources) {
        if (!form.isOefOifCombatEpisodeEmpty(oefOifCombatEpisode)) {
            String index = "[" + oefOifCombatEpisode + "]";
            String label = null;
            String startDate = (String)form.getOefOifCombatEpisodeStartDateList().get(oefOifCombatEpisode);
            label = messageResources.getMessage("label.conflictStartDate");
            MilitaryServiceValidator.validateDate(startDate, "oefOifCombatEpisodeStartDate" + index, label, errors);
            String endDate = (String)form.getOefOifCombatEpisodeEndDateList().get(oefOifCombatEpisode);
            label = messageResources.getMessage("label.conflictEndDate");
            MilitaryServiceValidator.validateDate(endDate, "oefOifCombatEpisodeEndDate" + index, label, errors);
            String location = (String)form.getOefOifCombatEpisodeLocationList().get(oefOifCombatEpisode);
            if (StringUtils.isEmpty((String)location)) {
                label = messageResources.getMessage("label.conflictservicelocation");
                errors.add("oefOifCombatEpisodeLocation" + index, new ActionMessage("errors.required", (Object)label));
            }
        }
    }

    private static boolean validateDate(String fieldValue, String fieldName, String fieldLabel, ActionMessages errors) {
        boolean isValid = true;
        if (StringUtils.isNotEmpty((String)fieldValue)) {
            try {
                DateUtils.getDate((String)fieldValue);
            }
            catch (Exception ex) {
                isValid = false;
                try {
                    ImpreciseDate impDate = DateUtils.getImpreciseDate((String)fieldValue);
                    if (impDate != null) {
                        errors.add(fieldName, new ActionMessage("errors.mustBePrecise", (Object)fieldLabel));
                    } else {
                        errors.add(fieldName, new ActionMessage("errors.invalid", (Object)fieldLabel));
                    }
                }
                catch (Exception ex1) {
                    errors.add(fieldName, new ActionMessage("errors.invalid", (Object)fieldLabel));
                }
            }
        } else {
            isValid = false;
            errors.add(fieldName, new ActionMessage("errors.required", (Object)fieldLabel));
        }
        return isValid;
    }

    private static void validateCampLejeune(MilitaryServiceInfoForm form, ActionMessages errors, MessageResources messageResources) {
        Iterator<String> clvmsIter;
        String label;
        if (form.getCampLejeuneInd() != null && StringUtils.isNotBlank((String)form.getCampLejeuneInd()) && Indicator.YES.getCode().equalsIgnoreCase(form.getCampLejeuneInd())) {
            label = null;
            boolean isValid = true;
            String campLejeuneChangeDate = form.getCampLejeuneChangeDate();
            label = "Camp Lejeune " + messageResources.getMessage("label.clvChangeDate");
            if (StringUtils.isNotEmpty((String)campLejeuneChangeDate) && (isValid = MilitaryServiceValidator.validateDate(campLejeuneChangeDate, "campLejeuneChangeDate", label, errors))) {
                CommonDateUtils.getDate((String)campLejeuneChangeDate, (boolean)true);
                Date receiptdate = DateUtils.getDate((String)campLejeuneChangeDate, (boolean)true);
                Date current = DateUtils.getCurrentDateTime();
                if (receiptdate != null && receiptdate.compareTo(current) > 0) {
                    errors.add("campLejeuneChangeDate", new ActionMessage("errors.detail", (Object)(label + " cannot be a future date")));
                }
            }
        }
        if (form.getCampLejeuneVerificationComments() != null && form.getCampLejeuneVerificationComments().length() > 200) {
            label = messageResources.getMessage("label.clvComments");
            errors.add("campLejeuneVerificationComments", new ActionMessage("errors.detail", (Object)(label + "is limitted to 200 characters")));
        }
        List<String> clvms = null;
        if (form.getCampLejeuneVerificationMethods() != null) {
            clvms = Arrays.asList(form.getCampLejeuneVerificationMethods());
        }
        Iterator<String> iterator = clvmsIter = clvms != null ? clvms.iterator() : null;
        if (clvmsIter != null) {
            while (clvmsIter.hasNext()) {
                String clveficationMethod = clvmsIter.next();
                if (!clveficationMethod.equalsIgnoreCase("7") || form.getCampLejeuneVerificationComments() != null && !form.getCampLejeuneVerificationComments().equals("")) continue;
                String label2 = messageResources.getMessage("label.clvComments");
                errors.add("campLejeuneVerificationComments", new ActionMessage("errors.detail", (Object)(label2 + " are required when the verified method Other is selected.")));
            }
        }
    }
}

