/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.militaryservice.action;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.AgentOrangeExposure;
import gov.va.med.esr.common.model.ee.CampLejeuneVerification;
import gov.va.med.esr.common.model.ee.CampLejeuneVerificationMethod;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.ee.CombatService;
import gov.va.med.esr.common.model.ee.ConflictExperience;
import gov.va.med.esr.common.model.ee.EnvironmentalContaminationExposure;
import gov.va.med.esr.common.model.ee.MedalOfHonor;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.RadiationExposure;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.ee.SpecialFactor;
import gov.va.med.esr.common.model.lookup.AgentOrangeExposureLocation;
import gov.va.med.esr.common.model.lookup.CampLejeuneChangeSource;
import gov.va.med.esr.common.model.lookup.CampLejeuneVerificationType;
import gov.va.med.esr.common.model.lookup.CombatPayType;
import gov.va.med.esr.common.model.lookup.ConflictLocation;
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.lookup.DischargeType;
import gov.va.med.esr.common.model.lookup.FilipinoVeteranProof;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.MHDataSource;
import gov.va.med.esr.common.model.lookup.MilitaryServiceComponent;
import gov.va.med.esr.common.model.lookup.OEFOIFSource;
import gov.va.med.esr.common.model.lookup.PHDocumentType;
import gov.va.med.esr.common.model.lookup.RadiationExposureMethod;
import gov.va.med.esr.common.model.lookup.ServiceBranch;
import gov.va.med.esr.common.model.lookup.ServicePeriod;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.esr.ui.militaryservice.action.MilitaryServiceActionHelper;
import gov.va.med.esr.ui.militaryservice.action.MilitaryServiceInfoForm;
import gov.va.med.esr.ui.util.ConvertUtils;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.util.StringUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MilitaryServiceConversionService
extends UIConversionServiceImpl {
    public Object convert(Object source, Class targetClass) throws ConversionServiceException {
        return null;
    }

    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        if (source instanceof Person && target instanceof MilitaryServiceInfoForm) {
            MilitaryServiceInfoForm form = (MilitaryServiceInfoForm)((Object)target);
            Person person = (Person)source;
            try {
                this.populateForm(person, form);
            }
            catch (Exception ex) {
                throw new ConversionServiceException("Conversion Failed", ex);
            }
        }
        if (target instanceof Person && source instanceof MilitaryServiceInfoForm) {
            try {
                MilitaryServiceInfoForm form = (MilitaryServiceInfoForm)((Object)source);
                Person person = (Person)target;
                this.updateMilitaryService(form, person);
            }
            catch (Exception ex) {
                throw new ConversionServiceException("Error occured while updating person from MilitaryServiceInfoForm.", ex);
            }
        }
    }

    private void populateForm(Person person, MilitaryServiceInfoForm form) throws ConversionServiceException {
        MilitaryService militaryService;
        RadiationExposureMethod method;
        RadiationExposure radiationExposure;
        AgentOrangeExposureLocation location;
        AgentOrangeExposure agentOrangeExposure;
        BirthRecord birthRecord;
        if (form == null || person == null) {
            return;
        }
        Set ssns = person.getSsns();
        if (ssns != null && ssns.size() > 0) {
            SSN ssn = (SSN)ssns.iterator().next();
            form.setSsn(ssn.getSsnText());
        }
        if ((birthRecord = person.getBirthRecord()) != null) {
            ImpreciseDate birthDate = birthRecord.getBirthDate();
            form.setBirthDate(JspUtils.displayValue((Object)birthDate, (String)"MM/dd/yyyy"));
        }
        if ((agentOrangeExposure = (AgentOrangeExposure)person.getSpecialFactorByType(AgentOrangeExposure.class)) != null && (location = agentOrangeExposure.getLocation()) != null) {
            form.setAgentOrangeExposureLocation(location.getCode());
        }
        if ((radiationExposure = (RadiationExposure)person.getSpecialFactorByType(RadiationExposure.class)) != null && (method = radiationExposure.getExposureMethod()) != null) {
            form.setRadiationExposureMethod(method.getCode());
        }
        this.populateMedalOfHonor(form, person);
        this.populateCampLejeune(form, person);
        EnvironmentalContaminationExposure contExp = (EnvironmentalContaminationExposure)person.getSpecialFactorByType(EnvironmentalContaminationExposure.class);
        Indicator envInd = contExp != null ? contExp.getEnvironmentalContaminationExposureIndicator() : null;
        form.setExposedToContaminants(envInd != null ? envInd.getCode() : Indicator.UNKNOWN.getCode());
        SHAD shad = person.getShad();
        form.setShad(shad != null && shad.getShadIndicator() != null ? shad.getShadIndicator().getCode() : Indicator.UNKNOWN.getCode());
        form.setEligibleForClassIIDental(this.getIndicatorCode(person.getEligibleForClassIIDental()));
        Date dueDate = person.getClassIIDentalApplicationDueBefore();
        if (dueDate != null) {
            form.setClassIIDentalApplicationDueBefore(DateUtils.format((Date)dueDate, (String)"MM/dd/yyyy"));
        }
        if ((militaryService = person.getMilitaryService()) != null) {
            form.setDischargeDueToDisability(this.getIndicatorCode(militaryService.getDischargeDueToDisability()));
            form.setRetirementDueToMilitaryDisability(this.getIndicatorCode(militaryService.getDisabilityRetirementIndicator()));
            Date endDate = militaryService.getCombatVeteranEligibilityEndDate();
            if (endDate != null) {
                form.setEligibilityEndDate(DateUtils.format((Date)endDate, (String)"MM/dd/yyyy"));
            }
            this.populateCombatServiceFields(form, militaryService.getCombatServices());
            this.populateCombatEpisodeFields(form, militaryService.getCombatEpisodes());
            MilitaryServiceSiteRecord militaryServiceSiteRecord = militaryService.getHECMilitaryServiceSiteRecord();
            if (militaryServiceSiteRecord != null) {
                FilipinoVeteranProof filipinoVeteranProof;
                ServicePeriod servicePeriod = militaryServiceSiteRecord.getServicePeriod();
                if (servicePeriod != null) {
                    form.setPeriodOfService(servicePeriod.getCode());
                }
                if ((filipinoVeteranProof = militaryServiceSiteRecord.getFilipinoVeteranProof()) != null) {
                    form.setFilipinoVeteranProof(filipinoVeteranProof.getCode());
                }
                Set serviceEpisodes = militaryServiceSiteRecord.getMilitaryServiceEpisodes();
                this.populateServiceEpisodeFields(form, serviceEpisodes);
                Set conflictExperiences = militaryServiceSiteRecord.getConflictExperiences();
                this.populateConflictEpisodeFields(form, conflictExperiences);
            }
        }
    }

    private void populateCampLejeune(MilitaryServiceInfoForm form, Person person) {
        CampLejeuneVerification clv = null;
        if (person != null) {
            clv = (CampLejeuneVerification)person.getSpecialFactorByType(CampLejeuneVerification.class);
            form.setCampLejeuneInd(clv != null && clv.getSpecialFactorIndicator() != null ? clv.getSpecialFactorIndicator().getCode() : Indicator.UNKNOWN.getCode());
            if (clv != null) {
                if (clv.getVerificationType() != null && clv.getVerificationType() != null) {
                    form.setCampLejeuneVerificationMethod(clv.getVerificationType().getCode());
                } else {
                    form.setCampLejeuneVerificationMethod("");
                }
                if (clv.getInternalCampLejeuneVerificationMethods() != null && clv.getInternalCampLejeuneVerificationMethods().size() > 0) {
                    Set clvms = clv.getInternalCampLejeuneVerificationMethods();
                    StringBuffer strMethod = new StringBuffer();
                    for (CampLejeuneVerificationMethod clvm : clvms) {
                        strMethod.append(clvm.getVerificationType().getCode());
                        strMethod.append(",");
                    }
                    form.setCampLejeuneVerificationMethods(strMethod.toString().split(","));
                }
                if (clv.getComments() != null) {
                    form.setCampLejeuneVerificationComments(clv.getComments());
                } else {
                    form.setCampLejeuneVerificationComments("");
                }
                if (clv.getChangeDate() != null) {
                    form.setCampLejeuneChangeDate(JspUtils.displayValue((Object)clv.getChangeDate(), null));
                }
                if (clv.getChangeSite() != null) {
                    form.setCampLejeuneChangeSite(clv.getChangeSite().getDescription());
                } else {
                    form.setCampLejeuneChangeSite("");
                }
                if (clv.getChangeSource() != null) {
                    if (clv.getChangeSource().getCode().equals(CampLejeuneChangeSource.CODE_HEC.getCode())) {
                        if (clv.getModifiedBy() != null && clv.getModifiedBy().getName() != null && !clv.getModifiedBy().getName().equalsIgnoreCase("MsdsService")) {
                            form.setCampLejeuneChangeSource(clv.getModifiedBy().getName());
                        } else {
                            form.setCampLejeuneChangeSource(clv.getChangeSource().getDescription());
                        }
                    } else {
                        form.setCampLejeuneChangeSource(clv.getChangeSource().getDescription());
                    }
                } else {
                    form.setCampLejeuneChangeSource("");
                }
            }
        }
    }

    private void populateMedalOfHonor(MilitaryServiceInfoForm form, Person person) {
        MedalOfHonor moh = this.getMoH(person);
        form.setMohInd(this.getMedalOfHonorIndicator(person));
        form.setOnFileMohInd(this.getMedalOfHonorIndicator(person));
        if (moh != null) {
            form.setMhLastStatusUpdateDate(JspUtils.displayValue((Object)moh.getStatusLastUpdateDate(), null));
            form.setStatus(moh.getStatus() == null ? "" : moh.getStatus().getDescription());
            form.setDocumentReceiptDate(JspUtils.displayValue((Object)moh.getDocumentReceiptDate(), null));
            form.setOnFileDocumentReceiptDate(JspUtils.displayValue((Object)moh.getDocumentReceiptDate(), null));
            form.setDocumentType(moh.getDocumentType() == null ? "" : moh.getDocumentType().getCode());
            form.setOnFileDocumentType(moh.getDocumentType() == null ? "" : moh.getDocumentType().getCode());
            form.setDataSource(moh.getDataSource() == null ? "" : moh.getDataSource().getCode());
            form.setOnFileMohDataSource(moh.getDataSource() == null ? "" : moh.getDataSource().getCode());
        } else {
            form.setMhLastStatusUpdateDate(null);
            form.setStatus("");
            form.setDocumentReceiptDate(null);
            form.setOnFileDocumentReceiptDate(null);
            form.setDocumentType("");
            form.setOnFileDocumentType("");
            form.setDataSource("");
            form.setOnFileMohDataSource("");
        }
    }

    private MedalOfHonor getMoH(Person person) {
        if (person != null) {
            return person.getMedalOfHonor();
        }
        return null;
    }

    public String getMedalOfHonorIndicator(Person person) {
        MedalOfHonor moh = person.getMedalOfHonor();
        if (moh == null) {
            return "nd";
        }
        return ConvertUtils.convertYesNoNoData(moh.getMhIndicator());
    }

    private void populateServiceEpisodeFields(MilitaryServiceInfoForm form, Set serviceEpisodes) {
        if (serviceEpisodes != null && !serviceEpisodes.isEmpty()) {
            List sortedServiceEpisodes = MilitaryServiceActionHelper.sortMilitaryServiceEpisodes(serviceEpisodes);
            MilitaryServiceEpisode serviceEpisode2 = null;
            String id = null;
            String militaryServiceNumber = null;
            String branchOfService = null;
            String entryDate = null;
            String separationDate = null;
            String dischargeType = null;
            String serviceComponent = null;
            String hashCode = null;
            for (MilitaryServiceEpisode serviceEpisode2 : sortedServiceEpisodes) {
                if (serviceEpisode2 == null) continue;
                id = serviceEpisode2.getEntityKey() != null ? serviceEpisode2.getEntityKey().getKeyValueAsString() : "";
                militaryServiceNumber = serviceEpisode2.getServiceNumber();
                branchOfService = serviceEpisode2.getServiceBranch() == null ? "" : serviceEpisode2.getServiceBranch().getCode();
                entryDate = JspUtils.displayValue((Object)serviceEpisode2.getStartDate(), (String)"MM/dd/yyyy");
                separationDate = JspUtils.displayValue((Object)serviceEpisode2.getEndDate(), (String)"MM/dd/yyyy");
                dischargeType = serviceEpisode2.getDischargeType() == null ? "" : serviceEpisode2.getDischargeType().getCode();
                serviceComponent = serviceEpisode2.getMilitaryServiceComponent() == null ? "" : serviceEpisode2.getMilitaryServiceComponent().getCode();
                hashCode = String.valueOf(serviceEpisode2.hashCode());
                form.addServiceEpisode(id, militaryServiceNumber, "", branchOfService, entryDate, separationDate, dischargeType, serviceComponent, hashCode);
            }
        }
    }

    private void populateCombatServiceFields(MilitaryServiceInfoForm form, Set combatServices) {
        if (combatServices != null && !combatServices.isEmpty()) {
            List sortedCombatServices = MilitaryServiceActionHelper.sortCombatServices(combatServices);
            CombatService combatService2 = null;
            String id = null;
            String startDate = null;
            String endDate = null;
            String location = null;
            String source = null;
            for (CombatService combatService2 : sortedCombatServices) {
                if (combatService2 == null) continue;
                id = combatService2.getEntityKey() != null ? combatService2.getEntityKey().getKeyValueAsString() : "";
                startDate = combatService2.getPayStartDate() == null ? "" : JspUtils.displayValue((Object)combatService2.getPayStartDate(), (String)"MM/dd/yyyy");
                endDate = combatService2.getPayEndDate() == null ? "" : JspUtils.displayValue((Object)combatService2.getPayEndDate(), (String)"MM/dd/yyyy");
                location = combatService2.getMsdsCountry() == null ? "" : combatService2.getMsdsCountry().getName();
                source = combatService2.getCombatServiceSource() == null ? "" : combatService2.getCombatServiceSource().getCode();
                form.addCombatService(id, startDate, endDate, location, source);
            }
        }
    }

    private void populateCombatEpisodeFields(MilitaryServiceInfoForm form, Set combatEpisodes) {
        if (combatEpisodes != null && !combatEpisodes.isEmpty()) {
            List sortedCombatEpisodes = MilitaryServiceActionHelper.sortCombatEpisodes(combatEpisodes);
            CombatEpisode combatEpisode2 = null;
            String id = null;
            String startDate = null;
            String endDate = null;
            String location = null;
            String payType = null;
            String source = null;
            String hashCode = null;
            for (CombatEpisode combatEpisode2 : sortedCombatEpisodes) {
                if (combatEpisode2 == null) continue;
                id = combatEpisode2.getEntityKey() != null ? combatEpisode2.getEntityKey().getKeyValueAsString() : "";
                startDate = combatEpisode2.getStartDate() == null ? "" : JspUtils.displayValue((Object)combatEpisode2.getStartDate(), (String)"MM/dd/yyyy");
                endDate = combatEpisode2.getEndDate() == null ? "" : JspUtils.displayValue((Object)combatEpisode2.getEndDate(), (String)"MM/dd/yyyy");
                location = combatEpisode2.getConflictLocation() == null ? "" : combatEpisode2.getConflictLocation().getCode();
                String string = payType = combatEpisode2.getCombatPayType() == null ? "" : combatEpisode2.getCombatPayType().getCode();
                source = combatEpisode2.getOEFOIFSource() != null ? (combatEpisode2.getOEFOIFSource() == null ? "" : combatEpisode2.getOEFOIFSource().getCode()) : (combatEpisode2.getOEFOIFStationNumber() == null ? "" : combatEpisode2.getOEFOIFStationNumber().getFacilityName());
                hashCode = String.valueOf(combatEpisode2.hashCode());
                form.addOefOifCombatEpisode(id, startDate, endDate, location, source, payType, hashCode);
            }
        }
    }

    private void populateConflictEpisodeFields(MilitaryServiceInfoForm form, Set conflictExperiences) {
        if (conflictExperiences != null && !conflictExperiences.isEmpty()) {
            List sortedConflictExperiences = MilitaryServiceActionHelper.sortConflictExperiences(conflictExperiences);
            ConflictExperience conflictExperience2 = null;
            String id = null;
            String startDate = null;
            String endDate = null;
            String location = null;
            String hashCode = null;
            for (ConflictExperience conflictExperience2 : sortedConflictExperiences) {
                if (conflictExperience2 == null) continue;
                id = conflictExperience2.getEntityKey() != null ? conflictExperience2.getEntityKey().getKeyValueAsString() : "";
                startDate = conflictExperience2.getStartDate() == null ? "" : JspUtils.displayValue((Object)conflictExperience2.getStartDate(), (String)"MM/dd/yyyy");
                endDate = conflictExperience2.getEndDate() == null ? "" : JspUtils.displayValue((Object)conflictExperience2.getEndDate(), (String)"MM/dd/yyyy");
                location = conflictExperience2.getConflictLocation() == null ? "" : conflictExperience2.getConflictLocation().getCode();
                hashCode = String.valueOf(conflictExperience2.hashCode());
                form.addConflictEpisode(id, startDate, endDate, location, hashCode);
            }
        }
    }

    private void updateMilitaryService(MilitaryServiceInfoForm form, Person person) throws ConversionServiceException {
        person.setEligibleForClassIIDental(this.getBooleanIndicatorCode(form.getEligibleForClassIIDental()));
        this.setPersonMedalOfHonor(form, person);
        this.updateSpecialFactors(form, person);
        MilitaryService militaryService = person.getMilitaryService();
        if (militaryService == null) {
            militaryService = new MilitaryService();
            person.setMilitaryService(militaryService);
        }
        militaryService.setDischargeDueToDisability(this.getBooleanIndicatorCode(form.getDischargeDueToDisability()));
        militaryService.setDisabilityRetirementIndicator(this.getBooleanIndicatorCode(form.getRetirementDueToMilitaryDisability()));
        this.updateOefOifCombatEpisode(form, militaryService);
        MilitaryServiceSiteRecord hecMSSiteRecord = militaryService.getHECMilitaryServiceSiteRecord();
        boolean isNewHecSiteRecord = false;
        if (hecMSSiteRecord == null) {
            isNewHecSiteRecord = true;
            hecMSSiteRecord = new MilitaryServiceSiteRecord();
            hecMSSiteRecord.setSite((VAFacility)this.getLookup(VAFacility.class, VAFacility.CODE_HEC.getName()));
        }
        String filipinoVeteranProof = form.getFilipinoVeteranProof();
        hecMSSiteRecord.setFilipinoVeteranProof((FilipinoVeteranProof)this.getLookup(FilipinoVeteranProof.class, filipinoVeteranProof));
        String periodOfService = form.getPeriodOfService();
        hecMSSiteRecord.setServicePeriod((ServicePeriod)this.getLookup(ServicePeriod.class, periodOfService));
        this.updateMilitaryServiceEpisodes(form, hecMSSiteRecord);
        this.updateConflictExperiences(form, hecMSSiteRecord);
        if (isNewHecSiteRecord && !hecMSSiteRecord.isEmpty()) {
            militaryService.addMilitaryServiceSiteRecord(hecMSSiteRecord);
        }
    }

    private void setPersonMedalOfHonor(MilitaryServiceInfoForm form, Person person) throws ConversionServiceException {
        try {
            LookupCacheService lookupCacheService = this.getLookupCacheService();
            this.setMedalOfHonorIndicator(form, person);
            MedalOfHonor moh = person.getMedalOfHonor();
            String mohInd = form.getMohInd();
            String oldMohInd = form.getOnFileMohInd();
            if (StringUtils.isNotEmpty((String)mohInd) && "y".equalsIgnoreCase(mohInd)) {
                if (moh == null) {
                    moh = new MedalOfHonor();
                    person.setMedalOfHonor(moh);
                }
                moh.setMhIndicator(Boolean.TRUE);
                Date documentReceiptDate = DateUtils.getDate((String)form.getDocumentReceiptDate());
                if (documentReceiptDate == null) {
                    documentReceiptDate = DateUtils.getCurrentDate();
                }
                moh.setDocumentReceiptDate(documentReceiptDate);
                moh.setDataSource((MHDataSource)lookupCacheService.getByCodeFromCache(MHDataSource.class, form.getDataSource()));
                moh.setDocumentType((PHDocumentType)lookupCacheService.getByCodeFromCache(PHDocumentType.class, form.getDocumentType()));
                moh.setStatus((DecorationStatus)lookupCacheService.getByCodeFromCache(DecorationStatus.class, DecorationStatus.CODE_CONFIRMED.getCode()));
                if (this.isAnyMOHDataChanged(form, person)) {
                    moh.setStatusLastUpdateDate(DateUtils.getCurrentDate());
                }
            } else if (StringUtils.isNotEmpty((String)oldMohInd) && "y".equalsIgnoreCase(oldMohInd)) {
                moh.setDataSource(null);
                moh.setDocumentReceiptDate(null);
                moh.setDocumentType(null);
                moh.setStatus(null);
                moh.setStatusLastUpdateDate(null);
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Error occured while updating medal of honor information from MilitaryServiceInfoForm.", ex);
        }
    }

    private void setMedalOfHonorIndicator(MilitaryServiceInfoForm form, Person person) {
        MedalOfHonor moh = person.getMedalOfHonor();
        String setYes = form.getMohInd();
        if (setYes == null || setYes.equalsIgnoreCase("nd")) {
            if (moh != null) {
                moh.setMhIndicator(null);
            }
        } else {
            if (moh == null) {
                moh = new MedalOfHonor();
                person.setMedalOfHonor(moh);
            }
            boolean hasThisType = setYes.equalsIgnoreCase("y");
            moh.setMhIndicator(Boolean.valueOf(hasThisType));
        }
    }

    private boolean isAnyMOHDataChanged(MilitaryServiceInfoForm form, Person person) {
        if (form.getOnFileMohInd() != null && ("n".equalsIgnoreCase(form.getOnFileMohInd()) || "nd".equalsIgnoreCase(form.getOnFileMohInd()))) {
            return true;
        }
        if (form.getDataSource() != null && form.getDataSource().trim().length() > 0) {
            if (StringUtils.isEmpty((String)form.getOnFileMohDataSource())) {
                return true;
            }
            if (!form.getDataSource().equals(form.getOnFileMohDataSource())) {
                return true;
            }
        } else {
            return StringUtils.isNotEmpty((String)form.getOnFileMohDataSource());
        }
        if (form.getDocumentReceiptDate() != null && form.getDocumentReceiptDate().trim().length() > 0) {
            if (StringUtils.isEmpty((String)form.getOnFileDocumentReceiptDate())) {
                return true;
            }
            if (!form.getDocumentReceiptDate().equals(form.getOnFileDocumentReceiptDate())) {
                return true;
            }
        } else {
            return StringUtils.isNotEmpty((String)form.getOnFileDocumentReceiptDate());
        }
        if (form.getDocumentType() != null && form.getDocumentType().trim().length() > 0) {
            if (StringUtils.isEmpty((String)form.getDocumentType())) {
                return true;
            }
            return !form.getDocumentType().equals(form.getOnFileDocumentType());
        }
        return StringUtils.isNotEmpty((String)form.getOnFileDocumentType());
    }

    private void updateSpecialFactors(MilitaryServiceInfoForm form, Person person) throws ConversionServiceException {
        try {
            String aoel = form.getAgentOrangeExposureLocation();
            AgentOrangeExposureLocation location = (AgentOrangeExposureLocation)this.getLookup(AgentOrangeExposureLocation.class, aoel);
            AgentOrangeExposure ao = (AgentOrangeExposure)person.getSpecialFactorByType(AgentOrangeExposure.class);
            if (location != null) {
                if (ao == null) {
                    ao = new AgentOrangeExposure();
                    person.addSpecialFactor((SpecialFactor)ao);
                }
                ao.setLocation(location);
            } else if (ao != null) {
                ao.setLocation(null);
            }
            String rem = form.getRadiationExposureMethod();
            RadiationExposureMethod method = (RadiationExposureMethod)this.getLookup(RadiationExposureMethod.class, rem);
            RadiationExposure re = (RadiationExposure)person.getSpecialFactorByType(RadiationExposure.class);
            if (method != null) {
                if (re == null) {
                    re = new RadiationExposure();
                    person.addSpecialFactor((SpecialFactor)re);
                }
                re.setExposureMethod(method);
            } else if (re != null) {
                re.setExposureMethod(null);
            }
            EnvironmentalContaminationExposure contaminationExposure = (EnvironmentalContaminationExposure)person.getSpecialFactorByType(EnvironmentalContaminationExposure.class);
            String expToContaminants = form.getExposedToContaminants();
            Indicator expToContaminantsInd = (Indicator)this.getLookup(Indicator.class, expToContaminants);
            if (StringUtils.isNotEmpty((String)expToContaminants)) {
                if (contaminationExposure == null) {
                    contaminationExposure = new EnvironmentalContaminationExposure();
                    person.addSpecialFactor((SpecialFactor)contaminationExposure);
                }
                contaminationExposure.setEnvironmentalContaminationExposureIndicator(expToContaminantsInd);
            } else if (contaminationExposure != null) {
                contaminationExposure.setEnvironmentalContaminationExposureIndicator(expToContaminantsInd);
            }
            SHAD SHAD2 = person.getShad();
            if (StringUtils.isNotEmpty((String)form.getShad())) {
                if (SHAD2 == null) {
                    SHAD2 = new SHAD();
                    person.setShad(SHAD2);
                }
                SHAD2.setShadIndicator((Indicator)this.getLookup(Indicator.class, form.getShad()));
            } else if (SHAD2 != null && SHAD2.getShadIndicator() != null && Indicator.YES.getCode().equals(SHAD2.getShadIndicator().getCode())) {
                SHAD2.setShadIndicator((Indicator)this.getLookup(Indicator.class, Indicator.NO.getCode()));
            }
            CampLejeuneVerification clv = (CampLejeuneVerification)person.getSpecialFactorByType(CampLejeuneVerification.class);
            String clvStr = form.getCampLejeuneInd();
            if (clvStr != null && clvStr.equals("y")) {
                clvStr = "1";
            } else if (clvStr != null && clvStr.equals("n")) {
                clvStr = "2";
            }
            Indicator clvInd = (Indicator)this.getLookup(Indicator.class, clvStr);
            if (clv == null) {
                clv = new CampLejeuneVerification();
                person.addSpecialFactor((SpecialFactor)clv);
                clv = (CampLejeuneVerification)person.getSpecialFactorByType(CampLejeuneVerification.class);
            }
            clv.setSpecialFactorIndicator(clvInd);
            String clvVMStr = form.getCampLejeuneVerificationMethod();
            CampLejeuneVerificationType clvtype = (CampLejeuneVerificationType)this.getLookup(CampLejeuneVerificationType.class, clvVMStr);
            List<String> clvms = null;
            if (form.getCampLejeuneVerificationMethods() != null) {
                clvms = Arrays.asList(form.getCampLejeuneVerificationMethods());
            }
            if (clvms != null) {
                if (clv.getInternalCampLejeuneVerificationMethods() != null) {
                    Iterator iter = clv.getInternalCampLejeuneVerificationMethods().iterator();
                    while (iter.hasNext()) {
                        CampLejeuneVerificationMethod clm = (CampLejeuneVerificationMethod)iter.next();
                        if (clvms.contains(clm.getVerificationType().getCode())) continue;
                        iter.remove();
                    }
                }
                for (String clvVMStr1 : clvms) {
                    CampLejeuneVerificationType clvtype1 = (CampLejeuneVerificationType)this.getLookup(CampLejeuneVerificationType.class, clvVMStr1);
                    if (clv.getCampLejeuneMethodByType(clvVMStr1) != null) continue;
                    CampLejeuneVerificationMethod clvm = new CampLejeuneVerificationMethod();
                    clvm.setVerificationType(clvtype1);
                    clv.addCampLejeuneVerificationMethod(clvm);
                }
            }
            clv.setVerificationType(clvtype);
            clv.setComments(form.getCampLejeuneVerificationComments());
            Date clvChangeDate = DateUtils.getDate((String)form.getCampLejeuneChangeDate());
            if (clvChangeDate == null && clv != null && clv.getSpecialFactorIndicator() != null && (Indicator.YES.getCode().equals(clv.getSpecialFactorIndicator().getCode()) || Indicator.NO.getCode().equals(clv.getSpecialFactorIndicator().getCode()))) {
                clvChangeDate = DateUtils.getCurrentDate();
            }
            clv.setChangeDate(clvChangeDate);
            if (form.getCampLejeuneChangeSource() == null || form.getCampLejeuneChangeSource().equals("")) {
                CampLejeuneChangeSource clcs = (CampLejeuneChangeSource)this.getLookup(CampLejeuneChangeSource.class, CampLejeuneChangeSource.CODE_HEC.getName());
                clv.setChangeSource(clcs);
            }
            if (form.getCampLejeuneChangeSite() == null || form.getCampLejeuneChangeSite().equals("")) {
                VAFacility vafac = (VAFacility)this.getLookup(VAFacility.class, VAFacility.CODE_HEC.getName());
                clv.setChangeSite(vafac);
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Error occured while updating special factors from MilitaryServiceInfoForm.", ex);
        }
    }

    private void updateOefOifCombatEpisode(MilitaryServiceInfoForm form, MilitaryService militaryService) throws ConversionServiceException {
        Map existingCombatEpisodeMap = MilitaryServiceActionHelper.getMapFromCollection(militaryService.getCombatEpisodes());
        militaryService.removeAllCombatEpisodes();
        List combatEpisodeIds = form.getOefOifCombatEpisodeIdList();
        if (combatEpisodeIds != null && !combatEpisodeIds.isEmpty()) {
            for (int i = 0; i < combatEpisodeIds.size(); ++i) {
                String combatEpisodeId = (String)combatEpisodeIds.get(i);
                if (StringUtils.isEmpty((String)combatEpisodeId)) {
                    if (form.isOefOifCombatEpisodeEmpty(i)) continue;
                    CombatEpisode newCombatEpisode = this.createNewCombatEpisode(form, i);
                    form.setOefOifCombatEpisodeHashCode(i, String.valueOf(newCombatEpisode.hashCode()));
                    militaryService.addCombatEpisode(newCombatEpisode);
                    continue;
                }
                if (form.isOefOifCombatEpisodeEmpty(i)) continue;
                CombatEpisode combatEpisode = (CombatEpisode)existingCombatEpisodeMap.get(combatEpisodeId);
                if (combatEpisode == null) {
                    combatEpisode = this.createNewCombatEpisode(form, i);
                } else {
                    if (form.isOefOifCombatEpisodeChanged(i, combatEpisode)) {
                        OEFOIFSource oefOifSource = (OEFOIFSource)this.getLookup(OEFOIFSource.class, OEFOIFSource.CODE_CENTRALIZED_ELIGIBILITY_VERIFICATION.getCode());
                        combatEpisode.setOEFOIFSource(oefOifSource);
                    }
                    combatEpisode = this.updateCombatEpisode(form, i, combatEpisode);
                }
                form.setOefOifCombatEpisodeHashCode(i, String.valueOf(combatEpisode.hashCode()));
                militaryService.addCombatEpisode(combatEpisode);
            }
        }
    }

    private CombatEpisode createNewCombatEpisode(MilitaryServiceInfoForm form, int index) throws ConversionServiceException {
        CombatEpisode newCcombatEpisode = new CombatEpisode();
        OEFOIFSource oefOifSource = (OEFOIFSource)this.getLookup(OEFOIFSource.class, OEFOIFSource.CODE_CENTRALIZED_ELIGIBILITY_VERIFICATION.getCode());
        newCcombatEpisode.setOEFOIFSource(oefOifSource);
        return this.updateCombatEpisode(form, index, newCcombatEpisode);
    }

    private CombatEpisode updateCombatEpisode(MilitaryServiceInfoForm form, int index, CombatEpisode combatEpisode) throws ConversionServiceException {
        ImpreciseDate startDate = DateUtils.getImpreciseDate((String)form.getOefOifCombatEpisodeStartDate(index));
        ImpreciseDate endDate = DateUtils.getImpreciseDate((String)form.getOefOifCombatEpisodeEndDate(index));
        ConflictLocation conflictLocation = (ConflictLocation)this.getLookup(ConflictLocation.class, form.getOefOifCombatEpisodeLocation(index));
        CombatPayType payType = (CombatPayType)this.getLookup(CombatPayType.class, form.getOefOifCombatPayType(index));
        combatEpisode.setStartDate(startDate);
        combatEpisode.setEndDate(endDate);
        combatEpisode.setConflictLocation(conflictLocation);
        combatEpisode.setCombatPayType(payType);
        return combatEpisode;
    }

    private void updateMilitaryServiceEpisodes(MilitaryServiceInfoForm form, MilitaryServiceSiteRecord hecMSSiteRecord) throws ConversionServiceException {
        Set existingServiceEpisodes = hecMSSiteRecord.getMilitaryServiceEpisodes();
        Map existingServiceEpisodeMap = MilitaryServiceActionHelper.getMapFromCollection(existingServiceEpisodes);
        hecMSSiteRecord.removeAllMilitaryServiceEpisodes();
        List serviceEpisodeIds = form.getServiceEpisodeIdList();
        if (serviceEpisodeIds != null && !serviceEpisodeIds.isEmpty()) {
            for (int i = 0; i < serviceEpisodeIds.size(); ++i) {
                String serviceEpisodeId = (String)serviceEpisodeIds.get(i);
                if (StringUtils.isEmpty((String)serviceEpisodeId)) {
                    if (form.isServiceEpisodeEmpty(i)) continue;
                    MilitaryServiceEpisode newMSEpisode = this.creatNewMilitaryServiceEpisode(form, i);
                    form.setServiceEpisodeHashCode(i, String.valueOf(newMSEpisode.hashCode()));
                    hecMSSiteRecord.addMilitaryServiceEpisode(newMSEpisode);
                    continue;
                }
                if (form.isServiceEpisodeEmpty(i)) continue;
                MilitaryServiceEpisode msEpisode = (MilitaryServiceEpisode)existingServiceEpisodeMap.get(serviceEpisodeId);
                msEpisode = msEpisode == null ? this.creatNewMilitaryServiceEpisode(form, i) : this.updateMilitaryServiceEpisode(form, i, msEpisode);
                form.setServiceEpisodeHashCode(i, String.valueOf(msEpisode.hashCode()));
                hecMSSiteRecord.addMilitaryServiceEpisode(msEpisode);
            }
        }
    }

    private MilitaryServiceEpisode creatNewMilitaryServiceEpisode(MilitaryServiceInfoForm form, int index) throws ConversionServiceException {
        MilitaryServiceEpisode newMSEpisode = new MilitaryServiceEpisode();
        return this.updateMilitaryServiceEpisode(form, index, newMSEpisode);
    }

    private MilitaryServiceEpisode updateMilitaryServiceEpisode(MilitaryServiceInfoForm form, int index, MilitaryServiceEpisode msEpisode) throws ConversionServiceException {
        String serviceNumber = form.getServiceEpisodeMilitaryServiceNumber(index);
        ServiceBranch branchOfService = (ServiceBranch)this.getLookup(ServiceBranch.class, form.getServiceEpisodeBranchOfService(index));
        ImpreciseDate entryDate = DateUtils.getImpreciseDate((String)form.getServiceEpisodeEntryDate(index));
        ImpreciseDate separationDate = DateUtils.getImpreciseDate((String)form.getServiceEpisodeSeparationDate(index));
        DischargeType dischargeType = (DischargeType)this.getLookup(DischargeType.class, form.getServiceEpisodeDischargeType(index));
        MilitaryServiceComponent serviceComponent = (MilitaryServiceComponent)this.getLookup(MilitaryServiceComponent.class, form.getServiceEpisodeServiceComponent(index));
        msEpisode.setServiceNumber(serviceNumber);
        msEpisode.setServiceBranch(branchOfService);
        msEpisode.setStartDate(entryDate);
        msEpisode.setEndDate(separationDate);
        msEpisode.setDischargeType(dischargeType);
        msEpisode.setMilitaryServiceComponent(serviceComponent);
        return msEpisode;
    }

    private void updateConflictExperiences(MilitaryServiceInfoForm form, MilitaryServiceSiteRecord hecMSSiteRecord) throws ConversionServiceException {
        Set existingConflictExperiences = hecMSSiteRecord.getConflictExperiences();
        Map existingConflictExperienceMap = MilitaryServiceActionHelper.getMapFromCollection(existingConflictExperiences);
        hecMSSiteRecord.removeAllConflictExperiences();
        List conflictEpisodeIds = form.getConflictEpisodeIdList();
        if (conflictEpisodeIds != null && !conflictEpisodeIds.isEmpty()) {
            for (int i = 0; i < conflictEpisodeIds.size(); ++i) {
                String conflictEpisodeId = (String)conflictEpisodeIds.get(i);
                if (StringUtils.isEmpty((String)conflictEpisodeId)) {
                    if (form.isConflictEpisodeEmpty(i)) continue;
                    ConflictExperience newConflictExperience = this.createNewConflictExperience(form, i);
                    form.setConflictEpisodeHashCode(i, String.valueOf(newConflictExperience.hashCode()));
                    hecMSSiteRecord.addConflictExperience(newConflictExperience);
                    continue;
                }
                if (form.isConflictEpisodeEmpty(i)) continue;
                ConflictExperience conflictExperience = (ConflictExperience)existingConflictExperienceMap.get(conflictEpisodeId);
                conflictExperience = conflictExperience == null ? this.createNewConflictExperience(form, i) : this.updateConflictExperience(form, i, conflictExperience);
                form.setConflictEpisodeHashCode(i, String.valueOf(conflictExperience.hashCode()));
                hecMSSiteRecord.addConflictExperience(conflictExperience);
            }
        }
    }

    private ConflictExperience createNewConflictExperience(MilitaryServiceInfoForm form, int index) throws ConversionServiceException {
        ConflictExperience newConflictEpisode = new ConflictExperience();
        return this.updateConflictExperience(form, index, newConflictEpisode);
    }

    private ConflictExperience updateConflictExperience(MilitaryServiceInfoForm form, int index, ConflictExperience conflictExperience) throws ConversionServiceException {
        ImpreciseDate entryDate = DateUtils.getImpreciseDate((String)form.getConflictEpisodeStartDate(index));
        ImpreciseDate separationDate = DateUtils.getImpreciseDate((String)form.getConflictEpisodeEndDate(index));
        ConflictLocation conflictLocation = (ConflictLocation)this.getLookup(ConflictLocation.class, form.getConflictEpisodeLocation(index));
        conflictExperience.setStartDate(entryDate);
        conflictExperience.setEndDate(separationDate);
        conflictExperience.setConflictLocation(conflictLocation);
        return conflictExperience;
    }
}

