/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.militaryservice.action;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.ee.CombatService;
import gov.va.med.esr.common.model.ee.ConflictExperience;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.ui.militaryservice.action.MilitaryServiceSiteRecordWraper;
import gov.va.med.fw.model.AbstractKeyedEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MilitaryServiceActionHelper {
    public static List sortMilitaryServiceSiteRecords(Set siteRecords) {
        ArrayList<MilitaryServiceSiteRecordWraper> siteRecordList = new ArrayList<MilitaryServiceSiteRecordWraper>();
        if (siteRecords != null) {
            for (MilitaryServiceSiteRecord msSiteRecord : siteRecords) {
                if (msSiteRecord == null || msSiteRecord.getMilitaryServiceEpisodes().size() <= 0 && msSiteRecord.getConflictExperiences().size() <= 0) continue;
                siteRecordList.add(new MilitaryServiceSiteRecordWraper(msSiteRecord));
            }
        }
        if (siteRecordList != null && !siteRecordList.isEmpty()) {
            Comparator comparator = new Comparator(){

                public int compare(Object pObject1, Object pObject2) {
                    if (pObject1 != null && pObject1 instanceof MilitaryServiceSiteRecordWraper && pObject2 != null && pObject2 instanceof MilitaryServiceSiteRecordWraper) {
                        VAFacility vaFacility1 = ((MilitaryServiceSiteRecordWraper)pObject1).getSite();
                        VAFacility vaFacility2 = ((MilitaryServiceSiteRecordWraper)pObject2).getSite();
                        if (vaFacility1 != null && vaFacility1.getName() != null && vaFacility2 != null && vaFacility2.getName() != null) {
                            return vaFacility1.getName().compareTo(vaFacility2.getName());
                        }
                    }
                    return 0;
                }
            };
            Collections.sort(siteRecordList, comparator);
        }
        return siteRecordList;
    }

    public static List sortCombatServices(Set combatServices) {
        if (combatServices == null) {
            return null;
        }
        ArrayList combatServiceList = new ArrayList(combatServices);
        if (!combatServiceList.isEmpty()) {
            Comparator comparator = new Comparator(){

                public int compare(Object pObject1, Object pObject2) {
                    ImpreciseDate startDate2;
                    ImpreciseDate startDate1 = pObject1 != null && pObject1 instanceof CombatService ? ((CombatService)pObject1).getPayStartDate() : null;
                    ImpreciseDate impreciseDate = startDate2 = pObject2 != null && pObject2 instanceof CombatService ? ((CombatService)pObject2).getPayStartDate() : null;
                    if (startDate1 != null && startDate2 != null) {
                        return startDate1.compareTo(startDate2);
                    }
                    return 0;
                }
            };
            Collections.sort(combatServiceList, comparator);
        }
        return combatServiceList;
    }

    public static List sortCombatEpisodes(Set combatEpisodes) {
        if (combatEpisodes == null) {
            return null;
        }
        ArrayList combatEpisodeList = new ArrayList(combatEpisodes);
        if (!combatEpisodeList.isEmpty()) {
            Comparator comparator = new Comparator(){

                public int compare(Object pObject1, Object pObject2) {
                    ImpreciseDate startDate2;
                    ImpreciseDate startDate1 = pObject1 != null && pObject1 instanceof CombatEpisode ? ((CombatEpisode)pObject1).getStartDate() : null;
                    ImpreciseDate impreciseDate = startDate2 = pObject2 != null && pObject2 instanceof CombatEpisode ? ((CombatEpisode)pObject2).getStartDate() : null;
                    if (startDate1 != null && startDate2 != null) {
                        return startDate1.compareTo(startDate2);
                    }
                    return 0;
                }
            };
            Collections.sort(combatEpisodeList, comparator);
        }
        return combatEpisodeList;
    }

    public static List sortMilitaryServiceEpisodes(Set serviceEpisodes) {
        if (serviceEpisodes == null) {
            return null;
        }
        ArrayList serviceEpisodeList = new ArrayList(serviceEpisodes);
        if (!serviceEpisodeList.isEmpty()) {
            Comparator comparator = new Comparator(){

                public int compare(Object pObject1, Object pObject2) {
                    ImpreciseDate startImDate2;
                    ImpreciseDate startImDate1 = pObject1 != null && pObject1 instanceof MilitaryServiceEpisode ? ((MilitaryServiceEpisode)pObject1).getStartDate() : null;
                    ImpreciseDate impreciseDate = startImDate2 = pObject2 != null && pObject2 instanceof MilitaryServiceEpisode ? ((MilitaryServiceEpisode)pObject2).getStartDate() : null;
                    if (startImDate1 != null && startImDate2 != null) {
                        return startImDate1.compareTo(startImDate2);
                    }
                    return 0;
                }
            };
            Collections.sort(serviceEpisodeList, comparator);
        }
        return serviceEpisodeList;
    }

    public static List sortConflictExperiences(Set conflictExperiences) {
        if (conflictExperiences == null) {
            return null;
        }
        ArrayList conflictExperienceList = new ArrayList(conflictExperiences);
        if (!conflictExperienceList.isEmpty()) {
            Comparator comparator = new Comparator(){

                public int compare(Object pObject1, Object pObject2) {
                    ImpreciseDate startDate2;
                    ImpreciseDate startDate1 = pObject1 != null && pObject1 instanceof ConflictExperience ? ((ConflictExperience)pObject1).getStartDate() : null;
                    ImpreciseDate impreciseDate = startDate2 = pObject2 != null && pObject2 instanceof ConflictExperience ? ((ConflictExperience)pObject2).getStartDate() : null;
                    if (startDate1 != null && startDate2 != null) {
                        return startDate1.compareTo(startDate2);
                    }
                    return 0;
                }
            };
            Collections.sort(conflictExperienceList, comparator);
        }
        return conflictExperienceList;
    }

    public static Map getMapFromCollection(Set set) {
        HashMap<String, AbstractKeyedEntity> map = new HashMap<String, AbstractKeyedEntity>();
        if (set != null) {
            AbstractKeyedEntity keyedEntity2 = null;
            for (AbstractKeyedEntity keyedEntity2 : set) {
                if (keyedEntity2 == null || keyedEntity2.getEntityKey() == null) continue;
                map.put(keyedEntity2.getEntityKey().getKeyValueAsString(), keyedEntity2);
            }
        }
        return map;
    }
}

