/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.militaryservice.action;

import gov.va.med.esr.common.model.ee.CampLejeuneVerification;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.lookup.OEFOIFSource;
import gov.va.med.esr.common.model.lookup.ServiceBranch;
import gov.va.med.esr.common.model.lookup.ServicePeriod;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.MessagingService;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.conversion.UIConversionService;
import gov.va.med.esr.ui.ee.action.EligibilityAction;
import gov.va.med.esr.ui.militaryservice.action.MilitaryServiceActionHelper;
import gov.va.med.esr.ui.militaryservice.action.MilitaryServiceConstants;
import gov.va.med.esr.ui.militaryservice.action.MilitaryServiceInfoForm;
import gov.va.med.esr.ui.militaryservice.action.MilitaryServiceValidator;
import gov.va.med.esr.ui.util.SessionManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;

public class MilitaryServiceAction
extends EligibilityAction
implements MilitaryServiceConstants {
    public void afterPropertiesSet() throws Exception {
    }

    public ActionForward display(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;
        militaryServiceForm.reset(mapping, request);
        militaryServiceForm.setMsdsBrokerService(super.getSystemParameterService().getMSDSServiceIndicator().toString());
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        militaryServiceForm.setAddAPerson(isAddAPerson);
        Person person = this.getSelectedPerson(request);
        SessionManager.setAttribute(request, "militaryServiceSiteRecordList", null);
        UIConversionService uiConversionService = (UIConversionService)this.conversionService;
        uiConversionService.convert(person, (Object)militaryServiceForm);
        militaryServiceForm.setCampLejeuneDisabled(!this.getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));
        SessionManager.setAttribute(request, "clveligible", this.getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));
        MilitaryService militaryService = person.getMilitaryService();
        if (militaryService != null) {
            Set set = militaryService.getMilitaryServiceSiteRecords();
            List siteRecords = MilitaryServiceActionHelper.sortMilitaryServiceSiteRecords(set);
            SessionManager.setAttribute(request, "militaryServiceSiteRecordList", siteRecords);
        }
        return mapping.findForward("display");
    }

    public ActionForward updateMilitaryService(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;
        Person person = this.getSelectedPerson(request);
        Person updatedPerson = (Person)person.clone();
        this.conversionService.convert((Object)militaryServiceForm, (Object)updatedPerson);
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        militaryServiceForm.setAddAPerson(isAddAPerson);
        if (!isAddAPerson) {
            updatedPerson = this.getMilitaryInfoService().updateMilitaryServiceInformation(updatedPerson);
        }
        this.updateSelectedPerson(request, updatedPerson);
        this.addInformationMessage(request, "message.militaryService.updated");
        militaryServiceForm.setMsdsBrokerService(super.getSystemParameterService().getMSDSServiceIndicator().toString());
        return this.display(mapping, actionForm, request, response);
    }

    @Override
    protected ActionForward handleOptimisticLockException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        form.reset(mapping, request);
        return this.display(mapping, form, request, response);
    }

    public ActionForward calculatePeriodOfService(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MilitaryService militaryService;
        MilitaryServiceSiteRecord hecSite;
        ServicePeriod servicePeriod;
        MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;
        Person person = this.getSelectedPerson(request);
        Person updatedPerson = (Person)person.clone();
        this.conversionService.convert((Object)militaryServiceForm, (Object)updatedPerson);
        MilitaryServiceSiteRecord hecUpdatedSite = updatedPerson.getMilitaryService().getHECMilitaryServiceSiteRecord();
        if (hecUpdatedSite != null) {
            hecUpdatedSite.setServicePeriod(null);
        }
        ServicePeriod servicePeriod2 = servicePeriod = (hecSite = (militaryService = (updatedPerson = this.getMilitaryInfoService().updateCalculatePeriodOfService(updatedPerson)).getMilitaryService()).getHECMilitaryServiceSiteRecord()) != null ? hecSite.getServicePeriod() : null;
        if (servicePeriod != null) {
            militaryServiceForm.setPeriodOfService(servicePeriod.getCode());
        } else {
            militaryServiceForm.setPeriodOfService("");
        }
        this.addInformationMessage(request, "message.reviewCalulatedPeriodOfService");
        militaryServiceForm.setMsdsBrokerService(super.getSystemParameterService().getMSDSServiceIndicator().toString());
        militaryServiceForm.setCampLejeuneDisabled(!this.getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));
        if (person != null) {
            CampLejeuneVerification clv = (CampLejeuneVerification)person.getSpecialFactorByType(CampLejeuneVerification.class);
            if (!this.getMilitaryInfoService().calculateCLVeligibilitybyMSE(person)) {
                militaryServiceForm.setCampLejeuneInd(clv != null && clv.getSpecialFactorIndicator() != null ? clv.getSpecialFactorIndicator().getCode() : "");
            }
        }
        return mapping.findForward("display");
    }

    public ActionForward addOefOifCombatEpisode(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;
        militaryServiceForm.addNewOefOifCombatEpisode();
        militaryServiceForm.setMsdsBrokerService(super.getSystemParameterService().getMSDSServiceIndicator().toString());
        militaryServiceForm.setAddedOEFOIFCombatEpisode(militaryServiceForm.getOefOifCombatEpisodeIdList().size() - 1);
        Person person = this.getSelectedPerson(request);
        militaryServiceForm.setCampLejeuneDisabled(!this.getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));
        if (person != null) {
            CampLejeuneVerification clv = (CampLejeuneVerification)person.getSpecialFactorByType(CampLejeuneVerification.class);
            if (!this.getMilitaryInfoService().calculateCLVeligibilitybyMSE(person)) {
                militaryServiceForm.setCampLejeuneInd(clv != null && clv.getSpecialFactorIndicator() != null ? clv.getSpecialFactorIndicator().getCode() : "");
            }
        }
        return mapping.findForward("display");
    }

    public ActionForward addMilitaryServiceEpisode(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;
        militaryServiceForm.addNewServiceEpisode();
        militaryServiceForm.setMsdsBrokerService(super.getSystemParameterService().getMSDSServiceIndicator().toString());
        militaryServiceForm.setAddedMilitaryServiceEpisode(militaryServiceForm.getServiceEpisodeIdList().size() - 1);
        Person person = this.getSelectedPerson(request);
        militaryServiceForm.setCampLejeuneDisabled(!this.getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));
        if (person != null) {
            CampLejeuneVerification clv = (CampLejeuneVerification)person.getSpecialFactorByType(CampLejeuneVerification.class);
            if (!this.getMilitaryInfoService().calculateCLVeligibilitybyMSE(person)) {
                militaryServiceForm.setCampLejeuneInd(clv != null && clv.getSpecialFactorIndicator() != null ? clv.getSpecialFactorIndicator().getCode() : "");
            }
        }
        return mapping.findForward("display");
    }

    public ActionForward addConflictEpisode(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;
        militaryServiceForm.addNewConflictEpisode();
        militaryServiceForm.setMsdsBrokerService(super.getSystemParameterService().getMSDSServiceIndicator().toString());
        militaryServiceForm.setAddedConflictEpisode(militaryServiceForm.getConflictEpisodeIdList().size() - 1);
        Person person = this.getSelectedPerson(request);
        militaryServiceForm.setCampLejeuneDisabled(!this.getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));
        if (person != null) {
            CampLejeuneVerification clv = (CampLejeuneVerification)person.getSpecialFactorByType(CampLejeuneVerification.class);
            if (!this.getMilitaryInfoService().calculateCLVeligibilitybyMSE(person)) {
                militaryServiceForm.setCampLejeuneInd(clv != null && clv.getSpecialFactorIndicator() != null ? clv.getSpecialFactorIndicator().getCode() : "");
            }
        }
        return mapping.findForward("display");
    }

    public ActionForward deleteOefOifCombatEpisode(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        System.out.println("deleteoefoif");
        MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;
        int index = Integer.parseInt(militaryServiceForm.getDeletedEpisodeIndex());
        militaryServiceForm.removeOefOifCombatEpisode(index);
        militaryServiceForm.setDeletedEpisodeIndex(null);
        militaryServiceForm.setMsdsBrokerService(super.getSystemParameterService().getMSDSServiceIndicator().toString());
        Person person = this.getSelectedPerson(request);
        militaryServiceForm.setCampLejeuneDisabled(!this.getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));
        if (person != null) {
            CampLejeuneVerification clv = (CampLejeuneVerification)person.getSpecialFactorByType(CampLejeuneVerification.class);
            if (!this.getMilitaryInfoService().calculateCLVeligibilitybyMSE(person)) {
                militaryServiceForm.setCampLejeuneInd(clv != null && clv.getSpecialFactorIndicator() != null ? clv.getSpecialFactorIndicator().getCode() : "");
            }
        }
        return mapping.findForward("display");
    }

    public ActionForward deleteMilitaryServiceEpisode(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;
        int index = Integer.parseInt(militaryServiceForm.getDeletedEpisodeIndex());
        this.removeCevOefOifEpisodesForMSE(index, militaryServiceForm);
        this.removeHecConflictEpisodesForMSE(index, militaryServiceForm);
        militaryServiceForm.removeServiceEpisode(index);
        militaryServiceForm.setDeletedEpisodeIndex(null);
        this.removeFilipinoVeteranProof(militaryServiceForm);
        militaryServiceForm.setMsdsBrokerService(super.getSystemParameterService().getMSDSServiceIndicator().toString());
        Person person = this.getSelectedPerson(request);
        militaryServiceForm.setCampLejeuneDisabled(!this.getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));
        if (person != null) {
            CampLejeuneVerification clv = (CampLejeuneVerification)person.getSpecialFactorByType(CampLejeuneVerification.class);
            if (!this.getMilitaryInfoService().calculateCLVeligibilitybyMSE(person)) {
                militaryServiceForm.setCampLejeuneInd(clv != null && clv.getSpecialFactorIndicator() != null ? clv.getSpecialFactorIndicator().getCode() : "");
            }
        }
        return mapping.findForward("display");
    }

    public ActionForward deleteConflictEpisode(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;
        int index = Integer.parseInt(militaryServiceForm.getDeletedEpisodeIndex());
        militaryServiceForm.removeConflictEpisode(index);
        militaryServiceForm.setDeletedEpisodeIndex(null);
        militaryServiceForm.setMsdsBrokerService(super.getSystemParameterService().getMSDSServiceIndicator().toString());
        Person person = this.getSelectedPerson(request);
        militaryServiceForm.setCampLejeuneDisabled(!this.getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));
        if (person != null) {
            CampLejeuneVerification clv = (CampLejeuneVerification)person.getSpecialFactorByType(CampLejeuneVerification.class);
            if (!this.getMilitaryInfoService().calculateCLVeligibilitybyMSE(person)) {
                militaryServiceForm.setCampLejeuneInd(clv != null && clv.getSpecialFactorIndicator() != null ? clv.getSpecialFactorIndicator().getCode() : "");
            }
        }
        return mapping.findForward("display");
    }

    public ActionForward reset(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;
        militaryServiceForm.reset(mapping, request);
        militaryServiceForm.setMsdsBrokerService(super.getSystemParameterService().getMSDSServiceIndicator().toString());
        return this.display(mapping, actionForm, request, response);
    }

    public ActionForward sendConfirmQuery(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;
        Person person = this.getSelectedPerson(request);
        militaryServiceForm.setCampLejeuneDisabled(!this.getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));
        if (person != null) {
            CampLejeuneVerification clv = (CampLejeuneVerification)person.getSpecialFactorByType(CampLejeuneVerification.class);
            if (!this.getMilitaryInfoService().calculateCLVeligibilitybyMSE(person)) {
                militaryServiceForm.setCampLejeuneInd(clv != null && clv.getSpecialFactorIndicator() != null ? clv.getSpecialFactorIndicator().getCode() : "");
            }
        }
        return mapping.findForward("sendMsdsQueryMessage");
    }

    public ActionForward sendBrokerMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person person = this.getSelectedPerson(request);
        if (this.isValidQueryInfo(person)) {
            MessagingService messagingService = this.getMessagingService();
            messagingService.processTriggerBroker(person);
            return mapping.findForward("message.sent.successfully");
        }
        return mapping.findForward("errors.message.sent.failed");
    }

    private boolean isValidQueryInfo(Person person) {
        if (this.passedNullValidation(person)) {
            return !this.invalidQuery(person);
        }
        return false;
    }

    private boolean invalidQuery(Person person) {
        return person.getIdentityTraits().getLegalName().getGivenName() == null || person.getIdentityTraits().getLegalName().getGivenName().length() == 0 || person.getIdentityTraits().getLegalName().getGivenName().trim().length() == 0 || person.getIdentityTraits().getSsnText() == null || person.getIdentityTraits().getSsnText().length() == 0 || person.getIdentityTraits().getSsnText().trim().length() == 0 || person.getIdentityTraits().getLegalName().getFamilyName() == null || person.getIdentityTraits().getLegalName().getFamilyName().length() == 0 || person.getIdentityTraits().getLegalName().getFamilyName().trim().length() == 0 || person.getIdentityTraits().getBirthRecord().getBirthDate() == null;
    }

    public boolean passedNullValidation(Person person) {
        return person.getIdentityTraits() != null && person.getIdentityTraits().getLegalName() != null && person.getBirthRecord() != null;
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("return");
    }

    public ActionMessages validateAction(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;
        Person person = this.getSelectedPerson(request);
        militaryServiceForm.setCampLejeuneDisabled(!this.getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));
        return MilitaryServiceValidator.validateMilitaryService(militaryServiceForm, request, this.getSelectedPerson(request));
    }

    protected Map getKeyMethodMap() {
        if (this.keyMethodMap == null) {
            this.keyMethodMap = new HashMap();
            this.keyMethodMap.put("button.display", "display");
            this.keyMethodMap.put("button.calculatePOS", "calculatePeriodOfService");
            this.keyMethodMap.put("button.update", "updateMilitaryService");
            this.keyMethodMap.put("button.addOefOifCombatEpisode", "addOefOifCombatEpisode");
            this.keyMethodMap.put("button.addMilitaryServiceEpisode", "addMilitaryServiceEpisode");
            this.keyMethodMap.put("button.addConflictEpisode", "addConflictEpisode");
            this.keyMethodMap.put("button.deleteOefOifCombatEpisode", "deleteOefOifCombatEpisode");
            this.keyMethodMap.put("button.deleteMilitaryServiceEpisode", "deleteMilitaryServiceEpisode");
            this.keyMethodMap.put("button.deleteConflictEpisode", "deleteConflictEpisode");
            this.keyMethodMap.put("button.reset", "reset");
            this.keyMethodMap.put("button.sendBrokerQuery", "sendConfirmQuery");
            this.keyMethodMap.put("button.confirm", "sendBrokerMessage");
            this.keyMethodMap.put("button.cancel", "cancel");
        }
        return this.keyMethodMap;
    }

    private void removeFilipinoVeteranProof(MilitaryServiceInfoForm militaryServiceForm) {
        List mseList = militaryServiceForm.getServiceEpisodeBranchOfServiceList();
        Iterator mseIter = mseList.iterator();
        String commonWealthBranch = ServiceBranch.CODE_F_COMMONWEALTH.getCode();
        String guerillaBranch = ServiceBranch.CODE_F_GUERILLA.getCode();
        String scoutsNewBranch = ServiceBranch.CODE_F_SCOUTS_NEW.getCode();
        boolean removeFilipinoVeteranProofInd = true;
        while (mseIter.hasNext()) {
            String serviceBranch = (String)mseIter.next();
            if (!commonWealthBranch.equalsIgnoreCase(serviceBranch) && !guerillaBranch.equalsIgnoreCase(serviceBranch) && !scoutsNewBranch.equalsIgnoreCase(serviceBranch)) continue;
            removeFilipinoVeteranProofInd = false;
            break;
        }
        if (removeFilipinoVeteranProofInd) {
            militaryServiceForm.setFilipinoVeteranProof(null);
        }
    }

    private void removeCevOefOifEpisodesForMSE(int serviceEpisodeIndex, MilitaryServiceInfoForm militaryServiceForm) {
        String sStartDate = militaryServiceForm.getServiceEpisodeEntryDate(serviceEpisodeIndex);
        String sEndDate = militaryServiceForm.getServiceEpisodeSeparationDate(serviceEpisodeIndex);
        Date mseStartDate = DateUtils.getDate((String)sStartDate);
        Date mseEnddate = DateUtils.getDate((String)sEndDate);
        ArrayList oefStartDateList = new ArrayList(militaryServiceForm.getOefOifCombatEpisodeStartDateList());
        ArrayList oefEnddateList = new ArrayList(militaryServiceForm.getOefOifCombatEpisodeEndDateList());
        ArrayList oefSourceList = new ArrayList(militaryServiceForm.getOefOifCombatSourceList());
        Iterator oefSourceIter = oefSourceList.iterator();
        Iterator oefStartdateIter = oefStartDateList.iterator();
        Iterator oefEnddateIter = oefEnddateList.iterator();
        String cevCode = OEFOIFSource.CODE_CENTRALIZED_ELIGIBILITY_VERIFICATION.getCode();
        int oefIndex = -1;
        while (oefStartdateIter.hasNext() && oefEnddateIter.hasNext() && oefSourceIter.hasNext()) {
            ++oefIndex;
            String sOefStartdate = (String)oefStartdateIter.next();
            String sOefEndDate = (String)oefEnddateIter.next();
            String oefSource = (String)oefSourceIter.next();
            if (!cevCode.equalsIgnoreCase(oefSource)) continue;
            Date oefStartdate = DateUtils.getDate((String)sOefStartdate);
            Date oefEndDate = DateUtils.getDate((String)sOefEndDate);
            if (oefStartdate.compareTo(mseStartDate) < 0 || oefEndDate.compareTo(mseEnddate) > 0) continue;
            militaryServiceForm.removeOefOifCombatEpisode(oefIndex);
            --oefIndex;
        }
    }

    private void removeHecConflictEpisodesForMSE(int serviceEpisodeIndex, MilitaryServiceInfoForm militaryServiceForm) {
        String sStartDate = militaryServiceForm.getServiceEpisodeEntryDate(serviceEpisodeIndex);
        String sEndDate = militaryServiceForm.getServiceEpisodeSeparationDate(serviceEpisodeIndex);
        Date mseStartDate = DateUtils.getDate((String)sStartDate);
        Date mseEnddate = DateUtils.getDate((String)sEndDate);
        ArrayList ceStartDateList = new ArrayList(militaryServiceForm.getConflictEpisodeStartDateList());
        ArrayList ceEnddateList = new ArrayList(militaryServiceForm.getConflictEpisodeEndDateList());
        Iterator ceStartdateIter = ceStartDateList.iterator();
        Iterator ceEnddateIter = ceEnddateList.iterator();
        int ceIndex = -1;
        while (ceStartdateIter.hasNext() && ceEnddateIter.hasNext()) {
            ++ceIndex;
            String sceStartdate = (String)ceStartdateIter.next();
            String sceEndDate = (String)ceEnddateIter.next();
            Date ceStartdate = DateUtils.getDate((String)sceStartdate);
            Date ceEndDate = DateUtils.getDate((String)sceEndDate);
            if (ceStartdate.compareTo(mseStartDate) < 0 || ceEndDate.compareTo(mseEnddate) > 0) continue;
            militaryServiceForm.removeConflictEpisode(ceIndex);
            --ceIndex;
        }
    }
}

