/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.message.action;

import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.common.model.lookup.MessageStatus;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.MessageLogEntryLite;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class MessageLogEntryBean
implements Serializable {
    private static final long serialVersionUID = 8112568008455978936L;
    private static Map messageTypeCapabilityMap = new HashMap();
    private MessageLogEntryLite messageLogEntryLite = null;

    MessageLogEntryBean(MessageLogEntryLite messageLogEntryLite) {
        Validate.notNull((Object)messageLogEntryLite, (String)"A MessageLogEntryLite must not be null");
        this.messageLogEntryLite = messageLogEntryLite;
    }

    public String getMessageLogEntryId() {
        return this.messageLogEntryLite.getEntityKey().getKeyValueAsString();
    }

    public Date getTransmissionDate() {
        return this.messageLogEntryLite.getTransmissionDate();
    }

    public MessageStatus getStatus() {
        return this.messageLogEntryLite.getStatus();
    }

    public MessageType getType() {
        return this.messageLogEntryLite.getType();
    }

    public String getMessageTypeString() {
        return this.messageLogEntryLite.getType() != null ? this.messageLogEntryLite.getType().getCode() + ":" + this.messageLogEntryLite.getType().getDescription() : "";
    }

    public VAFacility getFacility() {
        return this.messageLogEntryLite.getVaFacility();
    }

    public String getFacilityString() {
        return this.messageLogEntryLite.getVaFacility() != null ? this.messageLogEntryLite.getVaFacility().getDescription() + " (#" + this.messageLogEntryLite.getVaFacility().getStationNumber() + ")" : "";
    }

    public boolean isTransmittableMessageType() {
        String msgType;
        String string = msgType = this.messageLogEntryLite.getType() != null ? this.messageLogEntryLite.getType().getCode() : "";
        return MessageType.CODE_ORFZ11_TO_SITE.getName().equals(msgType) || MessageType.CODE_ORUZ11_TO_SITE.getName().equals(msgType) || MessageType.CODE_ORUZ05_TO_SITE.getName().equals(msgType) || MessageType.CODE_ORUZ04_TO_SITE.getName().equals(msgType) || MessageType.CODE_ORFZ10_TO_SITE.getName().equals(msgType) || MessageType.CODE_ORUZ10_TO_SITE.getName().equals(msgType) || MessageType.CODE_ORUZ06_TO_SITE.getName().equals(msgType);
    }

    public String getRetransmitPermissionCode() {
        return this.messageLogEntryLite.getType() == null ? "" : (String)messageTypeCapabilityMap.get(this.messageLogEntryLite.getType().getCode());
    }

    public boolean isError() {
        return this.messageLogEntryLite.getStatus() != null && this.messageLogEntryLite.getStatus().getCode().equals(MessageStatus.ERROR.getName());
    }

    static {
        messageTypeCapabilityMap.put(MessageType.CODE_ORFZ11_TO_SITE.getName(), Capability.RE_TRANSMIT_Z11.getName());
        messageTypeCapabilityMap.put(MessageType.CODE_ORUZ11_TO_SITE.getName(), Capability.RE_TRANSMIT_Z11.getName());
        messageTypeCapabilityMap.put(MessageType.CODE_ORUZ05_TO_SITE.getName(), Capability.RE_TRANSMIT_Z05.getName());
        messageTypeCapabilityMap.put(MessageType.CODE_ORUZ04_TO_SITE.getName(), Capability.RE_TRANSMIT_Z04.getName());
        messageTypeCapabilityMap.put(MessageType.CODE_ORFZ10_TO_SITE.getName(), Capability.RE_TRANSMIT_Z10.getName());
        messageTypeCapabilityMap.put(MessageType.CODE_ORUZ10_TO_SITE.getName(), Capability.RE_TRANSMIT_Z10.getName());
        messageTypeCapabilityMap.put(MessageType.CODE_ORUZ06_TO_SITE.getName(), Capability.RE_TRANSMIT_Z06.getName());
    }
}

