/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.message.action;

import gov.va.med.esr.common.model.messaging.ArchivedMessageLogEntry;
import gov.va.med.esr.common.model.messaging.MessageLogEntry;
import gov.va.med.esr.service.MessageFormatterService;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.esr.ui.message.action.MessageConstants;
import gov.va.med.esr.ui.message.action.MessageSearchForm;
import gov.va.med.fw.hl7.MessageParser;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import gov.va.med.fw.ui.valuelist.MaxRecordsExceededValueListException;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.SystemUtils;
import gov.va.med.fw.util.builder.BuilderException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.mlw.vlh.ValueList;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class MessageAction
extends AbstractAction
implements MessageConstants {
    public static final int MAX_CHARS_PER_LINE = 100;
    public static final int MIN_RAW_MESSAGE_ROWS = 22;
    private MessageFormatterService messageFormatterService;

    public MessageFormatterService getMessageFormatterService() {
        return this.messageFormatterService;
    }

    public void setMessageFormatterService(MessageFormatterService messageFormatterService) {
        this.messageFormatterService = messageFormatterService;
    }

    public ActionForward display(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("displaySearch");
    }

    public ActionForward clear(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((MessageSearchForm)actionForm).clear();
        return this.display(mapping, actionForm, request, response);
    }

    public ActionForward search(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            MessageSearchForm form = (MessageSearchForm)actionForm;
            ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)"messageSearchTableId", (String)"messageSearchAdapter");
            ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
            if (valueList == null || !valueList.hasNext()) {
                this.addInformationMessage(request, "errors.search.noresult");
            }
        }
        catch (MaxRecordsExceededValueListException ex) {
            this.addActionMessage(request, new ActionMessage("errors.max.records.exceeded", (Object)new Integer(ex.getTotalRecords()), (Object)new Integer(ex.getRecordLimit())));
        }
        return this.display(mapping, actionForm, request, response);
    }

    public ActionForward viewDetail(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("selectedMessage", (Object)this.getSelectedMessage(request));
        this.setSelectedSiteId(request);
        return mapping.findForward("displayMessageDetail");
    }

    public ActionForward retransmit(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String messageLogId = request.getParameter("selectedMsgId");
        if (StringUtils.isNotEmpty((String)messageLogId)) {
            this.getMessagingService().triggerRetransmission(new BigDecimal(messageLogId));
            this.addInformationMessage(request, "message.sent.successfully");
        }
        this.setSelectedSiteId(request);
        return this.search(mapping, actionForm, request, response);
    }

    public ActionForward viewRawMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        if (session.getAttribute("selectedMessage") != null && session.getAttribute("selectedMessage").getClass().equals(ArchivedMessageLogEntry.class)) {
            this.viewArchivedRawMessage(mapping, form, request, response);
        } else {
            this.viewMessageLogRawMessage(mapping, form, request, response);
        }
        return mapping.findForward("displayRawMessage");
    }

    public ActionForward viewMessageLogRawMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MessageLogEntry message = this.getSelectedMessage(request);
        String unformattedMessage = message.getBody();
        if (unformattedMessage.endsWith("\r")) {
            unformattedMessage = unformattedMessage.substring(0, unformattedMessage.length() - "\r".length());
        }
        String formattedMessage = MessageParser.getFormattedRawMessage((String)message.getBody(), (int)100);
        int unformattedMessageRows = StringUtils.numTimesStringPresent((String)unformattedMessage, (String)"\r") + 2;
        int formattedMessageRows = StringUtils.numTimesStringPresent((String)formattedMessage, (String)SystemUtils.LINE_SEPARATOR) + 2;
        if (unformattedMessageRows < 22) {
            unformattedMessageRows = 22;
        }
        if (formattedMessageRows < 22) {
            formattedMessageRows = 22;
        }
        this.setSelectedSiteId(request);
        request.setAttribute("formattedMessage", (Object)formattedMessage);
        request.setAttribute("unformattedMessage", (Object)unformattedMessage);
        request.setAttribute("formattedMessageRows", (Object)String.valueOf(formattedMessageRows));
        request.setAttribute("unformattedMessageRows", (Object)String.valueOf(unformattedMessageRows));
        return mapping.findForward("displayRawMessage");
    }

    public ActionForward viewParsedMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        try {
            if (session.getAttribute("selectedMessage") != null && session.getAttribute("selectedMessage").getClass().equals(ArchivedMessageLogEntry.class)) {
                this.viewArchivedParsedMessage(mapping, form, request, response);
            } else {
                this.viewMessageLogParsedMessage(mapping, form, request, response);
            }
        }
        catch (BuilderException be) {
            // empty catch block
        }
        return mapping.findForward("displayParsedMessage");
    }

    public ActionForward viewMessageLogParsedMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MessageLogEntry message = this.getSelectedMessage(request);
        String xmlMessage = null;
        try {
            xmlMessage = message != null ? this.messageFormatterService.getFormattedMessage(message) : null;
        }
        catch (BuilderException be) {
            String ac = be.getCause().getCause().toString();
            String ad = (String)be.getData();
            this.addInformationMessage(request, "errors.invalid", ac);
            xmlMessage = ad;
        }
        this.setSelectedSiteId(request);
        request.setAttribute("xmlFormattedMessage", (Object)xmlMessage);
        request.setAttribute("selectedMessage", (Object)message);
        return mapping.findForward("displayParsedMessage");
    }

    public ActionForward viewErrorMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setSelectedSiteId(request);
        request.setAttribute("selectedMessage", (Object)this.getSelectedMessage(request));
        return mapping.findForward("displayErrorMessage");
    }

    public ActionForward viewArchivedRawMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArchivedMessageLogEntry message = this.getSelectedArchivedMessage(request);
        String unformattedMessage = message.getBody();
        if (unformattedMessage.endsWith("\r")) {
            unformattedMessage = unformattedMessage.substring(0, unformattedMessage.length() - "\r".length());
        }
        String formattedMessage = MessageParser.getFormattedRawMessage((String)message.getBody(), (int)100);
        int unformattedMessageRows = StringUtils.numTimesStringPresent((String)unformattedMessage, (String)"\r") + 2;
        int formattedMessageRows = StringUtils.numTimesStringPresent((String)formattedMessage, (String)SystemUtils.LINE_SEPARATOR) + 2;
        if (unformattedMessageRows < 22) {
            unformattedMessageRows = 22;
        }
        if (formattedMessageRows < 22) {
            formattedMessageRows = 22;
        }
        this.setSelectedSiteId(request);
        request.setAttribute("formattedMessage", (Object)formattedMessage);
        request.setAttribute("unformattedMessage", (Object)unformattedMessage);
        request.setAttribute("formattedMessageRows", (Object)String.valueOf(formattedMessageRows));
        request.setAttribute("unformattedMessageRows", (Object)String.valueOf(unformattedMessageRows));
        return mapping.findForward("displayRawMessage");
    }

    public ActionForward viewArchivedParsedMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArchivedMessageLogEntry message = this.getSelectedArchivedMessage(request);
        String xmlMessage = null;
        try {
            xmlMessage = message != null ? this.messageFormatterService.getFormattedMessage(message) : null;
        }
        catch (BuilderException be) {
            // empty catch block
        }
        this.setSelectedSiteId(request);
        request.setAttribute("xmlFormattedMessage", (Object)xmlMessage);
        request.setAttribute("selectedMessage", (Object)message);
        return mapping.findForward("displayParsedMessage");
    }

    public ActionForward viewArchivedErrorMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setSelectedSiteId(request);
        request.setAttribute("selectedMessage", (Object)this.getSelectedArchivedMessage(request));
        return mapping.findForward("displayErrorMessage");
    }

    public ActionForward viewArchivedDetail(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("selectedMessage", (Object)this.getSelectedArchivedMessage(request));
        this.setSelectedSiteId(request);
        return mapping.findForward("displayMessageDetail");
    }

    public void afterPropertiesSet() throws Exception {
        Validate.notNull((Object)this.getMessagingService(), (String)"Missing required messaging service");
    }

    protected Map getKeyMethodMap() {
        if (this.keyMethodMap == null) {
            this.keyMethodMap = new HashMap();
            this.keyMethodMap.put("button.display", "display");
            this.keyMethodMap.put("button.search", "search");
            this.keyMethodMap.put("button.clear", "clear");
            this.keyMethodMap.put("buttom.retransmit", "retransmit");
            this.keyMethodMap.put("button.viewDetail", "viewDetail");
            this.keyMethodMap.put("link.viewParsedMessage", "viewParsedMessage");
            this.keyMethodMap.put("link.viewRawMessage", "viewRawMessage");
            this.keyMethodMap.put("link.viewErrorMessage", "viewErrorMessage");
            this.keyMethodMap.put("link.viewArchivedParsedMessage", "viewArchivedParsedMessage");
            this.keyMethodMap.put("link.viewArchivedRawMessage", "viewArchivedRawMessage");
            this.keyMethodMap.put("link.viewArchivedErrorMessage", "viewArchivedErrorMessage");
            this.keyMethodMap.put("button.viewArchivedDetail", "viewArchivedDetail");
        }
        return this.keyMethodMap;
    }

    private MessageLogEntry getSelectedMessage(HttpServletRequest request) throws Exception {
        HttpSession session;
        MessageLogEntry messageLogEntry = null;
        String msgId = request.getParameter("selectedMsgId");
        if (StringUtils.isNotEmpty((String)msgId) && ((messageLogEntry = (MessageLogEntry)(session = request.getSession()).getAttribute("selectedMessage")) == null || !StringUtils.equals((String)msgId, (String)messageLogEntry.getEntityKey().getKeyValueAsString()))) {
            messageLogEntry = this.getMessagingService().getMessageLogEntryById(new BigDecimal(msgId));
            session.setAttribute("selectedMessage", (Object)messageLogEntry);
        }
        return messageLogEntry;
    }

    private ArchivedMessageLogEntry getSelectedArchivedMessage(HttpServletRequest request) throws Exception {
        HttpSession session;
        ArchivedMessageLogEntry messageLogEntry = null;
        String msgId = request.getParameter("selectedMsgId");
        if (StringUtils.isNotEmpty((String)msgId) && ((messageLogEntry = (ArchivedMessageLogEntry)(session = request.getSession()).getAttribute("selectedMessage")) == null || !StringUtils.equals((String)msgId, (String)messageLogEntry.getEntityKey().getKeyValueAsString()))) {
            messageLogEntry = this.getArchivedMessagingService().getMessageLogEntryById(new BigDecimal(msgId));
            session.setAttribute("selectedMessage", (Object)messageLogEntry);
        }
        return messageLogEntry;
    }

    private void setSelectedSiteId(HttpServletRequest request) {
        String selectedMsgId = request.getParameter("selectedSiteId");
        if (StringUtils.isNotEmpty((String)selectedMsgId)) {
            request.setAttribute("selectedSiteId", (Object)selectedMsgId);
        }
    }
}

