/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.financials.action;

import gov.va.med.esr.common.model.financials.GMTThreshold;
import gov.va.med.esr.common.model.financials.IncomeThreshold;
import gov.va.med.esr.common.model.lookup.ZipCode;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.financials.action.ThresholdForm;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.ServiceOptimisticLockException;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.LabelValueBean;

public class ThresholdAction
extends AbstractAction {
    public static final String THRESHOLD_INCOME_YEAR_LIST_SESSION_KEY = "thresholdIncomeYearListSessionKey";
    public static final String ZIPCODE_LIST_SESSION_KEY = "ZipCodeList";
    public static final String OPTIMISTC_LOCK_WF_ERROR_KEY = "error.application.error.title.message";
    public static final String FORWARD_THRESHOLDS = "thresholds";
    public static final String FORWARD_COPAYMENTS = "copayments";
    public static final String FIELD_NAME_ZIP_CODE = "zipCode";
    public static final String FIELD_NAME_STATE = "state";
    public static final String FIELD_NAME_CITY = "city";
    public static final String FIELD_NAME_ADDITIONAL_DEPENDENT = "additionalDependent";
    public static final String MESSAGE_ZIP_REQUIRED = "message.zipRequired";
    public static final String MESSAGE_CITY_OR_STATE_REQUIRED = "message.cityOrStateRequired";
    public static final String MESSAGE_ZIP_OR_CITY_OR_STATE_REQUIRED = "message.zipOrCityOrStateRequired";
    public static final String MESSAGE_INVALID_ZIP_CODE = "message.invalidZipcode";
    public static final String MESSAGE_NUMBER_OF_DEPS_REQUIRED = "message.depNumberRequired";
    public static final String MESSAGE_ZIP_CODE_NOT_FOUND = "message.zipcodeNotFound";
    public static final String MESSAGE_ZIP_OR_CITY_REQUIRED = "message.zipcodeRequired";

    public void afterPropertiesSet() {
    }

    @Override
    protected void processOptimisticLockException(HttpServletRequest request, ServiceOptimisticLockException ex) throws Exception {
        log.error((Object)"ServiceOptimisticLockException from WorkflowAction", (Throwable)ex);
        this.addActionMessage(request, OPTIMISTC_LOCK_WF_ERROR_KEY);
    }

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object obj = request.getSession().getAttribute(THRESHOLD_INCOME_YEAR_LIST_SESSION_KEY);
        if (obj == null) {
            this.initializeValidIncomeYears(request);
        }
        request.getSession().setAttribute(ZIPCODE_LIST_SESSION_KEY, null);
        return mapping.findForward(FORWARD_THRESHOLDS);
    }

    public ActionForward displayThresholds(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThresholdForm thresholdForm = (ThresholdForm)form;
        String zip = thresholdForm.getZipCode();
        if (StringUtils.isEmpty((String)zip)) {
            if (StringUtils.isEmpty((String)thresholdForm.getCity())) {
                this.addActionMessageForField(request, MESSAGE_ZIP_OR_CITY_REQUIRED, FIELD_NAME_ZIP_CODE);
                this.addActionMessageForField(request, MESSAGE_ZIP_OR_CITY_REQUIRED, FIELD_NAME_CITY);
                return this.display(mapping, form, request, response);
            }
            return this.getZipCodes(mapping, form, request, response);
        }
        Integer incomeYear = null;
        incomeYear = StringUtils.isEmpty((String)thresholdForm.getIncomeYear()) ? new Integer(DateUtils.getCurrentYear() - 1) : new Integer(thresholdForm.getIncomeYear());
        thresholdForm.setIncomeYear(String.valueOf(incomeYear));
        ZipCode zipCode = this.getZipCode(request, zip);
        String fipsCode = null;
        try {
            fipsCode = this.getLookupService().getFipsCode(zipCode.getZipCode());
            this.logger.info((Object)("Found fipsCode=" + fipsCode));
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not retrive fipsCode value", (Throwable)e);
        }
        String msaCode = null;
        try {
            msaCode = this.getLookupService().getMsaCode(zipCode.getZipCode());
            if (msaCode != null && msaCode.equals("0")) {
                msaCode = "9999";
                this.logger.info((Object)("Found msaCode=" + msaCode));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not retrive msaCode value", (Throwable)e);
        }
        List gmtThresholds = null;
        gmtThresholds = StringUtils.isEmpty((String)msaCode) ? this.getLookupService().getGMTThreshold(incomeYear, fipsCode) : this.getLookupService().getGMTThreshold(incomeYear, fipsCode, msaCode);
        GMTThreshold gmtThreshold = null;
        if (gmtThresholds != null && gmtThresholds.size() > 0) {
            gmtThreshold = (GMTThreshold)gmtThresholds.get(0);
        }
        if (gmtThreshold == null) {
            gmtThreshold = new GMTThreshold();
            gmtThreshold.setYear(incomeYear);
        }
        IncomeThreshold incomeThreshold = this.getFinancialsService().getIncomeThreshold(incomeYear);
        this.populateForm(thresholdForm, gmtThreshold, incomeThreshold, zipCode);
        thresholdForm.setAdditionalDependent(null);
        return this.display(mapping, form, request, response);
    }

    public ActionForward calulateAdditionDepThresholds(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThresholdForm thresholdForm = (ThresholdForm)form;
        String zip = thresholdForm.getZipCode();
        if (StringUtils.isEmpty((String)zip)) {
            return this.displayThresholds(mapping, form, request, response);
        }
        Integer incomeYear = new Integer(thresholdForm.getIncomeYear());
        if (thresholdForm.getAdditionalDependent() == null || StringUtils.isEmpty((String)thresholdForm.getAdditionalDependent())) {
            this.addActionMessageForField(request, MESSAGE_NUMBER_OF_DEPS_REQUIRED, FIELD_NAME_ADDITIONAL_DEPENDENT);
            thresholdForm.setAdditionalDependent(null);
            return this.display(mapping, form, request, response);
        }
        int addDep = Integer.parseInt(thresholdForm.getAdditionalDependent());
        ZipCode zipCode = this.getZipCode(request, zip);
        GMTThreshold gmtThreshold = null;
        try {
            if (zipCode != null) {
                gmtThreshold = this.getFinancialsService().getGMTThreshold(incomeYear, zip, addDep);
            }
        }
        catch (ServiceException ex) {
            log.error((Object)"Could not retrive GMT Thresholds", (Throwable)ex);
        }
        if (gmtThreshold == null) {
            gmtThreshold = new GMTThreshold();
            gmtThreshold.setYear(incomeYear);
        }
        IncomeThreshold incomeThreshold = this.getFinancialsService().getIncomeThreshold(incomeYear, addDep);
        this.populateForm(thresholdForm, gmtThreshold, incomeThreshold, zipCode);
        if (gmtThreshold != null) {
            thresholdForm.setAddDepGMTThreshold(gmtThreshold.getThresholdValue(addDep + 7));
        }
        if (incomeThreshold != null) {
            BigDecimal addDepMTThreshold = incomeThreshold.getMeansTestThresholdValue(addDep + 7);
            thresholdForm.setAddDepMTThreshold(addDepMTThreshold != null ? addDepMTThreshold.setScale(2, 4) : null);
            BigDecimal pThresholdValue = incomeThreshold.getPensionThresholdValue(addDep + 7);
            thresholdForm.setAddDepPensionThreshold(pThresholdValue != null ? pThresholdValue.setScale(2, 4) : null);
            BigDecimal mdValue = incomeThreshold.getMedicalDeductiblesValue(addDep + 7);
            thresholdForm.setAddDepMedicalDeductible(mdValue != null ? mdValue.setScale(2, 4) : null);
        }
        return this.display(mapping, form, request, response);
    }

    public ActionForward displayCopayments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThresholdForm thresholdForm = (ThresholdForm)form;
        thresholdForm.clearLists();
        Integer incomeYear = null;
        incomeYear = StringUtils.isEmpty((String)thresholdForm.getIncomeYear()) ? new Integer(DateUtils.getCurrentYear() - 1) : new Integer(thresholdForm.getIncomeYear());
        thresholdForm.setIncomeYear(String.valueOf(incomeYear));
        IncomeThreshold income = this.getFinancialsService().getIncomeThreshold(incomeYear);
        thresholdForm.setIncomeThreshold(income);
        return mapping.findForward(FORWARD_COPAYMENTS);
    }

    public ActionForward clear(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThresholdForm thresholdForm = form instanceof ThresholdForm ? (ThresholdForm)form : null;
        Validate.notNull((Object)((Object)thresholdForm), (String)"ThresholdForm bean is null.");
        thresholdForm.setGmtThreshold(null);
        thresholdForm.setZipCode(null);
        thresholdForm.setCity(null);
        thresholdForm.setIncomeYear(null);
        thresholdForm.setState(null);
        return this.display(mapping, form, request, response);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThresholdForm thresholdForm = form instanceof ThresholdForm ? (ThresholdForm)form : null;
        Validate.notNull((Object)((Object)thresholdForm), (String)"ThresholdForm bean is null.");
        thresholdForm.setGmtThreshold(null);
        return this.display(mapping, form, request, response);
    }

    public ActionForward getZipCodes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThresholdForm thresholdForm = (ThresholdForm)form;
        if (StringUtils.isEmpty((String)thresholdForm.getCity())) {
            this.addActionMessageForField(request, MESSAGE_CITY_OR_STATE_REQUIRED, FIELD_NAME_CITY);
        } else {
            List ls = null;
            if (StringUtils.isNotEmpty((String)thresholdForm.getCity()) && StringUtils.isNotEmpty((String)thresholdForm.getState())) {
                ls = this.getLookupService().getPartialZipCodeByCityState(thresholdForm.getCity(), thresholdForm.getState());
            } else if (StringUtils.isNotEmpty((String)thresholdForm.getCity())) {
                ls = this.getLookupService().getPartialZipCodeByCity(thresholdForm.getCity());
            }
            if (ls == null || ls.isEmpty()) {
                this.addActionMessage(request, MESSAGE_ZIP_CODE_NOT_FOUND);
            } else {
                request.setAttribute(ZIPCODE_LIST_SESSION_KEY, (Object)ls);
            }
        }
        return mapping.findForward(FORWARD_THRESHOLDS);
    }

    protected void initializeValidIncomeYears(HttpServletRequest request) throws Exception {
        ArrayList<LabelValueBean> incomeYearBeans = new ArrayList<LabelValueBean>();
        List ls = this.getLookupService().getAllIncomeThresholds();
        Iterator iterator = ls.iterator();
        while (iterator.hasNext()) {
            Integer value = ((IncomeThreshold)iterator.next()).getYear();
            String year = String.valueOf(value);
            incomeYearBeans.add(new LabelValueBean(year, year));
        }
        request.getSession().setAttribute(THRESHOLD_INCOME_YEAR_LIST_SESSION_KEY, incomeYearBeans);
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title.thresholds", "display");
        map.put("button.search", "displayThresholds");
        map.put("button.cancel", "cancel");
        map.put("button.clear", "clear");
        map.put("button.calculateThresholds", "calulateAdditionDepThresholds");
        map.put("title.copayments", "displayCopayments");
        map.put("button.viewData", "displayCopayments");
        map.put("button.getZipCodes", "getZipCodes");
        return map;
    }

    private void populateForm(ThresholdForm thresholdForm, GMTThreshold gmtThreshold, IncomeThreshold incomeThreshold, ZipCode zip) throws Exception {
        if (zip != null) {
            thresholdForm.setCity(zip.getPreferredCity().getName());
            thresholdForm.setState(zip.getState().getCode());
            thresholdForm.setCounty(zip.getCounty().getName());
            thresholdForm.setFIPSCode(zip.getState().getFipsCode());
        } else {
            thresholdForm.setCity(null);
            thresholdForm.setState(null);
            thresholdForm.setCounty(null);
            thresholdForm.setFIPSCode(null);
        }
        thresholdForm.setGmtThreshold(gmtThreshold);
        thresholdForm.setIncomeThreshold(incomeThreshold);
        thresholdForm.clearLists();
        for (int j = 0; j <= 7; ++j) {
            BigDecimal thresholdValue = gmtThreshold.getThresholdValue(j);
            thresholdValue = thresholdValue != null ? thresholdValue.setScale(2, 4) : null;
            gmtThreshold.setThresholdValue(j, thresholdValue);
            thresholdForm.addGMTThresholdValue(thresholdValue);
            if (incomeThreshold == null) continue;
            BigDecimal mtThresholdValue = incomeThreshold.getMeansTestThresholdValue(j);
            thresholdForm.addMTThresholdValue(mtThresholdValue != null ? mtThresholdValue.setScale(2, 4) : null);
            BigDecimal pThresholdValue = incomeThreshold.getPensionThresholdValue(j);
            thresholdForm.addPensionThresholdValue(pThresholdValue != null ? pThresholdValue.setScale(2, 4) : null);
            BigDecimal mdThresholdValue = incomeThreshold.getMedicalDeductiblesValue(j);
            thresholdForm.addMedicalDeductibleValue(mdThresholdValue != null ? mdThresholdValue.setScale(2, 4) : null);
        }
    }

    private ZipCode getZipCode(HttpServletRequest request, String zipCode) {
        try {
            return this.getLookupService().getZipCodeByCode(zipCode);
        }
        catch (Exception ex) {
            this.addInformationMessage(request, MESSAGE_INVALID_ZIP_CODE);
            return null;
        }
    }
}

