/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.financials.action;

import gov.va.med.esr.common.model.financials.RelaxationPercentage;
import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.service.RelaxationPercentageService;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.esr.ui.financials.action.RelaxationPercentageAddForm;
import gov.va.med.esr.ui.financials.action.RelaxationPercentageUpdateForm;
import gov.va.med.fw.batchprocess.BatchProcessDetail;
import gov.va.med.fw.validation.ValidationServiceException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

public class RelaxationPercentageEditAction
extends AbstractAction {
    public static final String FORWARD_RELAXATION_PERCENTAGE_EDIT = "relaxationPercentage";
    public static final String FORWARD_RELAXATION_PERCENTAGE_EDIT_ERROR = "relaxationPercentageEditError";
    public static final String FORWARD_RELAXATION_PERCENTAGE_EDIT_CONFIRMATION = "relaxationPercentageEditConfirmation";
    private static final Map METHOD_NAME_OVERRIDES = new HashMap();
    private RelaxationPercentageService service;

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RelaxationPercentageUpdateForm rpForm = (RelaxationPercentageUpdateForm)form;
        int currentIncomeYear = this.getCurrentIncomeYear();
        RelaxationPercentage rp = this.service.getRelaxationPercentageByIncomeYear(currentIncomeYear);
        if (rp == null) {
            throw new Exception("No Relaxation Percentage data defined for the current year (" + currentIncomeYear + ")");
        }
        rpForm.setIncomeYear(rp.getIncomeYear());
        rpForm.setValue(rp.getValue().toString());
        rpForm.setRetroactiveProcess(true);
        this.populateReferenceData((ActionForm)rpForm);
        if (request.getParameter("updateSuccess") != null) {
            ActionMessages actionMessages = new ActionMessages();
            actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("message.relaxationPercentage.changesWereSaved"));
            this.saveMessages(request, actionMessages);
        }
        request.setAttribute("editCapability", (Object)Capability.EDIT_RELAXATION_PERCENTAGE.getCode());
        return mapping.findForward(FORWARD_RELAXATION_PERCENTAGE_EDIT);
    }

    public ActionForward displayAdd(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RelaxationPercentageAddForm rpForm = (RelaxationPercentageAddForm)form;
        int currentIncomeYear = this.getCurrentIncomeYear();
        RelaxationPercentage rp = this.service.getRelaxationPercentageByIncomeYear(currentIncomeYear);
        if (rp != null) {
            rpForm.setValue(rp.getValue().toString());
        }
        this.populateReferenceData((ActionForm)rpForm);
        return mapping.findForward(FORWARD_RELAXATION_PERCENTAGE_EDIT);
    }

    public ActionForward add(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RelaxationPercentageAddForm rpForm = (RelaxationPercentageAddForm)form;
        try {
            this.service.addRelaxationPercentage(new BigDecimal(rpForm.getValue()));
        }
        catch (ValidationServiceException valEx) {
            this.setValidationMessages(request, valEx.getValidationMessages());
            this.populateReferenceData((ActionForm)rpForm);
            return mapping.findForward(FORWARD_RELAXATION_PERCENTAGE_EDIT_ERROR);
        }
        return mapping.findForward(FORWARD_RELAXATION_PERCENTAGE_EDIT_CONFIRMATION);
    }

    private void populateReferenceData(ActionForm form) {
        if (form instanceof RelaxationPercentageUpdateForm) {
            RelaxationPercentageUpdateForm rpForm = (RelaxationPercentageUpdateForm)form;
            List allRelaxationPercentages = this.service.getAllRelaxationPercentages();
            rpForm.setAllRelaxationPercentages(allRelaxationPercentages);
        } else if (form instanceof RelaxationPercentageAddForm) {
            RelaxationPercentageAddForm relaxationPercentageAddForm = (RelaxationPercentageAddForm)form;
        }
    }

    public void failedValidationCallback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.populateReferenceData(form);
    }

    public ActionForward update(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RelaxationPercentageUpdateForm rpForm = (RelaxationPercentageUpdateForm)form;
        BatchProcessDetail batchProcessDetail = (BatchProcessDetail)this.getLookupCacheService().getByCodeFromCache(BatchProcessDetail.class.getName(), "scheduledJob.relaxationPercentageRetroactiveProcess");
        try {
            this.service.updateRelaxationPercentage(rpForm.getIncomeYear(), new BigDecimal(rpForm.getValue()), rpForm.isRetroactiveProcess(), batchProcessDetail);
        }
        catch (ValidationServiceException valEx) {
            this.setValidationMessages(request, valEx.getValidationMessages());
            this.populateReferenceData((ActionForm)rpForm);
            return mapping.findForward(FORWARD_RELAXATION_PERCENTAGE_EDIT_ERROR);
        }
        return mapping.findForward(FORWARD_RELAXATION_PERCENTAGE_EDIT_CONFIRMATION);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("cancel");
    }

    public ActionForward reset(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.display(mapping, form, request, response);
    }

    private int getCurrentIncomeYear() {
        return Calendar.getInstance().get(1) - 1;
    }

    protected String getMethodName(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String parameter) throws Exception {
        String keyName = request.getParameter(parameter);
        String key = (String)METHOD_NAME_OVERRIDES.get(keyName);
        return key != null ? key : keyName;
    }

    public void afterPropertiesSet() throws Exception {
        Validate.notNull((Object)this.service, (String)("The " + RelaxationPercentageService.class.getName() + " field must be set in " + ((Object)((Object)this)).getClass().getName()));
    }

    @Override
    protected ActionForward handleOptimisticLockException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        form.reset(mapping, request);
        return this.display(mapping, form, request, response);
    }

    public void setService(RelaxationPercentageService service) {
        this.service = service;
    }

    static {
        METHOD_NAME_OVERRIDES.put("ADD", "add");
        METHOD_NAME_OVERRIDES.put("UPDATE", "update");
        METHOD_NAME_OVERRIDES.put("RESET", "reset");
        METHOD_NAME_OVERRIDES.put("CANCEL", "cancel");
    }
}

