/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.financials.action;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.financials.action.FinancialsAction;
import gov.va.med.esr.ui.financials.action.FinancialsReviewImpactForm;
import gov.va.med.esr.ui.util.SessionManager;
import gov.va.med.fw.service.ServiceConfigurationException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class FinancialsReviewImpactAction
extends FinancialsAction {
    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialsReviewImpactForm reviewForm = this.getFinancialsReviewImpactForm(form);
        Person person = this.getSelectedPerson(request);
        reviewForm.setPerson(person);
        Person assesedPerson = (Person)SessionManager.getCalculatedPerson(request);
        reviewForm.setAssesedPerson(assesedPerson);
        Integer incomeYear = this.getSelectedIncomeYear(request);
        reviewForm.setIncomeYear(String.valueOf(incomeYear));
        if (this.conversionService != null) {
            this.conversionService.convert((Object)person, (Object)reviewForm);
        }
        return mapping.findForward("finacialReviewImpact");
    }

    @Override
    protected ActionForward handleOptimisticLockException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        form.reset(mapping, request);
        return this.display(mapping, form, request, response);
    }

    public ActionForward complete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer incomeYear = this.getSelectedIncomeYear(request);
        Person person = this.getUpdatedPerson(request);
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        if (isAddAPerson) {
            this.updateSelectedPerson(request, person);
        } else {
            Person updatedPerson = this.getFinancialsService().updateFinancialAssessment(incomeYear, person);
            if (updatedPerson != null) {
                this.setUpdatedPerson(request, null);
                SessionManager.setCalculatedPerson(request, null);
                this.updateSelectedPerson(request, updatedPerson);
            }
        }
        return mapping.findForward("financialSummary");
    }

    public ActionForward returnToFinancialDetail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("returnToFinancialDetailsEdit");
    }

    public ActionForward saveInProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("financialSummary");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("financialSummary");
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.completeAssessment", "complete");
        map.put("button.discardChanges", "cancel");
        map.put("button.returnToFinancialDetails", "returnToFinancialDetail");
        map.put("button.saveInProcess", "saveInProcess");
        map.put("button.display", "display");
        map.put("button.reviewImpact", "display");
        return map;
    }

    protected FinancialsReviewImpactForm getFinancialsReviewImpactForm(ActionForm form) throws ServiceConfigurationException {
        FinancialsReviewImpactForm personalForm;
        FinancialsReviewImpactForm financialsReviewImpactForm = personalForm = form instanceof FinancialsReviewImpactForm ? (FinancialsReviewImpactForm)form : null;
        if (personalForm == null) {
            throw new ServiceConfigurationException("FinancialsReviewImpactForm not properly configured.");
        }
        return personalForm;
    }
}

