/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.financials.action;

import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.esr.ui.financials.action.FinancialsReviewImpactForm;
import gov.va.med.fw.conversion.ConversionServiceException;
import java.util.Date;

public class FinancialsReviewConversionService
extends UIConversionServiceImpl {
    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        Person person = null;
        FinancialsReviewImpactForm form = null;
        if (source instanceof Person) {
            person = (Person)source;
            if (!(target instanceof FinancialsReviewImpactForm)) {
                throw new ConversionServiceException("Target object is of type " + target.getClass().getName() + " and must be of type FinancialsReviewImpactForm.");
            }
            form = (FinancialsReviewImpactForm)((Object)target);
            this.convertPersonToForm(person, form);
        }
    }

    protected void convertPersonToForm(Person person, FinancialsReviewImpactForm form) throws ConversionServiceException {
        try {
            IncomeTest testProposed;
            IncomeTest test = person.getIncomeTest(new Integer(form.getIncomeYear()));
            if (test != null) {
                form.setIncomeTest(test);
                if (test.getStatus() != null) {
                    form.setTestStatus(test.getStatus().getDescription());
                }
                if (test.getDeterminedStatus() != null) {
                    form.setTestDeterminedStatus(test.getDeterminedStatus().getDescription());
                }
                if (test.getTotalIncome() != null && test.getNetWorth() != null) {
                    form.setTotalIncomePlusNetworth(test.getTotalIncome().add(test.getNetWorth()));
                }
            }
            if (form.getAssesedPerson() != null && (testProposed = form.getAssesedPerson().getIncomeTest(new Integer(form.getIncomeYear()))) != null) {
                form.setIncomeTestProposed(testProposed);
                if (testProposed.getStatus() != null) {
                    form.setTestStatusProposed(testProposed.getStatus().getDescription());
                }
                if (testProposed.getDeterminedStatus() != null) {
                    form.setTestDeterminedStatusProposed(testProposed.getDeterminedStatus().getDescription());
                }
                if (testProposed.getTotalIncome() != null && testProposed.getNetWorth() != null) {
                    form.setTotalIncomePlusNetworthProposed(testProposed.getTotalIncome().add(testProposed.getNetWorth()));
                }
                Date today = new Date();
                form.setEditedDateProposed(today);
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Unable to convert Person to FinancialsReviewImpactForm.", ex);
        }
    }
}

