/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.financials.action;

import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.financials.action.FinancialsAction;
import gov.va.med.esr.ui.financials.action.FinancialsForm;
import gov.va.med.esr.ui.util.Financials1010EZApplication;
import gov.va.med.esr.ui.util.Financials1010EZRRenewal;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mlw.vlh.ValueList;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.LabelValueBean;

public class FinancialsOverviewAction
extends FinancialsAction {
    public static final String VALID_INCOME_YEAR_LIST_SESSION_KEY = "validIncomeYearListSessionKey";
    private String outputTempFilePath;

    public String getOutputTempFilePath() {
        return this.outputTempFilePath;
    }

    public void setOutputTempFilePath(String outputTempFilePath) {
        this.outputTempFilePath = outputTempFilePath;
    }

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialsForm finForm = this.getFinancialsForm(form);
        Person person = this.getSelectedPerson(request);
        Integer incomeYear = this.getSelectedIncomeYear(request);
        IncomeTest selectedIncomeTest = null;
        IncomeTest currentIncomeTest = null;
        Integer expectedIncomeYear = null;
        List validIncomeYears = this.initializeValidIncomeYears(request, person);
        selectedIncomeTest = this.getPersonHelperService().getCurrentIncomeTest(person);
        expectedIncomeYear = selectedIncomeTest != null ? selectedIncomeTest.getIncomeYear() : ((selectedIncomeTest = this.getPersonHelperService().getLatestIncomeTest(person)) != null ? selectedIncomeTest.getIncomeYear() : new Integer(DateUtils.getCurrentYear() - 1));
        if (incomeYear == null) {
            incomeYear = expectedIncomeYear;
            if (selectedIncomeTest != null) {
                currentIncomeTest = selectedIncomeTest;
            }
        } else {
            boolean isGivenIYValid = this.isGivenIYValid(validIncomeYears, incomeYear);
            if (!isGivenIYValid) {
                incomeYear = expectedIncomeYear;
            }
            selectedIncomeTest = person.getIncomeTest(incomeYear);
        }
        if (currentIncomeTest == null) {
            currentIncomeTest = this.getPersonHelperService().getCurrentIncomeTest(person);
        }
        if (currentIncomeTest != null && selectedIncomeTest != null && currentIncomeTest.getIncomeYear().equals(selectedIncomeTest.getIncomeYear())) {
            finForm.setIsCurrentIncomeTest(true);
        } else {
            finForm.setIsCurrentIncomeTest(false);
        }
        this.setSelectedIncomeYear(request, incomeYear);
        finForm.setIncomeYear(String.valueOf(incomeYear));
        finForm.setIncometest(selectedIncomeTest);
        if (selectedIncomeTest != null) {
            finForm.setBtFinancialInd(selectedIncomeTest.getBtFinancialInd());
        }
        finForm.setCanFinancialsBeAdded(this.getFinancialsService().canFinancialsBeUpdated(incomeYear, person));
        this.conversionService.convert((Object)person, (Object)finForm);
        ValueList valueList1 = ValueListActionUtils.getValueList((ActionForm)finForm, (HttpServletRequest)request, (String)"dependentTableId", (String)"financialDependentAdapter", (List)finForm.getDependentInfoList());
        ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList1, (String)"vlDepend");
        ValueList valueList2 = ValueListActionUtils.getValueList((ActionForm)finForm, (HttpServletRequest)request, (String)"incomeTableId", (String)"financialDependentAdapter", (List)finForm.getIncomes());
        ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList2, (String)"vlIncome");
        ValueList valueList3 = ValueListActionUtils.getValueList((ActionForm)finForm, (HttpServletRequest)request, (String)"expenseTableId", (String)"financialDependentAdapter", (List)finForm.getExpenses());
        ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList3, (String)"vlExpense");
        ValueList valueList4 = ValueListActionUtils.getValueList((ActionForm)finForm, (HttpServletRequest)request, (String)"assetTableId", (String)"financialDependentAdapter", (List)finForm.getAssets());
        ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList4, (String)"vlAsset");
        ValueList valueList5 = ValueListActionUtils.getValueList((ActionForm)finForm, (HttpServletRequest)request, (String)"debtTableId", (String)"financialDependentAdapter", (List)finForm.getDebts());
        ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList5, (String)"vlDebt");
        ArrayList benTravelLst = new ArrayList();
        if (finForm.getBeneficiaryTravels() != null) {
            Iterator it = finForm.getBeneficiaryTravels().iterator();
            while (it.hasNext()) {
                benTravelLst.add(it.next());
            }
        }
        ValueList valueList6 = ValueListActionUtils.getValueList((ActionForm)finForm, (HttpServletRequest)request, (String)"benTravelTableId", (String)"financialDependentAdapter", benTravelLst);
        ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList6, (String)"vlBenTravel");
        return mapping.findForward("financialsOverview");
    }

    public ActionForward viewData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialsForm finForm = this.getFinancialsForm(form);
        Integer incomeYear = new Integer(finForm.getIncomeYear());
        this.setSelectedIncomeYear(request, incomeYear);
        finForm.setFocusButton("viewData");
        return this.display(mapping, form, request, response);
    }

    public ActionForward print1010EZ(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person person = this.getSelectedPerson(request);
        FinancialsForm finForm = this.getFinancialsForm(form);
        Integer incomeYear = new Integer(finForm.getIncomeYear());
        this.setSelectedIncomeYear(request, incomeYear);
        InputStream isTemp = this.getClass().getResourceAsStream("/Fillable1010EZHealthcareApplication.pdf");
        if (isTemp == null) {
            log.info((Object)"The 1010EZ template form resource could not be found!");
        }
        String tempoutFilePath = this.getOutputTempFilePath();
        Financials1010EZApplication printform1010EZ = new Financials1010EZApplication(person, incomeYear, isTemp, tempoutFilePath);
        printform1010EZ.get1010EZ();
        printform1010EZ.display1010EZ(response);
        return null;
    }

    public ActionForward print1010EZR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person person = this.getSelectedPerson(request);
        FinancialsForm finForm = this.getFinancialsForm(form);
        Integer incomeYear = new Integer(finForm.getIncomeYear());
        this.setSelectedIncomeYear(request, incomeYear);
        InputStream isTemp = this.getClass().getResourceAsStream("/Fillable1010EZRHealthcareApplication.pdf");
        if (isTemp == null) {
            log.info((Object)"The 1010EZR form template resource could not be found!");
        }
        String tempoutFilePath = this.getOutputTempFilePath();
        Financials1010EZRRenewal printform1010EZR = new Financials1010EZRRenewal(person, incomeYear, isTemp, tempoutFilePath);
        printform1010EZR.get1010EZR();
        printform1010EZR.display1010EZR(response);
        return null;
    }

    protected List initializeValidIncomeYears(HttpServletRequest request, Person person) {
        ArrayList<LabelValueBean> incomeYearBeans = new ArrayList<LabelValueBean>();
        List incomeYears = this.determineValidIncomeYears(person);
        Iterator iterator = incomeYears.iterator();
        while (iterator.hasNext()) {
            String year = String.valueOf((Integer)iterator.next());
            incomeYearBeans.add(new LabelValueBean(year, year));
        }
        request.getSession().setAttribute(VALID_INCOME_YEAR_LIST_SESSION_KEY, incomeYearBeans);
        return incomeYears;
    }

    protected boolean isGivenIYValid(List incomeYears, Integer incomeYear) {
        boolean isGivenIYValid = false;
        if (incomeYear != null && incomeYears != null && incomeYears.size() > 0) {
            Iterator iterator = incomeYears.iterator();
            while (iterator.hasNext()) {
                int year = (Integer)iterator.next();
                if (year != incomeYear) continue;
                isGivenIYValid = true;
                break;
            }
        }
        return isGivenIYValid;
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title.financials", "display");
        map.put("button.viewData", "viewData");
        map.put("button.print1010EZ", "print1010EZ");
        map.put("button.print1010EZR", "print1010EZR");
        return map;
    }
}

