/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.financials.action;

import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.ui.financials.action.FinancialDetailsConversionService;
import gov.va.med.esr.ui.financials.action.FinancialsDependentAction;
import gov.va.med.esr.ui.financials.action.FinancialsDependentOverviewForm;
import gov.va.med.esr.ui.util.SessionManager;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.service.ServiceConfigurationException;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mlw.vlh.ValueList;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class FinancialsDependentOverviewAction
extends FinancialsDependentAction {
    public static final String FORWARD_FINANCIALS_DEPENDENT_OVERVIEW = "financialsDependentOverview";
    public static final String FORWARD_FINANCIALS_DEPENDENT_ADD_SPOUSE = "financialsDependentAddSpouse";
    public static final String FORWARD_FINANCIALS_DEPENDENT_ADD_CHILD = "financialsDependentAddChild";
    public static final String ERRORS_NO_PREVIOUS_DEPENDENT_INFO_MESSAGE_KEY = "errors.no.previous.dependent.information";
    public static final String ERRORS_NO_PREVIOUS_DEPENDENT_IN_YEAR_INFO_MESSAGE_KEY = "errors.no.previous.dependent.information.in.year";
    public static final String SUCCESS_COPY_DEPENDENT_INFO_MESSAGE_KEY = "success.copy.dependent.information";

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialsDependentOverviewForm dependentForm = this.getFinancialsDependentOverviewForm(form);
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        dependentForm.setAddAPerson(isAddAPerson);
        Person person = this.getSelectedPerson(request);
        Integer incomeYear = this.getSelectedIncomeYear(request);
        this.getDependentList(person, dependentForm, incomeYear);
        List ls = dependentForm.getDependentList();
        ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)"financialDependentTableId", (String)"financialDependentAdapter", (List)ls);
        ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
        return mapping.findForward(FORWARD_FINANCIALS_DEPENDENT_OVERVIEW);
    }

    public ActionForward gotoAddChild(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(FORWARD_FINANCIALS_DEPENDENT_ADD_CHILD);
    }

    public ActionForward gotoAddSpouse(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(FORWARD_FINANCIALS_DEPENDENT_ADD_SPOUSE);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("financialsOverview");
    }

    public ActionForward copyDependents(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person originalPerson = this.getSelectedPerson(request);
        Person person = (Person)originalPerson.clone();
        Integer currentIncomeYear = this.getSelectedIncomeYear(request);
        Integer prevIncomeYear = this.getPreviousIncomeYear(person, currentIncomeYear);
        FinancialStatement prevStatement = null;
        SpouseFinancials prevSpouseFinancials = null;
        Set prevDependentFinancialsSet = null;
        if (prevIncomeYear != null && (prevStatement = person.getFinancialStatement(prevIncomeYear)) != null) {
            prevSpouseFinancials = prevStatement.getActiveSpouseFinancials();
            prevDependentFinancialsSet = prevStatement.getDependentFinancials();
        }
        if (prevIncomeYear == null) {
            this.addActionMessage(request, ERRORS_NO_PREVIOUS_DEPENDENT_INFO_MESSAGE_KEY, String.valueOf(currentIncomeYear));
            return mapping.findForward(FORWARD_FINANCIALS_DEPENDENT_OVERVIEW);
        }
        if (prevSpouseFinancials == null && (prevDependentFinancialsSet == null || prevDependentFinancialsSet.isEmpty())) {
            this.addActionMessage(request, ERRORS_NO_PREVIOUS_DEPENDENT_IN_YEAR_INFO_MESSAGE_KEY, String.valueOf(prevIncomeYear));
            return mapping.findForward(FORWARD_FINANCIALS_DEPENDENT_OVERVIEW);
        }
        FinancialStatement currentStatement = person.getFinancialStatement(currentIncomeYear);
        if (currentStatement == null) {
            currentStatement = new FinancialStatement();
            currentStatement.setNumberOfDependentChildren(prevStatement.getNumberOfDependentChildren());
            currentStatement.setMarriedLastCalendarYear(prevStatement.getMarriedLastCalendarYear());
            currentStatement.setIsPost2005Format(Boolean.TRUE);
            currentStatement.setContributionToSpouse(prevStatement.getContributionToSpouse());
            person.setFinancialStatement(currentIncomeYear, currentStatement);
            currentStatement.setContributedToSpouseInd(prevStatement.getContributedToSpouseInd());
        }
        currentStatement.removeSpouseFinancials();
        currentStatement.removeAllDependentFinancials();
        if (prevSpouseFinancials != null) {
            SpouseFinancials currentSpouseFinancials = new SpouseFinancials();
            currentStatement.addSpouseFinancials(currentSpouseFinancials);
            Spouse prevSpouse = prevSpouseFinancials.getReportedOn();
            if (prevSpouse != null) {
                Spouse currentSpouse = new Spouse();
                this.getCopyService().copy((AbstractEntity)prevSpouse, (AbstractEntity)currentSpouse);
                this.getMergeRuleService().mergeSSN((Relation)prevSpouse, (Relation)currentSpouse);
                currentSpouseFinancials.setReportedOn(currentSpouse);
            }
        }
        for (DependentFinancials prevDependentFinancials : prevDependentFinancialsSet) {
            DependentFinancials currentDependentFinancials = new DependentFinancials();
            currentStatement.addDependentFinancials(currentDependentFinancials);
            Dependent prevDependent = prevDependentFinancials.getReportedOn();
            if (prevDependent == null) continue;
            Dependent currentDependent = new Dependent();
            this.getCopyService().copy((AbstractEntity)prevDependent, (AbstractEntity)currentDependent);
            this.getMergeRuleService().mergeSSN((Relation)prevDependent, (Relation)currentDependent);
            currentDependentFinancials.setReportedOn(currentDependent);
        }
        person = this.getFinancialsService().updateDependents(currentIncomeYear, person);
        this.addInformationMessage(request, SUCCESS_COPY_DEPENDENT_INFO_MESSAGE_KEY, String.valueOf(prevIncomeYear));
        this.updateSelectedPerson(request, person);
        return this.display(mapping, form, request, response);
    }

    protected FinancialsDependentOverviewForm getFinancialsDependentOverviewForm(ActionForm form) throws ServiceConfigurationException {
        FinancialsDependentOverviewForm personalForm;
        FinancialsDependentOverviewForm financialsDependentOverviewForm = personalForm = form instanceof FinancialsDependentOverviewForm ? (FinancialsDependentOverviewForm)form : null;
        if (personalForm == null) {
            throw new ServiceConfigurationException("FinancialsDependentOverviewForm not properly configured.");
        }
        return personalForm;
    }

    private void getDependentList(Person person, FinancialsDependentOverviewForm form, Integer incomeYear) throws Exception {
        FinancialStatement ftmt = person.getFinancialStatement(incomeYear);
        if (ftmt == null) {
            ftmt = new FinancialStatement();
        }
        Validate.isTrue((boolean)(this.getConversionService() instanceof FinancialDetailsConversionService), (String)"conversionService should be of type FinancialDetailsConversionService.");
        List list = ((FinancialDetailsConversionService)this.getConversionService()).getDependentInfoList(ftmt);
        form.setDependentList(list);
        SpouseFinancials sf = ftmt.getActiveSpouseFinancials();
        if (sf != null) {
            form.setSpouseAvaliableInd(true);
        }
    }

    private Integer getPreviousIncomeYear(Person person, Integer selectedIncomeYear) {
        Map financialStatementMap = person.getFinancialStatements();
        ArrayList yearList = new ArrayList(financialStatementMap.keySet());
        Collections.sort(yearList);
        Integer prevIncomeYear = null;
        for (int i = yearList.size() - 1; i >= 0 && prevIncomeYear == null; --i) {
            Integer incomeYear = (Integer)yearList.get(i);
            if (selectedIncomeYear.compareTo(incomeYear) < 0) continue;
            if (selectedIncomeYear.equals(incomeYear)) {
                int prevIncomeYearIndex = i - 1;
                if (prevIncomeYearIndex < 0) continue;
                prevIncomeYear = (Integer)yearList.get(prevIncomeYearIndex);
                continue;
            }
            prevIncomeYear = incomeYear;
        }
        return prevIncomeYear;
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.cancel", "cancel");
        map.put("button.addDepChild", "gotoAddChild");
        map.put("button.addDepSpouse", "gotoAddSpouse");
        map.put("button.copyDependents", "copyDependents");
        map.put("link.button.viewEditDeps", "display");
        return map;
    }
}

