/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.financials.action;

import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.action.AddressForm;
import gov.va.med.esr.ui.financials.action.FinancialsDependentAction;
import gov.va.med.esr.ui.financials.action.FinancialsDependentForm;
import gov.va.med.esr.ui.util.SessionManager;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class FinancialsDependentEditAction
extends FinancialsDependentAction {
    public static final String FORWARD_FINANCIALS_DEPENDENT_EDIT = "financialsDependentEdit";
    public static final String FORWARD_FINANCIALS_SPOUSE_EDIT = "financialsSpouseEdit";

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        FinancialsDependentForm dependentForm = (FinancialsDependentForm)form;
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        dependentForm.setAddAPerson(isAddAPerson);
        Integer incomeYear = this.getSelectedIncomeYear(request);
        dependentForm.setIncomeYear(String.valueOf(incomeYear));
        String dependentId = dependentForm.getDependentId();
        if (incomeYear != null && StringUtils.isNotEmpty((String)dependentId)) {
            Person person = this.getSelectedPerson(request);
            SpouseFinancials spouseFin = this.getSpouseFinancialsById(person, dependentId, incomeYear);
            if (spouseFin != null) {
                this.conversionService.convert((Object)spouseFin, (Object)dependentForm);
                forward = mapping.findForward(FORWARD_FINANCIALS_SPOUSE_EDIT);
            } else {
                DependentFinancials depFin = this.getDependentFinancialsById(person, dependentId, incomeYear);
                this.conversionService.convert((Object)depFin, (Object)dependentForm);
                forward = mapping.findForward(FORWARD_FINANCIALS_DEPENDENT_EDIT);
            }
        }
        return forward;
    }

    public ActionForward update(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialsDependentForm dependentForm = (FinancialsDependentForm)form;
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        dependentForm.setAddAPerson(isAddAPerson);
        Integer incomeYear = this.getSelectedIncomeYear(request);
        dependentForm.setIncomeYear(String.valueOf(incomeYear));
        Person person = this.getSelectedPerson(request);
        if (incomeYear != null && StringUtils.isNotEmpty((String)dependentForm.getDependentId())) {
            if (dependentForm.getSpouseInd()) {
                EntityKey activeSpouseKey;
                String spouseId = dependentForm.getDependentId();
                SpouseFinancials activeSpouse = this.getActiveSpouse(incomeYear, person);
                EntityKey entityKey = activeSpouseKey = activeSpouse != null ? activeSpouse.getEntityKey() : null;
                if (!dependentForm.isSpouseHasInactiveDate() && activeSpouseKey != null && !StringUtils.equals((String)spouseId, (String)activeSpouseKey.getKeyValueAsString())) {
                    this.addActionMessageForField(request, "message.spouseCannotBeActivated", "spouseInfo.inactiveDate");
                    return mapping.findForward(FORWARD_FINANCIALS_SPOUSE_EDIT);
                }
                Person clonePerson = (Person)person.clone();
                SpouseFinancials spouseFinancials = this.getSpouseFinancialsById(clonePerson, dependentForm.getDependentId(), incomeYear);
                this.conversionService.convert((Object)dependentForm, (Object)spouseFinancials);
                if (isAddAPerson) {
                    ActionForward overviewSuccessForward = new ActionForward(mapping.findForward(FORWARD_FINANCIALS_SPOUSE_EDIT));
                    ActionForward samePageForward = mapping.findForward(FORWARD_FINANCIALS_SPOUSE_EDIT);
                    if (Country.isUSAddress((String)dependentForm.getCountry())) {
                        if (!this.stateValid(dependentForm, AddressForm.class, "state", overviewSuccessForward, request)) {
                            return samePageForward;
                        }
                        if (!this.zipCodeMatchesCityAndState(dependentForm, AddressForm.class, "city", "state", "zipCode", request)) {
                            return samePageForward;
                        }
                    }
                    Person updatedPerson = spouseFinancials.getPerson();
                    this.updateSelectedPerson(request, updatedPerson);
                } else {
                    Person updatedPerson = this.getFinancialsService().updateSpouseFinancials(incomeYear, spouseFinancials, clonePerson);
                    this.updateSelectedPerson(request, updatedPerson);
                }
            } else {
                Person clonePerson = (Person)person.clone();
                DependentFinancials dependentFinancials = this.getDependentFinancialsById(clonePerson, dependentForm.getDependentId(), incomeYear);
                this.conversionService.convert((Object)dependentForm, (Object)dependentFinancials);
                if (isAddAPerson) {
                    Person updatedPerson = dependentFinancials.getPerson();
                    this.updateSelectedPerson(request, updatedPerson);
                } else {
                    Person updatedPerson = this.getFinancialsService().updateDependentFinancials(incomeYear, dependentFinancials, clonePerson);
                    this.updateSelectedPerson(request, updatedPerson);
                }
            }
        }
        return mapping.findForward("financialsDependentOverviewWithMsg");
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialsDependentForm dependentForm = this.getFinancialsDependentForm(form);
        Integer incomeYear = this.getSelectedIncomeYear(request);
        dependentForm.setIncomeYear(String.valueOf(incomeYear));
        String dependentId = dependentForm.getDependentId();
        if (StringUtils.isNotEmpty((String)dependentId)) {
            Person person = this.getSelectedPerson(request);
            Person clonePerson = (Person)person.clone();
            this.deleteRelationFinancialsById(clonePerson, dependentId, incomeYear);
            Person updatedPerson = this.getFinancialsService().updateDependents(incomeYear, clonePerson);
            this.updateSelectedPerson(request, updatedPerson);
        }
        return mapping.findForward("financialsDependentOverview");
    }

    protected void deleteRelationFinancialsById(Person person, String financialsId, Integer incomeYear) {
        FinancialStatement ftmt = person.getFinancialStatement(incomeYear);
        if (ftmt != null) {
            SpouseFinancials sf = this.getSpouseFinancialsById(person, financialsId, incomeYear);
            if (sf != null) {
                ftmt.removeSpouseFinancials(sf);
                return;
            }
            DependentFinancials df = this.getDependentFinancialsById(person, financialsId, incomeYear);
            if (df != null) {
                ftmt.removeDependentFinancials(df);
            }
        }
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("financialsDependentOverview");
    }

    @Override
    protected ActionForward handleOptimisticLockException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        form.reset(mapping, request);
        return this.display(mapping, form, request, response);
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.update", "update");
        map.put("button.cancel", "cancel");
        map.put("button.delete", "delete");
        map.put("button.display", "display");
        return map;
    }
}

