/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.financials.action;

import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.FinancialInformation;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.lookup.EmploymentStatus;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.PseudoSSNReason;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.lookup.SSNChangeSource;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.common.ui.conversion.CommonFinancialsDependentConversionService;
import gov.va.med.esr.common.ui.form.DependentFinancialInfoBean;
import gov.va.med.esr.common.ui.form.RelationFinancialInfoBean;
import gov.va.med.esr.common.ui.form.SpouseFinancialInfoBean;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.ui.common.action.AddressConversionService;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.financials.action.FinancialsDependentForm;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class FinancialsDependentConversionService
extends AddressConversionService {
    private CommonFinancialsDependentConversionService commonDependentConversionService;
    private static final Map relationGender = new HashMap();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        FinancialsDependentForm form = null;
        if (source instanceof FinancialInformation) {
            if (!(target instanceof FinancialsDependentForm)) throw new ConversionServiceException("Target object is of type " + target.getClass().getName() + " and must be of type FinancialsDependentForm.");
            form = (FinancialsDependentForm)((Object)target);
            if (source instanceof SpouseFinancials) {
                Address address;
                Employment employment;
                Spouse spouse;
                boolean isAddAPerson = form.isAddAPerson();
                SpouseFinancials finInfo = (SpouseFinancials)source;
                SpouseFinancialInfoBean sInfoBean = new SpouseFinancialInfoBean();
                sInfoBean.setAddAPerson(isAddAPerson);
                this.getCommonDependentConversionService().convertSpouseFinancialsToBean(finInfo, sInfoBean);
                form.setSpouseInfo(sInfoBean);
                form.setSpouseInd(true);
                System.out.println("FinancialsDependentConversionService source spouseFinancial target DependentForm isAddAPerson=" + isAddAPerson);
                if (!isAddAPerson || (spouse = finInfo.getReportedOn()) == null || (employment = spouse.getEmployment()) == null || (address = employment.getEmployerAddress()) == null) return;
                this.convertAddressToForm(address, form);
                return;
            } else {
                if (!(source instanceof DependentFinancials)) return;
                DependentFinancials finInfo = (DependentFinancials)source;
                DependentFinancialInfoBean dInfoBean = new DependentFinancialInfoBean();
                this.getCommonDependentConversionService().convertDependentFinancialsToBean(finInfo, dInfoBean);
                form.setDependentInfo(dInfoBean);
                form.setSpouseInd(false);
            }
            return;
        }
        if (!(source instanceof FinancialsDependentForm)) throw new ConversionServiceException("Source object is of type " + target.getClass().getName() + " and must be of type Person or FinancialsDependentForm.");
        try {
            form = (FinancialsDependentForm)((Object)source);
            if (target instanceof SpouseFinancials) {
                SpouseFinancials finInfo = (SpouseFinancials)target;
                boolean isAddAPerson = form.isAddAPerson();
                SpouseFinancialInfoBean sinfoBean = form.getSpouseInfo();
                if (sinfoBean == null) {
                    sinfoBean = new SpouseFinancialInfoBean();
                }
                sinfoBean.setAddAPerson(isAddAPerson);
                this.convertBeanToSpouseFinancials(sinfoBean, finInfo);
                System.out.println("FinancialsDependentConversionService source DependentForm target spouseFinancial isAddAPerson=" + isAddAPerson);
                if (!isAddAPerson) return;
                Spouse spouse = finInfo.getReportedOn();
                Employment employment = spouse.getEmployment();
                if (employment == null) {
                    employment = new Employment();
                    spouse.setEmployment(employment);
                }
                if (form.isAnyAddressFieldFilled()) {
                    Address address = employment.getEmployerAddress();
                    if (address == null) {
                        address = new Address();
                        employment.setEmployerAddress(address);
                    }
                    this.convertFormToAddress(form, address);
                    return;
                } else {
                    employment.setEmployerAddress(null);
                }
                return;
            } else {
                if (!(target instanceof DependentFinancials)) throw new ConversionServiceException("Target object is of type " + target.getClass().getName() + " and must be of type FinancialInformation.");
                DependentFinancials finInfo = (DependentFinancials)target;
                this.convertBeanToDependentFinancials(form.getDependentInfo(), finInfo);
            }
            return;
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Unable to convert FinancialsDependentForm to Person.", ex);
        }
    }

    public void convertBeanToSpouseFinancials(SpouseFinancialInfoBean bean, SpouseFinancials spFins) throws Exception {
        Spouse spouse;
        FinancialStatement statement = null;
        spFins.setLivedWithPatient(this.getBoolean(bean.getLivedWithVeteran()));
        statement = spFins.getFinancialStatement();
        if (statement != null) {
            statement.setContributedToSpouseInd(this.getBoolean(bean.getContributedToSpouseInd()));
        }
        if (StringUtils.isNotEmpty((String)bean.getContributedToSupport())) {
            if (statement != null) {
                statement.setContributionToSpouse(new BigDecimal(bean.getContributedToSupport()));
            }
        } else if (statement != null) {
            statement.setContributionToSpouse(null);
        }
        if ((spouse = spFins.getReportedOn()) == null) {
            spouse = new Spouse();
            spFins.setReportedOn(spouse);
        }
        this.convertBeanToRelation((RelationFinancialInfoBean)bean, (Relation)spouse);
    }

    public void convertBeanToDependentFinancials(DependentFinancialInfoBean bean, DependentFinancials depFins) throws Exception {
        depFins.setValidDependent(this.getBoolean(bean.getValidDependent()));
        depFins.setLivedWithPatient(this.getBoolean(bean.getLivedWithVeteran()));
        depFins.setIncapableOfSelfSupport(this.getBoolean(bean.getIncapableOfSelfSupport()));
        depFins.setHasIncome(this.getBoolean(bean.getHasIncome()));
        depFins.setContributedToSupport(this.getBoolean(bean.getContributedToSupport()));
        depFins.setAttendedSchool(this.getBoolean(bean.getAttendedSchool()));
        depFins.setIncomeAvailableToPatient(this.getBoolean(bean.getIncomeAvailableToPatient()));
        if (StringUtils.isNotEmpty((String)bean.getAmtContributed())) {
            depFins.setAmountContributedToSupport(new BigDecimal(bean.getAmtContributed()));
        } else {
            depFins.setAmountContributedToSupport(null);
        }
        Dependent dependent = depFins.getReportedOn();
        if (dependent == null) {
            dependent = new Dependent();
            depFins.setReportedOn(dependent);
        }
        this.convertBeanToRelation((RelationFinancialInfoBean)bean, (Relation)dependent);
    }

    private void convertBeanToRelation(RelationFinancialInfoBean bean, Relation relation) throws Exception {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        this.setNames(bean, relation, lookupCacheService);
        this.setDob(bean, relation);
        this.setSsnInfo(bean, relation, lookupCacheService);
        this.setPseudoSsnInfo(bean, relation, lookupCacheService);
        this.setEffectiveDate(bean, relation);
        this.setInActiveDate(bean, relation);
        String genderCode = bean.getGenderCode();
        String relationshipCode = bean.getRelationshipCode();
        if (relation instanceof Spouse) {
            Employment employment;
            relationshipCode = Relationship.CODE_SPOUSE.getName();
            SpouseFinancialInfoBean sBean = (SpouseFinancialInfoBean)bean;
            Spouse spouse = (Spouse)relation;
            spouse.setMaidenName(StringUtils.isBlank((String)sBean.getMaidenName()) ? null : sBean.getMaidenName());
            EmploymentStatus employmentStatus = (EmploymentStatus)lookupCacheService.getByCodeFromCache(EmploymentStatus.class, sBean.getEmploymentStatus());
            EmploymentStatus onFileEmploymentStatus = (EmploymentStatus)lookupCacheService.getByCodeFromCache(EmploymentStatus.class, sBean.getOnFileEmploymentStatus());
            if (employmentStatus == null && onFileEmploymentStatus != null) {
                employmentStatus = onFileEmploymentStatus;
            }
            if ((employment = spouse.getEmployment()) == null) {
                employment = new Employment();
                spouse.setEmployment(employment);
            }
            employment.setEmploymentStatus(employmentStatus);
            employment.setRetirementDate(DateUtils.getImpreciseDate((String)sBean.getRetirementDate()));
        } else if (relation instanceof Dependent) {
            genderCode = relationshipCode != null ? (String)relationGender.get(relationshipCode) : null;
        }
        this.setGender(relation, genderCode);
        this.setRelationship(relation, relationshipCode, lookupCacheService);
    }

    private void setNames(RelationFinancialInfoBean bean, Relation relation, LookupCacheService lookupCacheService) throws UnknownLookupTypeException, ClassNotFoundException {
        if (bean.isAnyNameFieldFilled()) {
            Name name = relation.getName();
            if (name == null) {
                name = new Name();
                name.setType((NameType)lookupCacheService.getByCodeFromCache(NameType.class, NameType.LEGAL_NAME.getName()));
                relation.setName(name);
            }
            name.setPrefix(StringUtils.isBlank((String)bean.getPrefix()) ? null : bean.getPrefix());
            name.setFamilyName(StringUtils.isBlank((String)bean.getLastName()) ? null : bean.getLastName());
            name.setGivenName(StringUtils.isBlank((String)bean.getFirstName()) ? null : bean.getFirstName());
            name.setMiddleName(StringUtils.isBlank((String)bean.getMiddleName()) ? null : bean.getMiddleName());
            name.setSuffix(StringUtils.isBlank((String)bean.getSuffix()) ? null : bean.getSuffix());
        } else {
            relation.setName(null);
        }
    }

    private void setDob(RelationFinancialInfoBean bean, Relation relation) {
        if (StringUtils.isNotEmpty((String)bean.getDateOfBirth())) {
            relation.setDob(DateUtils.getImpreciseDate((String)bean.getDateOfBirth()));
        } else {
            relation.setDob(null);
        }
    }

    private void setSsnInfo(RelationFinancialInfoBean bean, Relation relation, LookupCacheService lookupCacheService) throws UnknownLookupTypeException, ClassNotFoundException {
        String beanSsn = bean.getSsn();
        if (StringUtils.isNotEmpty((String)beanSsn)) {
            SSN ssn = relation.getOfficialSsn();
            if (ssn == null) {
                ssn = new SSN();
                ssn.setType((SSNType)lookupCacheService.getByCodeFromCache(SSNType.class, SSNType.CODE_ACTIVE.getName()));
                relation.addSsn(ssn);
            }
            ssn.setSsnText(beanSsn.replaceAll("-", ""));
            ssn.setSourceOfChange((SSNChangeSource)lookupCacheService.getByCodeFromCache(SSNChangeSource.class, bean.getSsnSourceOfChange()));
            ssn.setSsaVerificationStatus((SSAVerificationStatus)lookupCacheService.getByCodeFromCache(SSAVerificationStatus.class, bean.getSsaVerificationStatus()));
        } else {
            SSN ssn = relation.getOfficialSsn();
            if (ssn != null) {
                relation.removeSsn(ssn);
            }
        }
    }

    private void setGender(Relation relation, String genderCode) throws UnknownLookupTypeException, ClassNotFoundException {
        if (StringUtils.isNotEmpty((String)genderCode)) {
            relation.setGender((Gender)this.getLookupCacheService().getByCodeFromCache(Gender.class, genderCode));
        } else {
            relation.setGender(null);
        }
    }

    private void setInActiveDate(RelationFinancialInfoBean bean, Relation relation) {
        relation.setEndDate(DateUtils.getDate((String)bean.getInactiveDate()));
    }

    private void setEffectiveDate(RelationFinancialInfoBean bean, Relation relation) {
        if (StringUtils.isNotEmpty((String)bean.getEffectiveDate())) {
            relation.setStartDate(DateUtils.getImpreciseDate((String)bean.getEffectiveDate()));
        } else {
            relation.setStartDate(null);
        }
    }

    private void setRelationship(Relation relation, String relationshipCode, LookupCacheService lookupCacheService) throws UnknownLookupTypeException, ClassNotFoundException {
        if (StringUtils.isNotEmpty((String)relationshipCode)) {
            relation.setRelationship((Relationship)lookupCacheService.getByCodeFromCache(Relationship.class, relationshipCode));
        } else {
            relation.setRelationship(null);
        }
    }

    private void setPseudoSsnInfo(RelationFinancialInfoBean bean, Relation relation, LookupCacheService lookupCacheService) throws UnknownLookupTypeException, ClassNotFoundException {
        if (StringUtils.isNotEmpty((String)bean.getPseudoSsnReason())) {
            SSN pssn = relation.getPseudoSsn();
            if (pssn == null) {
                pssn = new SSN();
                pssn.setType((SSNType)lookupCacheService.getByCodeFromCache(SSNType.class, SSNType.CODE_PSEUDO.getName()));
                relation.addSsn(pssn);
            }
            if (StringUtils.isNotEmpty((String)bean.getPseudoSsn())) {
                pssn.setSsnText(bean.getPseudoSsn().replaceAll("-", ""));
            }
            pssn.setPseudoSSNReason((PseudoSSNReason)lookupCacheService.getByCodeFromCache(PseudoSSNReason.class, bean.getPseudoSsnReason()));
        } else {
            SSN pssn = relation.getPseudoSsn();
            if (pssn != null) {
                relation.removeSsn(pssn);
            }
        }
    }

    public CommonFinancialsDependentConversionService getCommonDependentConversionService() {
        return this.commonDependentConversionService;
    }

    public void setCommonDependentConversionService(CommonFinancialsDependentConversionService commonDependentConversionService) {
        this.commonDependentConversionService = commonDependentConversionService;
    }

    static {
        relationGender.put(Relationship.CODE_SON.getCode(), Gender.MALE.getName());
        relationGender.put(Relationship.CODE_STEPSON.getCode(), Gender.MALE.getName());
        relationGender.put(Relationship.CODE_DAUGHTER.getCode(), Gender.FEMALE.getName());
        relationGender.put(Relationship.CODE_STEPDAUGHTER.getCode(), Gender.FEMALE.getName());
    }
}

