/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.financials.action;

import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.action.AddressForm;
import gov.va.med.esr.ui.financials.action.FinancialsDependentAction;
import gov.va.med.esr.ui.financials.action.FinancialsDependentForm;
import gov.va.med.esr.ui.util.SessionManager;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class FinancialsDependentAddAction
extends FinancialsDependentAction {
    public static final String FORWARD_FINANCIALS_DEPENDENT_ADD = "financialsDependentAdd";
    public static final String FORWARD_FINANCIALS_SPOUSE_ADD = "financialsSpouseAdd";

    public ActionForward displayAddChildPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        FinancialsDependentForm dependentForm = this.getFinancialsDependentForm(form);
        dependentForm.setAddAPerson(isAddAPerson);
        dependentForm.setSpouseInd(false);
        return mapping.findForward(FORWARD_FINANCIALS_DEPENDENT_ADD);
    }

    public ActionForward displayAddSpousePage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        FinancialsDependentForm dependentForm = this.getFinancialsDependentForm(form);
        dependentForm.setAddAPerson(isAddAPerson);
        dependentForm.setSpouseInd(true);
        return mapping.findForward(FORWARD_FINANCIALS_SPOUSE_ADD);
    }

    @Override
    protected ActionForward handleOptimisticLockException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialsDependentForm dependentForm = this.getFinancialsDependentForm(form);
        boolean spouseInd = dependentForm.getSpouseInd();
        form.reset(mapping, request);
        if (spouseInd) {
            return this.displayAddSpousePage(mapping, form, request, response);
        }
        return this.displayAddChildPage(mapping, form, request, response);
    }

    public ActionForward add(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialsDependentForm dependentForm = this.getFinancialsDependentForm(form);
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        dependentForm.setAddAPerson(isAddAPerson);
        Person person = this.getSelectedPerson(request);
        Integer incomeYear = this.getSelectedIncomeYear(request);
        Person clonePerson = (Person)person.clone();
        FinancialStatement fstmt = clonePerson.getFinancialStatement(incomeYear);
        if (fstmt == null) {
            fstmt = new FinancialStatement();
            fstmt.setIsPost2005Format(Boolean.TRUE);
            clonePerson.setFinancialStatement(incomeYear, fstmt);
        }
        if (dependentForm.getSpouseInd()) {
            if (!dependentForm.isSpouseHasInactiveDate() && this.isPersonHasActiveSpouse(incomeYear, person)) {
                this.addActionMessageForField(request, "message.spouseCannotBeAdded", "spouseInfo.inactiveDate");
                return mapping.findForward(FORWARD_FINANCIALS_SPOUSE_ADD);
            }
            if (isAddAPerson) {
                ActionForward overviewSuccessForward = new ActionForward(mapping.findForward(FORWARD_FINANCIALS_SPOUSE_ADD));
                ActionForward samePageForward = mapping.findForward(FORWARD_FINANCIALS_SPOUSE_ADD);
                if (Country.isUSAddress((String)dependentForm.getCountry())) {
                    if (!this.stateValid(dependentForm, AddressForm.class, "state", overviewSuccessForward, request)) {
                        return samePageForward;
                    }
                    if (!this.zipCodeMatchesCityAndState(dependentForm, AddressForm.class, "city", "state", "zipCode", request)) {
                        return samePageForward;
                    }
                }
                SpouseFinancials spouseFinancials = new SpouseFinancials();
                fstmt.addSpouseFinancials(spouseFinancials);
                this.conversionService.convert((Object)dependentForm, (Object)spouseFinancials);
                Person updatedPerson = spouseFinancials.getPerson();
                this.updateSelectedPerson(request, updatedPerson);
            } else {
                SpouseFinancials spouseFinancials = new SpouseFinancials();
                fstmt.addSpouseFinancials(spouseFinancials);
                this.conversionService.convert((Object)dependentForm, (Object)spouseFinancials);
                Person updatedPerson = this.getFinancialsService().updateSpouseFinancials(incomeYear, spouseFinancials, clonePerson);
                this.updateSelectedPerson(request, updatedPerson);
            }
        } else {
            DependentFinancials dependentFinancials = new DependentFinancials();
            fstmt.addDependentFinancials(dependentFinancials);
            this.conversionService.convert((Object)dependentForm, (Object)dependentFinancials);
            if (isAddAPerson) {
                Person updatedPerson = dependentFinancials.getPerson();
                this.updateSelectedPerson(request, updatedPerson);
            } else {
                Person updatedPerson = this.getFinancialsService().updateDependentFinancials(incomeYear, dependentFinancials, clonePerson);
                this.updateSelectedPerson(request, updatedPerson);
            }
        }
        return mapping.findForward("financialsDependentOverviewWithMsg");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("financialsDependentOverview");
    }

    protected Map getKeyMethodMap() {
        if (this.keyMethodMap == null) {
            this.keyMethodMap = new HashMap();
            this.keyMethodMap.put("button.add", "add");
            this.keyMethodMap.put("button.cancel", "cancel");
            this.keyMethodMap.put("button.addDepChild", "displayAddChildPage");
            this.keyMethodMap.put("button.addDepSpouse", "displayAddSpousePage");
        }
        return this.keyMethodMap;
    }
}

