/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.financials.action;

import gov.va.med.esr.common.model.financials.Asset;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.Expense;
import gov.va.med.esr.common.model.financials.FinancialInformation;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.Income;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.esr.ui.financials.action.FinancialDetailsConversionService;
import gov.va.med.esr.ui.financials.action.FinancialsForm;
import gov.va.med.esr.ui.financials.beans.FinancialInfoBean;
import gov.va.med.esr.ui.util.NameHelper;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class FinancialsConversionService
extends FinancialDetailsConversionService {
    @Override
    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        Person person = null;
        FinancialsForm form = null;
        if (source instanceof Person) {
            person = (Person)source;
            if (!(target instanceof FinancialsForm)) {
                throw new ConversionServiceException("Target object is of type " + target.getClass().getName() + " and must be of type FinancialsForm.");
            }
            form = (FinancialsForm)((Object)target);
            this.convertPersonToForm(person, form);
        } else if (source instanceof FinancialsForm) {
            form = (FinancialsForm)((Object)source);
            if (!(target instanceof Person)) {
                throw new ConversionServiceException("Target object is of type " + target.getClass().getName() + " and must be of type Person.");
            }
            person = (Person)target;
            this.convertFormToPerson(form, person);
        } else {
            throw new ConversionServiceException("Source object is of type " + target.getClass().getName() + " and must be of type Person or FinancialsForm.");
        }
    }

    protected void convertPersonToForm(Person person, FinancialsForm form) throws ConversionServiceException {
        try {
            if (StringUtils.isEmpty((String)form.getIncomeYear())) {
                return;
            }
            Integer incomeyear = Integer.valueOf(form.getIncomeYear());
            if (form.getIncometest() != null) {
                MeansTestStatus mt;
                IncomeTestStatus st;
                HashSet otherNames = new HashSet(person.getNames());
                Name veteranName = Name.getNameOfType(otherNames, (String)NameType.LEGAL_NAME.getName());
                FinancialStatement fstmt = person.getFinancialStatement(incomeyear);
                form.setFinancialStatement(fstmt);
                if (fstmt != null) {
                    for (Expense e : fstmt.getExpenses().values()) {
                        if (e.getAmount() == null || !StringUtils.equals((String)e.getType().getCode(), (String)ExpenseType.EXPENSE_TYPE_ADJUSTED_MEDICAL.getName())) continue;
                        form.setAjustedMedicalExp(e.getAmount());
                    }
                }
                DependentFinancials df = this.getDependentFinancials(fstmt);
                form.setDependentFinancials(df);
                SpouseFinancials sf = this.getSpouseFinancials(fstmt);
                form.setSpouseFinancials(sf);
                BigDecimal spouseIncome = new BigDecimal(0);
                BigDecimal vetIncome = new BigDecimal(0);
                BigDecimal depIncome = new BigDecimal(0);
                BigDecimal spouseExpense = new BigDecimal(0);
                BigDecimal vetExpense = new BigDecimal(0);
                BigDecimal depExpense = new BigDecimal(0);
                BigDecimal spouseAsset = new BigDecimal(0);
                BigDecimal vetAsset = new BigDecimal(0);
                if (fstmt != null) {
                    Vector assets = new Vector();
                    Vector expenses = new Vector();
                    Vector incomes = new Vector();
                    Vector debts = new Vector();
                    vetAsset = this.getAssetInfo((FinancialInformation)fstmt, assets, this.getDisplayName(veteranName, "Veteran"));
                    vetIncome = this.getIncomeInfo((FinancialInformation)fstmt, incomes, this.getDisplayName(veteranName, "Veteran"));
                    vetExpense = this.getExpenseInfo((FinancialInformation)fstmt, expenses, this.getDisplayName(veteranName, "Veteran"));
                    this.getDebtInfo((FinancialInformation)fstmt, debts, this.getDisplayName(veteranName, "Veteran"));
                    if (sf != null) {
                        String spouseDisplayName;
                        Spouse s = sf.getReportedOn();
                        if (s != null) {
                            Name sn = s.getName();
                            spouseDisplayName = this.getDisplayName(sn, "Spouse");
                        } else {
                            spouseDisplayName = "Spouse";
                        }
                        spouseIncome = this.getIncomeInfo((FinancialInformation)sf, incomes, spouseDisplayName);
                        spouseAsset = this.getAssetInfo((FinancialInformation)sf, assets, spouseDisplayName);
                        spouseExpense = this.getExpenseInfo((FinancialInformation)sf, expenses, spouseDisplayName);
                        this.getDebtInfo((FinancialInformation)sf, debts, spouseDisplayName);
                    }
                    for (DependentFinancials dfin : fstmt.getDependentFinancials()) {
                        String displayName;
                        Dependent d = dfin.getReportedOn();
                        if (d != null && d.getRelationship() != null) {
                            Name dn = d.getName();
                            displayName = this.getDisplayName(dn, d.getRelationship().getDescription());
                        } else {
                            displayName = "Dependent";
                        }
                        this.getAssetInfo((FinancialInformation)dfin, assets, displayName);
                        this.getIncomeInfo((FinancialInformation)dfin, incomes, displayName);
                        this.getExpenseInfo((FinancialInformation)dfin, expenses, displayName);
                        this.getDebtInfo((FinancialInformation)dfin, debts, displayName);
                    }
                    form.setAssets(assets);
                    form.setExpenses(expenses);
                    form.setIncomes(incomes);
                    form.setDebts(debts);
                }
                form.setCalculatedTotalIncome(this.calculateTotalIncome(form, spouseIncome, vetIncome, depIncome, spouseExpense, vetExpense, depExpense));
                form.setCalculatedNetWorth(this.calculateNetWorth(form, spouseAsset, vetAsset));
                this.getPatientVisitTotals(person, incomeyear, form);
                this.setStatuses(form, form.getIncometest());
                if (form.getIncometest().getIncomeTestStatus() != null && (st = form.getIncometest().getIncomeTestStatus()) != null && st.getCompletedDate() != null) {
                    form.setTestCompletedDate(JspUtils.displayValue((Object)st.getCompletedDate(), (String)"MM/dd/yyyy"));
                }
                if (form.getIncometest().getDeterminedStatus() != null && (mt = form.getIncometest().getDeterminedStatus()) != null) {
                    form.setTestDeterminedStatus(mt.getDescription());
                }
                if (form.getIncometest().getStatus() != null && (mt = form.getIncometest().getStatus()) != null) {
                    form.setTestStatus(mt.getDescription());
                }
                if (fstmt != null) {
                    List list = this.getDependentInfoList(fstmt);
                    form.setDependentInfoList(list);
                }
            }
            Set beneficiarytravel = person.getBeneficiaryTravels(incomeyear);
            form.setBeneficiaryTravels(beneficiarytravel);
            if (beneficiarytravel != null) {
                form.setBeneficiaryTravelsSize(beneficiarytravel.size());
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Unable to convert Person to FinancialsForm.", ex);
        }
    }

    protected void convertFormToPerson(FinancialsForm form, Person person) throws ConversionServiceException {
    }

    public void setStatuses(FinancialsForm form, IncomeTest incometest) {
        Set statuses = incometest.getStatuses();
        if (statuses != null) {
            for (IncomeTestStatus status : statuses) {
                String statusDesc = null;
                if (status != null && status.getStatus() != null) {
                    statusDesc = status.getStatus().getDescription();
                }
                if (this.isOfType(status, IncomeTestType.CODE_MEANS_TEST.getName())) {
                    form.setMeansTest(status);
                    continue;
                }
                if (this.isOfType(status, IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getName())) {
                    form.setRxCopayStatus(statusDesc);
                    continue;
                }
                if (this.isOfType(status, IncomeTestType.CODE_LTC_CO_PAY_TEST.getName())) {
                    form.setLtcCopayStatus(statusDesc);
                    continue;
                }
                if (!this.isOfType(status, IncomeTestType.CODE_LTC_CO_PAY_EXEMPTION_TEST.getName())) continue;
                form.setLtcCopayStatus(statusDesc);
            }
        }
    }

    private boolean isOfType(IncomeTestStatus itStatus, String typeCode) {
        return itStatus != null && itStatus.getType() != null && itStatus.getType().getCode().equalsIgnoreCase(typeCode);
    }

    public BigDecimal calculateTotalIncome(FinancialsForm form, BigDecimal spouseIncome, BigDecimal vetIncome, BigDecimal depIncome, BigDecimal spouseExpense, BigDecimal vetExpense, BigDecimal depExpense) {
        BigDecimal totalIncome = new BigDecimal(0);
        if (vetIncome != null) {
            totalIncome = vetIncome.subtract(vetExpense);
        }
        if (this.includeSpouseIncome(form)) {
            totalIncome = totalIncome.add(spouseIncome).subtract(spouseExpense);
        }
        if (this.includeDependentIncome(form)) {
            totalIncome = totalIncome.add(depIncome).subtract(depExpense);
        }
        return totalIncome;
    }

    public BigDecimal calculateNetWorth(FinancialsForm form, BigDecimal spouseAsset, BigDecimal vetAsset) {
        BigDecimal networth = new BigDecimal(0);
        BigDecimal vetDebt = new BigDecimal(0);
        BigDecimal spouseDebt = new BigDecimal(0);
        if (form.getFinancialStatement() != null && form.getFinancialStatement().getDebt() != null) {
            vetDebt = form.getFinancialStatement().getDebt().getAmount();
        }
        if (form.getSpouseFinancials() != null && form.getSpouseFinancials().getDebt() != null) {
            spouseDebt = form.getSpouseFinancials().getDebt().getAmount();
        }
        if (vetAsset != null) {
            networth = vetAsset.subtract(vetDebt);
        }
        if (this.includeSpouseIncome(form)) {
            networth = networth.add(spouseAsset).subtract(spouseDebt);
        }
        return networth;
    }

    public boolean includeSpouseIncome(FinancialsForm form) {
        if (form.getFinancialStatement() == null || form.getSpouseFinancials() == null) {
            return false;
        }
        Boolean married = form.getFinancialStatement().getMarriedLastCalendarYear();
        Boolean livedWithPatient = form.getSpouseFinancials().getLivedWithPatient();
        return married != null && livedWithPatient != null && married != false && livedWithPatient != false;
    }

    public boolean includeDependentIncome(FinancialsForm form) {
        return false;
    }

    private BigDecimal getAssetInfo(FinancialInformation fstmt, Vector assets, String source) {
        BigDecimal total = new BigDecimal(0);
        if (fstmt == null || fstmt.getAssets() == null || fstmt.getAssets().values() == null) {
            return total;
        }
        for (Asset e : fstmt.getAssets().values()) {
            if (e.getAmount() == null) continue;
            FinancialInfoBean bean = new FinancialInfoBean(e.getType().getDescription(), e.getAmount(), source);
            assets.add(bean);
            total = total.add(e.getAmount());
        }
        return total;
    }

    private BigDecimal getIncomeInfo(FinancialInformation fstmt, Vector income, String source) {
        BigDecimal total = new BigDecimal(0);
        if (fstmt == null || fstmt.getIncome() == null || fstmt.getIncome().values() == null) {
            return total;
        }
        for (Income e : fstmt.getIncome().values()) {
            if (e.getAmount() == null) continue;
            FinancialInfoBean bean = new FinancialInfoBean(e.getType().getDescription(), e.getAmount(), source);
            income.add(bean);
            total = total.add(e.getAmount());
        }
        return total;
    }

    private BigDecimal getExpenseInfo(FinancialInformation fstmt, Vector expenses, String source) {
        BigDecimal total = new BigDecimal(0);
        if (fstmt == null || fstmt.getExpenses() == null || fstmt.getExpenses().values() == null) {
            return total;
        }
        for (Expense e : fstmt.getExpenses().values()) {
            if (e.getAmount() == null) continue;
            FinancialInfoBean bean = new FinancialInfoBean(e.getType().getDescription(), e.getAmount(), source);
            expenses.add(bean);
            total = total.add(e.getAmount());
        }
        return total;
    }

    private BigDecimal getDebtInfo(FinancialInformation fstmt, Vector debts, String source) {
        BigDecimal total = new BigDecimal(0);
        if (fstmt == null || fstmt.getDebt() == null) {
            return total;
        }
        if (fstmt.getDebt().getAmount() != null) {
            FinancialInfoBean bean = new FinancialInfoBean(null, fstmt.getDebt().getAmount(), source);
            debts.add(bean);
            total = total.add(fstmt.getDebt().getAmount());
        }
        return total;
    }

    private DependentFinancials getDependentFinancials(FinancialStatement financialStatement) {
        if (financialStatement == null || financialStatement.getDependentFinancials() == null) {
            return null;
        }
        for (Object obj : financialStatement.getDependentFinancials()) {
            if (!(obj instanceof DependentFinancials)) continue;
            return (DependentFinancials)obj;
        }
        return null;
    }

    private SpouseFinancials getSpouseFinancials(FinancialStatement financialStatement) {
        if (financialStatement == null || financialStatement.getSpouseFinancials() == null) {
            return null;
        }
        return financialStatement.getActiveSpouseFinancials();
    }

    private void getPatientVisitTotals(Person person, Integer incomeyear, FinancialsForm form) {
        int totalInpatientDays = 0;
        int totalOutpatientVisits = 0;
        if (person.getPatientVisitSummaries() != null && !person.getPatientVisitSummaries().isEmpty()) {
            for (PatientVisitSummary e : person.getPatientVisitSummaries().values()) {
                if (e.getIncomeYear() == null || !e.getIncomeYear().equals(incomeyear)) continue;
                if (e.getInpatientDays() != null) {
                    totalInpatientDays += e.getInpatientDays().intValue();
                }
                if (e.getOutpatientDays() == null) continue;
                totalOutpatientVisits += e.getOutpatientDays().intValue();
            }
        }
        form.setTotalInpatientDays(new Integer(totalInpatientDays));
        form.setTotalOutpatientVisits(new Integer(totalOutpatientVisits));
    }

    private String getDisplayName(Name name, String source) {
        String nameString = source;
        if (name != null && StringUtils.isNotBlank((String)(nameString = NameHelper.formatNameFirstNameFirst((Name)name))) && StringUtils.isNotBlank((String)source)) {
            nameString = nameString + ", " + source.trim();
        }
        return nameString;
    }
}

