/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.financials.action;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.SiteYear;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.service.impl.RuleValidationMessage;
import gov.va.med.esr.common.ui.form.FinancialDetailsForm;
import gov.va.med.esr.service.FinancialsService;
import gov.va.med.esr.ui.common.action.AddressValidationAction;
import gov.va.med.esr.ui.financials.action.FinancialsConstants;
import gov.va.med.esr.ui.financials.action.FinancialsDependentForm;
import gov.va.med.esr.ui.financials.action.FinancialsForm;
import gov.va.med.esr.ui.util.SessionManager;
import gov.va.med.fw.service.ServiceConfigurationException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.validation.ValidationServiceException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;

public class FinancialsAction
extends AddressValidationAction
implements FinancialsConstants {
    private FinancialsService financialsService;
    public static final String FORWARD_FINANCIALS_OVERVIEW = "financialsOverview";
    public static final String FORWARD_FINANCIALS_SUMMARY = "financialSummary";
    public static final String FORWARD_FINANCIAL_REVIEW_IMPACT = "finacialReviewImpact";
    public static final String FORWARD_FINANCIAL_REVIEW_IMPACT_DISPLAY = "finacialReviewImpactDisplay";
    public static final String FORWARD_FINANCIAL_DETAILS_EDIT = "financialDetailsEdit";
    public static final String FORWARD_RETURN_TO_FINANCIAL_DETAILS_EDIT = "returnToFinancialDetailsEdit";
    public static final String FORWARD_ADJUDICATION = "adjudication";
    public static final String FORWARD_CANCEL = "cancel";

    protected void setSelectedIncomeYear(HttpServletRequest request, Integer incomeYear) {
        SessionManager.setSelectedFinancialIncomeYear(request, incomeYear);
    }

    protected Integer getSelectedIncomeYear(HttpServletRequest request) {
        return SessionManager.getSelectedFinancialIncomeYear(request);
    }

    protected void removeSelectedIncomeYear(HttpServletRequest request) {
        SessionManager.removeSelectedFinancialIncomeYear(request);
    }

    protected List determineValidIncomeYears(Person person) {
        Map incomeTestMap = person.getIncomeTests();
        HashSet validIncomeYears = new HashSet(incomeTestMap.keySet());
        Map beneficiaryTravels = person.getBeneficiaryTravels();
        if (beneficiaryTravels != null && beneficiaryTravels.size() > 0) {
            Set keySet = beneficiaryTravels.keySet();
            for (SiteYear siteYear : keySet) {
                validIncomeYears.add(siteYear.getYear());
            }
        }
        Calendar calendar = Calendar.getInstance();
        int dayOfYear = calendar.get(6);
        int year = calendar.get(1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getYearStartDate((int)year));
        cal.add(5, 90);
        Date temp90 = cal.getTime();
        if (DateUtils.isAfter((Date)calendar.getTime(), (Date)temp90)) {
            int prevYear = gov.va.med.esr.ui.common.util.DateUtils.getCurrentYear() - 1;
            validIncomeYears.add(new Integer(prevYear));
        } else {
            int prevYear1 = gov.va.med.esr.ui.common.util.DateUtils.getCurrentYear() - 1;
            validIncomeYears.add(new Integer(prevYear1));
            int prevYear2 = gov.va.med.esr.ui.common.util.DateUtils.getCurrentYear() - 2;
            validIncomeYears.add(new Integer(prevYear2));
        }
        ArrayList yearList = new ArrayList(validIncomeYears);
        Collections.sort(yearList);
        return yearList;
    }

    protected FinancialsForm getFinancialsForm(ActionForm form) throws ServiceConfigurationException {
        FinancialsForm personalForm;
        FinancialsForm financialsForm = personalForm = form instanceof FinancialsForm ? (FinancialsForm)form : null;
        if (personalForm == null) {
            throw new ServiceConfigurationException("FinancialsForm not properly configured.");
        }
        return personalForm;
    }

    protected FinancialDetailsForm getFinancialDetailsForm(ActionForm form) throws ServiceConfigurationException {
        FinancialDetailsForm personalForm;
        FinancialDetailsForm financialDetailsForm = personalForm = form instanceof FinancialDetailsForm ? (FinancialDetailsForm)form : null;
        if (personalForm == null) {
            throw new ServiceConfigurationException("FinancialDetailsForm not properly configured.");
        }
        return personalForm;
    }

    protected FinancialsDependentForm getFinancialsDependentForm(ActionForm form) throws ServiceConfigurationException {
        FinancialsDependentForm personalForm;
        FinancialsDependentForm financialsDependentForm = personalForm = form instanceof FinancialsDependentForm ? (FinancialsDependentForm)form : null;
        if (personalForm == null) {
            throw new ServiceConfigurationException("FinancialsDependentForm not properly configured.");
        }
        return personalForm;
    }

    public void afterPropertiesSet() {
    }

    @Override
    public FinancialsService getFinancialsService() {
        return this.financialsService;
    }

    @Override
    public void setFinancialsService(FinancialsService financialsService) {
        this.financialsService = financialsService;
    }

    protected SpouseFinancials getSpouseFinancialsById(Person person, String financialsId, Integer incomeYear) {
        if (incomeYear != null && StringUtils.isNotEmpty((String)financialsId)) {
            FinancialStatement ftmt = person.getFinancialStatement(incomeYear);
            return ftmt.getSpouseFinancialsByEntityKey(CommonEntityKeyFactory.createSpouseFinancialsEntityKey((String)financialsId));
        }
        return null;
    }

    protected DependentFinancials getDependentFinancialsById(Person person, String financialsId, Integer incomeYear) {
        if (incomeYear != null && StringUtils.isNotEmpty((String)financialsId)) {
            FinancialStatement ftmt = person.getFinancialStatement(incomeYear);
            return ftmt.getDependentFinancialsByEntityKey(CommonEntityKeyFactory.createDependentFinancialsEntityKey((String)financialsId));
        }
        return null;
    }

    protected Person invokeAssessReviewImpact(FinancialDetailsForm detailsForm, Integer incomeYear, Person clonePerson) throws ServiceException {
        try {
            return this.getFinancialsService().assessFinancialImpact(incomeYear, clonePerson);
        }
        catch (ValidationServiceException ex) {
            this.setAdjudicationProperty(ex, detailsForm);
            throw ex;
        }
    }

    protected Person invokeUpdateFinancialAssessment(FinancialDetailsForm detailsForm, Integer incomeYear, Person person) throws ServiceException {
        try {
            return this.getFinancialsService().updateFinancialAssessment(incomeYear, person);
        }
        catch (ValidationServiceException ex) {
            this.setAdjudicationProperty(ex, detailsForm);
            throw ex;
        }
    }

    private void setAdjudicationProperty(ValidationServiceException ex, FinancialDetailsForm detailsForm) {
        if (ex.getValidationMessages() != null && ex.getValidationMessages().contains(RuleValidationMessage.SEND_TO_ADJUDICATION_REQUIRED.getCode())) {
            detailsForm.setAskAdjudicationQuestion(true);
        }
    }
}

