/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.financials.action;

import gov.va.med.esr.common.model.financials.InProcessFinancialInfo;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.service.impl.RuleValidationMessage;
import gov.va.med.esr.common.ui.form.FinancialDetailsData;
import gov.va.med.esr.common.ui.form.FinancialDetailsForm;
import gov.va.med.esr.ui.financials.action.AdjudicationForm;
import gov.va.med.esr.ui.financials.action.FinancialsAction;
import gov.va.med.esr.ui.util.SessionManager;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.util.SerializationUtils;
import gov.va.med.fw.validation.ValidationMessage;
import gov.va.med.fw.validation.ValidationMessages;
import gov.va.med.fw.validation.ValidationServiceException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class FinancialDetailsEditAction
extends FinancialsAction {
    private static final String EXPENSES_EXCEED_INCOME = "error.expensesExceedIncome";

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String inProcessData;
        FinancialDetailsForm detailsForm = this.getFinancialDetailsForm(form);
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        detailsForm.setAddAPerson(isAddAPerson);
        Integer incomeYear = this.getSelectedIncomeYear(request);
        detailsForm.setIncomeYear(String.valueOf(incomeYear));
        Person person = this.getSelectedPerson(request);
        InProcessFinancialInfo inProcessFinancial = person.getInProcessFinancial(incomeYear);
        String string = inProcessData = inProcessFinancial == null ? null : inProcessFinancial.getInProcessData();
        if (inProcessData != null) {
            byte[] decodedData = new BASE64Decoder().decodeBuffer(inProcessData);
            Object decodedObj = SerializationUtils.deserialize((byte[])decodedData);
            detailsForm.setFinancialsData((FinancialDetailsData)decodedObj);
        } else if (this.conversionService != null) {
            this.conversionService.convert((Object)person, (Object)detailsForm);
        }
        boolean canAdd = this.getFinancialsService().canFinancialsBeAdded(incomeYear, person);
        boolean canEdit = this.getFinancialsService().canFinancialsBeUpdated(incomeYear, person);
        boolean canUpdateNetWorth = true;
        detailsForm.setAllowedToAddFinancials(canAdd);
        detailsForm.setAllowedToEditFinancials(canEdit);
        detailsForm.setAllowedToUpdateNetWorth(canUpdateNetWorth);
        return mapping.findForward("financialDetailsEdit");
    }

    @Override
    protected ActionForward handleOptimisticLockException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        form.reset(mapping, request);
        return this.display(mapping, form, request, response);
    }

    public ActionForward update(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialDetailsForm detailsForm = this.getFinancialDetailsForm(form);
        Integer incomeYear = this.getSelectedIncomeYear(request);
        detailsForm.setIncomeYear(String.valueOf(incomeYear));
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        detailsForm.setAddAPerson(isAddAPerson);
        Person person = this.getSelectedPerson(request);
        if (this.conversionService != null) {
            Person clonePerson = (Person)person.clone();
            this.conversionService.convert((Object)detailsForm, (Object)clonePerson);
            clonePerson.setInProcessFinancial(incomeYear, null);
            if (isAddAPerson) {
                this.updateSelectedPerson(request, clonePerson);
            } else {
                Person calculatedPerson = this.invokeAssessReviewImpact(detailsForm, incomeYear, clonePerson);
                this.validateIncomesAndDeductibleExpenses(incomeYear, calculatedPerson, request);
                Person updatedPerson = this.invokeUpdateFinancialAssessment(detailsForm, incomeYear, clonePerson);
                this.updateSelectedPerson(request, updatedPerson);
            }
        }
        return mapping.findForward("financialSummary");
    }

    public ActionForward saveInProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialDetailsForm detailsForm = this.getFinancialDetailsForm(form);
        Integer incomeYear = this.getSelectedIncomeYear(request);
        detailsForm.setIncomeYear(String.valueOf(incomeYear));
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        detailsForm.setAddAPerson(isAddAPerson);
        Person person = this.getSelectedPerson(request);
        Person clonePerson = (Person)person.clone();
        byte[] data = SerializationUtils.serialize((Serializable)detailsForm.getFinancialsData());
        InProcessFinancialInfo inProcessFinancial = clonePerson.getInProcessFinancial(incomeYear);
        if (inProcessFinancial == null) {
            inProcessFinancial = new InProcessFinancialInfo();
            inProcessFinancial.setIncomeYear(incomeYear);
            clonePerson.setInProcessFinancial(incomeYear, inProcessFinancial);
        }
        inProcessFinancial.setInProcessData(new BASE64Encoder().encode(data));
        if (isAddAPerson) {
            this.updateSelectedPerson(request, clonePerson);
        } else {
            Person updatedPerson = this.getFinancialsService().updateInProcess(incomeYear, clonePerson);
            this.updateSelectedPerson(request, updatedPerson);
        }
        return mapping.findForward("financialSummary");
    }

    public ActionForward reviewImpact(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialDetailsForm detailsForm = this.getFinancialDetailsForm(form);
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        detailsForm.setAddAPerson(isAddAPerson);
        this.removeUpdatedPerson(request);
        SessionManager.removeCalculatedPerson(request);
        Person person = this.getSelectedPerson(request);
        Integer incomeYear = this.getSelectedIncomeYear(request);
        detailsForm.setIncomeYear(String.valueOf(incomeYear));
        if (this.conversionService != null) {
            Person clonePerson = (Person)person.clone();
            this.conversionService.convert((Object)detailsForm, (Object)clonePerson);
            this.setUpdatedPerson(request, clonePerson);
            if (!isAddAPerson) {
                Person calculatedPerson = this.invokeAssessReviewImpact(detailsForm, incomeYear, clonePerson);
                this.validateIncomesAndDeductibleExpenses(incomeYear, calculatedPerson, request);
                SessionManager.setCalculatedPerson(request, calculatedPerson);
            }
        }
        return mapping.findForward("finacialReviewImpactDisplay");
    }

    public ActionForward returnFromReviewImpact(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String inProcessData;
        FinancialDetailsForm detailsForm = this.getFinancialDetailsForm(form);
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        detailsForm.setAddAPerson(isAddAPerson);
        Integer incomeYear = this.getSelectedIncomeYear(request);
        detailsForm.setIncomeYear(String.valueOf(incomeYear));
        Person person = this.getUpdatedPerson(request);
        InProcessFinancialInfo inProcessFinancial = person.getInProcessFinancial(incomeYear);
        String string = inProcessData = inProcessFinancial == null ? null : inProcessFinancial.getInProcessData();
        if (inProcessData != null) {
            byte[] decodedData = new BASE64Decoder().decodeBuffer(inProcessData);
            Object decodedObj = SerializationUtils.deserialize((byte[])decodedData);
            detailsForm.setFinancialsData((FinancialDetailsData)decodedObj);
        } else if (this.conversionService != null) {
            this.conversionService.convert((Object)person, (Object)detailsForm);
            IncomeTest incomeTest = person.getIncomeTest(incomeYear);
            if (incomeTest != null && incomeTest.getEntityKey() == null) {
                detailsForm.setNewIncomeTestInd(true);
            }
        }
        detailsForm.setAllowedToAddFinancials(this.getFinancialsService().canFinancialsBeAdded(incomeYear, person));
        detailsForm.setAllowedToEditFinancials(this.getFinancialsService().canFinancialsBeAdded(incomeYear, person));
        return mapping.findForward("financialDetailsEdit");
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialDetailsForm detailsForm = this.getFinancialDetailsForm(form);
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        detailsForm.setAddAPerson(isAddAPerson);
        Person person = this.getSelectedPerson(request);
        Integer incomeYear = this.getSelectedIncomeYear(request);
        if (person.getIncomeTest(incomeYear) != null) {
            Person clonePerson = (Person)person.clone();
            clonePerson.setIncomeTest(incomeYear, null);
            clonePerson.setInProcessFinancial(incomeYear, null);
            if (isAddAPerson) {
                this.updateSelectedPerson(request, clonePerson);
            } else {
                Person updatedPerson = this.invokeUpdateFinancialAssessment(detailsForm, incomeYear, clonePerson);
                this.updateSelectedPerson(request, updatedPerson);
            }
        }
        return mapping.findForward("financialSummary");
    }

    public ActionForward addIncomeTest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialDetailsForm detailsForm = this.getFinancialDetailsForm(form);
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        detailsForm.setAddAPerson(isAddAPerson);
        detailsForm.setNewIncomeTestInd(true);
        detailsForm.setIncomeTestAvaliableInd(true);
        Integer incomeYear = this.getSelectedIncomeYear(request);
        detailsForm.setIncomeYear(String.valueOf(incomeYear));
        boolean canUpdateNetWorth = true;
        detailsForm.setAllowedToUpdateNetWorth(canUpdateNetWorth);
        return mapping.findForward("financialDetailsEdit");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        Integer incomeYear = this.getSelectedIncomeYear(request);
        Person person = this.getSelectedPerson(request);
        if (person.getInProcessFinancial(incomeYear) != null) {
            Person clonePerson = (Person)person.clone();
            clonePerson.setInProcessFinancial(incomeYear, null);
            if (isAddAPerson) {
                this.updateSelectedPerson(request, clonePerson);
            } else {
                Person updatedPerson = this.getFinancialsService().updateInProcess(incomeYear, clonePerson);
                this.updateSelectedPerson(request, updatedPerson);
            }
        }
        return mapping.findForward("cancel");
    }

    public ActionForward gotoAdjudicate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person person = this.getSelectedPerson(request);
        Integer incomeYear = this.getSelectedIncomeYear(request);
        this.validateInProcessFinancials(incomeYear, person);
        return mapping.findForward("adjudication");
    }

    public ActionForward displayAdjudicateIncomeTest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person person = this.getSelectedPerson(request);
        Integer incomeYear = this.getSelectedIncomeYear(request);
        IncomeTest test = person.getIncomeTest(incomeYear);
        AdjudicationForm adjudicationForm = (AdjudicationForm)form;
        adjudicationForm.setIncomeYear(String.valueOf(incomeYear));
        if (test != null) {
            BigDecimal gmtThreshold = test.getGmtThresholdAmount();
            BigDecimal mtThreshold = test.getThresholdA();
            adjudicationForm.setGmtThresholdAmount(gmtThreshold);
            adjudicationForm.setMeansTestThresholdAmount(mtThreshold);
            if (gmtThreshold == null) {
                gmtThreshold = new BigDecimal(0);
            }
            if (mtThreshold == null) {
                mtThreshold = new BigDecimal(0);
            }
            ArrayList<Lookup> mtStatusList = new ArrayList<Lookup>();
            if (gmtThreshold.compareTo(mtThreshold) > 0) {
                mtStatusList.add(this.getLookupCacheService().getByCodeFromCache(MeansTestStatus.class.getName(), MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED.getName()));
            } else {
                mtStatusList.add(this.getLookupCacheService().getByCodeFromCache(MeansTestStatus.class.getName(), MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getName()));
            }
            mtStatusList.add(this.getLookupCacheService().getByCodeFromCache(MeansTestStatus.class.getName(), MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT.getName()));
            request.getSession().setAttribute("meansTestStatusList", mtStatusList);
            return mapping.findForward("adjudication");
        }
        return mapping.findForward("financialSummary");
    }

    protected void validateInProcessFinancials(Integer incomeYear, Person incoming) throws ValidationServiceException {
        Validate.notNull((Object)incoming, (String)"Person must not be null.");
        if (incoming.getInProcessFinancial(incomeYear) != null) {
            ValidationMessages validationMessages = new ValidationMessages();
            validationMessages.add(new ValidationMessage(RuleValidationMessage.FINANCIALS_INPROCESS_STATE.getCode()));
            throw new ValidationServiceException(validationMessages);
        }
    }

    protected void validateIncomesAndDeductibleExpenses(Integer incomeYear, Person assessedPerson, HttpServletRequest request) throws ValidationServiceException {
        Validate.notNull((Object)assessedPerson, (String)"Person must not be null.");
        Validate.notNull((Object)incomeYear, (String)"income year must not be null.");
        IncomeTest incomeTest = assessedPerson.getIncomeTest(Integer.valueOf(incomeYear));
        if (incomeTest != null) {
            this.logger.info((Object)("incomeTest: " + incomeTest.toString()));
            BigDecimal incomes = incomeTest.getTotalIncome();
            this.logger.info((Object)("total income: " + incomes));
            BigDecimal expenses = incomeTest.getDeductibleExpenses();
            this.logger.info((Object)("total expenses: " + expenses));
            if (expenses.compareTo(incomes) == 1) {
                ValidationMessages validationMessages = new ValidationMessages();
                validationMessages.add(new ValidationMessage(EXPENSES_EXCEED_INCOME));
                throw new ValidationServiceException(validationMessages);
            }
        }
    }

    public ActionForward adjudicateIncomeTest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdjudicationForm adjudicationForm = (AdjudicationForm)form;
        Person updatedPerson = (Person)this.getSelectedPerson(request).clone();
        MeansTestStatus meansTestStatus = (MeansTestStatus)this.getLookupCacheService().getByCodeFromCache(MeansTestStatus.class.getName(), adjudicationForm.getMeansTestStatus());
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        if (!isAddAPerson) {
            this.getFinancialsService().updatePendingAdjudicationStatus(this.getSelectedIncomeYear(request), updatedPerson, meansTestStatus);
        }
        this.updateSelectedPerson(request, updatedPerson);
        return mapping.findForward("financialSummary");
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.acceptChanges", "update");
        map.put("button.cancel", "cancel");
        map.put("button.reviewImpact", "reviewImpact");
        map.put("button.display", "display");
        map.put("link.returnFromReviewImpact", "returnFromReviewImpact");
        map.put("button.deleteIncomeTest", "delete");
        map.put("button.addIncomeTest", "addIncomeTest");
        map.put("button.adjudicateIncomeTest", "gotoAdjudicate");
        map.put("link.disaplayAdjudication", "displayAdjudicateIncomeTest");
        map.put("button.update", "adjudicateIncomeTest");
        map.put("button.saveInProcess", "saveInProcess");
        return map;
    }
}

