/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.financials.action;

import gov.va.med.esr.common.model.financials.Asset;
import gov.va.med.esr.common.model.financials.Debt;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.Expense;
import gov.va.med.esr.common.model.financials.FinancialInformation;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.Income;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.lookup.AssetType;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.esr.common.model.lookup.IncomeTestSource;
import gov.va.med.esr.common.model.lookup.IncomeType;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.common.ui.conversion.CommonFinancialDetailsConversionService;
import gov.va.med.esr.common.ui.form.DependentFinancialInfoBean;
import gov.va.med.esr.common.ui.form.FinancialDetailsForm;
import gov.va.med.esr.common.ui.form.SpouseFinancialInfoBean;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.esr.ui.financials.action.FinancialsDependentConversionService;
import gov.va.med.esr.ui.util.ConvertUtils;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class FinancialDetailsConversionService
extends UIConversionServiceImpl {
    private CommonFinancialDetailsConversionService commonDetailsConversionService;
    private FinancialsDependentConversionService dependentConversionService;

    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        Person person = null;
        FinancialDetailsForm form = null;
        if (source instanceof FinancialDetailsForm) {
            form = (FinancialDetailsForm)source;
            if (!(target instanceof Person)) {
                throw new ConversionServiceException("Target object is of type " + target.getClass().getName() + " and must be of type Person.");
            }
            person = (Person)target;
            this.convertFormToPerson(form, person);
        } else {
            this.getCommonDetailsConversionService().convert(source, target);
        }
    }

    protected void convertPersonToForm(Person person, FinancialDetailsForm form) throws ConversionServiceException {
        this.getCommonDetailsConversionService().convert((Object)person, (Object)form);
    }

    protected void convertFormToPerson(FinancialDetailsForm form, Person person) throws ConversionServiceException {
        try {
            List depIds;
            boolean isAddAPerson = form.isAddAPerson();
            String year = form.getIncomeYear();
            if (year == null) {
                throw new ConversionServiceException("Unable to convert FinancialDetailsForm to Person, no IncomeYear selected");
            }
            Integer incomeYear = new Integer(year);
            FinancialStatement ftmt = person.getFinancialStatement(new Integer(year));
            if (ftmt == null) {
                ftmt = new FinancialStatement();
                ftmt.setIsPost2005Format(Boolean.TRUE);
                person.setFinancialStatement(incomeYear, ftmt);
            }
            ftmt.setMarriedLastCalendarYear(this.getBoolean(form.getMarriedLastCalendarYear()));
            IncomeTest test = person.getIncomeTest(incomeYear);
            if (test == null && form.getNewIncomeTestInd()) {
                test = new IncomeTest();
                test.setIncomeYear(incomeYear);
                person.setIncomeTest(incomeYear, test);
                test.setEffectiveDate(DateUtils.getDate((String)form.getTestEffDate()));
            }
            IncomeTestSource testSource = (IncomeTestSource)this.getLookupCacheService().getByCodeFromCache(IncomeTestSource.class, IncomeTestSource.CODE_HEC.getName());
            test.setSource(testSource);
            test.setSendForAdjudication(this.getBoolean(form.getSendForAdjudication()));
            test.setAgreesToPayDeductible(this.getBoolean(form.getAgreeToPayDeductible()));
            test.setDiscloseFinancialInformation(this.getBoolean(form.getDiscloseFinIncome()));
            this.convertFormToVeteranFinancialAmounts(form, ftmt);
            SpouseFinancials sf = ftmt.getRecentSpouseFinancials();
            if (sf != null) {
                this.convertFormToSpouseFinancials(form, sf);
            }
            if ((depIds = form.getDepFinacialsIdList()) != null && !depIds.isEmpty()) {
                for (int i = 0; i < depIds.size(); ++i) {
                    String id = form.getDepFinacialsId(i);
                    Set dependentFinancials = ftmt.getDependentFinancials();
                    for (DependentFinancials df : dependentFinancials) {
                        if (isAddAPerson) {
                            if (df == null) continue;
                            this.convertFormToDependentFinancials(form, i, df);
                            continue;
                        }
                        if (df == null || !id.equals(df.getEntityKey().getKeyValueAsString())) continue;
                        this.convertFormToDependentFinancials(form, i, df);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Unable to convert FinancialDetailsForm to Person.", ex);
        }
    }

    private void convertFormToVeteranFinancialAmounts(FinancialDetailsForm form, FinancialStatement ftmt) throws Exception {
        this.setIncome(form.getTotalEmploymentIncome(), IncomeType.INCOME_TYPE_TOTAL_INCOME_FROM_EMPLOYMENT.getName(), (FinancialInformation)ftmt);
        this.setIncome(form.getOtherIncome(), IncomeType.INCOME_TYPE_TOTAL_ALL_OTHER_INCOME.getName(), (FinancialInformation)ftmt);
        this.setIncome(form.getNetIncomeFromFarmRanchOrBusiness(), IncomeType.INCOME_TYPE_FARM_RANCH_PROPERTY_OR_BUSINESS_INCOME.getName(), (FinancialInformation)ftmt);
        this.setIncome(form.getUSCivilServiceIncome(), IncomeType.INCOME_TYPE_CIVIL_SERVICE.getName(), (FinancialInformation)ftmt);
        this.setIncome(form.getInterestDividentAnuityIncome(), IncomeType.INCOME_TYPE_INTEREST_DIVIDEND_ANNUITY.getName(), (FinancialInformation)ftmt);
        this.setIncome(form.getUnemploymentIncome(), IncomeType.INCOME_TYPE_UNEMPLOYMENT_COMPENSATION.getName(), (FinancialInformation)ftmt);
        this.setIncome(form.getSocialSecurityIncome(), IncomeType.INCOME_TYPE_SOCIAL_SECURITY.getName(), (FinancialInformation)ftmt);
        this.setIncome(form.getMilitaryRetirementIncome(), IncomeType.INCOME_TYPE_MILITARY_RETIREMENT.getName(), (FinancialInformation)ftmt);
        this.setIncome(form.getRailroadRetirementIncome(), IncomeType.INCOME_TYPE_RAILROAD_RETIREMENT.getName(), (FinancialInformation)ftmt);
        this.setIncome(form.getOtherRetirementIncome(), IncomeType.INCOME_TYPE_OTHER_RETIREMENT.getName(), (FinancialInformation)ftmt);
        this.setIncome(form.getWorkersCompIncome(), IncomeType.INCOME_TYPE_WORKERS_COMP_BLACK_LUNG.getName(), (FinancialInformation)ftmt);
        this.setExpense(form.getEducationExpense(), ExpenseType.EXPENSE_TYPE_COLLEGE_AND_VOCATION.getName(), (FinancialInformation)ftmt);
        this.setExpense(form.getNonReimbMedicalExpense(), ExpenseType.EXPENSE_TYPE_NON_REIMBURSED_MEDICAL.getName(), (FinancialInformation)ftmt);
        this.setExpense(form.getFuneralBurialExpense(), ExpenseType.EXPENSE_TYPE_FUNERAL_AND_BURIAL.getName(), (FinancialInformation)ftmt);
        this.setAsset(form.getCashAndBankAccountAsset(), AssetType.CODE_CASH.getName(), (FinancialInformation)ftmt);
        this.setAsset(form.getRealPropertyAsset(), AssetType.CODE_REAL_ESTATE.getName(), (FinancialInformation)ftmt);
        this.setAsset(form.getOtherPropertyAsset(), AssetType.CODE_OTHER.getName(), (FinancialInformation)ftmt);
        this.setAsset(form.getStocksAsset(), AssetType.CODE_STOCKS_AND_BONDS.getName(), (FinancialInformation)ftmt);
        if (StringUtils.isNotEmpty((String)form.getDebt())) {
            Debt debt = ftmt.getDebt();
            if (debt == null) {
                debt = new Debt();
                ftmt.setDebt(debt);
            }
            debt.setAmount(new BigDecimal(form.getDebt()));
        } else {
            ftmt.setDebt(null);
        }
    }

    private void convertFormToSpouseFinancials(FinancialDetailsForm form, SpouseFinancials ftmt) throws Exception {
        Spouse spouse;
        SpouseFinancialInfoBean bean = form.getSpouseInfo();
        this.convertFormToSpouseFinancialAmounts(form, ftmt);
        ftmt.setLivedWithPatient(this.getBoolean(bean.getLivedWithVeteran()));
        FinancialStatement statement = ftmt.getFinancialStatement();
        if (statement != null) {
            statement.setContributedToSpouseInd(this.getBoolean(bean.getContributedToSpouseInd()));
        }
        if (StringUtils.isNotEmpty((String)bean.getContributedToSupport())) {
            if (statement != null) {
                statement.setContributionToSpouse(new BigDecimal(bean.getContributedToSupport()));
            }
        } else if (statement != null) {
            statement.setContributionToSpouse(null);
        }
        if ((spouse = ftmt.getReportedOn()) != null) {
            spouse.setEndDate(DateUtils.getDate((String)bean.getInactiveDate()));
            if (StringUtils.isNotEmpty((String)bean.getMarriageDate())) {
                spouse.setMarriageDate(DateUtils.getImpreciseDate((String)bean.getMarriageDate()));
            } else {
                spouse.setMarriageDate(null);
            }
        }
    }

    private void setExpense(String amount, String expTypeCode, FinancialInformation ftmt) throws Exception {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        ExpenseType expType = (ExpenseType)lookupCacheService.getByCodeFromCache(ExpenseType.class, expTypeCode);
        if (StringUtils.isEmpty((String)amount)) {
            ftmt.setExpense(expType, null);
            return;
        }
        Expense exp = ftmt.getExpense(expType);
        if (exp == null) {
            exp = new Expense();
            ftmt.setExpense(expType, exp);
        }
        exp.setAmount(new BigDecimal(amount));
    }

    private void setIncome(String amount, String incomeTypeCode, FinancialInformation ftmt) throws Exception {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        IncomeType incomeType = (IncomeType)lookupCacheService.getByCodeFromCache(IncomeType.class, incomeTypeCode);
        if (StringUtils.isEmpty((String)amount)) {
            ftmt.setIncome(incomeType, null);
            return;
        }
        Income income = ftmt.getIncome(incomeType);
        if (income == null) {
            income = new Income();
            ftmt.setIncome(incomeType, income);
        }
        income.setAmount(new BigDecimal(amount));
    }

    private void setAsset(String amount, String assetTypeCode, FinancialInformation ftmt) throws Exception {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        AssetType assetType = (AssetType)lookupCacheService.getByCodeFromCache(AssetType.class, assetTypeCode);
        if (StringUtils.isEmpty((String)amount)) {
            ftmt.setAsset(assetType, null);
            return;
        }
        Asset asset = ftmt.getAsset(assetType);
        if (asset == null) {
            asset = new Asset();
            ftmt.setAsset(assetType, asset);
        }
        asset.setAmount(new BigDecimal(amount));
    }

    public void convertFormToSpouseFinancialAmounts(FinancialDetailsForm form, SpouseFinancials ftmt) throws Exception {
        SpouseFinancialInfoBean bean = new SpouseFinancialInfoBean();
        boolean isAddAPerson = form.isAddAPerson();
        if (isAddAPerson) {
            this.setIncome(form.getSpouseTotalIncome(0), IncomeType.INCOME_TYPE_TOTAL_INCOME_FROM_EMPLOYMENT.getName(), (FinancialInformation)ftmt);
            this.setIncome(form.getSpouseOtherIncome(0), IncomeType.INCOME_TYPE_TOTAL_ALL_OTHER_INCOME.getName(), (FinancialInformation)ftmt);
            this.setIncome(form.getSpouseIncomeFromRanch(0), IncomeType.INCOME_TYPE_FARM_RANCH_PROPERTY_OR_BUSINESS_INCOME.getName(), (FinancialInformation)ftmt);
            this.setIncome(form.getSpouseUSCivilServiceIncome(0), IncomeType.INCOME_TYPE_CIVIL_SERVICE.getName(), (FinancialInformation)ftmt);
            this.setIncome(form.getSpouseInterestDividentAnuityIncome(0), IncomeType.INCOME_TYPE_INTEREST_DIVIDEND_ANNUITY.getName(), (FinancialInformation)ftmt);
            this.setIncome(form.getSpouseUnemploymentIncome(0), IncomeType.INCOME_TYPE_UNEMPLOYMENT_COMPENSATION.getName(), (FinancialInformation)ftmt);
            this.setIncome(form.getSpouseSocialSecurityIncome(0), IncomeType.INCOME_TYPE_SOCIAL_SECURITY.getName(), (FinancialInformation)ftmt);
            this.setIncome(form.getSpouseMilitaryRetirementIncome(0), IncomeType.INCOME_TYPE_MILITARY_RETIREMENT.getName(), (FinancialInformation)ftmt);
            this.setIncome(form.getSpouseRailroadRetirementIncome(0), IncomeType.INCOME_TYPE_RAILROAD_RETIREMENT.getName(), (FinancialInformation)ftmt);
            this.setIncome(form.getSpouseOtherRetirementIncome(0), IncomeType.INCOME_TYPE_OTHER_RETIREMENT.getName(), (FinancialInformation)ftmt);
            this.setIncome(form.getSpouseWorkersCompIncome(0), IncomeType.INCOME_TYPE_WORKERS_COMP_BLACK_LUNG.getName(), (FinancialInformation)ftmt);
            this.setAsset(form.getSpouseCashAsset(0), AssetType.CODE_CASH.getName(), (FinancialInformation)ftmt);
            this.setAsset(form.getSpouseRealAsset(0), AssetType.CODE_REAL_ESTATE.getName(), (FinancialInformation)ftmt);
            this.setAsset(form.getSpouseOtherAsset(0), AssetType.CODE_OTHER.getName(), (FinancialInformation)ftmt);
            this.setAsset(form.getSpouseStocksAsset(0), AssetType.CODE_STOCKS_AND_BONDS.getName(), (FinancialInformation)ftmt);
        } else {
            bean = form.getSpouseInfo();
            this.setIncome(bean.getTotalEmploymentIncome(), IncomeType.INCOME_TYPE_TOTAL_INCOME_FROM_EMPLOYMENT.getName(), (FinancialInformation)ftmt);
            this.setIncome(bean.getOtherIncome(), IncomeType.INCOME_TYPE_TOTAL_ALL_OTHER_INCOME.getName(), (FinancialInformation)ftmt);
            this.setIncome(bean.getNetIncomeFromFarmRanchOrBusiness(), IncomeType.INCOME_TYPE_FARM_RANCH_PROPERTY_OR_BUSINESS_INCOME.getName(), (FinancialInformation)ftmt);
            this.setIncome(bean.getUSCivilServiceIncome(), IncomeType.INCOME_TYPE_CIVIL_SERVICE.getName(), (FinancialInformation)ftmt);
            this.setIncome(bean.getInterestDividentAnuityIncome(), IncomeType.INCOME_TYPE_INTEREST_DIVIDEND_ANNUITY.getName(), (FinancialInformation)ftmt);
            this.setIncome(bean.getUnemploymentIncome(), IncomeType.INCOME_TYPE_UNEMPLOYMENT_COMPENSATION.getName(), (FinancialInformation)ftmt);
            this.setIncome(bean.getSocialSecurityIncome(), IncomeType.INCOME_TYPE_SOCIAL_SECURITY.getName(), (FinancialInformation)ftmt);
            this.setIncome(bean.getMilitaryRetirementIncome(), IncomeType.INCOME_TYPE_MILITARY_RETIREMENT.getName(), (FinancialInformation)ftmt);
            this.setIncome(bean.getRailroadRetirementIncome(), IncomeType.INCOME_TYPE_RAILROAD_RETIREMENT.getName(), (FinancialInformation)ftmt);
            this.setIncome(bean.getOtherRetirementIncome(), IncomeType.INCOME_TYPE_OTHER_RETIREMENT.getName(), (FinancialInformation)ftmt);
            this.setIncome(bean.getWorkersCompIncome(), IncomeType.INCOME_TYPE_WORKERS_COMP_BLACK_LUNG.getName(), (FinancialInformation)ftmt);
            this.setAsset(bean.getCashAndBankAccountAsset(), AssetType.CODE_CASH.getName(), (FinancialInformation)ftmt);
            this.setAsset(bean.getRealPropertyAsset(), AssetType.CODE_REAL_ESTATE.getName(), (FinancialInformation)ftmt);
            this.setAsset(bean.getOtherPropertyAsset(), AssetType.CODE_OTHER.getName(), (FinancialInformation)ftmt);
            this.setAsset(bean.getStocksAsset(), AssetType.CODE_STOCKS_AND_BONDS.getName(), (FinancialInformation)ftmt);
        }
        if (StringUtils.isNotEmpty((String)bean.getDebt())) {
            Debt debt = ftmt.getDebt();
            if (debt == null) {
                debt = new Debt();
                ftmt.setDebt(debt);
            }
            debt.setAmount(new BigDecimal(bean.getDebt()));
        } else {
            ftmt.setDebt(null);
        }
    }

    private void convertFormToDependentFinancials(FinancialDetailsForm form, int index, DependentFinancials ftmt) throws Exception {
        this.convertFormToDependentFinancialAmounts(form, index, ftmt);
        form.setDepFinacialsHashCode(index, String.valueOf(ftmt.hashCode()));
        ftmt.setLivedWithPatient(ConvertUtils.convertBoolean(form.getDepLivedWithPatient(index)));
        ftmt.setIncapableOfSelfSupport(ConvertUtils.convertBoolean(form.getDepIncapableOfSelfSupport(index)));
        ftmt.setHasIncome(ConvertUtils.convertBoolean(form.getDepHasIncome(index)));
        ftmt.setContributedToSupport(ConvertUtils.convertBoolean(form.getDepContributedToSupport(index)));
        ftmt.setAttendedSchool(ConvertUtils.convertBoolean(form.getDepAttendedSchool(index)));
        ftmt.setIncomeAvailableToPatient(ConvertUtils.convertBoolean(form.getDepIncomeAvailableToPatient(index)));
        if (StringUtils.isNotEmpty((String)form.getDepAmtContributed(index))) {
            ftmt.setAmountContributedToSupport(new BigDecimal(form.getDepAmtContributed(index)));
        } else {
            ftmt.setAmountContributedToSupport(null);
        }
        Dependent dependent = ftmt.getReportedOn();
        if (dependent != null) {
            dependent.setEndDate(DateUtils.getDate((String)form.getDepInactiveDate(index)));
            if (StringUtils.isNotEmpty((String)form.getDepEffectiveDate(index))) {
                dependent.setStartDate(DateUtils.getImpreciseDate((String)form.getDepEffectiveDate(index)));
            } else {
                dependent.setStartDate(null);
            }
        }
    }

    private void convertFormToDependentFinancialAmounts(FinancialDetailsForm form, int index, DependentFinancials ftmt) throws Exception {
        this.setIncome(form.getDepTotalIncome(index), IncomeType.INCOME_TYPE_TOTAL_INCOME_FROM_EMPLOYMENT.getName(), (FinancialInformation)ftmt);
        this.setIncome(form.getDepOtherIncome(index), IncomeType.INCOME_TYPE_TOTAL_ALL_OTHER_INCOME.getName(), (FinancialInformation)ftmt);
        this.setIncome(form.getDepIncomeFromRanch(index), IncomeType.INCOME_TYPE_FARM_RANCH_PROPERTY_OR_BUSINESS_INCOME.getName(), (FinancialInformation)ftmt);
        this.setIncome(form.getDepUSCivilServiceIncome(index), IncomeType.INCOME_TYPE_CIVIL_SERVICE.getName(), (FinancialInformation)ftmt);
        this.setIncome(form.getDepInterestDividentAnuityIncome(index), IncomeType.INCOME_TYPE_INTEREST_DIVIDEND_ANNUITY.getName(), (FinancialInformation)ftmt);
        this.setIncome(form.getDepUnemploymentIncome(index), IncomeType.INCOME_TYPE_UNEMPLOYMENT_COMPENSATION.getName(), (FinancialInformation)ftmt);
        this.setIncome(form.getDepSocialSecurityIncome(index), IncomeType.INCOME_TYPE_SOCIAL_SECURITY.getName(), (FinancialInformation)ftmt);
        this.setIncome(form.getDepMilitaryRetirementIncome(index), IncomeType.INCOME_TYPE_MILITARY_RETIREMENT.getName(), (FinancialInformation)ftmt);
        this.setIncome(form.getDepRailroadRetirementIncome(index), IncomeType.INCOME_TYPE_RAILROAD_RETIREMENT.getName(), (FinancialInformation)ftmt);
        this.setIncome(form.getDepOtherRetirementIncome(index), IncomeType.INCOME_TYPE_OTHER_RETIREMENT.getName(), (FinancialInformation)ftmt);
        this.setIncome(form.getDepWorkersCompIncome(index), IncomeType.INCOME_TYPE_WORKERS_COMP_BLACK_LUNG.getName(), (FinancialInformation)ftmt);
        this.setExpense(form.getDepEduExpenses(index), ExpenseType.EXPENSE_TYPE_EDUCATIONAL_EXPENSES_BY_DEPENDENT.getName(), (FinancialInformation)ftmt);
        this.setAsset(form.getDepCashAsset(index), AssetType.CODE_CASH.getName(), (FinancialInformation)ftmt);
        this.setAsset(form.getDepRealAsset(index), AssetType.CODE_REAL_ESTATE.getName(), (FinancialInformation)ftmt);
        this.setAsset(form.getDepOtherAsset(index), AssetType.CODE_OTHER.getName(), (FinancialInformation)ftmt);
        this.setAsset(form.getDepStocksAsset(index), AssetType.CODE_STOCKS_AND_BONDS.getName(), (FinancialInformation)ftmt);
    }

    public List getDependentInfoList(FinancialStatement ftmt) throws Exception {
        ArrayList<Object> depInfoList = new ArrayList<Object>();
        Set spouseFinancials = ftmt.getSpouseFinancials();
        for (SpouseFinancials sf : spouseFinancials) {
            SpouseFinancialInfoBean sbean = new SpouseFinancialInfoBean();
            this.convertSpouseFinancialsToBean(sf, sbean);
            if (StringUtils.isEmpty((String)sbean.getDisplaySSN())) {
                sbean.setDisplaySSN("UNKNOWN");
            }
            sbean.setContributedToSpouseInd(this.getYesNoNoData(ftmt.getContributedToSpouseInd()));
            depInfoList.add(sbean);
        }
        Set dependentFinancials = ftmt.getDependentFinancials();
        for (DependentFinancials df : dependentFinancials) {
            DependentFinancialInfoBean bean = new DependentFinancialInfoBean();
            this.convertDependentFinancialsToBean(df, bean);
            if (StringUtils.isEmpty((String)bean.getDisplaySSN())) {
                bean.setDisplaySSN("UNKNOWN");
            }
            depInfoList.add(bean);
        }
        return depInfoList;
    }

    public CommonFinancialDetailsConversionService getCommonDetailsConversionService() {
        return this.commonDetailsConversionService;
    }

    public void setCommonDetailsConversionService(CommonFinancialDetailsConversionService commonDetailsConversionService) {
        this.commonDetailsConversionService = commonDetailsConversionService;
    }

    public FinancialsDependentConversionService getDependentConversionService() {
        return this.dependentConversionService;
    }

    public void setDependentConversionService(FinancialsDependentConversionService dependentConversionService) {
        this.dependentConversionService = dependentConversionService;
    }

    public void convertBeanToDependentFinancials(DependentFinancialInfoBean bean, DependentFinancials depFins) throws Exception {
        this.dependentConversionService.convertBeanToDependentFinancials(bean, depFins);
    }

    public void convertBeanToSpouseFinancials(SpouseFinancialInfoBean bean, SpouseFinancials spFins) throws Exception {
        this.dependentConversionService.convertBeanToSpouseFinancials(bean, spFins);
    }

    protected void convertSpouseFinancialsToBean(SpouseFinancials spFins, SpouseFinancialInfoBean bean) {
        this.getCommonDetailsConversionService().convertSpouseFinancialsToBean(spFins, bean);
    }

    protected void convertDependentFinancialsToBean(DependentFinancials depFin, DependentFinancialInfoBean bean) {
        this.getCommonDetailsConversionService().convertDependentFinancialsToBean(depFin, bean);
    }
}

