/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.financials.action;

import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.ui.form.FinancialDetailsForm;
import gov.va.med.esr.ui.financials.action.FinancialsAction;
import gov.va.med.esr.ui.util.SessionManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class FinancialDetailsAddAction
extends FinancialsAction {
    public static final String FORWARD_FINANCIAL_DETAILS_ADD = "financialDetailsAdd";

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialDetailsForm detailsForm = this.getFinancialDetailsForm(form);
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        detailsForm.setAddAPerson(isAddAPerson);
        detailsForm.setNewIncomeTestInd(true);
        Person person = this.getSelectedPerson(request);
        Integer incomeYear = this.getSelectedIncomeYear(request);
        detailsForm.setIncomeYear(String.valueOf(incomeYear));
        this.getPersonName(person, detailsForm);
        return mapping.findForward(FORWARD_FINANCIAL_DETAILS_ADD);
    }

    @Override
    protected ActionForward handleOptimisticLockException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        form.reset(mapping, request);
        return this.display(mapping, form, request, response);
    }

    public ActionForward add(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialDetailsForm detailsForm = this.getFinancialDetailsForm(form);
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        detailsForm.setAddAPerson(isAddAPerson);
        Person person = this.getSelectedPerson(request);
        Integer incomeYear = this.getSelectedIncomeYear(request);
        detailsForm.setIncomeYear(String.valueOf(incomeYear));
        if (this.conversionService != null) {
            Person clonePerson = (Person)person.clone();
            this.conversionService.convert((Object)detailsForm, (Object)clonePerson);
            if (isAddAPerson) {
                this.updateSelectedPerson(request, clonePerson);
            } else {
                Person updatedPerson = this.invokeUpdateFinancialAssessment(detailsForm, incomeYear, clonePerson);
                this.updateSelectedPerson(request, updatedPerson);
            }
        }
        return mapping.findForward("financialSummary");
    }

    public ActionForward reviewImpact(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FinancialDetailsForm detailsForm = this.getFinancialDetailsForm(form);
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        detailsForm.setAddAPerson(isAddAPerson);
        Person person = this.getSelectedPerson(request);
        Integer incomeYear = this.getSelectedIncomeYear(request);
        detailsForm.setIncomeYear(String.valueOf(incomeYear));
        if (this.conversionService != null) {
            Person calPerson;
            Person clonePerson = (Person)person.clone();
            this.conversionService.convert((Object)detailsForm, (Object)clonePerson);
            this.setUpdatedPerson(request, clonePerson);
            if (!isAddAPerson && (calPerson = this.invokeAssessReviewImpact(detailsForm, incomeYear, clonePerson)) != null) {
                SessionManager.setCalculatedPerson(request, calPerson);
            }
        }
        return mapping.findForward("finacialReviewImpactDisplay");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("financialSummary");
    }

    protected Map getKeyMethodMap() {
        if (this.keyMethodMap == null) {
            this.keyMethodMap = new HashMap();
            this.keyMethodMap.put("button.addIncomeTest", "display");
            this.keyMethodMap.put("button.addTest", "add");
            this.keyMethodMap.put("button.cancel", "cancel");
            this.keyMethodMap.put("button.reviewImpact", "reviewImpact");
            this.keyMethodMap.put("button.display", "display");
        }
        return this.keyMethodMap;
    }

    private void getPersonName(Person person, FinancialDetailsForm form) {
        HashSet otherNames = new HashSet(person.getNames());
        Name name = Name.getNameOfType(otherNames, (String)NameType.LEGAL_NAME.getName());
        if (name != null) {
            StringBuffer displayName = new StringBuffer(name.getGivenName());
            displayName.append(" ");
            displayName.append(name.getFamilyName());
            form.setName(displayName.toString());
        }
    }
}

