/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.facility.beans;

import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.ui.facility.beans.FeeBasisProgramBean;
import gov.va.med.fw.model.AbstractEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;

public class FacilityBean
extends AbstractEntity
implements Serializable,
Comparable {
    private static final long serialVersionUID = 6997222544997858141L;
    private Boolean primaryTestFacility = Boolean.FALSE;
    private Boolean preferredFacility = Boolean.FALSE;
    private List feeBasisInfoList = null;
    private List patientVisitSummaries = null;
    private VAFacility vaFacility = null;

    public FacilityBean() {
    }

    public FacilityBean(VAFacility vaFacility) {
        this.vaFacility = vaFacility;
    }

    public List getFeeBasisInfo() {
        return this.feeBasisInfoList;
    }

    public void setFeeBasisInfo(List feeBasisInfoList) {
        this.feeBasisInfoList = feeBasisInfoList;
    }

    public void addFeeBasis(FeeBasisProgramBean feeBasisProgramBean) {
        if (this.feeBasisInfoList == null) {
            this.feeBasisInfoList = new ArrayList();
        }
        this.feeBasisInfoList.add(feeBasisProgramBean);
    }

    public List getPatientVisitSummaries() {
        if (this.patientVisitSummaries != null && this.patientVisitSummaries.size() > 1) {
            Comparator comparator = new Comparator(){

                public int compare(Object obj1, Object obj2) {
                    PatientVisitSummary summary1 = (PatientVisitSummary)obj1;
                    PatientVisitSummary summary2 = (PatientVisitSummary)obj2;
                    int order = FacilityBean.this.compareTo(summary1.getIncomeYear(), summary2.getIncomeYear());
                    return order == 0 ? FacilityBean.this.compareTo(summary1.getLastVisitDate(), summary2.getLastVisitDate()) : order;
                }
            };
            Collections.sort(this.patientVisitSummaries, comparator);
        }
        return this.patientVisitSummaries;
    }

    public void setPatientVisitSummaries(List patientVisitSummaries) {
        this.patientVisitSummaries = patientVisitSummaries;
    }

    public void addPatientVisitSummary(PatientVisitSummary patientVisitSummary) {
        if (this.patientVisitSummaries == null) {
            this.patientVisitSummaries = new ArrayList();
        }
        this.patientVisitSummaries.add(patientVisitSummary);
    }

    public VAFacility getVaFacility() {
        return this.vaFacility;
    }

    public void setVaFacility(VAFacility vaFacility) {
        this.vaFacility = vaFacility;
    }

    public Boolean getPreferredFacility() {
        return this.preferredFacility;
    }

    public void setPreferredFacility(Boolean preferredFacility) {
        this.preferredFacility = preferredFacility;
    }

    public Boolean getPrimaryTestFacility() {
        return this.primaryTestFacility;
    }

    public void setPrimaryTestFacility(Boolean primaryTestFacility) {
        this.primaryTestFacility = primaryTestFacility;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        if (Boolean.TRUE.equals(this.preferredFacility)) {
            return 1;
        }
        if (!(o instanceof FacilityBean)) {
            return 1;
        }
        FacilityBean targetBean = (FacilityBean)o;
        return this.compareTo(this.getLastVisitDate(), targetBean.getLastVisitDate());
    }

    protected Date getLastVisitDate() {
        if (this.patientVisitSummaries != null && this.patientVisitSummaries.size() > 0) {
            List visitSummaries = this.getPatientVisitSummaries();
            PatientVisitSummary patientVisitSummary = (PatientVisitSummary)visitSummaries.get(0);
            return patientVisitSummary.getLastVisitDate();
        }
        return null;
    }

    protected void buildToString(ToStringBuilder arg0) {
    }

    private int compareTo(Integer obj1, Integer obj2) {
        if (obj1 != null) {
            if (obj2 != null) {
                return obj1.compareTo(obj2);
            }
            return 1;
        }
        return obj2 == null ? 0 : 1;
    }

    protected int compareTo(Date date1, Date date2) {
        if (date1 != null) {
            if (date2 != null) {
                return date1.compareTo(date2);
            }
            return 1;
        }
        return date2 == null ? 0 : 1;
    }
}

