/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.facility.action;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.MessagingService;
import gov.va.med.esr.ui.common.action.PersonAbstractAction;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.facility.action.SendQueryMessageZ07Form;
import gov.va.med.esr.ui.util.SessionManager;
import gov.va.med.fw.service.ServiceConfigurationException;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class SendQueryMessageZ07Action
extends PersonAbstractAction {
    public static final String FORWARD_SEND_QUERY_MESSAGE_Z07 = "sendQueryMessageZ07";
    public static final String FORWARD_SEND_BROKER_QUERY_MESSAGE = "sendMsdsQueryMessage";
    public static final String FORWARD_FACILITY = "facility";
    public static final String FORWARD_FACILITY_SENT_SUCCESSFULLY = "facility.sent.successfully";
    public static final String FORWARD_FACILITY_NO_FACILITY = "facility.no.facility";

    public void afterPropertiesSet() {
    }

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SendQueryMessageZ07Form z07Form = this.getSendQueryMessageZ07Form(form);
        Person person = this.getSelectedPerson(request);
        List siteList = SessionManager.getQRYZ07FacilityList(request);
        if (siteList == null) {
            MessagingService messagingService = this.getMessagingService();
            Set siteIdentities = messagingService.findSitesOfRecord(person);
            ArrayList<VAFacility> sites = new ArrayList<VAFacility>();
            for (SiteIdentity siteIdentity : siteIdentities) {
                VAFacility vaFacility = siteIdentity.getVaFacility();
                sites.add(vaFacility);
            }
            if (sites.isEmpty()) {
                return mapping.findForward(FORWARD_FACILITY_NO_FACILITY);
            }
            SessionManager.setQRYZ07FacilityList(request, sites);
        }
        if (StringUtils.isBlank((String)z07Form.getIncomeYear())) {
            z07Form.setIncomeYear(String.valueOf(DateUtils.getCurrentYear()));
        }
        return mapping.findForward(FORWARD_SEND_QUERY_MESSAGE_Z07);
    }

    public ActionForward reset(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SendQueryMessageZ07Form z07Form = this.getSendQueryMessageZ07Form(form);
        z07Form.reset(mapping, request);
        return this.display(mapping, form, request, response);
    }

    public ActionForward sendMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SendQueryMessageZ07Form z07Form = this.getSendQueryMessageZ07Form(form);
        Person person = this.getSelectedPerson(request);
        LookupService lookupService = this.getLookupService();
        VAFacility facility = lookupService.getVaFacilityByCode(z07Form.getSite());
        MessagingService messagingService = this.getMessagingService();
        messagingService.triggerQRYZ07(person, facility, new Integer(z07Form.getIncomeYear()));
        return mapping.findForward(FORWARD_FACILITY_SENT_SUCCESSFULLY);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(FORWARD_FACILITY);
    }

    protected SendQueryMessageZ07Form getSendQueryMessageZ07Form(ActionForm form) throws ServiceConfigurationException {
        SendQueryMessageZ07Form z07Form;
        SendQueryMessageZ07Form sendQueryMessageZ07Form = z07Form = form instanceof SendQueryMessageZ07Form ? (SendQueryMessageZ07Form)form : null;
        if (z07Form == null) {
            throw new ServiceConfigurationException("SendQueryMessageZ07Form not properly configured.");
        }
        return z07Form;
    }

    public ActionForward sendBrokerMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person person = this.getSelectedPerson(request);
        MessagingService messagingService = this.getMessagingService();
        messagingService.processTriggerBroker(person);
        return mapping.findForward(FORWARD_FACILITY_SENT_SUCCESSFULLY);
    }

    public ActionForward displayConfirmation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(FORWARD_SEND_BROKER_QUERY_MESSAGE);
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.send", "sendMessage");
        map.put("button.cancel", "cancel");
        map.put("button.reset", "reset");
        map.put("link.name.sendQueryZ07", "display");
        map.put("button.confirm", "sendBrokerMessage");
        map.put("link.name.sendMsdsQuery", "displayConfirmation");
        return map;
    }
}

