/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.facility.action;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.ArchivedMessageLogEntry;
import gov.va.med.esr.ui.common.action.PersonAbstractAction;
import gov.va.med.esr.ui.facility.action.FacilityConstants;
import gov.va.med.esr.ui.message.action.MessageSearchForm;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import gov.va.med.fw.ui.valuelist.MaxRecordsExceededValueListException;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.mlw.vlh.ValueList;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class HL7MessageAction
extends PersonAbstractAction
implements FacilityConstants {
    public ActionForward chooseDisplayMessages(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        HttpSession session = request.getSession();
        forward = session.getAttribute("selectedMessage") != null && session.getAttribute("selectedMessage").getClass().equals(ArchivedMessageLogEntry.class) ? this.displayArchivedMessages(mapping, actionForm, request, response) : this.displayMessages(mapping, actionForm, request, response);
        return forward;
    }

    public ActionForward displayMessages(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String selectedSiteId;
        HttpSession session = request.getSession();
        if (session.getAttribute("selectedMessage") != null) {
            session.removeAttribute("selectedMessage");
        }
        ActionForward forward = StringUtils.isNotEmpty((String)(selectedSiteId = request.getParameter("selectedSiteId"))) ? mapping.findForward("siteMessages") : mapping.findForward("messages");
        try {
            MessageSearchForm form = (MessageSearchForm)actionForm;
            form.clear();
            form.setPersonId(this.getSelectedPersonId(request));
            if (StringUtils.isNotEmpty((String)selectedSiteId)) {
                form.setFacility(selectedSiteId);
                VAFacility facility = (VAFacility)this.getLookupCacheService().getByCodeFromCache(VAFacility.class, selectedSiteId);
                request.setAttribute("selectedSiteId", (Object)selectedSiteId);
                request.setAttribute("selectedSite", (Object)facility);
            }
            ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)"messageSearchTableId", (String)"veteranMessageSearchAdapter");
            ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
            if (valueList == null || !valueList.hasNext()) {
                forward = mapping.findForward("facility");
                this.addInformationMessage(request, "errors.search.noresult");
            }
        }
        catch (MaxRecordsExceededValueListException ex) {
            this.addActionMessage(request, new ActionMessage("errors.max.records.exceeded", (Object)new Integer(ex.getTotalRecords()), (Object)new Integer(ex.getRecordLimit())));
        }
        return forward;
    }

    public ActionForward displayArchivedMessages(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String selectedSiteId;
        HttpSession session = request.getSession();
        if (session.getAttribute("selectedMessage") != null) {
            session.removeAttribute("selectedMessage");
        }
        ActionForward forward = StringUtils.isNotEmpty((String)(selectedSiteId = request.getParameter("selectedSiteId"))) ? mapping.findForward("siteMessages") : mapping.findForward("archivedMessages");
        try {
            MessageSearchForm form = (MessageSearchForm)actionForm;
            form.clear();
            form.setPersonId(this.getSelectedPersonId(request));
            if (StringUtils.isNotEmpty((String)selectedSiteId)) {
                form.setFacility(selectedSiteId);
                VAFacility facility = (VAFacility)this.getLookupCacheService().getByCodeFromCache(VAFacility.class, selectedSiteId);
                request.setAttribute("selectedSiteId", (Object)selectedSiteId);
                request.setAttribute("selectedSite", (Object)facility);
            }
            ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)"archivedMessageSearchTableId", (String)"archivedMessageSearchAdapter");
            ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
            if (valueList == null || !valueList.hasNext()) {
                forward = mapping.findForward("facility");
                this.addInformationMessage(request, "errors.search.noresult");
            }
        }
        catch (MaxRecordsExceededValueListException ex) {
            this.addActionMessage(request, new ActionMessage("errors.max.records.exceeded", (Object)new Integer(ex.getTotalRecords()), (Object)new Integer(ex.getRecordLimit())));
        }
        return forward;
    }

    public ActionForward retransmit(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String selectedMsgId;
        String messageLogId = request.getParameter("selectedMsgId");
        if (StringUtils.isNotEmpty((String)messageLogId)) {
            this.getMessagingService().triggerRetransmission(new BigDecimal(messageLogId));
            this.addInformationMessage(request, "message.sent.successfully");
        }
        if (StringUtils.isNotEmpty((String)(selectedMsgId = request.getParameter("selectedSiteId")))) {
            request.setAttribute("selectedSiteId", (Object)selectedMsgId);
        }
        return this.displayMessages(mapping, actionForm, request, response);
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("link.displayMessages", "displayMessages");
        map.put("link.displayArchivedMessages", "displayArchivedMessages");
        map.put("buttom.retransmit", "retransmit");
        map.put("link.displayChooseMessages", "chooseDisplayMessages");
        return map;
    }

    public void afterPropertiesSet() throws Exception {
        Validate.notNull((Object)this.getMessagingService(), (String)"Missing required messaging service");
    }
}

