/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.facility.action;

import gov.va.med.esr.common.model.SiteYear;
import gov.va.med.esr.common.model.ee.FeeBasis;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.action.PersonAbstractAction;
import gov.va.med.esr.ui.facility.action.FacilityConstants;
import gov.va.med.esr.ui.facility.beans.FacilityBean;
import gov.va.med.esr.ui.facility.beans.FeeBasisProgramBean;
import gov.va.med.esr.ui.message.action.MessageSearchForm;
import gov.va.med.esr.ui.util.SessionManager;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mlw.vlh.ValueList;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class FacilityAction
extends PersonAbstractAction
implements FacilityConstants {
    public void afterPropertiesSet() {
    }

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person person = this.getSelectedPerson(request);
        List facilities = this.convert(person);
        if (facilities != null && facilities.size() > 0) {
            request.setAttribute("facilitys", (Object)facilities);
            ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)"facilityTableId", (String)"facilityValueListAdapter", (List)facilities);
            ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
        }
        MessageSearchForm facilityForm = form instanceof MessageSearchForm ? (MessageSearchForm)form : null;
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        if (facilityForm != null) {
            facilityForm.setAddAPerson(isAddAPerson);
        }
        return mapping.findForward("success");
    }

    private List convert(Person person) {
        Set feeBasisSet;
        HashMap<VAFacility, FacilityBean> facilities = new HashMap<VAFacility, FacilityBean>();
        Map patientVisits = person.getPatientVisitSummaries();
        VAFacility preferredFacility = person.getMostRecentPreferredFacility();
        if (preferredFacility != null) {
            FacilityBean facilityBean = new FacilityBean(preferredFacility);
            facilityBean.setPreferredFacility(Boolean.TRUE);
            facilities.put(preferredFacility, facilityBean);
        }
        IncomeTest incomeTest = this.getPersonHelperService().getCurrentIncomeTest(person);
        VAFacility siteConductingTest = null;
        if (incomeTest != null && (siteConductingTest = incomeTest.getSiteConductingTest()) != null) {
            FacilityBean facilityBean = (FacilityBean)facilities.get(siteConductingTest);
            if (facilityBean == null) {
                facilityBean = new FacilityBean(siteConductingTest);
            }
            facilityBean.setPrimaryTestFacility(Boolean.TRUE);
            facilities.put(siteConductingTest, facilityBean);
        }
        if ((feeBasisSet = person.getFeeBasis()) != null && feeBasisSet.size() > 0) {
            for (FeeBasis feeBasis : feeBasisSet) {
                VAFacility reportSite = feeBasis != null ? feeBasis.getReportSite() : null;
                if (reportSite == null) continue;
                FacilityBean facilityBean = (FacilityBean)facilities.get(reportSite);
                if (facilityBean == null) {
                    facilityBean = new FacilityBean(reportSite);
                    facilities.put(reportSite, facilityBean);
                }
                FeeBasisProgramBean feeBasisBean = new FeeBasisProgramBean();
                feeBasisBean.setName(feeBasis.getProgram() != null ? feeBasis.getProgram().getDescription() : null);
                feeBasisBean.setTreatmentType(feeBasis.getTreatmentType() != null ? feeBasis.getTreatmentType().getDescription() : null);
                feeBasisBean.setAuthorizationFrom(feeBasis.getAuthorizationFromDate());
                feeBasisBean.setAuthorizationTo(feeBasis.getAuthorizationToDate());
                feeBasisBean.setReportDate(feeBasis.getReportDate());
                facilityBean.addFeeBasis(feeBasisBean);
            }
        }
        Set facilityKeys = patientVisits.keySet();
        for (SiteYear siteYear : facilityKeys) {
            if (siteYear == null) continue;
            PatientVisitSummary patientVisitSummary = (PatientVisitSummary)patientVisits.get(siteYear);
            VAFacility facility = siteYear.getFacility();
            FacilityBean facilityBean = (FacilityBean)facilities.get(facility);
            if (facilityBean == null) {
                facilityBean = new FacilityBean(facility);
            }
            facilities.put(facility, facilityBean);
            facilityBean.addPatientVisitSummary(patientVisitSummary);
        }
        ArrayList sortedList = new ArrayList(facilities.values());
        Collections.sort(sortedList);
        return sortedList;
    }
}

