/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.egt.action;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.ui.egt.action.EGTSettingAction;
import gov.va.med.esr.ui.egt.action.EGTSettingInfoForm;
import gov.va.med.fw.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EGTSettingUpdateAction
extends EGTSettingAction {
    @Override
    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EGTSettingInfoForm egtForm = this.getScreenSpecificForm(form);
        String egtSettingId = egtForm.getEgtSettingId();
        if (StringUtils.isEmpty((String)egtSettingId)) {
            throw new Exception("EGT Setting ID must not be null.");
        }
        EGTSetting egtSetting = this.getEGTSettingByEntityKey(request, CommonEntityKeyFactory.createEGTSettingEntityKey((String)egtSettingId));
        if (egtSetting == null) {
            throw new Exception("Unable to obtain EGT Setting from Session with ID: " + egtSettingId);
        }
        this.conversionService.convert((Object)egtSetting, (Object)egtForm);
        return mapping.findForward("display");
    }

    public ActionForward updateEGTSetting(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.updateEGTSettingImpl(mapping, form, request, response, false);
        return mapping.findForward("overviewWithUpdateMessage");
    }

    public ActionForward disableEGTSetting(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.updateEGTSettingImpl(mapping, form, request, response, true);
        return mapping.findForward("overviewWithDisableMessage");
    }

    public void updateEGTSettingImpl(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, boolean disableEgtSetting) throws Exception {
        EGTSettingInfoForm egtForm = this.getScreenSpecificForm(form);
        String egtSettingId = egtForm.getEgtSettingId();
        if (StringUtils.isEmpty((String)egtSettingId)) {
            throw new Exception("EGT Setting ID must not be null.");
        }
        EGTSetting egtSetting = this.getEGTSettingByEntityKey(request, CommonEntityKeyFactory.createEGTSettingEntityKey((String)egtSettingId));
        if (egtSetting == null) {
            throw new Exception("Unable to obtain EGT Setting from Session with ID: " + egtSettingId);
        }
        EGTSetting updatedEGTSetting = (EGTSetting)egtSetting.clone();
        if (!disableEgtSetting) {
            this.getConversionService().convert((Object)egtForm, (Object)updatedEGTSetting);
        }
        updatedEGTSetting.setDisable(new Boolean(disableEgtSetting));
        this.getEgtService().updateEGTSetting(updatedEGTSetting);
    }

    @Override
    protected Map getKeyMethodMap() {
        Map map = super.getKeyMethodMap();
        map.put("button.update", "updateEGTSetting");
        map.put("button.disable", "disableEGTSetting");
        map.put("button.display", "display");
        return map;
    }
}

