/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.egt.action;

import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.lookup.EGTSettingType;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.esr.ui.egt.action.EGTSettingInfoForm;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.util.StringUtils;
import java.util.Date;

public class EGTSettingConversionService
extends UIConversionServiceImpl {
    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        EGTSetting egtSetting = null;
        EGTSettingInfoForm form = null;
        if (source instanceof EGTSetting) {
            egtSetting = (EGTSetting)source;
            if (!(target instanceof EGTSettingInfoForm)) {
                throw new ConversionServiceException("Target object is of type " + target.getClass().getName() + " and must be of type EGTSettingInfoForm.");
            }
            form = (EGTSettingInfoForm)((Object)target);
            this.convertBusinessObjectToForm(egtSetting, form);
        } else if (source instanceof EGTSettingInfoForm) {
            form = (EGTSettingInfoForm)((Object)source);
            if (!(target instanceof EGTSetting)) {
                throw new ConversionServiceException("Target object is of type " + target.getClass().getName() + " and must be of type EGTSetting.");
            }
            egtSetting = (EGTSetting)target;
            this.convertFormToBusinessObject(form, egtSetting);
        } else {
            throw new ConversionServiceException("Source object is of type " + target.getClass().getName() + " and must be of type EGTSetting or EGTSettingInfoForm.");
        }
    }

    protected void convertBusinessObjectToForm(EGTSetting egtSetting, EGTSettingInfoForm form) throws ConversionServiceException {
        try {
            form.setEgtSettingId(egtSetting.getEntityKey().getKeyValueAsString());
            form.setEgtType(egtSetting.getType() != null ? egtSetting.getType().getCode() : null);
            form.setEgtPriorityGroup(egtSetting.getPriorityGroup() != null ? egtSetting.getPriorityGroup().getCode() : null);
            form.setEgtPrioritySubGroup(egtSetting.getPrioritySubGroup() != null ? egtSetting.getPrioritySubGroup().getCode() : null);
            form.setEgtEffectiveDate(DateUtils.format((Date)egtSetting.getEffectiveDate(), null));
            form.setFederalRegisterDate(DateUtils.format((Date)egtSetting.getFederalRegisterDate(), null));
            form.setComments(egtSetting.getComments());
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Unable to convert EGTSetting to EGTSettingInfoForm.", ex);
        }
    }

    protected void convertFormToBusinessObject(EGTSettingInfoForm form, EGTSetting egtSetting) throws ConversionServiceException {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        try {
            egtSetting.setType((EGTSettingType)lookupCacheService.getByCodeFromCache(EGTSettingType.class, form.getEgtType()));
            egtSetting.setPriorityGroup((EnrollmentPriorityGroup)lookupCacheService.getByCodeFromCache(EnrollmentPriorityGroup.class, form.getEgtPriorityGroup()));
            egtSetting.setPrioritySubGroup((EnrollmentPrioritySubGroup)lookupCacheService.getByCodeFromCache(EnrollmentPrioritySubGroup.class, form.getEgtPrioritySubGroup()));
            egtSetting.setEffectiveDate(DateUtils.getDate((String)form.getEgtEffectiveDate()));
            egtSetting.setFederalRegisterDate(DateUtils.getDate((String)form.getFederalRegisterDate()));
            egtSetting.setComments(StringUtils.isBlank((String)form.getComments()) ? null : form.getComments());
            egtSetting.setDisable(Boolean.FALSE);
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Unable to convert EGTSettingInfoForm to EGTSetting.", ex);
        }
    }
}

