/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.egt.action;

import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.esr.ui.egt.action.EGTSettingInfoForm;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.service.ServiceConfigurationException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.DateComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EGTSettingAction
extends AbstractAction {
    public static final String FORWARD_EGT_SETTING_DISPLAY = "display";
    public static final String FORWARD_EGT_SETTING_OVERVIEW = "overview";
    public static final String FORWARD_EGT_SETTING_OVERVIEW_NO_REFRESH = "overviewNoRefresh";
    public static final String FORWARD_EGT_SETTING_OVERVIEW_WITH_STOP_MESSAGE = "overviewWithStopMessage";
    public static final String FORWARD_EGT_SETTING_OVERVIEW_WITH_NO_STOP_MESSAGE = "overviewWithNoStopMessage";
    public static final String FORWARD_EGT_SETTING_OVERVIEW_WITH_ADD_MESSAGE = "overviewWithAddMessage";
    public static final String FORWARD_EGT_SETTING_OVERVIEW_WITH_UPDATE_MESSAGE = "overviewWithUpdateMessage";
    public static final String FORWARD_EGT_SETTING_OVERVIEW_WITH_DISABLE_MESSAGE = "overviewWithDisableMessage";

    public void afterPropertiesSet() {
    }

    protected EGTSettingInfoForm getScreenSpecificForm(ActionForm form) throws ServiceConfigurationException {
        EGTSettingInfoForm specificForm;
        EGTSettingInfoForm eGTSettingInfoForm = specificForm = form instanceof EGTSettingInfoForm ? (EGTSettingInfoForm)form : null;
        if (specificForm == null) {
            throw new ServiceConfigurationException("EGTSettingInfoForm not properly configured.");
        }
        return specificForm;
    }

    protected List sortEGTSettings(Set egtSettings) {
        if (egtSettings == null) {
            return null;
        }
        ArrayList egtSettingsList = new ArrayList(egtSettings);
        Collections.sort(egtSettingsList, new BeanComparator("effectiveDate", (Comparator)new DateComparator()));
        return egtSettingsList;
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(FORWARD_EGT_SETTING_OVERVIEW_NO_REFRESH);
    }

    public ActionForward reset(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EGTSettingInfoForm egtForm = this.getScreenSpecificForm(form);
        String egtSettingId = egtForm.getEgtSettingId();
        egtForm.reset(mapping, request);
        egtForm.setEgtSettingId(egtSettingId);
        return this.display(mapping, form, request, response);
    }

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        throw new Exception("Action called a method which required a display method that wasn't implemented.");
    }

    protected void refreshEGTSettings(HttpServletRequest request) throws ServiceException {
        this.setCurrentEGTSetting(request, this.getEgtService().getCurrentEGTSetting());
        this.setFutureEGTSettings(request, this.sortEGTSettings(this.getEgtService().getFutureEGTSettings()));
    }

    protected EGTSetting getEGTSettingByEntityKey(HttpServletRequest request, EntityKey entityKey) {
        EGTSetting egtSetting2 = this.getCurrentEGTSetting(request);
        if (egtSetting2 != null && egtSetting2.getEntityKey().equals(entityKey)) {
            return egtSetting2;
        }
        List egtSettings = this.getFutureEGTSettings(request);
        if (egtSettings != null) {
            for (EGTSetting egtSetting2 : egtSettings) {
                if (!egtSetting2.getEntityKey().equals(entityKey)) continue;
                return egtSetting2;
            }
        }
        return null;
    }

    protected void setCurrentEGTSetting(HttpServletRequest request, EGTSetting egtSetting) {
        this.putSandboxEntry(request, "currentEGTSetting", egtSetting);
    }

    protected EGTSetting getCurrentEGTSetting(HttpServletRequest request) {
        return (EGTSetting)this.getSandboxEntry(request, "currentEGTSetting");
    }

    protected void setFutureEGTSettings(HttpServletRequest request, List egtSettings) {
        this.putSandboxEntry(request, "futureEGTSettings", egtSettings);
    }

    protected List getFutureEGTSettings(HttpServletRequest request) {
        return (List)this.getSandboxEntry(request, "futureEGTSettings");
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.cancel", "cancel");
        map.put("button.reset", "reset");
        map.put("button.clear", "reset");
        return map;
    }
}

