/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.ee.action;

import gov.va.med.esr.common.model.ee.Decoration;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.PurpleHeartDocument;
import gov.va.med.esr.common.model.lookup.PHDataSource;
import gov.va.med.esr.common.model.lookup.PHDocumentType;
import gov.va.med.esr.common.model.lookup.RejectionRemark;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.esr.ui.ee.action.PurpleHeartForm;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

public class PurpleHeartConversionService
extends UIConversionServiceImpl {
    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        if (source instanceof Person && target instanceof PurpleHeartForm) {
            this.convertPersonToForm((Person)source, (PurpleHeartForm)((Object)target));
        } else if (target instanceof Person && source instanceof PurpleHeartForm) {
            this.convertFormToPerson((PurpleHeartForm)((Object)source), (Person)target);
        } else {
            throw new ConversionServiceException("Can not conver from " + source.getClass().getName() + " to " + target.getClass().getName());
        }
    }

    private void convertPersonToForm(Person person, PurpleHeartForm form) throws ConversionServiceException {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        PurpleHeart ph = person.getPurpleHeart();
        if (ph != null) {
            form.setPurpleHeartStatus(ph.getStatus() == null ? null : ph.getStatus().getCode());
            form.setStatusUpdateDate(DateUtils.format((Date)ph.getStatusLastEditDate(), null));
            form.setFacility(ph.getFacility() == null ? null : ph.getFacility().getCode());
            form.setAssignedContactUser(ph.getAssignedContactUser());
            form.setRejectionRemark(ph.getRejectionRemark() == null ? null : ph.getRejectionRemark().getCode());
            form.setLastUpdateUserId(ph.getModifiedBy() == null ? null : ph.getModifiedBy().getName());
            form.setLastUpdateDate(ph.getModifiedOn() == null ? null : DateUtils.formatWithTime((Date)ph.getModifiedOn(), (String)"MM/dd/yyyy h:mm:ssa"));
            ArrayList documents = new ArrayList(ph.getDocuments());
            PurpleHeartDocument phDocument = null;
            if (documents.size() > 0) {
                Collections.sort(documents);
                PurpleHeartDocument document2 = null;
                for (PurpleHeartDocument document2 : documents) {
                    if (!Boolean.TRUE.equals(document2.getAcceptable())) continue;
                    phDocument = document2;
                    break;
                }
                if (phDocument == null) {
                    phDocument = (PurpleHeartDocument)documents.get(documents.size() - 1);
                }
                form.setCurrentDocId(phDocument.getEntityKey() == null ? null : phDocument.getEntityKey().getKeyValueAsString());
                form.setCurrentDocAcceptable(phDocument.getAcceptable() == null ? null : String.valueOf(phDocument.getAcceptable()));
                form.setCurrentDocUnacceptableRemarks(phDocument.getUnacceptableRemarks());
                form.setCurrentDocReceivedDate(DateUtils.format((Date)phDocument.getReceivedDate(), null));
                form.setCurrentDocLoginDate(DateUtils.format((Date)phDocument.getLoginDate(), null));
                PHDocumentType docType = phDocument.getDocumentType();
                PHDataSource dataSource = phDocument.getDataSource();
                form.setCurrentDocDocumentType(this.getLookupCode((Lookup)docType));
                form.setCurrentDocDataSource(this.getLookupCode((Lookup)dataSource));
            }
        }
        form.setNewDocLoginDate(DateUtils.format((Date)DateUtils.getCurrentDate(), null));
        form.setNewDocReceivedDate(DateUtils.format((Date)DateUtils.getCurrentDate(), null));
        form.setNewDocument(Boolean.FALSE);
    }

    private void convertFormToPerson(PurpleHeartForm form, Person person) throws ConversionServiceException {
        PurpleHeart ph = person.getPurpleHeart();
        String loggedInUserName = this.getLoggedInUser().getName();
        PurpleHeartDocument newDocument = null;
        String newLAS = null;
        if (Boolean.TRUE.equals(form.getNewDocument())) {
            newDocument = new PurpleHeartDocument();
            newDocument.setReceivedDate(DateUtils.getDate((String)form.getNewDocReceivedDate()));
            newDocument.setDocumentType((PHDocumentType)this.getLookup(PHDocumentType.class, form.getNewDocDocumentType()));
            newDocument.setDataSource((PHDataSource)this.getLookup(PHDataSource.class, form.getNewDocDataSource()));
            if (form.getNewDocAcceptable() == null || StringUtils.isEmpty((String)form.getNewDocAcceptable())) {
                newDocument.setAcceptable(null);
            } else {
                newDocument.setAcceptable(new Boolean(form.getNewDocAcceptable()));
            }
            newDocument.setUnacceptableRemarks(StringUtils.isBlank((String)form.getNewDocUnacceptableRemarks()) ? null : form.getNewDocUnacceptableRemarks());
            newDocument.setLoginDate(DateUtils.getCurrentDateTime());
            if (StringUtils.isNotEmpty((String)form.getNewAssignedContactUser())) {
                newLAS = form.getNewAssignedContactUser();
            }
        }
        if (ph == null && newDocument == null) {
            return;
        }
        if (ph == null) {
            ph = new PurpleHeart();
            ph.setAssignedContactUser(newLAS);
            ph.setStatusLastUpdateUser(loggedInUserName);
            ph.setStatusLastEditDate(DateUtils.getCurrentDate());
            ph.setFacility((VAFacility)this.getLookup(VAFacility.class, VAFacility.CODE_HEC.getCode()));
            person.addDecoration((Decoration)ph);
        } else if (newLAS != null) {
            ph.setAssignedContactUser(newLAS);
        } else if (StringUtils.isEmpty((String)form.getAssignedContactUser())) {
            ph.setAssignedContactUser(null);
        } else {
            ph.setAssignedContactUser(form.getAssignedContactUser());
        }
        ph.setRejectionRemark((RejectionRemark)this.getLookup(RejectionRemark.class, form.getRejectionRemark()));
        if (newDocument != null) {
            ph.addDocument(newDocument);
        }
        PurpleHeartDocument phDocument = null;
        String currentDocId = form.getCurrentDocId();
        if (StringUtils.isNotEmpty((String)currentDocId)) {
            EntityKey entityKey = EntityKeyFactory.createEntityKey((Serializable)new BigDecimal(currentDocId), PurpleHeartDocument.class);
            phDocument = ph.getDocumentByEntityKey(entityKey);
            if (phDocument == null) {
                throw new ConversionServiceException("Current Document could not be found");
            }
            if (StringUtils.isNotEmpty((String)form.getCurrentDocReceivedDate())) {
                phDocument.setReceivedDate(DateUtils.getDate((String)form.getCurrentDocReceivedDate()));
            }
            phDocument.setDocumentType((PHDocumentType)this.getLookup(PHDocumentType.class, form.getCurrentDocDocumentType()));
            phDocument.setDataSource((PHDataSource)this.getLookup(PHDataSource.class, form.getCurrentDocDataSource()));
            if (form.getCurrentDocAcceptable() == null || StringUtils.isEmpty((String)form.getCurrentDocAcceptable())) {
                phDocument.setAcceptable(null);
            } else {
                phDocument.setAcceptable(new Boolean(form.getCurrentDocAcceptable()));
            }
            phDocument.setUnacceptableRemarks(StringUtils.isBlank((String)form.getCurrentDocUnacceptableRemarks()) ? null : form.getCurrentDocUnacceptableRemarks());
        }
    }
}

