/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.ee.action;

import gov.va.med.esr.common.model.ee.HealthBenefitPlan;
import gov.va.med.esr.common.model.ee.HealthBenefitProfile;
import gov.va.med.esr.common.model.lookup.DataChangeSource;
import gov.va.med.esr.common.model.lookup.HealthBenefitPlanType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.esr.ui.ee.action.HealthBenefitPlanForm;
import gov.va.med.fw.conversion.ConversionServiceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class HealthBenefitPlanConversionService
extends UIConversionServiceImpl {
    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        if (source instanceof Person && target instanceof HealthBenefitPlanForm) {
            try {
                this.convert((Person)source, (HealthBenefitPlanForm)((Object)target));
            }
            catch (Exception ex) {
                throw new ConversionServiceException("Conversion Failed", ex);
            }
        } else if (source instanceof HealthBenefitPlanForm && target instanceof Person) {
            try {
                this.convert((HealthBenefitPlanForm)((Object)source), (Person)target);
            }
            catch (Exception ex) {
                throw new ConversionServiceException("Conversion Failed", ex);
            }
        } else {
            throw new ConversionServiceException("Type mismatch: Expecting Person, HealthBenefitPlansForm Received " + source.getClass().getName() + " and " + target.getClass().getName());
        }
    }

    private void convert(Person person, HealthBenefitPlanForm form) throws Exception {
        boolean isNotEditable;
        String code;
        HealthBenefitProfile hbpProfile = person.getHealthBenefitProfile();
        if (hbpProfile != null) {
            ArrayList healthBenefitPlans = new ArrayList(hbpProfile.getHealthBenefitPlans());
            Collections.sort(healthBenefitPlans);
            int index = 0;
            for (HealthBenefitPlan hbp : healthBenefitPlans) {
                code = hbp.getPlanType().getCode();
                isNotEditable = HealthBenefitPlanType.CODE_PRESUMPTIVE.getCode().equalsIgnoreCase(code);
                form.setAssignedHbpCode(index, code);
                form.setAssignedHbpDesc(index, hbp.getPlanType().getName());
                form.setAssignedHbpInd(index, Boolean.TRUE);
                form.setAssignedHbpLastUpdatedDate(index, hbp.getChangeDate().toString());
                form.setAssignedHbpEditable(index, isNotEditable);
                ++index;
            }
        }
        Collection hbpTypes = this.getLookupCacheService().getFromCache(HealthBenefitPlanType.class.getName());
        int j = 0;
        for (HealthBenefitPlanType type : hbpTypes) {
            if (hbpProfile.getHealthBenefitPlanByType(type) != null) continue;
            code = type.getCode();
            isNotEditable = HealthBenefitPlanType.CODE_PRESUMPTIVE.getCode().equalsIgnoreCase(code);
            form.setHbpCode(j, code);
            form.setHbpDesc(j, type.getName());
            form.setHbpEditable(j, isNotEditable);
            ++j;
        }
    }

    private void convert(HealthBenefitPlanForm form, Person person) throws Exception {
        HealthBenefitPlanType planType;
        Boolean selected;
        int i;
        ArrayList<HealthBenefitPlanType> addList = new ArrayList<HealthBenefitPlanType>();
        List codeList = form.getAssignedHbpCodeList();
        if (codeList != null && codeList.size() > 0) {
            for (i = 0; i < codeList.size(); ++i) {
                selected = form.getAssignedHbpInd(i);
                planType = (HealthBenefitPlanType)this.getLookupCacheService().getByCodeFromCache(HealthBenefitPlanType.class, form.getAssignedHbpCode(i));
                if (!Boolean.TRUE.equals(selected)) continue;
                addList.add(planType);
            }
        }
        if ((codeList = form.getHbpCodeList()) != null && codeList.size() > 0) {
            for (i = 0; i < codeList.size(); ++i) {
                selected = form.getHbpInd(i);
                planType = (HealthBenefitPlanType)this.getLookupCacheService().getByCodeFromCache(HealthBenefitPlanType.class, form.getHbpCode(i));
                if (!Boolean.TRUE.equals(selected)) continue;
                addList.add(planType);
            }
        }
        ArrayList<HealthBenefitPlan> deleteList = new ArrayList<HealthBenefitPlan>();
        ArrayList originalList = new ArrayList(person.getHealthBenefitProfile().getHealthBenefitPlans());
        if (originalList != null && originalList.size() > 0) {
            for (int j = 0; j < originalList.size(); ++j) {
                HealthBenefitPlan plan = (HealthBenefitPlan)originalList.get(j);
                if (!addList.contains(plan.getPlanType())) {
                    deleteList.add(plan);
                }
                person.getHealthBenefitProfile().removeHealthBenefitPlans(deleteList);
            }
        }
        HealthBenefitProfile hbpProfile = person.getHealthBenefitProfile();
        for (HealthBenefitPlanType planType2 : addList) {
            if (hbpProfile.getHealthBenefitPlanByType(planType2) != null) continue;
            HealthBenefitPlan newPlan = new HealthBenefitPlan();
            newPlan.setPlanType(planType2);
            newPlan.setChangeDate(new Date());
            newPlan.setChangeSource((DataChangeSource)this.getLookupCacheService().getByCodeFromCache(DataChangeSource.class, DataChangeSource.CODE_ESR.getCode()));
            hbpProfile.addHealthBenefitPlan(newPlan);
        }
    }
}

