/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.ee.action;

import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.lookup.CancelDeclineNotProcessedReason;
import gov.va.med.esr.common.model.lookup.CancelDeclineReason;
import gov.va.med.esr.common.model.lookup.EnrollmentCategory;
import gov.va.med.esr.common.model.lookup.EnrollmentOverrideReason;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.esr.ui.ee.action.EligibilityEnrollmentConversionService;
import gov.va.med.esr.ui.ee.action.EnrollmentForm;
import gov.va.med.fw.conversion.ConversionServiceException;
import java.util.Date;

public class EnrollmentConversionService
extends EligibilityEnrollmentConversionService {
    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        this.log.trace((Object)"EnrollmentConversionService postProcessConvert() is called.");
        PersonHelperService helper = this.getPersonHelperService();
        if (source instanceof Person && target instanceof EnrollmentForm) {
            Person person = (Person)source;
            EnrollmentForm formBean = (EnrollmentForm)((Object)target);
            formBean.setTodayDate(JspUtils.displayValue((Object)new Date(), null));
            formBean.setDeathDate(JspUtils.displayValue((Object)(person.getDeathRecord() == null ? null : person.getDeathRecord().getDeathDate()), null));
            formBean.setBirthDate(JspUtils.displayValue((Object)(person.getBirthRecord() == null ? null : person.getBirthRecord().getBirthDate()), null));
            try {
                EnrollmentCategory category = helper.getEnrollmentCategory(person);
                EnrollmentDetermination enroll = helper.getEnrollmentDetermination(person);
                formBean.setEnrollCategory(category);
                formBean.setEnrollmentStatus(helper.getEnrollmentStatus(person));
                formBean.setEnrollmentDate(this.getEnrollDate(enroll));
                formBean.setEnrollmentEffDate(this.getEnrollEffDate(enroll));
                formBean.setEnrollmentPriority(EnrollmentConversionService.getEnrollmentPriority(enroll));
                formBean.setInitialEnrollmentPriority(EnrollmentConversionService.getInitialEnrollmentPriority(enroll));
                formBean.setEnrollmentEndDate(this.getEnrollEndDate(enroll));
                formBean.setPreferredFacility(person.getMostRecentPreferredFacility());
                formBean.setEnrollmentSource(this.getEnrollmentSource(enroll));
                formBean.setFacilityReceived(this.getFacilityReceived(enroll));
                formBean.setEGTPrioritySub(this.getEGTPriority(person));
                formBean.setEGTType(this.getEGTType(person));
                formBean.setApplicationDate(JspUtils.displayValue((Object)EnrollmentConversionService.getApplicationDate(person), null));
                formBean.setCanceledDeclinedIndicator(this.getCancelDeclineIndicator(person));
                formBean.setCanceledDeclinedIndicatorCurrent(this.getCancelDeclineIndicator(person));
                formBean.setEnrollCategoryCode(category != null ? category.getCode() : null);
                formBean.setCanceledDeclinedEffectiveDate(JspUtils.displayValue((Object)this.getCancelDeclineEffectiveDate(person), null));
                formBean.setCanceledDeclinedReason(this.getCancelDeclineReason(person));
                formBean.setCanceledDeclinedNotProcessedReason(this.getCancelDeclineNotProcessedReason(person));
                formBean.setCanceledDeclinedRemarks(this.getCancelDeclineRemarks(person));
                if (!this.getCancelDeclineIndicator(person).equalsIgnoreCase("Y") || !this.getCancelDeclineReason(person).equalsIgnoreCase("4")) {
                    formBean.setCanceledDeclinedRemarks("");
                }
                formBean.setEnrollmentOverride(this.getEnrollmentOverrideInd(person));
                formBean.setEnrollmentOverrideCurrent(this.getEnrollmentOverrideInd(person));
                formBean.setEnrollmentOverrideReason(this.getEnrollmentOverrideReason(person));
                formBean.setEnrollmentOverrideComment(this.getEnrollmentOverrideComment(person));
                formBean.setSignatureDate(JspUtils.displayValue((Object)this.getSignatureDate(person), null));
                formBean.setApplicationMethod(this.getApplicationMethod(person));
            }
            catch (Exception ex) {
                throw new ConversionServiceException("Conversion Failed", ex);
            }
        } else if (target instanceof Person && source instanceof EnrollmentForm) {
            LookupCacheService lookupCacheService = this.getLookupCacheService();
            Person person = (Person)target;
            EnrollmentForm formBean = (EnrollmentForm)((Object)source);
            try {
                this.setApplicationDate(person, formBean.getApplicationDate());
                this.setCancelDeclineIndicator(person, formBean.getCanceledDeclinedIndicator());
                this.setCancelDeclineEffectiveDate(person, formBean.getCanceledDeclinedEffectiveDate());
                this.setCancelDeclineReason(person, (CancelDeclineReason)lookupCacheService.getByCodeFromCache(CancelDeclineReason.class, formBean.getCanceledDeclinedReason()));
                this.setCancelDeclineNotProcessedReason(person, (CancelDeclineNotProcessedReason)lookupCacheService.getByCodeFromCache(CancelDeclineNotProcessedReason.class, formBean.getCanceledDeclinedNotProcessedReason()));
                this.setCancelDeclineRemarks(person, formBean.getCanceledDeclinedRemarks());
                if (!this.getCancelDeclineIndicator(person).equalsIgnoreCase("Y") || !this.getCancelDeclineReason(person).equalsIgnoreCase("4")) {
                    this.setCancelDeclineRemarks(person, "");
                }
                this.setEnrollmentOverrideInd(person, lookupCacheService, formBean.getEnrollmentOverride(), formBean.getEnrollmentOverrideCurrent());
                this.setEnrollmentOverrideReason(person, (EnrollmentOverrideReason)lookupCacheService.getByCodeFromCache(EnrollmentOverrideReason.class, formBean.getEnrollmentOverrideReason()));
                this.setEnrollmentOverrideComment(person, formBean.getEnrollmentOverrideComment());
                this.setSignatureDate(person, formBean.getSignatureDate());
                this.setApplicationMethod(person, lookupCacheService.getLookupService().getApplicationMethodByCode(formBean.getApplicationMethod()));
            }
            catch (Exception ex) {
                throw new ConversionServiceException("Conversion Failed", ex);
            }
        } else {
            throw new ConversionServiceException("Type mismatch: Expecting Person, EnrollmentForm Received " + source.getClass().getName() + " and " + target.getClass().getName());
        }
    }
}

