/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.ee.action;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.action.PersonAbstractAction;
import gov.va.med.esr.ui.ee.action.EnrollmentForm;
import gov.va.med.esr.ui.util.SessionManager;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EnrollmentAction
extends PersonAbstractAction {
    public static final String CANCEL_FORWARD = "cancel";
    public static final String SUCCESS_FORWARD = "success";
    public static final String DISPLAY_FORWARD = "display";

    public void afterPropertiesSet() {
        Validate.notNull((Object)this.getPersonService(), (String)"A person service is required");
        Validate.notNull((Object)this.getEnrollmentService(), (String)"An enrollment service is required");
    }

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EnrollmentForm enrollmentForm;
        EnrollmentForm enrollmentForm2 = enrollmentForm = form instanceof EnrollmentForm ? (EnrollmentForm)form : null;
        if (enrollmentForm != null) {
            enrollmentForm.setAddAPerson(SessionManager.isAddAPerson(request));
            Person person = this.getSelectedPerson(request);
            enrollmentForm.setPerson(person);
            this.conversionService.convert((Object)person, (Object)enrollmentForm);
        }
        return mapping.findForward(DISPLAY_FORWARD);
    }

    public ActionForward update(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EnrollmentForm enrollmentForm = form instanceof EnrollmentForm ? (EnrollmentForm)form : null;
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        if (enrollmentForm != null) {
            enrollmentForm.setAddAPerson(isAddAPerson);
            Person person = this.getSelectedPerson(request);
            Person updatePerson = (Person)person.clone();
            this.conversionService.convert((Object)enrollmentForm, (Object)updatePerson);
            if (!isAddAPerson) {
                updatePerson = this.getEnrollmentService().updateEnrollmentData(updatePerson);
            }
            this.updateSelectedPerson(request, updatePerson);
        }
        return mapping.findForward(SUCCESS_FORWARD);
    }

    @Override
    protected ActionForward handleOptimisticLockException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        form.reset(mapping, request);
        return this.display(mapping, form, request, response);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(CANCEL_FORWARD);
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.display", DISPLAY_FORWARD);
        map.put("button.update", "update");
        map.put("button.cancel", CANCEL_FORWARD);
        return map;
    }
}

