/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.ee.action;

import gov.va.med.esr.common.model.ee.RatedDisability;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.conversion.UIConversionService;
import gov.va.med.esr.ui.ee.action.EligibilityAction;
import gov.va.med.esr.ui.ee.action.EligibilityViewForm;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mlw.vlh.ValueList;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EligibilityViewAction
extends EligibilityAction {
    public void afterPropertiesSet() {
        Validate.notNull((Object)this.getPersonService(), (String)"A person service is required.");
        Validate.notNull((Object)this.getPersonHelperService(), (String)"A person helper service is required.");
    }

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.redisplay(mapping, form, request, response);
    }

    public ActionForward redisplay(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EligibilityViewForm eligibilityForm = form instanceof EligibilityViewForm ? (EligibilityViewForm)form : null;
        Person person = this.getSelectedPerson(request);
        if (eligibilityForm != null) {
            eligibilityForm.setPerson(person);
            UIConversionService uiConversionService = (UIConversionService)this.conversionService;
            uiConversionService.convert(person, (Object)eligibilityForm);
        }
        ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)"ratedDisabilitiesTableId", (String)"ratedDisabilitiesAdapter", (List)this.getRatedDisabilities(person));
        ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
        return mapping.findForward("success");
    }

    private List getRatedDisabilities(Person person) {
        ServiceConnectionAward scAward = person.getServiceConnectionAward();
        if (scAward != null && scAward.getRatedDisabilities() != null && scAward.getRatedDisabilities().size() > 0) {
            ArrayList<RatedDisability> results = new ArrayList<RatedDisability>();
            ArrayList disabilities = new ArrayList(scAward.getRatedDisabilities());
            for (RatedDisability ratedDisability : disabilities) {
                if (ratedDisability == null) continue;
                RatedDisability rdClone = (RatedDisability)ratedDisability.clone();
                results.add(rdClone);
            }
            return results;
        }
        return null;
    }

    public ActionForward editEligibility(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("success");
    }

    public ActionForward displayClinicalDeter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("success");
    }
}

