/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.ee.action;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.TriState;
import gov.va.med.esr.common.model.ee.AgentOrangeExposure;
import gov.va.med.esr.common.model.ee.Application;
import gov.va.med.esr.common.model.ee.CampLejeuneVerification;
import gov.va.med.esr.common.model.ee.CampLejeuneVerificationMethod;
import gov.va.med.esr.common.model.ee.CancelDecline;
import gov.va.med.esr.common.model.ee.Decoration;
import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.EnrollmentOverride;
import gov.va.med.esr.common.model.ee.EnvironmentalContaminationExposure;
import gov.va.med.esr.common.model.ee.IncompetenceRuling;
import gov.va.med.esr.common.model.ee.IneligibilityFactor;
import gov.va.med.esr.common.model.ee.MedicaidFactor;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.NoseThroatRadium;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.RadiationExposure;
import gov.va.med.esr.common.model.ee.RatedDisability;
import gov.va.med.esr.common.model.ee.ReceivedEligibility;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.ee.SpecialFactor;
import gov.va.med.esr.common.model.ee.SpinalCordInjury;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.lookup.AACIndicator;
import gov.va.med.esr.common.model.lookup.AgentOrangeExposureLocation;
import gov.va.med.esr.common.model.lookup.AlliedCountry;
import gov.va.med.esr.common.model.lookup.ApplicationMethod;
import gov.va.med.esr.common.model.lookup.CampLejeuneChangeSource;
import gov.va.med.esr.common.model.lookup.CampLejeuneVerificationType;
import gov.va.med.esr.common.model.lookup.CancelDeclineNotProcessedReason;
import gov.va.med.esr.common.model.lookup.CancelDeclineReason;
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.lookup.EligibilityVerificationSource;
import gov.va.med.esr.common.model.lookup.EnrollmentOverrideReason;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentSource;
import gov.va.med.esr.common.model.lookup.FederalAgency;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;
import gov.va.med.esr.common.model.lookup.RadiationExposureMethod;
import gov.va.med.esr.common.model.lookup.RejectionRemark;
import gov.va.med.esr.common.model.lookup.ServicePeriod;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.esr.ui.ee.action.EligibilityEditActionForm;
import gov.va.med.esr.ui.ee.beans.CancelDeclineNotProcessedReasonBean;
import gov.va.med.esr.ui.ee.beans.CancelDeclineReasonBean;
import gov.va.med.esr.ui.ee.beans.DisabilityBean;
import gov.va.med.esr.ui.util.ConvertUtils;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class EligibilityEnrollmentConversionService
extends UIConversionServiceImpl {
    public static final String EMPTY_STRING = "";

    public String getVeteranIndicator(Person person) {
        return ConvertUtils.convertYesNo(person.getVeteran());
    }

    public void setVeteranIndicator(Person person, String setYes) {
        person.setVeteran(ConvertUtils.convertBoolean(setYes));
    }

    public static EnrollmentDetermination getEnrollment(Person person) {
        return person.getEnrollmentDetermination();
    }

    public static String getEnrollmentPriority(Person person) {
        EnrollmentDetermination enroll = EligibilityEnrollmentConversionService.getEnrollment(person);
        return EligibilityEnrollmentConversionService.getEnrollmentPriority(enroll);
    }

    public static String getEnrollmentPriority(EnrollmentDetermination enroll) {
        if (enroll != null && enroll.getPriorityGroup() != null) {
            String priority = enroll.getPriorityGroup().getDescription();
            if (enroll.getPrioritySubGroup() != null) {
                priority = priority + enroll.getPrioritySubGroup().getDescription();
            }
            priority = priority.replaceAll("Enrollment Priority sub-Group", EMPTY_STRING);
            return priority.replaceAll("'", EMPTY_STRING);
        }
        return null;
    }

    public static String getInitialEnrollmentPriority(EnrollmentDetermination enroll) {
        if (enroll != null && enroll.getInitialPriorityGroup() != null) {
            String priority = enroll.getInitialPriorityGroup().getDescription();
            if (enroll.getInitialPrioritySubGroup() != null) {
                priority = priority + enroll.getInitialPrioritySubGroup().getDescription();
            }
            priority = priority.replaceAll("Enrollment Priority sub-Group", EMPTY_STRING);
            return priority.replaceAll("'", EMPTY_STRING);
        }
        return null;
    }

    public Date getEnrollDate(EnrollmentDetermination enroll) {
        if (enroll != null) {
            return enroll.getEnrollmentDate();
        }
        return null;
    }

    public Date getEnrollEffDate(EnrollmentDetermination enroll) {
        if (enroll != null) {
            return enroll.getEffectiveDate();
        }
        return null;
    }

    public Date getEnrollModifiedDate(Person person) {
        EnrollmentDetermination enrol = EligibilityEnrollmentConversionService.getEnrollment(person);
        if (enrol != null) {
            if (enrol.getModifiedOn() != null) {
                return enrol.getModifiedOn();
            }
            return new Date();
        }
        return null;
    }

    public static Date getApplicationDate(Person person) {
        Application application = person.getApplication();
        if (application != null) {
            return application.getApplicationDate();
        }
        return null;
    }

    public void setApplicationDate(Person person, Date appDate) {
        Application application = person.getApplication();
        if (application == null) {
            application = new Application();
            person.setApplication(application);
        }
        application.setApplicationDate(appDate);
    }

    public void setApplicationDate(Person person, String dateStr) {
        this.setApplicationDate(person, DateUtils.getDate((String)dateStr));
    }

    public Date getEnrollEndDate(EnrollmentDetermination enroll) {
        if (enroll != null) {
            return enroll.getEndDate();
        }
        return null;
    }

    public EnrollmentSource getEnrollmentSource(EnrollmentDetermination enroll) {
        if (enroll != null) {
            return enroll.getCalculationSource();
        }
        return null;
    }

    public VAFacility getFacilityReceived(EnrollmentDetermination enroll) {
        if (enroll != null) {
            return enroll.getFacilityReceived();
        }
        return null;
    }

    public String getEGTPriority(Person person) {
        EnrollmentDetermination enrol = EligibilityEnrollmentConversionService.getEnrollment(person);
        if (enrol != null && enrol.getEgtSetting() != null) {
            EnrollmentPrioritySubGroup subgroup;
            EnrollmentPriorityGroup group = enrol.getEgtSetting().getPriorityGroup();
            String priority = EMPTY_STRING;
            if (group != null) {
                priority = group.getDescription();
            }
            if ((subgroup = enrol.getEgtSetting().getPrioritySubGroup()) != null) {
                priority = priority + subgroup.getDescription();
            }
            priority = priority.replaceAll("Enrollment Priority sub-Group '", EMPTY_STRING);
            return priority.replaceAll("'", EMPTY_STRING);
        }
        return null;
    }

    public String getEGTType(Person person) {
        EnrollmentDetermination enrol = EligibilityEnrollmentConversionService.getEnrollment(person);
        if (enrol != null && enrol.getEgtSetting() != null) {
            return enrol.getEgtSetting().getType().getDescription();
        }
        return null;
    }

    public String getCancelDeclineIndicator(Person person) {
        CancelDecline cd = person.getCancelDecline();
        if (cd == null) {
            return "nd";
        }
        return ConvertUtils.convertYesNoNoData(cd.getCancelDeclineIndicator());
    }

    public void setCancelDeclineIndicator(Person person, String setYes) {
        if (setYes == null || setYes.equalsIgnoreCase("nd")) {
            person.setCancelDecline(null);
        } else {
            CancelDecline cd = person.getCancelDecline();
            if (cd == null) {
                cd = new CancelDecline();
            }
            cd.setCancelDeclineIndicator(ConvertUtils.convertBoolean(setYes));
            person.setCancelDecline(cd);
        }
    }

    public Date getCancelDeclineEffectiveDate(Person person) {
        CancelDecline cd = person.getCancelDecline();
        if (cd != null) {
            return cd.getEffectiveDate();
        }
        return null;
    }

    public void setCancelDeclineEffectiveDate(Person person, String dateStr) {
        CancelDecline cd = person.getCancelDecline();
        if (cd != null) {
            cd.setEffectiveDate(DateUtils.getDate((String)dateStr));
        }
    }

    public String getCancelDeclineReason(Person person) {
        CancelDecline cd = person.getCancelDecline();
        if (cd != null) {
            CancelDeclineReason cdr = cd.getReason();
            if (cdr != null) {
                return cdr.getCode();
            }
            return null;
        }
        return null;
    }

    public void setCancelDeclineReason(Person person, CancelDeclineReason reason) {
        CancelDecline cd = person.getCancelDecline();
        if (cd != null) {
            cd.setReason(reason);
        }
    }

    public void setCancelDeclineReason(Person person, Collection cancelDeclineReasonBeanList, String code) {
        CancelDecline cd = person.getCancelDecline();
        if (cd != null) {
            cd.setReason(null);
            if (code != null && cancelDeclineReasonBeanList != null) {
                Iterator it = cancelDeclineReasonBeanList.iterator();
                while (it != null && it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof CancelDeclineReasonBean) || !code.equals(((CancelDeclineReasonBean)obj).getcancelDeclineReasonCode())) continue;
                    cd.setReason(((CancelDeclineReasonBean)obj).getCancelDeclineReason());
                }
            }
        }
    }

    public String getCancelDeclineNotProcessedReason(Person person) {
        CancelDecline cd = person.getCancelDecline();
        if (cd != null) {
            CancelDeclineNotProcessedReason cdnpr = cd.getReasonNotProcessed();
            if (cdnpr != null) {
                return cdnpr.getCode();
            }
            return null;
        }
        return null;
    }

    public void setCancelDeclineNotProcessedReason(Person person, CancelDeclineNotProcessedReason reason) {
        CancelDecline cd = person.getCancelDecline();
        if (cd != null) {
            cd.setReasonNotProcessed(reason);
        }
    }

    public void setCancelDeclineNotProcessedReason(Person person, Collection cancelDeclineNotProcessedReasonList, String code) {
        CancelDecline cd = person.getCancelDecline();
        if (cd == null && code != null && !code.equals("0")) {
            cd = new CancelDecline();
            person.setCancelDecline(cd);
        }
        if (cd != null) {
            cd.setReasonNotProcessed(null);
            if (code != null && cancelDeclineNotProcessedReasonList != null) {
                Iterator it = cancelDeclineNotProcessedReasonList.iterator();
                while (it != null && it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof CancelDeclineNotProcessedReasonBean) || !code.equals(((CancelDeclineNotProcessedReasonBean)obj).getcancelDeclineNotProcessedReasonCode())) continue;
                    cd.setReasonNotProcessed(((CancelDeclineNotProcessedReasonBean)obj).getCancelDeclineNotProcessedReason());
                }
            }
        }
    }

    public String getCancelDeclineRemarks(Person person) {
        CancelDecline cd = person.getCancelDecline();
        if (cd != null) {
            return cd.getRemarks();
        }
        return null;
    }

    public void setCancelDeclineRemarks(Person person, String remarks) {
        CancelDecline cd = person.getCancelDecline();
        if (cd != null) {
            if (remarks == null || StringUtils.isEmpty((String)remarks)) {
                cd.setRemarks(null);
            } else {
                cd.setRemarks(remarks);
            }
        }
    }

    public EnrollmentOverride getEnrollmentOverride(Person person) {
        if (person != null) {
            return person.getEnrollmentOverride();
        }
        return null;
    }

    public String getEnrollmentOverrideInd(Person person) {
        Boolean or;
        EnrollmentOverride override = this.getEnrollmentOverride(person);
        if (override != null && (or = override.getOverride()) != null && or.booleanValue()) {
            return "y";
        }
        return "n";
    }

    public void setEnrollmentOverrideInd(Person person, LookupCacheService lookupCacheService, String setYes, String wasYes) throws Exception {
        if (setYes == null || !setYes.equalsIgnoreCase("y")) {
            person.setEnrollmentOverride(null);
        } else if (setYes != null && setYes.equalsIgnoreCase("y") && (wasYes == null || !wasYes.equalsIgnoreCase("y"))) {
            EnrollmentOverride eo = person.getEnrollmentOverride();
            if (eo == null) {
                eo = new EnrollmentOverride();
                person.setEnrollmentOverride(eo);
            }
            eo.setOverride(ConvertUtils.convertBoolean(setYes));
            SecurityContext securityContext = SecurityContextHelper.getSecurityContext();
            UserPrincipal user = securityContext.getUserPrincipal();
            if (user != null) {
                eo.setOverrideBy(user.getName());
            }
            eo.setOverrideDate(new Date());
        }
    }

    public String getEnrollmentOverrideReason(Person person) {
        EnrollmentOverride override = this.getEnrollmentOverride(person);
        if (override != null && override.getOverrideReason() != null) {
            return override.getOverrideReason().getCode();
        }
        return null;
    }

    public void setEnrollmentOverrideReason(Person person, EnrollmentOverrideReason reason) {
        EnrollmentOverride override = this.getEnrollmentOverride(person);
        if (override != null) {
            override.setOverrideReason(reason);
        }
    }

    public String getEnrollmentOverrideComment(Person person) {
        EnrollmentOverride override = this.getEnrollmentOverride(person);
        if (override != null) {
            return override.getOverrideComment();
        }
        return null;
    }

    public void setEnrollmentOverrideComment(Person person, String comment) {
        EnrollmentOverride override = this.getEnrollmentOverride(person);
        if (override != null) {
            override.setOverrideComment(comment);
        }
    }

    public Eligibility getPrimaryEligibility(Person person) {
        EnrollmentDetermination enrol = EligibilityEnrollmentConversionService.getEnrollment(person);
        if (enrol != null) {
            return enrol.getPrimaryEligibility();
        }
        return null;
    }

    public EligibilityType getPrimaryEligibilityType(Person person) {
        Eligibility elig = this.getPrimaryEligibility(person);
        if (elig != null) {
            return elig.getType();
        }
        return null;
    }

    public String getPrimaryEligibilityDesc(Person person) {
        EligibilityType eligType = this.getPrimaryEligibilityType(person);
        if (eligType != null) {
            return eligType.getDescription();
        }
        return null;
    }

    public Boolean isServiceConnected(Person person) {
        if (this.getServiceConnectedPercentage(person) != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public String getServiceConnectedPercentage(Person person) {
        ServiceConnectionAward scAward = person.getServiceConnectionAward();
        if (scAward != null) {
            return scAward.getServiceConnectedPercentage() == null ? null : scAward.getServiceConnectedPercentage().toString();
        }
        return null;
    }

    public void setServiceConnectedPercentage(Person person, Integer num) {
        ServiceConnectionAward scAward = person.getServiceConnectionAward();
        if (num != null) {
            if (scAward == null) {
                scAward = new ServiceConnectionAward();
                person.setServiceConnectionAward(scAward);
            }
            scAward.setServiceConnectedPercentage(num);
        } else if (scAward != null) {
            scAward.setServiceConnectedPercentage(num);
            if (scAward.getServiceConnectedIndicator() != null && Boolean.TRUE.equals(scAward.getServiceConnectedIndicator())) {
                scAward.setServiceConnectedIndicator(Boolean.FALSE);
            }
        }
    }

    public void setServiceConnectedPercentage(Person person, String perc) {
        try {
            Integer scPercentage = new Integer(perc);
            this.setServiceConnectedPercentage(person, scPercentage);
        }
        catch (NumberFormatException e) {
            this.setServiceConnectedPercentage(person, (Integer)null);
        }
    }

    public ImpreciseDate getEffectiveDateCombinedRating(Person person) {
        ServiceConnectionAward scAward = person.getServiceConnectionAward();
        if (scAward != null) {
            return scAward.getCombinedServiceConnectedPercentageEffectiveDate();
        }
        return null;
    }

    public void setEffectiveDateCombinedRating(Person person, String dateStr) {
        ImpreciseDate date = DateUtils.getImpreciseDate((String)dateStr);
        ServiceConnectionAward scAward = person.getServiceConnectionAward();
        if (scAward == null && date != null) {
            scAward = new ServiceConnectionAward();
            person.setServiceConnectionAward(scAward);
        }
        if (scAward != null) {
            scAward.setCombinedServiceConnectedPercentageEffectiveDate(date);
        }
    }

    public BigDecimal getTotalCheckAmount(Person person) {
        MonetaryBenefitAward mba = person.getMonetaryBenefitAward();
        if (mba != null) {
            return mba.getCheckAmount();
        }
        return null;
    }

    public void setTotalCheckAmount(Person person, BigDecimal amount) {
        MonetaryBenefitAward mba = person.getMonetaryBenefitAward();
        if (mba == null) {
            mba = new MonetaryBenefitAward();
            person.setMonetaryBenefitAward(mba);
        }
        mba.setCheckAmount(amount);
    }

    public void setTotalCheckAmount(Person person, String amount) {
        try {
            BigDecimal num = new BigDecimal(amount);
            this.setTotalCheckAmount(person, num);
        }
        catch (NumberFormatException e) {
            this.setTotalCheckAmount(person, (BigDecimal)null);
        }
    }

    public String getEligVerMethod(Person person) {
        EligibilityVerification eligVerify = person.getEligibilityVerification();
        if (eligVerify != null) {
            return eligVerify.getVerificationMethod();
        }
        return null;
    }

    public void setEligVerMethod(Person person, String text) {
        EligibilityVerification eligVerify = person.getEligibilityVerification();
        if (eligVerify == null && StringUtils.isNotBlank((String)text)) {
            eligVerify = new EligibilityVerification();
            person.setEligibilityVerification(eligVerify);
        }
        if (eligVerify != null) {
            eligVerify.setVerificationMethod(StringUtils.isBlank((String)text) ? null : text);
        }
    }

    public String getEligStatusPendingVerfReasonExplain(Person person) {
        EligibilityVerification eligVerify = person.getEligibilityVerification();
        if (eligVerify != null) {
            return eligVerify.getEligStatusPendingVerfReasonExplain();
        }
        return null;
    }

    public void setEligStatusPendingVerfReasonExplain(Person person, String text) {
        EligibilityVerification eligVerify = person.getEligibilityVerification();
        if (eligVerify == null && StringUtils.isNotBlank((String)text)) {
            eligVerify = new EligibilityVerification();
            person.setEligibilityVerification(eligVerify);
        }
        if (eligVerify != null) {
            eligVerify.setEligStatusPendingVerfReasonExplain(StringUtils.isBlank((String)text) ? null : text);
        }
    }

    public EligibilityVerificationSource getEligVerSource(Person person) {
        EligibilityVerification eligVerify = person.getEligibilityVerification();
        if (eligVerify != null) {
            return eligVerify.getVerificationSource();
        }
        return null;
    }

    public String getEligVerSourceFacility(Person person) {
        EligibilityVerification eligVerify = person.getEligibilityVerification();
        if (eligVerify != null) {
            return eligVerify.getVerificationSourceFacility();
        }
        return null;
    }

    public void setEligVerSource(Person person, EligibilityVerificationSource source) {
        EligibilityVerification eligVerify = person.getEligibilityVerification();
        if (eligVerify == null && source != null) {
            eligVerify = new EligibilityVerification();
            person.setEligibilityVerification(eligVerify);
        }
        if (eligVerify != null) {
            eligVerify.setVerificationSource(source);
            eligVerify.setVerificationFacility(null);
        }
    }

    public ImpreciseDate getEligStatusDate(Person person) {
        EligibilityVerification eligVerify = person.getEligibilityVerification();
        if (eligVerify != null) {
            return eligVerify.getEligibilityStatusDate();
        }
        return null;
    }

    public void setEligStatusDate(Person person, String dateStr) {
        EligibilityVerification eligVerify = person.getEligibilityVerification();
        if (eligVerify == null && dateStr != null) {
            eligVerify = new EligibilityVerification();
            person.setEligibilityVerification(eligVerify);
        }
        if (eligVerify != null) {
            eligVerify.setEligibilityStatusDate(DateUtils.getImpreciseDate((String)dateStr));
        }
    }

    public AACIndicator getAACIndicator(Person person) {
        EligibilityVerification eligVerify = person.getEligibilityVerification();
        if (eligVerify != null) {
            return eligVerify.getAacIndicator();
        }
        return null;
    }

    public PurpleHeart getPurpleHeart(Person person) {
        Set ls = person.getDecorations();
        if (ls != null) {
            Iterator it = ls.iterator();
            while (it != null && it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof PurpleHeart)) continue;
                return (PurpleHeart)obj;
            }
        }
        return null;
    }

    public void setPurpleHeart(Person person, Boolean ind, DecorationStatus status, RejectionRemark remark) {
        PurpleHeart ph = this.getPurpleHeart(person);
        if (ind == null) {
            if (ph != null) {
                person.removeDecoration((Decoration)ph);
            }
        } else {
            if (ph == null) {
                ph = new PurpleHeart();
                person.addDecoration((Decoration)ph);
            }
            ph.setPhIndicator(ind);
            if (ind.booleanValue()) {
                ph.setStatus(status);
                ph.setRejectionRemark(null);
            } else {
                ph.setStatus(null);
                ph.setRejectionRemark(remark);
            }
        }
    }

    public Vector getDisabilities(Person person) {
        ServiceConnectionAward scAward = person.getServiceConnectionAward();
        Vector<DisabilityBean> scDisbilities = new Vector<DisabilityBean>();
        if (scAward != null) {
            Set list = scAward.getRatedDisabilities();
            Iterator i = list != null ? list.iterator() : null;
            int index = 0;
            while (i != null && i.hasNext()) {
                RatedDisability rd;
                Object data = i.next();
                if (!(data instanceof RatedDisability) || (rd = (RatedDisability)data) == null || rd.getDisability() == null) continue;
                scDisbilities.add(new DisabilityBean(EMPTY_STRING + index++, rd.getDisability(), rd.getDisability().getCode(), rd.getDisability().getDescription(), rd.getPercentage(), rd.getDiagnosticExtremity() == null ? null : rd.getDiagnosticExtremity().getCode(), JspUtils.displayValue((Object)rd.getOriginalEffectiveRatingDate(), null), JspUtils.displayValue((Object)rd.getRatingDate(), null)));
            }
        }
        return scDisbilities;
    }

    public Vector getOtherEligCodes(Person person) {
        EnrollmentDetermination enrol = EligibilityEnrollmentConversionService.getEnrollment(person);
        if (enrol != null && enrol.getSecondaryEligibilities() != null) {
            Vector<Object> vec = new Vector<Object>();
            Object[] a = enrol.getSecondaryEligibilities().toArray();
            Arrays.sort(a);
            vec.addAll(Arrays.asList(a));
            return vec;
        }
        return null;
    }

    public Vector getOtherEligFactors(Person person) {
        EnrollmentDetermination enrol = EligibilityEnrollmentConversionService.getEnrollment(person);
        if (enrol != null && enrol.getOtherEligibilities() != null) {
            Vector vec = new Vector();
            vec.addAll(enrol.getOtherEligibilities());
            return vec;
        }
        return null;
    }

    public Boolean hasMonetaryBenefitType(Person person, MonetaryBenefitType type) {
        if (person == null || person.getMonetaryBenefitAward() == null) {
            return null;
        }
        MonetaryBenefit mb = person.getMonetaryBenefitAward().getMonetaryBenefitByType(type);
        if (mb == null || mb.getMonetaryBenefitIndicator() == null) {
            return null;
        }
        return mb.getMonetaryBenefitIndicator().toBoolean();
    }

    public Boolean hasMonetaryBenefitType(Person person, String typeStr) {
        MonetaryBenefitAward mba = person.getMonetaryBenefitAward();
        if (mba != null) {
            Set benefits = mba.getMonetaryBenefits();
            for (MonetaryBenefit mb : benefits) {
                if (!mb.getType().getCode().equals(typeStr)) continue;
                Indicator indicator = mb.getMonetaryBenefitIndicator();
                return indicator == null ? Boolean.FALSE : indicator.toBoolean();
            }
        }
        return Boolean.FALSE;
    }

    public void setMonetaryBenefitType(Person person, MonetaryBenefitType type, boolean hasThisType) throws Exception {
        this.setMonetaryBenefitType(person, type, new Boolean(hasThisType));
    }

    public void setMonetaryBenefitType(Person person, MonetaryBenefitType type, Boolean hasThisType) throws Exception {
        MonetaryBenefit mb;
        MonetaryBenefitAward mba = person.getMonetaryBenefitAward();
        if (mba == null) {
            mba = new MonetaryBenefitAward();
            person.setMonetaryBenefitAward(mba);
        }
        if ((mb = mba.getMonetaryBenefitByType(type)) == null) {
            mb = new MonetaryBenefit();
            mb.setType(type);
            mba.addMonetaryBenefit(mb);
        }
        mb.setMonetaryBenefitIndicator((Indicator)this.getLookupCacheService().getByCodeFromCache(Indicator.class, hasThisType == null ? Indicator.UNKNOWN.getName() : (hasThisType != false ? Indicator.YES.getName() : Indicator.NO.getName())));
    }

    public void setMonetaryBenefit(Person person, String setYes, MonetaryBenefitType type) throws Exception {
        Boolean hasThisType = null;
        if (setYes != null && !setYes.equalsIgnoreCase("uk")) {
            hasThisType = new Boolean(setYes.equalsIgnoreCase("y"));
        }
        this.setMonetaryBenefitType(person, type, hasThisType);
    }

    public Boolean isHousebound(Person person) {
        return this.hasMonetaryBenefitType(person, MonetaryBenefitType.CODE_HOUSEBOUND.getName());
    }

    public Boolean isVAPension(Person person) {
        return this.hasMonetaryBenefitType(person, MonetaryBenefitType.CODE_VA_PENSION.getName());
    }

    public Boolean isAidAttendance(Person person) {
        return this.hasMonetaryBenefitType(person, MonetaryBenefitType.CODE_AID_AND_ATTENDANCE.getName());
    }

    public Boolean isReceivingVADisabilityCompensation(Person person) {
        return this.hasMonetaryBenefitType(person, MonetaryBenefitType.CODE_DISABILITY_COMPENSATION.getName());
    }

    public void setUnemployable(Person person, String setYes) {
        boolean hasThisType = setYes != null && setYes.equalsIgnoreCase("y");
        ServiceConnectionAward sca = person.getServiceConnectionAward();
        if (sca != null) {
            sca.setUnemployable(Boolean.valueOf(hasThisType));
        } else if (hasThisType) {
            sca = new ServiceConnectionAward();
            sca.setUnemployable(Boolean.TRUE);
            person.setServiceConnectionAward(sca);
        }
    }

    public Boolean isUnemployable(Person person) {
        ServiceConnectionAward sca = person.getServiceConnectionAward();
        if (sca != null) {
            return sca.isUnemployable();
        }
        return null;
    }

    public Boolean isPermanentTotal(Person person) {
        ServiceConnectionAward sca = person.getServiceConnectionAward();
        if (sca != null) {
            return sca.isPermanentAndTotal();
        }
        return null;
    }

    public Date getPermanentTotalEffDate(Person person) {
        ServiceConnectionAward sca = person.getServiceConnectionAward();
        if (sca != null) {
            return sca.getPermanentAndTotalEffectiveDate();
        }
        return null;
    }

    public void setPermanentAndTotal(Person person, String setYes) {
        boolean hasThisType = setYes != null && setYes.equalsIgnoreCase("y");
        ServiceConnectionAward sca = person.getServiceConnectionAward();
        if (sca != null) {
            sca.setPermanentAndTotal(Boolean.valueOf(hasThisType));
        } else if (hasThisType) {
            sca = new ServiceConnectionAward();
            sca.setPermanentAndTotal(Boolean.TRUE);
            person.setServiceConnectionAward(sca);
        }
    }

    public Date getPermanentAndTotalEffDate(Person person) {
        ServiceConnectionAward sca = person.getServiceConnectionAward();
        if (sca != null) {
            return sca.getPermanentAndTotalEffectiveDate();
        }
        return null;
    }

    public void setPermanentAndTotalEffDate(Person person, String date) {
        ServiceConnectionAward sca = person.getServiceConnectionAward();
        if (sca != null) {
            sca.setPermanentAndTotalEffectiveDate(DateUtils.getDate((String)date));
        }
    }

    public void setRatedIncompetent(Person person, String setYes) {
        if (setYes == null || setYes.equalsIgnoreCase("nd")) {
            person.setIncompetenceRuling(null);
        } else {
            boolean hasThisType = setYes.equalsIgnoreCase("y");
            IncompetenceRuling incompetenceRuling = person.getIncompetenceRuling();
            if (incompetenceRuling == null) {
                incompetenceRuling = new IncompetenceRuling();
                person.setIncompetenceRuling(incompetenceRuling);
            }
            incompetenceRuling.setIncompetent(Boolean.valueOf(hasThisType));
        }
    }

    public void setCivilDate(Person person, ImpreciseDate date) {
        IncompetenceRuling incompetenceRuling = person.getIncompetenceRuling();
        if (incompetenceRuling != null) {
            incompetenceRuling.setCivilRulingDate(date);
        }
    }

    public void setVaDate(Person person, ImpreciseDate date) {
        IncompetenceRuling incompetenceRuling = person.getIncompetenceRuling();
        if (incompetenceRuling != null) {
            incompetenceRuling.setVaRulingDate(date);
        }
    }

    public Boolean isEligibleForMedicaid(Person person) {
        MedicaidFactor mf = person.getMedicaidFactor();
        if (mf != null) {
            return mf.isEligibleForMedicaid();
        }
        return null;
    }

    public void setEligibleForMedicaid(Person person, String setYes, Date date) {
        if (date == null && (setYes == null || setYes.equalsIgnoreCase("nd"))) {
            person.setMedicaidFactor(null);
        } else {
            MedicaidFactor mf = person.getMedicaidFactor();
            if (mf == null) {
                mf = new MedicaidFactor();
                person.setMedicaidFactor(mf);
            }
            boolean hasThisType = setYes != null && setYes.equalsIgnoreCase("y");
            mf.setEligibleForMedicaid(Boolean.valueOf(hasThisType));
            mf.setLastUpdateDate(date);
        }
    }

    public Date getMedicaidUpdatedDate(Person person) {
        MedicaidFactor mf = person.getMedicaidFactor();
        if (mf != null) {
            return mf.getLastUpdateDate();
        }
        return null;
    }

    public Date getIneligibleDate(Person person) {
        IneligibilityFactor iFactor = person.getIneligibilityFactor();
        if (iFactor != null) {
            return iFactor.getIneligibleDate();
        }
        return null;
    }

    public void setIneligibleDate(Person person, String dateStr) {
        Date aDate = DateUtils.getDate((String)dateStr);
        IneligibilityFactor iFactor = person.getIneligibilityFactor();
        if (aDate != null) {
            if (iFactor == null) {
                iFactor = new IneligibilityFactor();
                person.setIneligibilityFactor(iFactor);
            }
            iFactor.setIneligibleDate(aDate);
        } else if (iFactor != null) {
            iFactor.setIneligibleDate(null);
        }
    }

    public String getIneligibleReason(Person person) {
        IneligibilityFactor iFactor = person.getIneligibilityFactor();
        if (iFactor != null) {
            return iFactor.getReason();
        }
        return null;
    }

    public void setIneligibleReason(Person person, String reason) {
        IneligibilityFactor iFactor = person.getIneligibilityFactor();
        if (reason != null && reason.length() > 0) {
            if (iFactor == null) {
                iFactor = new IneligibilityFactor();
                person.setIneligibilityFactor(iFactor);
            }
            iFactor.setReason(reason);
        } else if (iFactor != null) {
            iFactor.setReason(null);
        }
    }

    public String getIneligibleVARODecision(Person person) {
        IneligibilityFactor iFactor = person.getIneligibilityFactor();
        if (iFactor != null) {
            return iFactor.getVaroDecision();
        }
        return null;
    }

    public void setIneligibleVARODecision(Person person, String decision) {
        IneligibilityFactor iFactor = person.getIneligibilityFactor();
        if (decision != null && decision.length() > 0) {
            if (iFactor == null) {
                iFactor = new IneligibilityFactor();
                person.setIneligibilityFactor(iFactor);
            }
            iFactor.setVaroDecision(decision);
        } else if (iFactor != null) {
            iFactor.setVaroDecision(null);
        }
    }

    public Boolean getDischargeDueDisability(Person person) {
        MilitaryService ms = person.getMilitaryService();
        if (ms != null) {
            return ms.getDischargeDueToDisability();
        }
        return null;
    }

    public void setDischargeDueDisability(Person person, Boolean status) {
        MilitaryService ms = person.getMilitaryService();
        if (status == null) {
            if (ms != null) {
                ms.setDischargeDueToDisability(null);
            }
        } else {
            if (ms == null) {
                ms = new MilitaryService();
                person.setMilitaryService(ms);
            }
            ms.setDischargeDueToDisability(status);
        }
    }

    public Boolean getDisabilityRetirementIndicator(Person person) {
        MilitaryService ms = person.getMilitaryService();
        if (ms != null) {
            return ms.getDisabilityRetirementIndicator();
        }
        return null;
    }

    public void setDisabilityRetirementIndicator(Person person, Boolean status) {
        MilitaryService ms = person.getMilitaryService();
        if (status == null) {
            if (ms != null) {
                ms.setDisabilityRetirementIndicator(null);
            }
        } else {
            if (ms == null) {
                ms = new MilitaryService();
                person.setMilitaryService(ms);
            }
            ms.setDisabilityRetirementIndicator(status);
        }
    }

    public SpecialFactor getSpecialFactor(Person person, Class aClass) {
        if (person.getSpecialFactors() != null) {
            Object[] objs = person.getSpecialFactors().toArray();
            for (int i = 0; i < objs.length; ++i) {
                if (!objs[i].getClass().equals(aClass)) continue;
                return (SpecialFactor)objs[i];
            }
        }
        return null;
    }

    public AgentOrangeExposure getAgentOrangeExposure(Person person) {
        return (AgentOrangeExposure)this.getSpecialFactor(person, AgentOrangeExposure.class);
    }

    public void setAgentOrangeExposure(Person person, AgentOrangeExposureLocation aoel) throws Exception {
        AgentOrangeExposure ao = this.getAgentOrangeExposure(person);
        if (ao == null) {
            ao = new AgentOrangeExposure();
            person.addSpecialFactor((SpecialFactor)ao);
        }
        ao.setAgentOrangeExposureIndicator((Indicator)this.getLookupCacheService().getByCodeFromCache(Indicator.class, aoel != null ? Indicator.YES.getName() : Indicator.NO.getName()));
        ao.setLocation(aoel);
    }

    public String getAgentOrangeLocation(Person person) {
        AgentOrangeExposure aoe = this.getAgentOrangeExposure(person);
        if (aoe != null && aoe.getLocation() != null) {
            return aoe.getLocation().getCode();
        }
        return null;
    }

    public EnvironmentalContaminationExposure getEnvironmentalContaminationExposure(Person person) {
        return (EnvironmentalContaminationExposure)this.getSpecialFactor(person, EnvironmentalContaminationExposure.class);
    }

    public void setEnvironmentalContaminationExposure(Person person, String setYes) throws Exception {
        boolean hasThisType = setYes != null && setYes.equalsIgnoreCase("y");
        EnvironmentalContaminationExposure ece = this.getEnvironmentalContaminationExposure(person);
        if (ece == null) {
            ece = new EnvironmentalContaminationExposure();
            person.addSpecialFactor((SpecialFactor)ece);
        }
        ece.setEnvironmentalContaminationExposureIndicator((Indicator)this.getLookupCacheService().getByCodeFromCache(Indicator.class, hasThisType ? Indicator.YES.getName() : Indicator.NO.getName()));
    }

    public RadiationExposure getRadiationExposure(Person person) {
        return (RadiationExposure)this.getSpecialFactor(person, RadiationExposure.class);
    }

    public void setRadiationExposureMethod(Person person, RadiationExposureMethod rem) throws Exception {
        RadiationExposure re = this.getRadiationExposure(person);
        if (re == null) {
            re = new RadiationExposure();
            person.addSpecialFactor((SpecialFactor)re);
        }
        re.setRadiationExposureIndicator((Indicator)this.getLookupCacheService().getByCodeFromCache(Indicator.class, rem != null ? Indicator.YES.getName() : Indicator.NO.getName()));
        re.setExposureMethod(rem);
    }

    public String getRadiationExposureMethod(Person person) {
        RadiationExposure re = this.getRadiationExposure(person);
        if (re != null && re.getExposureMethod() != null) {
            return re.getExposureMethod().getCode();
        }
        return null;
    }

    private MilitaryServiceSiteRecord getHECMilitaryServiceSiteRecord(Person person) {
        MilitaryService militaryService = person.getMilitaryService();
        if (militaryService != null) {
            return militaryService.getHECMilitaryServiceSiteRecord();
        }
        return null;
    }

    public String getPeriodOfService(Person person) {
        ServicePeriod servicePeriod;
        MilitaryServiceSiteRecord militaryServiceSiteRecord = this.getHECMilitaryServiceSiteRecord(person);
        if (militaryServiceSiteRecord != null && (servicePeriod = militaryServiceSiteRecord.getServicePeriod()) != null) {
            return servicePeriod.getCode();
        }
        return null;
    }

    public void setPeriodOfService(Person person, String periodOfService, LookupCacheService lookupCacheService) throws Exception {
        MilitaryService militaryService = person.getMilitaryService();
        MilitaryServiceSiteRecord hecMilitaryServiceSiteRecord = null;
        if (periodOfService != null && periodOfService.trim().length() > 0) {
            if (militaryService == null) {
                militaryService = new MilitaryService();
                person.setMilitaryService(militaryService);
            }
            if ((hecMilitaryServiceSiteRecord = militaryService.getHECMilitaryServiceSiteRecord()) == null) {
                hecMilitaryServiceSiteRecord = new MilitaryServiceSiteRecord();
                hecMilitaryServiceSiteRecord.setSite((VAFacility)lookupCacheService.getByCodeFromCache(VAFacility.class, VAFacility.CODE_HEC.getName()));
                militaryService.addMilitaryServiceSiteRecord(hecMilitaryServiceSiteRecord);
            }
        }
        if (hecMilitaryServiceSiteRecord != null) {
            hecMilitaryServiceSiteRecord.setServicePeriod((ServicePeriod)lookupCacheService.getByCodeFromCache(ServicePeriod.class, periodOfService));
        }
    }

    public Boolean isTricare(Person person) {
        return this.isEligiable(person, EligibilityType.TRICARE_CHAMPUS.getName());
    }

    public Boolean isSharingAgreement(Person person) {
        return this.isEligiable(person, EligibilityType.SHARING_AGREEMENT.getName());
    }

    public Boolean isAlliedVeteranCountry(Person person) {
        return this.isEligiable(person, EligibilityType.ALLIED_VETERAN.getName());
    }

    public String getAlliedVeteranCountry(Person person) {
        ReceivedEligibility elig;
        Boolean indicator = this.isAlliedVeteranCountry(person);
        if (indicator != null && indicator.booleanValue() && (elig = this.getReceivedEligibility(person, EligibilityType.ALLIED_VETERAN.getName())) != null && elig.getAlliedCountry() != null) {
            return elig.getAlliedCountry().getCode();
        }
        return null;
    }

    public Boolean isChampa(Person person) {
        return this.isEligiable(person, EligibilityType.CHAMPVA.getName());
    }

    public Boolean isEmployee(Person person) {
        return this.isEligiable(person, EligibilityType.EMPLOYEE.getName());
    }

    public Boolean isCollateralOfVet(Person person) {
        return this.isEligiable(person, EligibilityType.COLLATERAL_OF_VETERAN.getName());
    }

    public Boolean isOtherFederalAgency(Person person) {
        return this.isEligiable(person, EligibilityType.OTHER_FEDERAL_AGENCY.getName());
    }

    public String getOtherFederalAgency(Person person) {
        ReceivedEligibility elig;
        Boolean indicator = this.isOtherFederalAgency(person);
        if (indicator != null && indicator.booleanValue() && (elig = this.getReceivedEligibility(person, EligibilityType.OTHER_FEDERAL_AGENCY.getName())) != null && elig.getOtherFederalAgency() != null) {
            return elig.getOtherFederalAgency().getCode();
        }
        return null;
    }

    public Boolean isEligiable(Person person, String codeName) {
        Eligibility elg2;
        EnrollmentDetermination enrol = EligibilityEnrollmentConversionService.getEnrollment(person);
        Eligibility eligibility = elg2 = enrol != null ? enrol.getPrimaryEligibility() : null;
        if (elg2 != null && elg2.getType().getCode().equals(codeName)) {
            return Boolean.TRUE;
        }
        if (enrol != null && enrol.getSecondaryEligibilities() != null) {
            for (Eligibility elg2 : enrol.getSecondaryEligibilities()) {
                if (elg2 == null || !elg2.getType().getCode().equals(codeName)) continue;
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public ReceivedEligibility getReceivedEligibility(Person person, String codeName) {
        if (StringUtils.isNotBlank((String)codeName)) {
            ReceivedEligibility elg2 = person.getReceivedPrimaryEligibility();
            if (elg2 != null && elg2.getType() != null && elg2.getType().getCode().equals(codeName)) {
                return elg2;
            }
            Set received = person.getReceivedSecondaryEligibilities();
            if (received != null && received.size() > 0) {
                for (ReceivedEligibility elg2 : received) {
                    if (elg2 == null || elg2.getType() == null || !elg2.getType().getCode().equals(codeName)) continue;
                    return elg2;
                }
            }
        }
        return null;
    }

    public VAFacility getFacilityHEC(LookupCacheService lookupCacheService) throws Exception {
        return (VAFacility)lookupCacheService.getByCodeFromCache(VAFacility.class, VAFacility.CODE_HEC.getName());
    }

    public void setNonVeteranElig(Person person, LookupCacheService lookupCacheService, String typeName) throws Exception {
        this.setNonVeteranElig(person, (EligibilityType)lookupCacheService.getByCodeFromCache(EligibilityType.class, typeName), this.getFacilityHEC(lookupCacheService));
    }

    public void setNonVeteranElig(Person person, EligibilityType type, VAFacility site) {
        ReceivedEligibility elig = new ReceivedEligibility();
        elig.setType(type);
        elig.setReportSite(site);
        person.addReceivedSecondaryEligibility(elig);
    }

    public void setAlliedCountry(Person person, LookupCacheService lookupCacheService, String country) throws Exception {
        if (country != null) {
            ReceivedEligibility elig = new ReceivedEligibility();
            elig.setType((EligibilityType)lookupCacheService.getByCodeFromCache(EligibilityType.class, EligibilityType.ALLIED_VETERAN.getName()));
            elig.setReportSite((VAFacility)lookupCacheService.getByCodeFromCache(VAFacility.class, VAFacility.CODE_HEC.getName()));
            elig.setAlliedCountry((AlliedCountry)lookupCacheService.getByCodeFromCache(AlliedCountry.class, country));
            person.addReceivedSecondaryEligibility(elig);
        }
    }

    public void setOtherFederalAgency(Person person, LookupCacheService lookupCacheService, String country) throws Exception {
        if (country != null) {
            ReceivedEligibility elig = new ReceivedEligibility();
            elig.setType((EligibilityType)lookupCacheService.getByCodeFromCache(EligibilityType.class, EligibilityType.OTHER_FEDERAL_AGENCY.getName()));
            elig.setReportSite((VAFacility)lookupCacheService.getByCodeFromCache(VAFacility.class, VAFacility.CODE_HEC.getName()));
            elig.setOtherFederalAgency((FederalAgency)lookupCacheService.getByCodeFromCache(FederalAgency.class, country));
            person.addReceivedSecondaryEligibility(elig);
        }
    }

    protected Date getIncomeTestDate(Person person) {
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(person);
        if (it != null) {
            return it.getEffectiveDate();
        }
        return null;
    }

    protected String getIncomeTestFacility(Person person) {
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(person);
        if (it != null && it.getSiteConductingTest() != null) {
            return it.getSiteConductingTest().getStationNumber();
        }
        return null;
    }

    protected String getIncomeTestStatusDesc(Person person) {
        IncomeTestStatus its = this.getIncomeTestStatus(person);
        if (its != null && its.getStatus() != null) {
            return its.getStatus().getDescription();
        }
        return null;
    }

    protected IncomeTestStatus getIncomeTestStatus(Person person) {
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(person);
        return it != null ? it.getIncomeTestStatus() : null;
    }

    protected String getIncomeTestYear(Person person) {
        IncomeTest it = this.getPersonHelperService().getCurrentIncomeTest(person);
        if (it != null && it.getIncomeYear() != null) {
            return it.getIncomeYear().toString();
        }
        return null;
    }

    protected Date getIncomeTestLastEdited(Person person) {
        IncomeTestStatus its = this.getIncomeTestStatus(person);
        if (its != null) {
            return its.getLastEditedDate();
        }
        return null;
    }

    protected String convertYesNoUnknown(TriState triState) {
        String retValue = null;
        if (triState == null || triState.equals((Object)TriState.UNKNOWN)) {
            retValue = "uk";
        } else if (triState.equals((Object)TriState.FALSE)) {
            retValue = "n";
        } else if (triState.equals((Object)TriState.TRUE)) {
            retValue = "y";
        }
        return retValue;
    }

    protected TriState convertToTriState(String value) {
        TriState triState = value == null || value.equals("uk") ? TriState.UNKNOWN : (value.equals("n") ? TriState.FALSE : (value.equals("y") ? TriState.TRUE : TriState.UNKNOWN));
        return triState;
    }

    protected String getNoseThroatRadium(Person person) {
        NoseThroatRadium ntr = null;
        TriState triState = null;
        try {
            ntr = person.getNoseThroatRadium();
        }
        catch (Exception e) {
            String string = this.convertYesNoUnknown(null);
        }
        triState = ntr == null ? null : ntr.getReceivingTreatment();
        String retValue = this.convertYesNoUnknown(triState);
        return retValue;
    }

    protected void setNoseThroatRadium(Person person, String value) {
        TriState triState = this.convertToTriState(value);
        NoseThroatRadium ntr = person.getNoseThroatRadium();
        if (ntr == null) {
            ntr = new NoseThroatRadium();
            person.setNoseThroatRadium(ntr);
        }
        ntr.setReceivingTreatment(triState);
    }

    protected String getSpinalCodrInjury(Person person) {
        SpinalCordInjury sci = null;
        try {
            sci = person.getSpinalCordInjury();
        }
        catch (Exception e) {
            String string = EMPTY_STRING;
        }
        String retValue = sci == null ? EMPTY_STRING : sci.toString();
        return retValue;
    }

    protected Date getSignatureDate(Person person) {
        return new Date();
    }

    protected void setSignatureDate(Person person, String date) {
    }

    protected String getApplicationMethod(Person person) {
        if (person.getApplication() == null || person.getApplication().getApplicationMethod() == null || person.getApplication().getApplicationMethod().getCode() == null) {
            return EMPTY_STRING;
        }
        return person.getApplication().getApplicationMethod().getCode();
    }

    protected void setApplicationMethod(Person person, ApplicationMethod appMethod) {
        person.getApplication().setAppliactionMethod(appMethod);
    }

    public void populateCampLejeune(EligibilityEditActionForm form, Person person) {
        if (form != null) {
            form.resetCampLejeune();
        }
        CampLejeuneVerification clv = null;
        if (person != null) {
            clv = (CampLejeuneVerification)person.getSpecialFactorByType(CampLejeuneVerification.class);
            form.setCampLejeuneInd(clv != null && clv.getSpecialFactorIndicator() != null ? clv.getSpecialFactorIndicator().getCode() : Indicator.UNKNOWN.getCode());
            if (clv != null) {
                if (clv.getVerificationType() != null) {
                    form.setCampLejeuneVerificationMethod(clv.getVerificationType().getCode());
                } else {
                    form.setCampLejeuneVerificationMethod(EMPTY_STRING);
                }
                if (clv.getInternalCampLejeuneVerificationMethods() != null && clv.getInternalCampLejeuneVerificationMethods().size() > 0) {
                    Set clvms = clv.getInternalCampLejeuneVerificationMethods();
                    StringBuffer strMethod = new StringBuffer();
                    for (CampLejeuneVerificationMethod clvm : clvms) {
                        strMethod.append(clvm.getVerificationType().getCode());
                        strMethod.append(",");
                    }
                    form.setCampLejeuneVerificationMethods(strMethod.toString().split(","));
                }
                if (clv.getComments() != null) {
                    form.setCampLejeuneVerificationComments(clv.getComments());
                } else {
                    form.setCampLejeuneVerificationComments(EMPTY_STRING);
                }
                if (clv.getChangeDate() != null) {
                    form.setCampLejeuneChangeDate(JspUtils.displayValue((Object)clv.getChangeDate(), null));
                }
                if (clv.getChangeSite() != null) {
                    form.setCampLejeuneChangeSite(clv.getChangeSite().getDescription());
                } else {
                    form.setCampLejeuneChangeSite(EMPTY_STRING);
                }
                if (clv.getChangeSource() != null) {
                    if (clv.getChangeSource().getCode().equals(CampLejeuneChangeSource.CODE_HEC.getCode())) {
                        if (clv.getModifiedBy() != null && clv.getModifiedBy().getName() != null && !clv.getModifiedBy().getName().equalsIgnoreCase("MsdsService")) {
                            form.setCampLejeuneChangeSource(clv.getModifiedBy().getName());
                        } else {
                            form.setCampLejeuneChangeSource(clv.getChangeSource().getDescription());
                        }
                    } else {
                        form.setCampLejeuneChangeSource(clv.getChangeSource().getDescription());
                    }
                } else {
                    form.setCampLejeuneChangeSource(EMPTY_STRING);
                }
            }
        }
    }

    public void updateCLVFromGUI(EligibilityEditActionForm form, Person person) throws ConversionServiceException {
        CampLejeuneVerification clv = (CampLejeuneVerification)person.getSpecialFactorByType(CampLejeuneVerification.class);
        String clvStr = form.getCampLejeuneInd();
        if (clvStr != null && clvStr.equals("y")) {
            clvStr = "1";
        } else if (clvStr != null && clvStr.equals("n")) {
            clvStr = "2";
        }
        Indicator clvInd = (Indicator)this.getLookup(Indicator.class, clvStr);
        if (clv == null) {
            clv = new CampLejeuneVerification();
            person.addSpecialFactor((SpecialFactor)clv);
            clv = (CampLejeuneVerification)person.getSpecialFactorByType(CampLejeuneVerification.class);
        }
        clv.setSpecialFactorIndicator(clvInd);
        String clvVMStr = form.getCampLejeuneVerificationMethod();
        CampLejeuneVerificationType clvtype = (CampLejeuneVerificationType)this.getLookup(CampLejeuneVerificationType.class, clvVMStr);
        clv.setVerificationType(clvtype);
        List<String> clvms = null;
        if (form.getCampLejeuneVerificationMethods() != null) {
            clvms = Arrays.asList(form.getCampLejeuneVerificationMethods());
        }
        if (clvms != null) {
            if (clv.getInternalCampLejeuneVerificationMethods() != null) {
                Iterator iter = clv.getInternalCampLejeuneVerificationMethods().iterator();
                while (iter.hasNext()) {
                    CampLejeuneVerificationMethod clm = (CampLejeuneVerificationMethod)iter.next();
                    if (clvms.contains(clm.getVerificationType().getCode())) continue;
                    iter.remove();
                }
            }
            for (String clvVMStr1 : clvms) {
                CampLejeuneVerificationType clvtype1 = (CampLejeuneVerificationType)this.getLookup(CampLejeuneVerificationType.class, clvVMStr1);
                if (clv.getCampLejeuneMethodByType(clvVMStr1) != null) continue;
                CampLejeuneVerificationMethod clvm = new CampLejeuneVerificationMethod();
                clvm.setVerificationType(clvtype1);
                clv.addCampLejeuneVerificationMethod(clvm);
            }
        }
        clv.setComments(form.getCampLejeuneVerificationComments());
        Date clvChangeDate = DateUtils.getDate((String)form.getCampLejeuneChangeDate());
        if (clvChangeDate == null && clv != null && clv.getSpecialFactorIndicator() != null && (Indicator.YES.getCode().equals(clv.getSpecialFactorIndicator().getCode()) || Indicator.NO.getCode().equals(clv.getSpecialFactorIndicator().getCode()))) {
            clvChangeDate = DateUtils.getCurrentDate();
        }
        clv.setChangeDate(clvChangeDate);
        CampLejeuneChangeSource clcs = (CampLejeuneChangeSource)this.getLookup(CampLejeuneChangeSource.class, CampLejeuneChangeSource.CODE_HEC.getName());
        clv.setChangeSource(clcs);
        VAFacility vafac = (VAFacility)this.getLookup(VAFacility.class, VAFacility.CODE_HEC.getName());
        clv.setChangeSite(vafac);
    }
}

