/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.ee.action;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.CommonDateUtils;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.ee.action.VOAAttahmentEditActionForm;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.ui.struts.AbstractForm;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;

public class EligibilityEditActionForm
extends AbstractForm {
    private static final long serialVersionUID = -5010494002166429488L;
    public static final String FIELD_NAME_INELIGIBILE_DATE = "ineligibleDate";
    public static final String FIELD_LABEL_INELIGIBILE_DATE = "label.ineligibleDate";
    public static final String MESSAGE_KEY_INELIGIBILE_DATE_NOT_ALLOWED = "error.ineligibleDateNotAllowed";
    public static final String MESSAGE_KEY_INELIGIBILE_PRIOR_TO_SERVICEENTRY_DATE = "error.invalidIneligibilityDate";
    private String focusButton;
    private String deathDate;
    private String birthDate;
    private String todayDate;
    private String nefHiddenId;
    private String rdHiddenId;
    private String nveHiddenId;
    private String powHiddenId;
    private Integer addPOWSource;
    private String veteranIndicator;
    private String oldVeteranIndicator;
    private String enrollmentCategoryCode;
    private String eligibilityStatus;
    private Collection eligibilityStatusList;
    private String eligibilityStatusDate;
    private String oldEligibilityStatusDate;
    private String verificationMethod;
    private String eligStatusPendingVerficationReason;
    private String eligStatusPendingVerfReasonExplain;
    private String totalCheckAmount;
    private String totalMonthlyCheckAmount;
    private String serviceConnected;
    private String effectiveDateCombinedRating;
    private String oldEffectiveDateCombinedRating;
    private String applicationDate;
    private String isReceivingCompensation;
    private String vaPension;
    private String oldvaPension;
    private String housebound;
    private String aidAttendance;
    private String phStatus;
    private String voaHiddenId;
    private String activeVOARowID;
    private String powInd;
    private List powId;
    private List powConfinementLocation;
    private List powCaptureDate;
    private List powReleaseDate;
    private List powCaptivityDays;
    private List powSource;
    private List powDateEntered;
    private List powDocumentType;
    private List powCampLocation;
    private List powCampCode;
    private List powCampName;
    private List powCampCity;
    private String agentOrangeExposure;
    private String agentOrangeLocation;
    private String environmentalContaminationExposure;
    private String radiationExposure;
    private String radiationExposureMethod;
    private String dischargeDueDisability;
    private String disabilityRetirementIndicator;
    private String unemployable;
    private String permanentTotal;
    private String permanentTotalEffDate;
    private String ratedIncompetent;
    private String civilDate;
    private String vaDate;
    private String eligibleForMedicaid;
    private String medicaidUpdatedDate;
    private String serviceEntryDate;
    private String ineligibleDate;
    private String ineligibleReason;
    private String ineligibleVARODecision;
    private String claimFolderNumber;
    private String claimFolderLocation;
    private String preferredFacility;
    private String canceledDeclinedIndicator;
    private String canceledDeclinedEffectiveDate;
    private String canceledDeclinedReason;
    private String canceledDeclinedNotProcessedReason;
    private String canceledDeclinedRemarks;
    private String periodOfService;
    private String tricare;
    private String sharingAgreement;
    private String alliedVeteranCountry;
    private String champa;
    private String employee;
    private String collateralOfVet;
    private String otherFederalAgency;
    private String[] campLejeuneVerificationMethods = new String[0];
    private String[] resetCampLejeuneVerificationMethods = new String[0];
    private List disabilityId;
    private List disabilityIdStrings;
    private int[] selectedDisabilityIndexes;
    private List disabilityCodes;
    private List disDescription;
    private List percentage;
    private List diagnosticExtremity;
    private List originalEffectiveDate;
    private List currentEffectiveDate;
    private List oldOriginalEffectiveDate;
    private List oldCurrentEffectiveDate;
    private List voaAttachments = new ArrayList();
    private String pensionAwardEffectiveDate;
    private String oldPensionAwardEffectiveDate;
    private String pensionAwardReasonCode;
    private String pensionAwardTerminationDate;
    private String oldPensionAwardTerminationDate;
    private String pensionAwardTerminationReasonCode1;
    private String pensionAwardTerminationReasonCode2;
    private String pensionAwardTerminationReasonCode3;
    private String pensionAwardTerminationReasonCode4;
    private String spinalCordInjury;
    private String noseThroatRadium;
    private String addedRatedDisability = "n";
    private String campLejeuneInd;
    private String campLejeuneVerificationMethod;
    private String campLejeuneVerificationComments;
    private String campLejeuneChangeDate;
    private String campLejeuneChangeSite;
    private String campLejeuneChangeSource;
    private boolean campLejeuneDisabled;

    public String getFocusButton() {
        return this.focusButton;
    }

    public void setFocusButton(String focusButton) {
        this.focusButton = focusButton;
    }

    public Integer getAddPOWSource() {
        return this.addPOWSource;
    }

    public void setAddPOWSource(Integer addPOWSource) {
        this.addPOWSource = addPOWSource;
    }

    public String getAddedRatedDisability() {
        return this.addedRatedDisability;
    }

    public void setAddedRatedDisability(String addedRatedDisability) {
        this.addedRatedDisability = addedRatedDisability;
    }

    public String getDeathDate() {
        return this.deathDate;
    }

    public void setDeathDate(String deathDate) {
        this.deathDate = deathDate;
    }

    public String getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(String birthDate) {
        this.birthDate = birthDate;
    }

    public String getTodayDate() {
        return this.todayDate;
    }

    public void setTodayDate(String todayDate) {
        this.todayDate = todayDate;
    }

    public String getNefHiddenId() {
        return this.nefHiddenId;
    }

    public void setNefHiddenId(String nefHiddenId) {
        this.nefHiddenId = nefHiddenId;
    }

    public String getNveHiddenId() {
        return this.nveHiddenId;
    }

    public void setNveHiddenId(String nveHiddenId) {
        this.nveHiddenId = nveHiddenId;
    }

    public String getPowHiddenId() {
        return this.powHiddenId;
    }

    public void setPowHiddenId(String powHiddenId) {
        this.powHiddenId = powHiddenId;
    }

    public String getRdHiddenId() {
        return this.rdHiddenId;
    }

    public void setRdHiddenId(String rdHiddenId) {
        this.rdHiddenId = rdHiddenId;
    }

    public String getVoaHiddenId() {
        return this.voaHiddenId;
    }

    public void setVoaHiddenId(String voaHiddenId) {
        this.voaHiddenId = voaHiddenId;
    }

    public String getVeteranIndicator() {
        return this.veteranIndicator;
    }

    public void setVeteranIndicator(String veteranIndicator) {
        this.veteranIndicator = veteranIndicator;
    }

    public String getOldVeteranIndicator() {
        return this.oldVeteranIndicator;
    }

    public void setOldVeteranIndicator(String oldVeteranIndicator) {
        this.oldVeteranIndicator = oldVeteranIndicator;
    }

    public String getEnrollmentCategoryCode() {
        return this.enrollmentCategoryCode;
    }

    public void setEnrollmentCategoryCode(String enrollmentCategoryCode) {
        this.enrollmentCategoryCode = enrollmentCategoryCode;
    }

    public void setVerificationMethod(String verificationMethod) {
        this.verificationMethod = verificationMethod;
    }

    public String getVerificationMethod() {
        return this.verificationMethod;
    }

    public void setServiceConnected(String serviceConnected) {
        this.serviceConnected = serviceConnected;
    }

    public String getServiceConnected() {
        return this.serviceConnected;
    }

    public String getEffectiveDateCombinedRating() {
        return this.effectiveDateCombinedRating;
    }

    public void setEffectiveDateCombinedRating(String effectiveDateCombinedRating) {
        this.effectiveDateCombinedRating = effectiveDateCombinedRating;
    }

    public String getOldEffectiveDateCombinedRating() {
        return this.oldEffectiveDateCombinedRating;
    }

    public void setOldEffectiveDateCombinedRating(String oldEffectiveDateCombinedRating) {
        this.oldEffectiveDateCombinedRating = oldEffectiveDateCombinedRating;
    }

    public String getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(String applicationDate) {
        this.applicationDate = applicationDate;
    }

    public void setVaPension(String vaPension) {
        this.vaPension = vaPension;
    }

    public String getVaPension() {
        return this.vaPension;
    }

    public void setHousebound(String housebound) {
        this.housebound = housebound;
    }

    public String getHousebound() {
        return this.housebound;
    }

    public void setAidAttendance(String aidAttendance) {
        this.aidAttendance = aidAttendance;
    }

    public String getAidAttendance() {
        return this.aidAttendance;
    }

    public String getPhStatus() {
        return this.phStatus;
    }

    public void setPhStatus(String phStatus) {
        this.phStatus = phStatus;
    }

    public void setPowInd(String powInd) {
        this.powInd = powInd;
    }

    public String getPowInd() {
        return this.powInd;
    }

    public List getPowCaptureDateList() {
        return this.powCaptureDate;
    }

    public void setPowCaptureDateList(List powCaptureDate) {
        this.powCaptureDate = powCaptureDate;
    }

    public String getPowCaptureDate(int index) {
        return (String)this.powCaptureDate.get(index);
    }

    public void setPowCaptureDate(int index, String powCaptureDate) {
        this.setElement(this.powCaptureDate, index, powCaptureDate);
    }

    public List getPowConfinementLocationList() {
        return this.powConfinementLocation;
    }

    public void setPowConfinementLocationList(List powConfinementLocation) {
        this.powConfinementLocation = powConfinementLocation;
    }

    public String getPowConfinementLocation(int index) {
        return (String)this.powConfinementLocation.get(index);
    }

    public void setPowConfinementLocation(int index, String powConfinementLocation) {
        this.setElement(this.powConfinementLocation, index, powConfinementLocation);
    }

    public List getPowReleaseDateList() {
        return this.powReleaseDate;
    }

    public void setPowReleaseDateList(List powReleaseDate) {
        this.powReleaseDate = powReleaseDate;
    }

    public String getPowReleaseDate(int index) {
        return (String)this.powReleaseDate.get(index);
    }

    public void setPowReleaseDate(int index, String powReleaseDate) {
        this.setElement(this.powReleaseDate, index, powReleaseDate);
    }

    public List getPowCaptivityDaysList() {
        return this.powCaptivityDays;
    }

    public void setPowCaptivityDaysList(List powCaptivityDays) {
        this.powCaptivityDays = powCaptivityDays;
    }

    public String getPowCaptivityDays(int index) {
        return (String)this.powCaptivityDays.get(index);
    }

    public void setPowCaptivityDays(int index, String powCaptivityDays) {
        this.setElement(this.powCaptivityDays, index, powCaptivityDays);
    }

    public List getPowSourceList() {
        return this.powSource;
    }

    public void setPowSourceList(List powSource) {
        this.powSource = powSource;
    }

    public String getPowSource(int index) {
        return (String)this.powSource.get(index);
    }

    public void setPowSource(int index, String powSource) {
        this.setElement(this.powSource, index, powSource);
    }

    public List getPowDateEnteredList() {
        return this.powDateEntered;
    }

    public void setPowDateEnteredList(List powDateEntered) {
        this.powDateEntered = powDateEntered;
    }

    public String getPowDateEntered(int index) {
        return (String)this.powDateEntered.get(index);
    }

    public void setPowDateEntered(int index, String powDateEntered) {
        this.setElement(this.powDateEntered, index, powDateEntered);
    }

    public List getPowDocumentTypeList() {
        return this.powDocumentType;
    }

    public void setPowDocumentTypeList(List powDocumentType) {
        this.powDocumentType = powDocumentType;
    }

    public String getPowDocumentType(int index) {
        return (String)this.powDocumentType.get(index);
    }

    public void setPowDocumentType(int index, String powDocumentType) {
        this.setElement(this.powDocumentType, index, powDocumentType);
    }

    public List getPowCampLocationList() {
        return this.powCampLocation;
    }

    public void setPowCampLocationList(List powCampLocation) {
        this.powCampLocation = powCampLocation;
    }

    public String getPowCampLocation(int index) {
        return (String)this.powCampLocation.get(index);
    }

    public void setPowCampLocation(int index, String powCampLocation) {
        this.setElement(this.powCampLocation, index, powCampLocation);
    }

    public List getPowCampCodeList() {
        return this.powCampCode;
    }

    public void setPowCampCodeList(List powCampCode) {
        this.powCampCode = powCampCode;
    }

    public String getPowCampCode(int index) {
        return (String)this.powCampCode.get(index);
    }

    public void setPowCampCode(int index, String powCampCode) {
        this.setElement(this.powCampCode, index, powCampCode);
    }

    public List getPowCampNameList() {
        return this.powCampName;
    }

    public void setPowCampNameList(List powCampName) {
        this.powCampName = powCampName;
    }

    public String getPowCampName(int index) {
        return (String)this.powCampName.get(index);
    }

    public void setPowCampName(int index, String powCampName) {
        this.setElement(this.powCampName, index, powCampName);
    }

    public List getPowCampCityList() {
        return this.powCampCity;
    }

    public void setPowCampCityList(List powCampCity) {
        this.powCampCity = powCampCity;
    }

    public String getPowCampCity(int index) {
        return (String)this.powCampCity.get(index);
    }

    public void setPowCampCity(int index, String powCampCity) {
        this.setElement(this.powCampCity, index, powCampCity);
    }

    public void setUnemployable(String unemployable) {
        this.unemployable = unemployable;
    }

    public String getUnemployable() {
        return this.unemployable;
    }

    public void setPermanentTotal(String permanentTotal) {
        this.permanentTotal = permanentTotal;
    }

    public String getPermanentTotal() {
        return this.permanentTotal;
    }

    public String getPermanentTotalEffDate() {
        return this.permanentTotalEffDate;
    }

    public void setPermanentTotalEffDate(String permanentTotalEffDate) {
        this.permanentTotalEffDate = permanentTotalEffDate;
    }

    public void setRatedIncompetent(String ratedIncompetent) {
        this.ratedIncompetent = ratedIncompetent;
    }

    public String getRatedIncompetent() {
        return this.ratedIncompetent;
    }

    public String getDischargeDueDisability() {
        return this.dischargeDueDisability;
    }

    public void setDischargeDueDisability(String dischargeDueDisability) {
        this.dischargeDueDisability = dischargeDueDisability;
    }

    public void setCivilDate(String civilDate) {
        this.civilDate = civilDate;
    }

    public String getCivilDate() {
        return this.civilDate;
    }

    public void setVaDate(String vaDate) {
        this.vaDate = vaDate;
    }

    public String getVaDate() {
        return this.vaDate;
    }

    public void setEligibleForMedicaid(String eligibleForMedicaid) {
        this.eligibleForMedicaid = eligibleForMedicaid;
    }

    public String getEligibleForMedicaid() {
        return this.eligibleForMedicaid;
    }

    public void setMedicaidUpdatedDate(String medicaidUpdatedDate) {
        this.medicaidUpdatedDate = medicaidUpdatedDate;
    }

    public String getMedicaidUpdatedDate() {
        return this.medicaidUpdatedDate;
    }

    public String getServiceEntryDate() {
        return this.serviceEntryDate;
    }

    public void setServiceEntryDate(String serviceEntryDate) {
        this.serviceEntryDate = serviceEntryDate;
    }

    public void setIneligibleDate(String ineligibleDate) {
        this.ineligibleDate = ineligibleDate;
    }

    public String getIneligibleDate() {
        return this.ineligibleDate;
    }

    public void setIneligibleReason(String ineligibleReason) {
        this.ineligibleReason = ineligibleReason;
    }

    public String getIneligibleReason() {
        return this.ineligibleReason;
    }

    public void setIneligibleVARODecision(String ineligibleVARODecision) {
        this.ineligibleVARODecision = ineligibleVARODecision;
    }

    public String getIneligibleVARODecision() {
        return this.ineligibleVARODecision;
    }

    public void setClaimFolderNumber(String claimFolderNumber) {
        this.claimFolderNumber = claimFolderNumber;
    }

    public String getClaimFolderNumber() {
        return this.claimFolderNumber;
    }

    public void setClaimFolderLocation(String claimFolderLocation) {
        this.claimFolderLocation = claimFolderLocation;
    }

    public String getClaimFolderLocation() {
        return this.claimFolderLocation;
    }

    public void setPreferredFacility(String preferredFacility) {
        this.preferredFacility = preferredFacility;
    }

    public String getPreferredFacility() {
        return this.preferredFacility;
    }

    public void setCanceledDeclinedIndicator(String canceledDeclinedIndicator) {
        this.canceledDeclinedIndicator = canceledDeclinedIndicator;
    }

    public String getCanceledDeclinedIndicator() {
        return this.canceledDeclinedIndicator;
    }

    public void setCanceledDeclinedEffectiveDate(String canceledDeclinedEffectiveDate) {
        this.canceledDeclinedEffectiveDate = canceledDeclinedEffectiveDate;
    }

    public String getCanceledDeclinedEffectiveDate() {
        return this.canceledDeclinedEffectiveDate;
    }

    public void setCanceledDeclinedReason(String canceledDeclinedReason) {
        this.canceledDeclinedReason = canceledDeclinedReason;
    }

    public String getCanceledDeclinedReason() {
        return this.canceledDeclinedReason;
    }

    public void setCanceledDeclinedNotProcessedReason(String canceledDeclinedNotProcessedReason) {
        this.canceledDeclinedNotProcessedReason = canceledDeclinedNotProcessedReason;
    }

    public String getCanceledDeclinedNotProcessedReason() {
        return this.canceledDeclinedNotProcessedReason;
    }

    public void setCanceledDeclinedRemarks(String canceledDeclinedRemarks) {
        this.canceledDeclinedRemarks = canceledDeclinedRemarks;
    }

    public String getCanceledDeclinedRemarks() {
        return this.canceledDeclinedRemarks;
    }

    public void setEligibilityStatusDate(String eligibilityStatusDate) {
        this.eligibilityStatusDate = eligibilityStatusDate;
    }

    public String getEligibilityStatusDate() {
        return this.eligibilityStatusDate;
    }

    public void setTotalCheckAmount(String totalCheckAmount) {
        this.totalCheckAmount = totalCheckAmount;
    }

    public String getTotalCheckAmount() {
        return this.totalCheckAmount;
    }

    public String getTotalMonthlyCheckAmount() {
        return this.totalMonthlyCheckAmount;
    }

    public void setTotalMonthlyCheckAmount(String totalMonthlyCheckAmount) {
        this.totalMonthlyCheckAmount = totalMonthlyCheckAmount;
    }

    public void setIsReceivingCompensation(String isReceivingCompensation) {
        this.isReceivingCompensation = isReceivingCompensation;
    }

    public String getIsReceivingCompensation() {
        return this.isReceivingCompensation;
    }

    public void setEligibilityStatus(String eligibilityStatus) {
        this.eligibilityStatus = eligibilityStatus;
    }

    public String getEligibilityStatus() {
        return this.eligibilityStatus;
    }

    public String getIsSpinalCordInjury() {
        return this.spinalCordInjury;
    }

    public void setSpinalCordInjury(String spinalCordInjury) {
        this.spinalCordInjury = spinalCordInjury;
    }

    public String getSpinalCordInjury() {
        return this.spinalCordInjury;
    }

    public String getIsNoseThroatRadium() {
        return this.noseThroatRadium;
    }

    public String getNoseThroatRadium() {
        return this.noseThroatRadium;
    }

    public void setNoseThroatRadium(String radium) {
        this.noseThroatRadium = radium;
    }

    public String getAddAPerson() {
        return "" + this.isAddAPerson();
    }

    public void setDisabilityCodesList(List disabilityCodes) {
        this.disabilityCodes = disabilityCodes;
    }

    public List getDisabilityCodesList() {
        return this.disabilityCodes;
    }

    public String getDisabilityCodes(int index) {
        return (String)this.disabilityCodes.get(index);
    }

    public void setDisabilityCodes(int index, String disabilityCodes) {
        this.setElement(this.disabilityCodes, index, disabilityCodes);
    }

    public List getDisDescriptionList() {
        return this.disDescription;
    }

    public void setDisDescriptionList(List disDescription) {
        this.disDescription = disDescription;
    }

    public String getDisDescription(int index) {
        return (String)this.disDescription.get(index);
    }

    public void setDisDescription(int index, String disDescription) {
        this.setElement(this.disDescription, index, disDescription);
    }

    public void setPercentageList(List percentage) {
        this.percentage = percentage;
    }

    public List getPercentageList() {
        return this.percentage;
    }

    public String getPercentage(int index) {
        return (String)this.percentage.get(index);
    }

    public void setPercentage(int index, String percentage) {
        this.setElement(this.percentage, index, percentage);
    }

    public List getDiagnosticExtremityList() {
        return this.diagnosticExtremity;
    }

    public void setDiagnosticExtremityList(List diagnosticExtremity) {
        this.diagnosticExtremity = diagnosticExtremity;
    }

    public String getDiagnosticExtremity(int index) {
        return (String)this.diagnosticExtremity.get(index);
    }

    public void setDiagnosticExtremity(int index, String diagnosticExtremity) {
        this.setElement(this.diagnosticExtremity, index, diagnosticExtremity);
    }

    public List getOriginalEffectiveDateList() {
        return this.originalEffectiveDate;
    }

    public void setOriginalEffectiveDateList(List originalEffectiveDate) {
        this.originalEffectiveDate = originalEffectiveDate;
    }

    public String getOriginalEffectiveDate(int index) {
        return (String)this.originalEffectiveDate.get(index);
    }

    public void setOriginalEffectiveDate(int index, String originalEffectiveDate) {
        this.setElement(this.originalEffectiveDate, index, originalEffectiveDate);
    }

    public List getOldOriginalEffectiveDateList() {
        return this.oldOriginalEffectiveDate;
    }

    public void setOldOriginalEffectiveDateList(List oldOriginalEffectiveDate) {
        this.oldOriginalEffectiveDate = oldOriginalEffectiveDate;
    }

    public String getOldOriginalEffectiveDate(int index) {
        return (String)this.oldOriginalEffectiveDate.get(index);
    }

    public void setOldOriginalEffectiveDate(int index, String oldOriginalEffectiveDate) {
        this.setElement(this.oldOriginalEffectiveDate, index, oldOriginalEffectiveDate);
    }

    public List getCurrentEffectiveDateList() {
        return this.currentEffectiveDate;
    }

    public void setCurrentEffectiveDateList(List currentEffectiveDate) {
        this.currentEffectiveDate = currentEffectiveDate;
    }

    public String getCurrentEffectiveDate(int index) {
        return (String)this.currentEffectiveDate.get(index);
    }

    public void setCurrentEffectiveDate(int index, String ratingDate) {
        this.setElement(this.currentEffectiveDate, index, ratingDate);
    }

    public List getOldCurrentEffectiveDateList() {
        return this.oldCurrentEffectiveDate;
    }

    public void setOldCurrentEffectiveDateList(List oldCurrentEffectiveDate) {
        this.oldCurrentEffectiveDate = oldCurrentEffectiveDate;
    }

    public String getOldCurrentEffectiveDate(int index) {
        return (String)this.oldCurrentEffectiveDate.get(index);
    }

    public void setOldCurrentEffectiveDate(int index, String oldCurrentEffectiveDate) {
        this.setElement(this.oldCurrentEffectiveDate, index, oldCurrentEffectiveDate);
    }

    public String getAgentOrangeExposure() {
        return this.agentOrangeExposure;
    }

    public void setAgentOrangeExposure(String agentOrangeExposure) {
        this.agentOrangeExposure = agentOrangeExposure;
    }

    public String getAgentOrangeLocation() {
        return this.agentOrangeLocation;
    }

    public void setAgentOrangeLocation(String agentOrangeLocation) {
        this.agentOrangeLocation = agentOrangeLocation;
    }

    public String getEnvironmentalContaminationExposure() {
        return this.environmentalContaminationExposure;
    }

    public void setEnvironmentalContaminationExposure(String environmentalContaminationExposure) {
        this.environmentalContaminationExposure = environmentalContaminationExposure;
    }

    public String getRadiationExposure() {
        return this.radiationExposure;
    }

    public void setRadiationExposure(String radiationExposure) {
        this.radiationExposure = radiationExposure;
    }

    public String getDisabilityRetirementIndicator() {
        return this.disabilityRetirementIndicator;
    }

    public void setDisabilityRetirementIndicator(String disabilityRetirementIndicator) {
        this.disabilityRetirementIndicator = disabilityRetirementIndicator;
    }

    public String getRadiationExposureMethod() {
        return this.radiationExposureMethod;
    }

    public void setRadiationExposureMethod(String radiationExposureMethod) {
        this.radiationExposureMethod = radiationExposureMethod;
    }

    public String getAlliedVeteranCountry() {
        return this.alliedVeteranCountry;
    }

    public void setAlliedVeteranCountry(String alliedVeteranCountry) {
        this.alliedVeteranCountry = alliedVeteranCountry;
    }

    public String getChampa() {
        return this.champa;
    }

    public void setChampa(String champa) {
        this.champa = champa;
    }

    public String getCollateralOfVet() {
        return this.collateralOfVet;
    }

    public void setCollateralOfVet(String collateralOfVet) {
        this.collateralOfVet = collateralOfVet;
    }

    public String getEmployee() {
        return this.employee;
    }

    public void setEmployee(String employee) {
        this.employee = employee;
    }

    public String getOtherFederalAgency() {
        return this.otherFederalAgency;
    }

    public void setOtherFederalAgency(String otherFederalAgency) {
        this.otherFederalAgency = otherFederalAgency;
    }

    public String getSharingAgreement() {
        return this.sharingAgreement;
    }

    public void setSharingAgreement(String sharingAgreement) {
        this.sharingAgreement = sharingAgreement;
    }

    public String getTricare() {
        return this.tricare;
    }

    public void setTricare(String tricare) {
        this.tricare = tricare;
    }

    public String getPeriodOfService() {
        return this.periodOfService;
    }

    public void setPeriodOfService(String periodOfService) {
        this.periodOfService = periodOfService;
    }

    public List getDisabilityIdList() {
        return this.disabilityId;
    }

    public void setDisabilityIdList(List disabilityId) {
        this.disabilityId = disabilityId;
    }

    public EntityKey getDisabilityId(int index) {
        return (EntityKey)this.disabilityId.get(index);
    }

    public void setDisabilityId(int index, EntityKey disabilityId) {
        this.setElement(this.disabilityId, index, disabilityId);
    }

    public List getDisabilityIdStringsList() {
        return this.disabilityIdStrings;
    }

    public void setDisabilityIdStringsList(List disabilityIdStrings) {
        this.disabilityIdStrings = disabilityIdStrings;
    }

    public String getDisabilityIdStrings(int index) {
        return (String)this.disabilityIdStrings.get(index);
    }

    public void setDisabilityStringsId(int index, String disabilityIdStrings) {
        this.setElement(this.disabilityIdStrings, index, disabilityIdStrings);
    }

    public String getVoaHiddenIdList() {
        return this.voaHiddenId;
    }

    public void setVoaHiddenIdList(String voaHiddenId) {
        this.voaHiddenId = voaHiddenId;
    }

    public List getPowIdList() {
        return this.powId;
    }

    public int getPowIdListSize() {
        return this.powId.size();
    }

    public void setPowIdList(List powId) {
        this.powId = powId;
    }

    public EntityKey getPowId(int index) {
        return (EntityKey)this.powId.get(index);
    }

    public void setPowId(int index, EntityKey value) {
        this.setElement(this.powId, index, value);
    }

    public String getOldEligibilityStatusDate() {
        return this.oldEligibilityStatusDate;
    }

    public void setOldEligibilityStatusDate(String oldEligibilityStatusDate) {
        this.oldEligibilityStatusDate = oldEligibilityStatusDate;
    }

    public int[] getSelectedDisabilityIndexes() {
        return this.selectedDisabilityIndexes;
    }

    public int getSelectedDisabilityIndexesLength() {
        return this.selectedDisabilityIndexes != null ? this.selectedDisabilityIndexes.length : 0;
    }

    public void setSelectedDisabilityIndexes(int[] selectedDisabilityIndexes) {
        this.selectedDisabilityIndexes = selectedDisabilityIndexes;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.setSelectedDisabilityIndexes(new int[0]);
    }

    public void init() {
        this.setSelectedDisabilityIndexes(new int[0]);
        this.initPow();
        this.initDisability();
        this.resetCampLejeune();
    }

    public void resetCampLejeune() {
        this.campLejeuneInd = "";
        this.campLejeuneVerificationComments = "";
        this.campLejeuneChangeDate = "";
        this.campLejeuneChangeSite = "";
        this.campLejeuneChangeSource = "";
        this.campLejeuneDisabled = true;
        this.campLejeuneVerificationMethods = this.resetCampLejeuneVerificationMethods;
    }

    public void initPow() {
        this.powId = new ArrayList();
        this.powConfinementLocation = new ArrayList();
        this.powCaptureDate = new ArrayList();
        this.powReleaseDate = new ArrayList();
        this.powCaptivityDays = new ArrayList();
        this.powSource = new ArrayList();
        this.powDocumentType = new ArrayList();
        this.powCampLocation = new ArrayList();
        this.powCampCode = new ArrayList();
        this.powCampName = new ArrayList();
        this.powCampCity = new ArrayList();
        this.powDateEntered = new ArrayList();
    }

    public void addPow(EntityKey id, String loc, String cap, String rel, String days, String source, String documentType, String campLocation, String campCode, String campName, String campCity, String dateEntered) {
        this.powId.add(id);
        this.powConfinementLocation.add(loc);
        this.powCaptureDate.add(cap);
        this.powReleaseDate.add(rel);
        this.powCaptivityDays.add(days);
        this.powSource.add(source);
        this.powDocumentType.add(documentType);
        this.powCampLocation.add(campLocation);
        this.powCampCode.add(campCode);
        this.powCampName.add(campName);
        this.powCampCity.add(campCity);
        this.powDateEntered.add(dateEntered);
    }

    public void addNewPow() {
        this.addPow(null, "", "", "", "", "", "", "", "", "", "", "");
    }

    public void initDisability() {
        this.disabilityId = new ArrayList();
        this.disabilityIdStrings = new ArrayList();
        this.disabilityCodes = new ArrayList();
        this.disDescription = new ArrayList();
        this.percentage = new ArrayList();
        this.diagnosticExtremity = new ArrayList();
        this.originalEffectiveDate = new ArrayList();
        this.currentEffectiveDate = new ArrayList();
        this.oldOriginalEffectiveDate = new ArrayList();
        this.oldCurrentEffectiveDate = new ArrayList();
        this.setSelectedDisabilityIndexes(new int[0]);
    }

    public void addDisability(EntityKey id, String idString, String code, String desc, String perc, String extCode, String originalEffectiveDate, String currentEffectiveDate) {
        this.disabilityId.add(id);
        this.disabilityIdStrings.add(idString);
        this.disabilityCodes.add(code);
        this.disDescription.add(desc);
        this.percentage.add(perc);
        this.diagnosticExtremity.add(extCode);
        this.originalEffectiveDate.add(originalEffectiveDate);
        this.oldOriginalEffectiveDate.add(originalEffectiveDate);
        this.currentEffectiveDate.add(currentEffectiveDate);
        this.oldCurrentEffectiveDate.add(currentEffectiveDate);
    }

    public void addNewDisability(int index) {
        this.addDisability(null, String.valueOf(new Date().getTime() + (long)index), "", "", "", "", "", "");
    }

    public void removeAllDisability() {
        this.initDisability();
    }

    private void validateTotalCheckAmount(MessageResources messageResources, ActionMessages messages) {
        String fieldLabel = messageResources.getMessage("label.totalCheckAmount");
        String fieldName = "totalCheckAmount";
        Double minValue = new Double(0.0);
        Double maxValue = new Double(99999.0);
        try {
            Double d;
            if (this.getTotalCheckAmount() != null && this.getTotalCheckAmount().trim().length() > 0 && ((d = new Double(this.getTotalCheckAmount())) < 0.0 || d > 99999.0)) {
                messages.add(fieldName, new ActionMessage("errors.range", (Object)fieldLabel, (Object)minValue, (Object)maxValue));
            }
        }
        catch (NumberFormatException e) {
            messages.add(fieldName, new ActionMessage("errors.double", (Object)fieldLabel));
        }
    }

    private void validatePOW(MessageResources messageResources, ActionMessages messages) {
        String captureDateLabel = "Capture Date";
        String captureDateName = "powCaptureDate";
        String releaseDateLabel = "Release Date";
        String releaseDateName = "powReleaseDate";
        String confinementLocationLabel = "Confinement Location";
        String confinementLocationName = "powConfinementLocation";
        for (int i = 0; i < this.getPowIdList().size(); ++i) {
            boolean hasData;
            EntityKey id = this.getPowId(i);
            String loc = this.getPowConfinementLocation(i);
            ImpreciseDate capDate = null;
            ImpreciseDate relDate = null;
            if (this.getPowCaptureDate(i) != null && this.getPowCaptureDate(i).trim().length() > 0) {
                if (this.getPowCaptureDate(i).trim().length() < 5) {
                    messages.add(captureDateName + "[" + i + "]", new ActionMessage("errors.imprecisedateWithMonth", (Object)(captureDateLabel + "[" + i + "]" + " value '" + this.getPowCaptureDate(i) + "'")));
                }
                try {
                    capDate = DateUtils.getImpreciseDate((String)this.getPowCaptureDate(i));
                    if (!capDate.isMonthPrecise()) {
                        messages.add(captureDateName + "[" + i + "]", new ActionMessage("errors.detail", (Object)"Capture Date must be at least a Month and Year."));
                    }
                }
                catch (Exception ex) {
                    messages.add(captureDateName + "[" + i + "]", new ActionMessage("errors.imprecisedateWithMonth", (Object)(captureDateLabel + "[" + i + "]" + " value '" + this.getPowCaptureDate(i) + "'")));
                }
            }
            if (this.getPowReleaseDate(i) != null && this.getPowReleaseDate(i).trim().length() > 0) {
                if (this.getPowReleaseDate(i).trim().length() < 5) {
                    messages.add(releaseDateName + "[" + i + "]", new ActionMessage("errors.imprecisedateWithMonth", (Object)(releaseDateLabel + "[" + i + "]" + " value '" + this.getPowReleaseDate(i) + "'")));
                }
                try {
                    relDate = DateUtils.getImpreciseDate((String)this.getPowReleaseDate(i));
                    if (!relDate.isMonthPrecise()) {
                        messages.add(releaseDateName + "[" + i + "]", new ActionMessage("errors.detail", (Object)"Release Date must be at least a Month and Year."));
                    }
                }
                catch (Exception ex) {
                    messages.add(releaseDateName + "[" + i + "]", new ActionMessage("errors.imprecisedateWithMonth", (Object)(releaseDateLabel + "[" + i + "]" + " value '" + this.getPowReleaseDate(i) + "'")));
                }
            }
            boolean bl = hasData = capDate != null || relDate != null || loc != null && loc.trim().length() > 0 || this.getPowSource(i) != null && this.getPowSource(i).trim().length() > 0 || this.getPowDocumentType(i) != null && this.getPowDocumentType(i).trim().length() > 0 || this.getPowCampLocation(i) != null && this.getPowCampLocation(i).trim().length() > 0;
            if (!hasData) continue;
            if (loc == null || loc.trim().length() == 0) {
                messages.add(confinementLocationName + "[" + i + "]", new ActionMessage("errors.detail", (Object)"Confinement Location is required information."));
                continue;
            }
            if (capDate == null) {
                messages.add(captureDateName + "[" + i + "]", new ActionMessage("errors.detail", (Object)"Capture Date is required information."));
                continue;
            }
            if (relDate == null) {
                messages.add(releaseDateName + "[" + i + "]", new ActionMessage("errors.detail", (Object)"Release Date is required information."));
                continue;
            }
            if (!DateUtils.isDateBetween((ImpreciseDate)capDate, null, (ImpreciseDate)relDate)) {
                messages.add(captureDateName + "[" + i + "]", new ActionMessage("errors.detail", (Object)"Capture Date cannot be after the Release Date."));
                continue;
            }
            if (!DateUtils.isDateBetween((ImpreciseDate)capDate, null, (ImpreciseDate)new ImpreciseDate(new Date()))) {
                messages.add(captureDateName + "[" + i + "]", new ActionMessage("errors.detail", (Object)"Capture Date cannot be a future date."));
                continue;
            }
            if (!DateUtils.isDateBetween((ImpreciseDate)relDate, null, (ImpreciseDate)new ImpreciseDate(new Date()))) {
                messages.add(releaseDateName + "[" + i + "]", new ActionMessage("errors.detail", (Object)"Release Date cannot be a future date."));
                continue;
            }
            if (this.getDeathDate() != null && !DateUtils.isDateBetween((ImpreciseDate)capDate, null, (ImpreciseDate)DateUtils.getImpreciseDate((String)this.getDeathDate()))) {
                messages.add(captureDateName + "[" + i + "]", new ActionMessage("errors.detail", (Object)"Capture Date cannot fall after Date of Death."));
                continue;
            }
            if (this.getDeathDate() != null && !DateUtils.isDateBetween((ImpreciseDate)relDate, null, (ImpreciseDate)DateUtils.getImpreciseDate((String)this.getDeathDate()))) {
                messages.add(releaseDateName + "[" + i + "]", new ActionMessage("errors.detail", (Object)"Release Date cannot fall after Date of Death."));
                continue;
            }
            if (this.getBirthDate() != null && !DateUtils.isDateBetween((ImpreciseDate)capDate, (ImpreciseDate)DateUtils.getImpreciseDate((String)this.getBirthDate()), null)) {
                messages.add(captureDateName + "[" + i + "]", new ActionMessage("errors.detail", (Object)"Capture Date cannot be prior to Date of Birth."));
                continue;
            }
            if (this.getBirthDate() == null || DateUtils.isDateBetween((ImpreciseDate)relDate, (ImpreciseDate)DateUtils.getImpreciseDate((String)this.getBirthDate()), null)) continue;
            messages.add(releaseDateName + "[" + i + "]", new ActionMessage("errors.detail", (Object)"Release Date cannot be prior to Date of Birth."));
        }
    }

    private void validateRatedDisability(MessageResources messageResources, ActionMessages messages) {
        String codeFieldLabel = "Rated Disability Code";
        String codeFieldName = "code";
        String percentageFieldLabel = "Service Connected Percentage";
        String percentageFieldName = "percentage";
        String originalEffectiveDateLabel = "Original Effective Date";
        String originalEffectiveDateName = "originalEffectiveDate";
        String currentEffectiveDateLabel = "Current Effective Date";
        String currentEffectiveDateName = "currentEffectiveDate";
        ImpreciseDate effectiveDateCombinedRatingDate = null;
        if (this.effectiveDateCombinedRating != null) {
            effectiveDateCombinedRatingDate = DateUtils.getImpreciseDate((String)this.effectiveDateCombinedRating);
        }
        for (int i = 0; i < this.getSelectedDisabilityIndexes().length; ++i) {
            ImpreciseDate input;
            int index = this.selectedDisabilityIndexes[i];
            if (index < 0 || index >= this.disabilityCodes.size()) continue;
            String code = this.getDisabilityCodes(index);
            String percentage = this.getPercentage(index);
            if (code == null || code.trim().length() == 0) {
                messages.add(codeFieldName, new ActionMessage("errors.required", (Object)codeFieldLabel));
            } else if (percentage == null || percentage.trim().length() == 0) {
                messages.add(percentageFieldName, new ActionMessage("errors.integer", (Object)(percentageFieldLabel + " for Code: " + code)));
            } else {
                try {
                    Integer value = new Integer(percentage);
                    if (value < 0 || value > 100) {
                        messages.add(percentageFieldName, new ActionMessage("errors.range", (Object)(percentageFieldLabel + " for Code: " + code), (Object)new Integer(0), (Object)new Integer(100)));
                    }
                }
                catch (NumberFormatException e) {
                    messages.add(percentageFieldName, new ActionMessage("errors.integer", (Object)(percentageFieldLabel + " for Code: " + code)));
                }
            }
            if (this.getOriginalEffectiveDate(index) != null && this.getOriginalEffectiveDate(index).trim().length() > 0) {
                if (!this.getOriginalEffectiveDate(index).trim().equals(this.getOldOriginalEffectiveDate(index))) {
                    try {
                        DateUtils.getDate((String)this.getOriginalEffectiveDate(index));
                    }
                    catch (Exception ex) {
                        messages.add(originalEffectiveDateName, new ActionMessage("errors.date", (Object)(originalEffectiveDateLabel + " value '" + this.getOriginalEffectiveDate(index) + "'")));
                        return;
                    }
                }
                if ((input = DateUtils.getImpreciseDate((String)this.getOriginalEffectiveDate(index))) != null) {
                    if (!DateUtils.isDateBetween((ImpreciseDate)input, null, (ImpreciseDate)new ImpreciseDate(new Date()))) {
                        messages.add(originalEffectiveDateName, new ActionMessage("errors.detail", (Object)"Rated Disability Original Effective Date cannot be a future date."));
                    }
                    if (this.getDeathDate() != null && (!DateUtils.isDateBetween((ImpreciseDate)input, null, (ImpreciseDate)DateUtils.getImpreciseDate((String)this.getDeathDate())) || DateUtils.format((ImpreciseDate)input, (String)"MM/dd/yyyy").equals(DateUtils.format((ImpreciseDate)DateUtils.getImpreciseDate((String)this.getDeathDate()), (String)"MM/dd/yyyy")))) {
                        messages.add(originalEffectiveDateName, new ActionMessage("errors.detail", (Object)"Rated Disability Original Effective Date cannot be on or after a Date of Death."));
                    }
                    if (this.getBirthDate() != null && !DateUtils.isDateBetween((ImpreciseDate)input, (ImpreciseDate)DateUtils.getImpreciseDate((String)this.getBirthDate()), null)) {
                        messages.add(originalEffectiveDateName, new ActionMessage("errors.detail", (Object)"Rated Disability Original Effective Date cannot be prior to Date of Birth."));
                    }
                    if (effectiveDateCombinedRatingDate != null && !DateUtils.isDateBetween((ImpreciseDate)input, null, (ImpreciseDate)effectiveDateCombinedRatingDate) && !DateUtils.format((ImpreciseDate)input, (String)"MM/dd/yyyy").equals(DateUtils.format((ImpreciseDate)effectiveDateCombinedRatingDate, (String)"MM/dd/yyyy"))) {
                        messages.add(originalEffectiveDateName, new ActionMessage("errors.detail", (Object)"Rated Disability Original Effective Date must fall on or prior to the Effective Date of Combined Evaluation."));
                    }
                }
            }
            if (this.getCurrentEffectiveDate(index) == null || this.getCurrentEffectiveDate(index).trim().length() <= 0) continue;
            if (!this.getCurrentEffectiveDate(index).trim().equals(this.getOldCurrentEffectiveDate(index))) {
                try {
                    DateUtils.getDate((String)this.getCurrentEffectiveDate(index));
                }
                catch (Exception ex) {
                    messages.add(currentEffectiveDateName, new ActionMessage("errors.date", (Object)(currentEffectiveDateLabel + " value '" + this.getCurrentEffectiveDate(index) + "'")));
                    return;
                }
            }
            if ((input = DateUtils.getImpreciseDate((String)this.getCurrentEffectiveDate(index))) == null) continue;
            if (!DateUtils.isDateBetween((ImpreciseDate)input, null, (ImpreciseDate)new ImpreciseDate(new Date()))) {
                messages.add(currentEffectiveDateName, new ActionMessage("errors.detail", (Object)"Rated Disability Current Effective Date cannot be a future date."));
            }
            if (this.getDeathDate() != null && (!DateUtils.isDateBetween((ImpreciseDate)input, null, (ImpreciseDate)DateUtils.getImpreciseDate((String)this.getDeathDate())) || DateUtils.format((ImpreciseDate)input, (String)"MM/dd/yyyy").equals(DateUtils.format((ImpreciseDate)DateUtils.getImpreciseDate((String)this.getDeathDate()), (String)"MM/dd/yyyy")))) {
                messages.add(currentEffectiveDateName, new ActionMessage("errors.detail", (Object)"Rated Disability Current Effective Date cannot be on or after a Date of Death."));
            }
            if (this.getBirthDate() != null && !DateUtils.isDateBetween((ImpreciseDate)input, (ImpreciseDate)DateUtils.getImpreciseDate((String)this.getBirthDate()), null)) {
                messages.add(currentEffectiveDateName, new ActionMessage("errors.detail", (Object)"Rated Disability Current Effective Date cannot be prior to Date of Birth."));
            }
            if (effectiveDateCombinedRatingDate == null || DateUtils.isDateBetween((ImpreciseDate)input, null, (ImpreciseDate)effectiveDateCombinedRatingDate) || DateUtils.format((ImpreciseDate)input, (String)"MM/dd/yyyy").equals(DateUtils.format((ImpreciseDate)effectiveDateCombinedRatingDate, (String)"MM/dd/yyyy"))) continue;
            messages.add(currentEffectiveDateName, new ActionMessage("errors.detail", (Object)"Rated Disability Current Effective Date must fall on or prior to the Effective Date of Combined Evaluation."));
        }
    }

    private void validateNonVeteranFields(MessageResources messageResources, ActionMessages messages) {
        if ("n".equals(this.getVeteranIndicator()) && "n".equals(this.getTricare()) && "n".equals(this.getSharingAgreement()) && "n".equals(this.getChampa()) && "n".equals(this.getEmployee()) && "n".equals(this.getCollateralOfVet()) && StringUtils.isEmpty((String)this.getAlliedVeteranCountry()) && StringUtils.isEmpty((String)this.getOtherFederalAgency()) && StringUtils.isBlank((String)this.getIneligibleDate())) {
            messages.add(FIELD_NAME_INELIGIBILE_DATE, new ActionMessage("error.nonVeteranEligibilityCodeRequired", (Object)FIELD_LABEL_INELIGIBILE_DATE));
            messages.add("nonVetEligibilityCodes", new ActionMessage("error.nonVeteranEligibilityCodeRequired", (Object)"label.nonVetEligibilityCodes"));
        }
    }

    public boolean getOtherEligibilityFactorsPresent() {
        return StringUtils.isNotBlank((String)this.getAgentOrangeLocation()) || StringUtils.isNotBlank((String)this.getRadiationExposureMethod()) || "y".equals(this.getDischargeDueDisability()) || "y".equals(this.getDisabilityRetirementIndicator()) || "y".equals(this.getEnvironmentalContaminationExposure()) || "y".equals(this.getCampLejeuneInd());
    }

    public ActionMessages validateForm(ActionMapping mapping, HttpServletRequest request) {
        MessageResources messageResources = this.getResources(request);
        ActionMessages messages = new ActionMessages();
        this.validateNonVeteranFields(messageResources, messages);
        this.validateTotalCheckAmount(messageResources, messages);
        this.validatePOW(messageResources, messages);
        ImpreciseDate oldDate = null;
        ImpreciseDate newDate = null;
        if (StringUtils.isNotEmpty((String)this.getOldEligibilityStatusDate())) {
            oldDate = DateUtils.getImpreciseDate((String)this.getOldEligibilityStatusDate());
        }
        if (StringUtils.isNotEmpty((String)this.getEligibilityStatusDate())) {
            try {
                newDate = DateUtils.getImpreciseDate((String)this.getEligibilityStatusDate());
                if (oldDate == null || !oldDate.equals((Object)newDate)) {
                    ImpreciseDate dob;
                    if (newDate.isImprecise()) {
                        messages.add("eligibilityStatusDate", new ActionMessage("errors.detail", (Object)"Eligibility Status Date requires a precise date mm/dd/yyyy"));
                    }
                    if ((dob = DateUtils.getImpreciseDate((String)this.getBirthDate())).compareTo(newDate) > 0) {
                        messages.add("eligibilityStatusDate", new ActionMessage("errors.detail", (Object)"Eligibility Status Date cannot be prior to the Date of Birth"));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                messages.add("eligibilityStatusDate", new ActionMessage("errors.date", (Object)this.getEligibilityStatusDate()));
            }
        }
        if (this.getEffectiveDateCombinedRating() != null && this.getEffectiveDateCombinedRating().trim().length() > 0 && !this.getEffectiveDateCombinedRating().trim().equals(this.getOldEffectiveDateCombinedRating())) {
            try {
                Date date = DateUtils.getDate((String)this.getEffectiveDateCombinedRating().trim());
                if (this.getDeathDate() != null && (!DateUtils.isDateBetween((ImpreciseDate)DateUtils.getImpreciseDate((String)this.getEffectiveDateCombinedRating()), null, (ImpreciseDate)DateUtils.getImpreciseDate((String)this.getDeathDate())) || this.getEffectiveDateCombinedRating().equals(this.getDeathDate()))) {
                    messages.add("effectiveDateCombinedRating", new ActionMessage("errors.detail", (Object)"Effective Date of Combined Evaluation must be prior to the Date of Death"));
                }
            }
            catch (IllegalArgumentException e) {
                messages.add("effectiveDateCombinedRating", new ActionMessage("errors.detail", (Object)"Effective Date of Combined Evaluation must be entered as a precise date"));
                return messages;
            }
        }
        this.validateRatedDisability(messageResources, messages);
        if (StringUtils.isNotEmpty((String)this.getIneligibleDate()) && StringUtils.equalsIgnoreCase((String)"n", (String)this.oldVeteranIndicator) && StringUtils.equalsIgnoreCase((String)"y", (String)this.veteranIndicator) && !this.isIneligibleDateAllowedForVeteran()) {
            String fieldLabel = messageResources.getMessage(FIELD_LABEL_INELIGIBILE_DATE);
            messages.add(FIELD_NAME_INELIGIBILE_DATE, new ActionMessage(MESSAGE_KEY_INELIGIBILE_DATE_NOT_ALLOWED, (Object)fieldLabel));
        }
        if (StringUtils.isNotEmpty((String)this.getIneligibleDate()) && StringUtils.isNotEmpty((String)this.getServiceEntryDate())) {
            Date ineligibleDate = DateUtils.getDate((String)this.getIneligibleDate());
            Date serviceEntryDate = DateUtils.getDate((String)this.getServiceEntryDate());
            if (serviceEntryDate.after(ineligibleDate)) {
                String fieldLabel = messageResources.getMessage(FIELD_LABEL_INELIGIBILE_DATE);
                messages.add(FIELD_NAME_INELIGIBILE_DATE, new ActionMessage(MESSAGE_KEY_INELIGIBILE_DATE_NOT_ALLOWED, (Object)fieldLabel));
            }
        }
        this.validatePensionGroupData(messageResources, messages);
        return messages;
    }

    private void validatePensionGroupData(MessageResources messageResources, ActionMessages messages) {
        Date date1;
        Date date2;
        Date date12;
        String fieldLabel2;
        Date current;
        Date date;
        String dateStr = this.getPensionAwardEffectiveDate();
        String fieldLabel = messageResources.getMessage("label.pensionAwardEffectiveDate");
        if (StringUtils.isNotEmpty((String)this.getPensionAwardEffectiveDate())) {
            try {
                CommonDateUtils.getDate((String)dateStr, (boolean)true);
                date = DateUtils.getDate((String)dateStr, (boolean)true);
                current = DateUtils.getCurrentDateTime();
                if (date != null && date.compareTo(current) > 0) {
                    messages.add("pensionAwardEffectiveDate", new ActionMessage("errors.detail", (Object)(fieldLabel + " cannot be greater than the current system date")));
                    return;
                }
            }
            catch (Exception e) {
                messages.add("pensionAwardEffectiveDate", new ActionMessage("errors.detail", (Object)(fieldLabel + " must be a precise date.")));
                return;
            }
        }
        dateStr = this.getPensionAwardTerminationDate();
        fieldLabel = messageResources.getMessage("label.pensionAwardTerminationDate");
        if (StringUtils.isNotEmpty((String)this.getPensionAwardTerminationDate())) {
            try {
                CommonDateUtils.getDate((String)dateStr, (boolean)true);
                date = DateUtils.getDate((String)dateStr, (boolean)true);
                current = DateUtils.getCurrentDateTime();
                if (date != null && date.compareTo(current) > 0) {
                    messages.add("pensionAwardTerminationDate", new ActionMessage("errors.detail", (Object)(fieldLabel + " cannot be greater than the current system date")));
                    return;
                }
            }
            catch (Exception e) {
                messages.add("pensionAwardTerminationDate", new ActionMessage("errors.detail", (Object)(fieldLabel + " must be a precise date.")));
                return;
            }
        }
        if (StringUtils.isNotBlank((String)this.getVaPension()) && "y".equalsIgnoreCase(this.getVaPension()) && StringUtils.isNotEmpty((String)this.getPensionAwardEffectiveDate()) && StringUtils.isNotEmpty((String)this.getPensionAwardTerminationDate())) {
            fieldLabel = messageResources.getMessage("label.pensionAwardEffectiveDate");
            fieldLabel2 = messageResources.getMessage("label.pensionAwardTerminationDate");
            date12 = DateUtils.getDate((String)this.getPensionAwardEffectiveDate(), (boolean)true);
            date2 = DateUtils.getDate((String)this.getPensionAwardTerminationDate(), (boolean)true);
            if (date12 != null && date2 != null && date12.compareTo(date2) < 0) {
                messages.add("pensionAwardEffectiveDate", new ActionMessage("errors.detail", (Object)(fieldLabel + " cannot be less than the " + fieldLabel2)));
                return;
            }
        }
        if (StringUtils.isNotBlank((String)this.getVaPension()) && "n".equalsIgnoreCase(this.getVaPension()) && StringUtils.isNotEmpty((String)this.getPensionAwardTerminationDate()) && StringUtils.isNotEmpty((String)this.getPensionAwardEffectiveDate())) {
            fieldLabel = messageResources.getMessage("label.pensionAwardTerminationDate");
            fieldLabel2 = messageResources.getMessage("label.pensionAwardEffectiveDate");
            date12 = DateUtils.getDate((String)this.getPensionAwardTerminationDate(), (boolean)true);
            date2 = DateUtils.getDate((String)this.getPensionAwardEffectiveDate(), (boolean)true);
            if (date12 != null && date2 != null && date12.compareTo(date2) < 0) {
                messages.add("pensionAwardTerminationDate", new ActionMessage("errors.detail", (Object)(fieldLabel + " cannot be less than the " + fieldLabel2)));
                return;
            }
        }
        if (StringUtils.isNotBlank((String)this.getVaPension()) && "y".equalsIgnoreCase(this.getVaPension()) && (StringUtils.isBlank((String)this.getOldvaPension()) || "n".equalsIgnoreCase(this.getOldvaPension()))) {
            if (StringUtils.isEmpty((String)this.getPensionAwardEffectiveDate())) {
                messages.add("pensionAwardEffectiveDate", new ActionMessage("errors.detail", (Object)"Pension Award Effective Date is required when VA pension changed to YES"));
                return;
            }
            if (StringUtils.isEmpty((String)this.getPensionAwardReasonCode())) {
                messages.add("pensionAwardReasonCode", new ActionMessage("errors.detail", (Object)"Pension Award Reason Code is required when VA pension changed to YES"));
                return;
            }
        }
        if (StringUtils.isNotBlank((String)this.getVaPension()) && "n".equalsIgnoreCase(this.getVaPension()) && (StringUtils.isBlank((String)this.getOldvaPension()) || "y".equalsIgnoreCase(this.getOldvaPension()))) {
            if (StringUtils.isEmpty((String)this.getPensionAwardTerminationDate())) {
                messages.add("pensionAwardTerminationDate", new ActionMessage("errors.detail", (Object)"Pension Award Termination Date is required when VA pension changed to NO"));
                return;
            }
            if (StringUtils.isEmpty((String)this.getPensionAwardTerminationReasonCode1()) && StringUtils.isEmpty((String)this.getPensionAwardTerminationReasonCode2()) && StringUtils.isEmpty((String)this.getPensionAwardTerminationReasonCode3()) && StringUtils.isEmpty((String)this.getPensionAwardTerminationReasonCode4())) {
                messages.add("PensionAwardTerminationReasonCode1", new ActionMessage("errors.detail", (Object)"A Pension Award Termination Code is required when pension termination date is entered"));
                return;
            }
        }
        if (StringUtils.isNotBlank((String)this.getVaPension()) && "n".equalsIgnoreCase(this.getVaPension())) {
            if (StringUtils.isNotEmpty((String)this.getPensionAwardTerminationDate())) {
                date1 = DateUtils.getDate((String)this.getPensionAwardTerminationDate(), (boolean)true);
                if (date1 != null && StringUtils.isEmpty((String)this.getPensionAwardTerminationReasonCode1()) && StringUtils.isEmpty((String)this.getPensionAwardTerminationReasonCode2()) && StringUtils.isEmpty((String)this.getPensionAwardTerminationReasonCode3()) && StringUtils.isEmpty((String)this.getPensionAwardTerminationReasonCode4())) {
                    messages.add("PensionAwardTerminationReasonCode1", new ActionMessage("errors.detail", (Object)"A Pension Award Termination Code is required when pension termination date is entered"));
                    return;
                }
            } else if (StringUtils.isEmpty((String)this.getPensionAwardTerminationDate()) && (StringUtils.isNotEmpty((String)this.getPensionAwardTerminationReasonCode1()) || StringUtils.isNotEmpty((String)this.getPensionAwardTerminationReasonCode2()) || StringUtils.isNotEmpty((String)this.getPensionAwardTerminationReasonCode3()) || StringUtils.isNotEmpty((String)this.getPensionAwardTerminationReasonCode4()))) {
                messages.add("pensionAwardTerminationDate", new ActionMessage("errors.detail", (Object)"A Pension Award Termination Date is required when a pension termination reason code is entered"));
                return;
            }
        }
        if (StringUtils.isNotBlank((String)this.getVaPension()) && "y".equalsIgnoreCase(this.getVaPension())) {
            if (StringUtils.isNotEmpty((String)this.getPensionAwardEffectiveDate())) {
                date1 = DateUtils.getDate((String)this.getPensionAwardEffectiveDate(), (boolean)true);
                if (date1 != null && StringUtils.isEmpty((String)this.getPensionAwardReasonCode())) {
                    messages.add("pensionAwardReasonCode", new ActionMessage("errors.detail", (Object)"Pension Award Reason Code is required when pension award effective date is entered"));
                }
            } else if (StringUtils.isEmpty((String)this.getPensionAwardEffectiveDate()) && StringUtils.isNotEmpty((String)this.getPensionAwardReasonCode())) {
                messages.add("pensionAwardEffectiveDate", new ActionMessage("errors.detail", (Object)"Pension Award Effective Date is required when pension award reason code is entered"));
            }
        }
    }

    public static boolean validatePreciseDate(String dateStr, String fieldName, String fieldLabel, ActionMessages errors) {
        if (StringUtils.isEmpty((String)dateStr)) {
            return true;
        }
        boolean fieldValid = true;
        try {
            boolean timeSupported = false;
            CommonDateUtils.getDate((String)dateStr, (boolean)timeSupported);
        }
        catch (Exception e) {
            fieldValid = false;
        }
        if (!fieldValid) {
            errors.add(fieldName, new ActionMessage("errors.date", (Object)fieldLabel));
        }
        return fieldValid;
    }

    public static boolean validatePastDate(String dateStr, String fieldName, String fieldLabel, ActionMessages errors) {
        if (StringUtils.isEmpty((String)dateStr)) {
            return true;
        }
        try {
            Date date = DateUtils.getDate((String)dateStr, (boolean)true);
            Date current = DateUtils.getCurrentDateTime();
            if (date.compareTo(current) <= 0) {
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        errors.add(fieldName, new ActionMessage("errors.detail", (Object)(fieldLabel + " cannot be greater than the current system date")));
        return false;
    }

    private boolean isIneligibleDateAllowedForVeteran() {
        Integer sc = this.getInteger(this.getServiceConnected());
        if (sc == null || sc > 0 || this.getPercentageList() == null || this.getPercentageList().isEmpty()) {
            return false;
        }
        Iterator iter = this.getPercentageList().iterator();
        while (iter.hasNext()) {
            Integer ratedSC = this.getInteger((String)iter.next());
            if (ratedSC == null || ratedSC <= 0) continue;
            return false;
        }
        return true;
    }

    private Integer getInteger(String value) {
        Integer intValue = null;
        if (StringUtils.isNotEmpty((String)value) && StringUtils.isNumeric((String)value.trim())) {
            try {
                intValue = new Integer(value.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return intValue;
    }

    protected AbstractEntity createValueObject() {
        return new Person();
    }

    public VOAAttahmentEditActionForm getVoaAttachment(int index) {
        if (this.voaAttachments == null) {
            this.voaAttachments = new ArrayList();
        }
        while (index >= this.voaAttachments.size()) {
            this.voaAttachments.add(new VOAAttahmentEditActionForm());
        }
        return (VOAAttahmentEditActionForm)((Object)this.voaAttachments.get(index));
    }

    public List getVoaAttachments() {
        return this.voaAttachments;
    }

    public void setVoaAttachments(List voaAttachments) {
        this.voaAttachments = voaAttachments;
    }

    public String getActiveVOARowID() {
        return this.activeVOARowID;
    }

    public void setActiveVOARowID(String activeVOARowID) {
        this.activeVOARowID = activeVOARowID;
    }

    public String getPensionAwardEffectiveDate() {
        return this.pensionAwardEffectiveDate;
    }

    public void setPensionAwardEffectiveDate(String pensionAwardEffectiveDate) {
        this.pensionAwardEffectiveDate = pensionAwardEffectiveDate;
    }

    public String getPensionAwardReasonCode() {
        return this.pensionAwardReasonCode;
    }

    public void setPensionAwardReasonCode(String pensionAwardReasonCode) {
        this.pensionAwardReasonCode = pensionAwardReasonCode;
    }

    public String getPensionAwardTerminationDate() {
        return this.pensionAwardTerminationDate;
    }

    public void setPensionAwardTerminationDate(String pensionAwardTerminationDate) {
        this.pensionAwardTerminationDate = pensionAwardTerminationDate;
    }

    public String getPensionAwardTerminationReasonCode1() {
        return this.pensionAwardTerminationReasonCode1;
    }

    public void setPensionAwardTerminationReasonCode1(String pensionAwardTerminationReasonCode1) {
        this.pensionAwardTerminationReasonCode1 = pensionAwardTerminationReasonCode1;
    }

    public String getPensionAwardTerminationReasonCode2() {
        return this.pensionAwardTerminationReasonCode2;
    }

    public void setPensionAwardTerminationReasonCode2(String pensionAwardTerminationReasonCode2) {
        this.pensionAwardTerminationReasonCode2 = pensionAwardTerminationReasonCode2;
    }

    public String getPensionAwardTerminationReasonCode3() {
        return this.pensionAwardTerminationReasonCode3;
    }

    public void setPensionAwardTerminationReasonCode3(String pensionAwardTerminationReasonCode3) {
        this.pensionAwardTerminationReasonCode3 = pensionAwardTerminationReasonCode3;
    }

    public String getPensionAwardTerminationReasonCode4() {
        return this.pensionAwardTerminationReasonCode4;
    }

    public void setPensionAwardTerminationReasonCode4(String pensionAwardTerminationReasonCode4) {
        this.pensionAwardTerminationReasonCode4 = pensionAwardTerminationReasonCode4;
    }

    public String getOldvaPension() {
        return this.oldvaPension;
    }

    public void setOldvaPension(String oldvaPension) {
        this.oldvaPension = oldvaPension;
    }

    public String getOldPensionAwardEffectiveDate() {
        return this.oldPensionAwardEffectiveDate;
    }

    public void setOldPensionAwardEffectiveDate(String oldPensionAwardEffectiveDate) {
        this.oldPensionAwardEffectiveDate = oldPensionAwardEffectiveDate;
    }

    public String getOldPensionAwardTerminationDate() {
        return this.oldPensionAwardTerminationDate;
    }

    public void setOldPensionAwardTerminationDate(String oldPensionAwardTerminationDate) {
        this.oldPensionAwardTerminationDate = oldPensionAwardTerminationDate;
    }

    public String getCampLejeuneInd() {
        return this.campLejeuneInd;
    }

    public void setCampLejeuneInd(String campLejeuneInd) {
        this.campLejeuneInd = campLejeuneInd;
    }

    public String[] getCampLejeuneVerificationMethods() {
        return this.campLejeuneVerificationMethods;
    }

    public void setCampLejeuneVerificationMethods(String[] campLejeuneVerificationMethods) {
        this.campLejeuneVerificationMethods = campLejeuneVerificationMethods;
    }

    public String getCampLejeuneVerificationMethod() {
        return this.campLejeuneVerificationMethod;
    }

    public void setCampLejeuneVerificationMethod(String campLejeuneVerificationMethod) {
        this.campLejeuneVerificationMethod = campLejeuneVerificationMethod;
    }

    public String getCampLejeuneVerificationComments() {
        return this.campLejeuneVerificationComments;
    }

    public void setCampLejeuneVerificationComments(String campLejeuneVerificationComments) {
        this.campLejeuneVerificationComments = campLejeuneVerificationComments;
    }

    public String getCampLejeuneChangeDate() {
        return this.campLejeuneChangeDate;
    }

    public void setCampLejeuneChangeDate(String campLejeuneChangeDate) {
        this.campLejeuneChangeDate = campLejeuneChangeDate;
    }

    public String getCampLejeuneChangeSite() {
        return this.campLejeuneChangeSite;
    }

    public void setCampLejeuneChangeSite(String campLejeuneChangeSite) {
        this.campLejeuneChangeSite = campLejeuneChangeSite;
    }

    public String getCampLejeuneChangeSource() {
        return this.campLejeuneChangeSource;
    }

    public void setCampLejeuneChangeSource(String campLejeuneChangeSource) {
        this.campLejeuneChangeSource = campLejeuneChangeSource;
    }

    public boolean isCampLejeuneDisabled() {
        return this.campLejeuneDisabled;
    }

    public void setCampLejeuneDisabled(boolean campLejeuneDisabled) {
        this.campLejeuneDisabled = campLejeuneDisabled;
    }

    public String getIsSelectedOtherCLVer() {
        Iterator clvmsIter;
        String selectedOthers = "false";
        List<String> clvms = null;
        List<String> list = clvms = this.campLejeuneVerificationMethods != null && this.campLejeuneVerificationMethods.length > 0 ? Arrays.asList(this.campLejeuneVerificationMethods) : null;
        if (clvms != null && (clvmsIter = clvms.iterator()) != null) {
            while (clvmsIter.hasNext()) {
                String clveficationMethod = (String)clvmsIter.next();
                System.out.println(clveficationMethod);
                if (!clveficationMethod.equalsIgnoreCase("7")) continue;
                selectedOthers = "true";
            }
        }
        System.out.println(selectedOthers);
        return selectedOthers;
    }

    public void reset() {
        this.campLejeuneVerificationMethods = this.resetCampLejeuneVerificationMethods;
    }

    public String getEligStatusPendingVerficationReason() {
        return this.eligStatusPendingVerficationReason;
    }

    public void setEligStatusPendingVerficationReason(String eligStatusPendingVerficationReason) {
        this.eligStatusPendingVerficationReason = eligStatusPendingVerficationReason;
    }

    public String getEligStatusPendingVerfReasonExplain() {
        return this.eligStatusPendingVerfReasonExplain;
    }

    public void setEligStatusPendingVerfReasonExplain(String eligStatusPendingVerfReasonExplain) {
        this.eligStatusPendingVerfReasonExplain = eligStatusPendingVerfReasonExplain;
    }
}

